// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// Plex plex
//
// swagger:model plex
type Plex struct {

	// aggregate
	Aggregate *PlexInlineAggregate `json:"aggregate,omitempty"`

	// Plex name
	// Example: plex0
	// Read Only: true
	Name *string `json:"name,omitempty"`

	// Plex is online
	// Read Only: true
	Online *bool `json:"online,omitempty"`

	// plex inline raid groups
	// Read Only: true
	PlexInlineRaidGroups []*RaidGroup `json:"raid_groups,omitempty"`

	// SyncMirror pool assignment
	// Read Only: true
	// Enum: ["pool0","pool1"]
	Pool *string `json:"pool,omitempty"`

	// resync
	Resync *PlexInlineResync `json:"resync,omitempty"`

	// Plex state
	// Read Only: true
	// Enum: ["normal","failed","out_of_date"]
	State *string `json:"state,omitempty"`
}

// Validate validates this plex
func (m *Plex) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateAggregate(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePlexInlineRaidGroups(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePool(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateResync(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *Plex) validateAggregate(formats strfmt.Registry) error {
	if swag.IsZero(m.Aggregate) { // not required
		return nil
	}

	if m.Aggregate != nil {
		if err := m.Aggregate.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("aggregate")
			}
			return err
		}
	}

	return nil
}

func (m *Plex) validatePlexInlineRaidGroups(formats strfmt.Registry) error {
	if swag.IsZero(m.PlexInlineRaidGroups) { // not required
		return nil
	}

	for i := 0; i < len(m.PlexInlineRaidGroups); i++ {
		if swag.IsZero(m.PlexInlineRaidGroups[i]) { // not required
			continue
		}

		if m.PlexInlineRaidGroups[i] != nil {
			if err := m.PlexInlineRaidGroups[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("raid_groups" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

var plexTypePoolPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["pool0","pool1"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		plexTypePoolPropEnum = append(plexTypePoolPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// plex
	// Plex
	// pool
	// Pool
	// pool0
	// END DEBUGGING
	// PlexPoolPool0 captures enum value "pool0"
	PlexPoolPool0 string = "pool0"

	// BEGIN DEBUGGING
	// plex
	// Plex
	// pool
	// Pool
	// pool1
	// END DEBUGGING
	// PlexPoolPool1 captures enum value "pool1"
	PlexPoolPool1 string = "pool1"
)

// prop value enum
func (m *Plex) validatePoolEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, plexTypePoolPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *Plex) validatePool(formats strfmt.Registry) error {
	if swag.IsZero(m.Pool) { // not required
		return nil
	}

	// value enum
	if err := m.validatePoolEnum("pool", "body", *m.Pool); err != nil {
		return err
	}

	return nil
}

func (m *Plex) validateResync(formats strfmt.Registry) error {
	if swag.IsZero(m.Resync) { // not required
		return nil
	}

	if m.Resync != nil {
		if err := m.Resync.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("resync")
			}
			return err
		}
	}

	return nil
}

var plexTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["normal","failed","out_of_date"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		plexTypeStatePropEnum = append(plexTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// plex
	// Plex
	// state
	// State
	// normal
	// END DEBUGGING
	// PlexStateNormal captures enum value "normal"
	PlexStateNormal string = "normal"

	// BEGIN DEBUGGING
	// plex
	// Plex
	// state
	// State
	// failed
	// END DEBUGGING
	// PlexStateFailed captures enum value "failed"
	PlexStateFailed string = "failed"

	// BEGIN DEBUGGING
	// plex
	// Plex
	// state
	// State
	// out_of_date
	// END DEBUGGING
	// PlexStateOutOfDate captures enum value "out_of_date"
	PlexStateOutOfDate string = "out_of_date"
)

// prop value enum
func (m *Plex) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, plexTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *Plex) validateState(formats strfmt.Registry) error {
	if swag.IsZero(m.State) { // not required
		return nil
	}

	// value enum
	if err := m.validateStateEnum("state", "body", *m.State); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this plex based on the context it is used
func (m *Plex) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateAggregate(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateName(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateOnline(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidatePlexInlineRaidGroups(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidatePool(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateResync(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *Plex) contextValidateAggregate(ctx context.Context, formats strfmt.Registry) error {

	if m.Aggregate != nil {
		if err := m.Aggregate.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("aggregate")
			}
			return err
		}
	}

	return nil
}

func (m *Plex) contextValidateName(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "name", "body", m.Name); err != nil {
		return err
	}

	return nil
}

func (m *Plex) contextValidateOnline(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "online", "body", m.Online); err != nil {
		return err
	}

	return nil
}

func (m *Plex) contextValidatePlexInlineRaidGroups(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "raid_groups", "body", []*RaidGroup(m.PlexInlineRaidGroups)); err != nil {
		return err
	}

	for i := 0; i < len(m.PlexInlineRaidGroups); i++ {

		if m.PlexInlineRaidGroups[i] != nil {
			if err := m.PlexInlineRaidGroups[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("raid_groups" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *Plex) contextValidatePool(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "pool", "body", m.Pool); err != nil {
		return err
	}

	return nil
}

func (m *Plex) contextValidateResync(ctx context.Context, formats strfmt.Registry) error {

	if m.Resync != nil {
		if err := m.Resync.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("resync")
			}
			return err
		}
	}

	return nil
}

func (m *Plex) contextValidateState(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "state", "body", m.State); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *Plex) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *Plex) UnmarshalBinary(b []byte) error {
	var res Plex
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// PlexInlineAggregate Aggregate
//
// swagger:model plex_inline_aggregate
type PlexInlineAggregate struct {

	// links
	Links *PlexInlineAggregateInlineLinks `json:"_links,omitempty"`

	// name
	// Example: aggr1
	Name *string `json:"name,omitempty"`

	// uuid
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this plex inline aggregate
func (m *PlexInlineAggregate) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PlexInlineAggregate) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("aggregate" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this plex inline aggregate based on the context it is used
func (m *PlexInlineAggregate) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PlexInlineAggregate) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("aggregate" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *PlexInlineAggregate) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PlexInlineAggregate) UnmarshalBinary(b []byte) error {
	var res PlexInlineAggregate
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// PlexInlineAggregateInlineLinks plex inline aggregate inline links
//
// swagger:model plex_inline_aggregate_inline__links
type PlexInlineAggregateInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this plex inline aggregate inline links
func (m *PlexInlineAggregateInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PlexInlineAggregateInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("aggregate" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this plex inline aggregate inline links based on the context it is used
func (m *PlexInlineAggregateInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PlexInlineAggregateInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("aggregate" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *PlexInlineAggregateInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PlexInlineAggregateInlineLinks) UnmarshalBinary(b []byte) error {
	var res PlexInlineAggregateInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// PlexInlineResync plex inline resync
//
// swagger:model plex_inline_resync
type PlexInlineResync struct {

	// Plex is being resynchronized to its mirrored plex
	// Read Only: true
	Active *bool `json:"active,omitempty"`

	// Plex resyncing level
	// Read Only: true
	// Enum: ["full","incremental"]
	Level *string `json:"level,omitempty"`

	// Plex resyncing percentage
	// Example: 10
	// Read Only: true
	Percent *int64 `json:"percent,omitempty"`
}

// Validate validates this plex inline resync
func (m *PlexInlineResync) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLevel(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var plexInlineResyncTypeLevelPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["full","incremental"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		plexInlineResyncTypeLevelPropEnum = append(plexInlineResyncTypeLevelPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// plex_inline_resync
	// PlexInlineResync
	// level
	// Level
	// full
	// END DEBUGGING
	// PlexInlineResyncLevelFull captures enum value "full"
	PlexInlineResyncLevelFull string = "full"

	// BEGIN DEBUGGING
	// plex_inline_resync
	// PlexInlineResync
	// level
	// Level
	// incremental
	// END DEBUGGING
	// PlexInlineResyncLevelIncremental captures enum value "incremental"
	PlexInlineResyncLevelIncremental string = "incremental"
)

// prop value enum
func (m *PlexInlineResync) validateLevelEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, plexInlineResyncTypeLevelPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *PlexInlineResync) validateLevel(formats strfmt.Registry) error {
	if swag.IsZero(m.Level) { // not required
		return nil
	}

	// value enum
	if err := m.validateLevelEnum("resync"+"."+"level", "body", *m.Level); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this plex inline resync based on the context it is used
func (m *PlexInlineResync) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateActive(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLevel(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidatePercent(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PlexInlineResync) contextValidateActive(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "resync"+"."+"active", "body", m.Active); err != nil {
		return err
	}

	return nil
}

func (m *PlexInlineResync) contextValidateLevel(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "resync"+"."+"level", "body", m.Level); err != nil {
		return err
	}

	return nil
}

func (m *PlexInlineResync) contextValidatePercent(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "resync"+"."+"percent", "body", m.Percent); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *PlexInlineResync) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PlexInlineResync) UnmarshalBinary(b []byte) error {
	var res PlexInlineResync
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
