// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// PoliciesAndRulesToBeApplied policies and rules to be applied
//
// swagger:model policies_and_rules_to_be_applied
type PoliciesAndRulesToBeApplied struct {

	// svm
	Svm *PoliciesAndRulesToBeAppliedInlineSvm `json:"svm,omitempty"`

	// to be applied
	ToBeApplied *PoliciesAndRulesToBeAppliedInlineToBeApplied `json:"to_be_applied,omitempty"`
}

// Validate validates this policies and rules to be applied
func (m *PoliciesAndRulesToBeApplied) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSvm(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateToBeApplied(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PoliciesAndRulesToBeApplied) validateSvm(formats strfmt.Registry) error {
	if swag.IsZero(m.Svm) { // not required
		return nil
	}

	if m.Svm != nil {
		if err := m.Svm.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm")
			}
			return err
		}
	}

	return nil
}

func (m *PoliciesAndRulesToBeApplied) validateToBeApplied(formats strfmt.Registry) error {
	if swag.IsZero(m.ToBeApplied) { // not required
		return nil
	}

	if m.ToBeApplied != nil {
		if err := m.ToBeApplied.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("to_be_applied")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this policies and rules to be applied based on the context it is used
func (m *PoliciesAndRulesToBeApplied) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSvm(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateToBeApplied(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PoliciesAndRulesToBeApplied) contextValidateSvm(ctx context.Context, formats strfmt.Registry) error {

	if m.Svm != nil {
		if err := m.Svm.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm")
			}
			return err
		}
	}

	return nil
}

func (m *PoliciesAndRulesToBeApplied) contextValidateToBeApplied(ctx context.Context, formats strfmt.Registry) error {

	if m.ToBeApplied != nil {
		if err := m.ToBeApplied.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("to_be_applied")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *PoliciesAndRulesToBeApplied) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PoliciesAndRulesToBeApplied) UnmarshalBinary(b []byte) error {
	var res PoliciesAndRulesToBeApplied
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// PoliciesAndRulesToBeAppliedInlineSvm SVM, applies only to SVM-scoped objects.
//
// swagger:model policies_and_rules_to_be_applied_inline_svm
type PoliciesAndRulesToBeAppliedInlineSvm struct {

	// links
	Links *PoliciesAndRulesToBeAppliedInlineSvmInlineLinks `json:"_links,omitempty"`

	// The name of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: svm1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: 02c9e252-41be-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this policies and rules to be applied inline svm
func (m *PoliciesAndRulesToBeAppliedInlineSvm) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PoliciesAndRulesToBeAppliedInlineSvm) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this policies and rules to be applied inline svm based on the context it is used
func (m *PoliciesAndRulesToBeAppliedInlineSvm) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PoliciesAndRulesToBeAppliedInlineSvm) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *PoliciesAndRulesToBeAppliedInlineSvm) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PoliciesAndRulesToBeAppliedInlineSvm) UnmarshalBinary(b []byte) error {
	var res PoliciesAndRulesToBeAppliedInlineSvm
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// PoliciesAndRulesToBeAppliedInlineSvmInlineLinks policies and rules to be applied inline svm inline links
//
// swagger:model policies_and_rules_to_be_applied_inline_svm_inline__links
type PoliciesAndRulesToBeAppliedInlineSvmInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this policies and rules to be applied inline svm inline links
func (m *PoliciesAndRulesToBeAppliedInlineSvmInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PoliciesAndRulesToBeAppliedInlineSvmInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this policies and rules to be applied inline svm inline links based on the context it is used
func (m *PoliciesAndRulesToBeAppliedInlineSvmInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PoliciesAndRulesToBeAppliedInlineSvmInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *PoliciesAndRulesToBeAppliedInlineSvmInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PoliciesAndRulesToBeAppliedInlineSvmInlineLinks) UnmarshalBinary(b []byte) error {
	var res PoliciesAndRulesToBeAppliedInlineSvmInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// PoliciesAndRulesToBeAppliedInlineToBeApplied policies and rules to be applied inline to be applied
//
// swagger:model policies_and_rules_to_be_applied_inline_to_be_applied
type PoliciesAndRulesToBeAppliedInlineToBeApplied struct {

	// access policies
	AccessPolicies []*GroupPolicyObjectCentralAccessPolicy `json:"access_policies,omitempty"`

	// access rules
	AccessRules []*GroupPolicyObjectCentralAccessRule `json:"access_rules,omitempty"`

	// objects
	Objects []*GroupPolicyObject `json:"objects,omitempty"`

	// restricted groups
	RestrictedGroups []*GroupPolicyObjectRestrictedGroup `json:"restricted_groups,omitempty"`
}

// Validate validates this policies and rules to be applied inline to be applied
func (m *PoliciesAndRulesToBeAppliedInlineToBeApplied) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateAccessPolicies(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateAccessRules(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateObjects(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateRestrictedGroups(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PoliciesAndRulesToBeAppliedInlineToBeApplied) validateAccessPolicies(formats strfmt.Registry) error {
	if swag.IsZero(m.AccessPolicies) { // not required
		return nil
	}

	for i := 0; i < len(m.AccessPolicies); i++ {
		if swag.IsZero(m.AccessPolicies[i]) { // not required
			continue
		}

		if m.AccessPolicies[i] != nil {
			if err := m.AccessPolicies[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("to_be_applied" + "." + "access_policies" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *PoliciesAndRulesToBeAppliedInlineToBeApplied) validateAccessRules(formats strfmt.Registry) error {
	if swag.IsZero(m.AccessRules) { // not required
		return nil
	}

	for i := 0; i < len(m.AccessRules); i++ {
		if swag.IsZero(m.AccessRules[i]) { // not required
			continue
		}

		if m.AccessRules[i] != nil {
			if err := m.AccessRules[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("to_be_applied" + "." + "access_rules" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *PoliciesAndRulesToBeAppliedInlineToBeApplied) validateObjects(formats strfmt.Registry) error {
	if swag.IsZero(m.Objects) { // not required
		return nil
	}

	for i := 0; i < len(m.Objects); i++ {
		if swag.IsZero(m.Objects[i]) { // not required
			continue
		}

		if m.Objects[i] != nil {
			if err := m.Objects[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("to_be_applied" + "." + "objects" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *PoliciesAndRulesToBeAppliedInlineToBeApplied) validateRestrictedGroups(formats strfmt.Registry) error {
	if swag.IsZero(m.RestrictedGroups) { // not required
		return nil
	}

	for i := 0; i < len(m.RestrictedGroups); i++ {
		if swag.IsZero(m.RestrictedGroups[i]) { // not required
			continue
		}

		if m.RestrictedGroups[i] != nil {
			if err := m.RestrictedGroups[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("to_be_applied" + "." + "restricted_groups" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this policies and rules to be applied inline to be applied based on the context it is used
func (m *PoliciesAndRulesToBeAppliedInlineToBeApplied) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateAccessPolicies(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateAccessRules(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateObjects(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateRestrictedGroups(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PoliciesAndRulesToBeAppliedInlineToBeApplied) contextValidateAccessPolicies(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.AccessPolicies); i++ {

		if m.AccessPolicies[i] != nil {
			if err := m.AccessPolicies[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("to_be_applied" + "." + "access_policies" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *PoliciesAndRulesToBeAppliedInlineToBeApplied) contextValidateAccessRules(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.AccessRules); i++ {

		if m.AccessRules[i] != nil {
			if err := m.AccessRules[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("to_be_applied" + "." + "access_rules" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *PoliciesAndRulesToBeAppliedInlineToBeApplied) contextValidateObjects(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.Objects); i++ {

		if m.Objects[i] != nil {
			if err := m.Objects[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("to_be_applied" + "." + "objects" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *PoliciesAndRulesToBeAppliedInlineToBeApplied) contextValidateRestrictedGroups(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.RestrictedGroups); i++ {

		if m.RestrictedGroups[i] != nil {
			if err := m.RestrictedGroups[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("to_be_applied" + "." + "restricted_groups" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *PoliciesAndRulesToBeAppliedInlineToBeApplied) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PoliciesAndRulesToBeAppliedInlineToBeApplied) UnmarshalBinary(b []byte) error {
	var res PoliciesAndRulesToBeAppliedInlineToBeApplied
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
