// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// PoliciesAndRulesToBeAppliedResponse policies and rules to be applied response
//
// swagger:model policies_and_rules_to_be_applied_response
type PoliciesAndRulesToBeAppliedResponse struct {

	// links
	Links *PoliciesAndRulesToBeAppliedResponseInlineLinks `json:"_links,omitempty"`

	// Number of central access rules.
	// Example: 1
	NumRecords *int64 `json:"num_records,omitempty"`

	// policies and rules to be applied response inline records
	PoliciesAndRulesToBeAppliedResponseInlineRecords []*PoliciesAndRulesToBeApplied `json:"records,omitempty"`
}

// Validate validates this policies and rules to be applied response
func (m *PoliciesAndRulesToBeAppliedResponse) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePoliciesAndRulesToBeAppliedResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PoliciesAndRulesToBeAppliedResponse) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *PoliciesAndRulesToBeAppliedResponse) validatePoliciesAndRulesToBeAppliedResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(m.PoliciesAndRulesToBeAppliedResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(m.PoliciesAndRulesToBeAppliedResponseInlineRecords); i++ {
		if swag.IsZero(m.PoliciesAndRulesToBeAppliedResponseInlineRecords[i]) { // not required
			continue
		}

		if m.PoliciesAndRulesToBeAppliedResponseInlineRecords[i] != nil {
			if err := m.PoliciesAndRulesToBeAppliedResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this policies and rules to be applied response based on the context it is used
func (m *PoliciesAndRulesToBeAppliedResponse) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidatePoliciesAndRulesToBeAppliedResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PoliciesAndRulesToBeAppliedResponse) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *PoliciesAndRulesToBeAppliedResponse) contextValidatePoliciesAndRulesToBeAppliedResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.PoliciesAndRulesToBeAppliedResponseInlineRecords); i++ {

		if m.PoliciesAndRulesToBeAppliedResponseInlineRecords[i] != nil {
			if err := m.PoliciesAndRulesToBeAppliedResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *PoliciesAndRulesToBeAppliedResponse) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PoliciesAndRulesToBeAppliedResponse) UnmarshalBinary(b []byte) error {
	var res PoliciesAndRulesToBeAppliedResponse
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// PoliciesAndRulesToBeAppliedResponseInlineLinks policies and rules to be applied response inline links
//
// swagger:model policies_and_rules_to_be_applied_response_inline__links
type PoliciesAndRulesToBeAppliedResponseInlineLinks struct {

	// next
	Next *Href `json:"next,omitempty"`

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this policies and rules to be applied response inline links
func (m *PoliciesAndRulesToBeAppliedResponseInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateNext(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PoliciesAndRulesToBeAppliedResponseInlineLinks) validateNext(formats strfmt.Registry) error {
	if swag.IsZero(m.Next) { // not required
		return nil
	}

	if m.Next != nil {
		if err := m.Next.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "next")
			}
			return err
		}
	}

	return nil
}

func (m *PoliciesAndRulesToBeAppliedResponseInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this policies and rules to be applied response inline links based on the context it is used
func (m *PoliciesAndRulesToBeAppliedResponseInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateNext(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PoliciesAndRulesToBeAppliedResponseInlineLinks) contextValidateNext(ctx context.Context, formats strfmt.Registry) error {

	if m.Next != nil {
		if err := m.Next.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "next")
			}
			return err
		}
	}

	return nil
}

func (m *PoliciesAndRulesToBeAppliedResponseInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *PoliciesAndRulesToBeAppliedResponseInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PoliciesAndRulesToBeAppliedResponseInlineLinks) UnmarshalBinary(b []byte) error {
	var res PoliciesAndRulesToBeAppliedResponseInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
