// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// Port port
//
// swagger:model port
type Port struct {

	// links
	Links *PortInlineLinks `json:"_links,omitempty"`

	// broadcast domain
	BroadcastDomain *PortInlineBroadcastDomain `json:"broadcast_domain,omitempty"`

	// enabled
	Enabled *bool `json:"enabled,omitempty"`

	// Requested flow control
	// Enum: ["none","send","receive","full","pfc"]
	FlowcontrolAdmin *string `json:"flowcontrol_admin,omitempty"`

	// Number of interfaces hosted. This field is only applicable for cluster administrators. No value is returned for SVM administrators. If the node hosting a port is not healthy no value will be returned.
	// Read Only: true
	InterfaceCount *int64 `json:"interface_count,omitempty"`

	// lag
	Lag *PortInlineLag `json:"lag,omitempty"`

	// mac address
	// Example: 01:02:03:04:05:06
	// Read Only: true
	MacAddress *string `json:"mac_address,omitempty"`

	// metric
	Metric *PortInlineMetric `json:"metric,omitempty"`

	// MTU of the port in bytes. Set by broadcast domain.
	// Example: 1500
	// Read Only: true
	// Minimum: 68
	Mtu *int64 `json:"mtu,omitempty"`

	// Portname, such as e0a, e1b-100 (VLAN on Ethernet), a0c (LAG/ifgrp), a0d-200 (VLAN on LAG/ifgrp), e0a.pv1 (p-VLAN, in select environments only)
	// Example: e1b
	// Read Only: true
	Name *string `json:"name,omitempty"`

	// node
	Node *PortInlineNode `json:"node,omitempty"`

	// Discovered devices
	// Read Only: true
	PortInlineDiscoveredDevices []*PortInlineDiscoveredDevicesInlineArrayItem `json:"discovered_devices,omitempty"`

	// List of PFC queues
	PortInlinePfcQueuesAdmin []*int64 `json:"pfc_queues_admin,omitempty"`

	// Reachable broadcast domains.
	// Read Only: true
	PortInlineReachableBroadcastDomains []*PortInlineReachableBroadcastDomainsInlineArrayItem `json:"reachable_broadcast_domains,omitempty"`

	// Supported RDMA offload protocols
	// Read Only: true
	RdmaProtocols []*string `json:"rdma_protocols,omitempty"`

	// Reachability status of the port. Enum value "ok" is the only acceptable value for a PATCH request to repair a port.
	// Example: ok
	// Enum: ["ok","repairable","not_repairable"]
	Reachability *string `json:"reachability,omitempty"`

	// Link speed in Mbps
	// Example: 1000
	// Read Only: true
	Speed *int64 `json:"speed,omitempty"`

	// Operational state of the port. The state is set to 'down' if the operational state of the port is down. The state is set to 'up' if the link state of the port is up and the port is healthy. The state is set to 'up' if the link state of the port is up and configured to ignore health status. The state is 'degraded' if the link state of the port is up, and the port is not healthy.
	// Read Only: true
	// Enum: ["up","down","degraded"]
	State *string `json:"state,omitempty"`

	// statistics
	Statistics *PortInlineStatistics `json:"statistics,omitempty"`

	// Type of physical or virtual port
	// Enum: ["vlan","physical","lag","pvlan"]
	Type *string `json:"type,omitempty"`

	// Port UUID
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`

	// vlan
	Vlan *PortInlineVlan `json:"vlan,omitempty"`
}

// Validate validates this port
func (m *Port) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateBroadcastDomain(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateFlowcontrolAdmin(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLag(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateMetric(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateMtu(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateNode(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePortInlineDiscoveredDevices(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePortInlinePfcQueuesAdmin(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePortInlineReachableBroadcastDomains(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateRdmaProtocols(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateReachability(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStatistics(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateType(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateVlan(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *Port) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *Port) validateBroadcastDomain(formats strfmt.Registry) error {
	if swag.IsZero(m.BroadcastDomain) { // not required
		return nil
	}

	if m.BroadcastDomain != nil {
		if err := m.BroadcastDomain.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("broadcast_domain")
			}
			return err
		}
	}

	return nil
}

var portTypeFlowcontrolAdminPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["none","send","receive","full","pfc"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		portTypeFlowcontrolAdminPropEnum = append(portTypeFlowcontrolAdminPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// port
	// Port
	// flowcontrol_admin
	// FlowcontrolAdmin
	// none
	// END DEBUGGING
	// PortFlowcontrolAdminNone captures enum value "none"
	PortFlowcontrolAdminNone string = "none"

	// BEGIN DEBUGGING
	// port
	// Port
	// flowcontrol_admin
	// FlowcontrolAdmin
	// send
	// END DEBUGGING
	// PortFlowcontrolAdminSend captures enum value "send"
	PortFlowcontrolAdminSend string = "send"

	// BEGIN DEBUGGING
	// port
	// Port
	// flowcontrol_admin
	// FlowcontrolAdmin
	// receive
	// END DEBUGGING
	// PortFlowcontrolAdminReceive captures enum value "receive"
	PortFlowcontrolAdminReceive string = "receive"

	// BEGIN DEBUGGING
	// port
	// Port
	// flowcontrol_admin
	// FlowcontrolAdmin
	// full
	// END DEBUGGING
	// PortFlowcontrolAdminFull captures enum value "full"
	PortFlowcontrolAdminFull string = "full"

	// BEGIN DEBUGGING
	// port
	// Port
	// flowcontrol_admin
	// FlowcontrolAdmin
	// pfc
	// END DEBUGGING
	// PortFlowcontrolAdminPfc captures enum value "pfc"
	PortFlowcontrolAdminPfc string = "pfc"
)

// prop value enum
func (m *Port) validateFlowcontrolAdminEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, portTypeFlowcontrolAdminPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *Port) validateFlowcontrolAdmin(formats strfmt.Registry) error {
	if swag.IsZero(m.FlowcontrolAdmin) { // not required
		return nil
	}

	// value enum
	if err := m.validateFlowcontrolAdminEnum("flowcontrol_admin", "body", *m.FlowcontrolAdmin); err != nil {
		return err
	}

	return nil
}

func (m *Port) validateLag(formats strfmt.Registry) error {
	if swag.IsZero(m.Lag) { // not required
		return nil
	}

	if m.Lag != nil {
		if err := m.Lag.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("lag")
			}
			return err
		}
	}

	return nil
}

func (m *Port) validateMetric(formats strfmt.Registry) error {
	if swag.IsZero(m.Metric) { // not required
		return nil
	}

	if m.Metric != nil {
		if err := m.Metric.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric")
			}
			return err
		}
	}

	return nil
}

func (m *Port) validateMtu(formats strfmt.Registry) error {
	if swag.IsZero(m.Mtu) { // not required
		return nil
	}

	if err := validate.MinimumInt("mtu", "body", *m.Mtu, 68, false); err != nil {
		return err
	}

	return nil
}

func (m *Port) validateNode(formats strfmt.Registry) error {
	if swag.IsZero(m.Node) { // not required
		return nil
	}

	if m.Node != nil {
		if err := m.Node.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node")
			}
			return err
		}
	}

	return nil
}

func (m *Port) validatePortInlineDiscoveredDevices(formats strfmt.Registry) error {
	if swag.IsZero(m.PortInlineDiscoveredDevices) { // not required
		return nil
	}

	for i := 0; i < len(m.PortInlineDiscoveredDevices); i++ {
		if swag.IsZero(m.PortInlineDiscoveredDevices[i]) { // not required
			continue
		}

		if m.PortInlineDiscoveredDevices[i] != nil {
			if err := m.PortInlineDiscoveredDevices[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("discovered_devices" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *Port) validatePortInlinePfcQueuesAdmin(formats strfmt.Registry) error {
	if swag.IsZero(m.PortInlinePfcQueuesAdmin) { // not required
		return nil
	}

	for i := 0; i < len(m.PortInlinePfcQueuesAdmin); i++ {
		if swag.IsZero(m.PortInlinePfcQueuesAdmin[i]) { // not required
			continue
		}

		if err := validate.MinimumInt("pfc_queues_admin"+"."+strconv.Itoa(i), "body", *m.PortInlinePfcQueuesAdmin[i], 0, false); err != nil {
			return err
		}

		if err := validate.MaximumInt("pfc_queues_admin"+"."+strconv.Itoa(i), "body", *m.PortInlinePfcQueuesAdmin[i], 7, false); err != nil {
			return err
		}

	}

	return nil
}

func (m *Port) validatePortInlineReachableBroadcastDomains(formats strfmt.Registry) error {
	if swag.IsZero(m.PortInlineReachableBroadcastDomains) { // not required
		return nil
	}

	for i := 0; i < len(m.PortInlineReachableBroadcastDomains); i++ {
		if swag.IsZero(m.PortInlineReachableBroadcastDomains[i]) { // not required
			continue
		}

		if m.PortInlineReachableBroadcastDomains[i] != nil {
			if err := m.PortInlineReachableBroadcastDomains[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("reachable_broadcast_domains" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

var portRdmaProtocolsItemsEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["roce"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		portRdmaProtocolsItemsEnum = append(portRdmaProtocolsItemsEnum, v)
	}
}

func (m *Port) validateRdmaProtocolsItemsEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, portRdmaProtocolsItemsEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *Port) validateRdmaProtocols(formats strfmt.Registry) error {
	if swag.IsZero(m.RdmaProtocols) { // not required
		return nil
	}

	for i := 0; i < len(m.RdmaProtocols); i++ {
		if swag.IsZero(m.RdmaProtocols[i]) { // not required
			continue
		}

		// value enum
		if err := m.validateRdmaProtocolsItemsEnum("rdma_protocols"+"."+strconv.Itoa(i), "body", *m.RdmaProtocols[i]); err != nil {
			return err
		}

	}

	return nil
}

var portTypeReachabilityPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ok","repairable","not_repairable"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		portTypeReachabilityPropEnum = append(portTypeReachabilityPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// port
	// Port
	// reachability
	// Reachability
	// ok
	// END DEBUGGING
	// PortReachabilityOk captures enum value "ok"
	PortReachabilityOk string = "ok"

	// BEGIN DEBUGGING
	// port
	// Port
	// reachability
	// Reachability
	// repairable
	// END DEBUGGING
	// PortReachabilityRepairable captures enum value "repairable"
	PortReachabilityRepairable string = "repairable"

	// BEGIN DEBUGGING
	// port
	// Port
	// reachability
	// Reachability
	// not_repairable
	// END DEBUGGING
	// PortReachabilityNotRepairable captures enum value "not_repairable"
	PortReachabilityNotRepairable string = "not_repairable"
)

// prop value enum
func (m *Port) validateReachabilityEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, portTypeReachabilityPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *Port) validateReachability(formats strfmt.Registry) error {
	if swag.IsZero(m.Reachability) { // not required
		return nil
	}

	// value enum
	if err := m.validateReachabilityEnum("reachability", "body", *m.Reachability); err != nil {
		return err
	}

	return nil
}

var portTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["up","down","degraded"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		portTypeStatePropEnum = append(portTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// port
	// Port
	// state
	// State
	// up
	// END DEBUGGING
	// PortStateUp captures enum value "up"
	PortStateUp string = "up"

	// BEGIN DEBUGGING
	// port
	// Port
	// state
	// State
	// down
	// END DEBUGGING
	// PortStateDown captures enum value "down"
	PortStateDown string = "down"

	// BEGIN DEBUGGING
	// port
	// Port
	// state
	// State
	// degraded
	// END DEBUGGING
	// PortStateDegraded captures enum value "degraded"
	PortStateDegraded string = "degraded"
)

// prop value enum
func (m *Port) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, portTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *Port) validateState(formats strfmt.Registry) error {
	if swag.IsZero(m.State) { // not required
		return nil
	}

	// value enum
	if err := m.validateStateEnum("state", "body", *m.State); err != nil {
		return err
	}

	return nil
}

func (m *Port) validateStatistics(formats strfmt.Registry) error {
	if swag.IsZero(m.Statistics) { // not required
		return nil
	}

	if m.Statistics != nil {
		if err := m.Statistics.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics")
			}
			return err
		}
	}

	return nil
}

var portTypeTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["vlan","physical","lag","pvlan"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		portTypeTypePropEnum = append(portTypeTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// port
	// Port
	// type
	// Type
	// vlan
	// END DEBUGGING
	// PortTypeVlan captures enum value "vlan"
	PortTypeVlan string = "vlan"

	// BEGIN DEBUGGING
	// port
	// Port
	// type
	// Type
	// physical
	// END DEBUGGING
	// PortTypePhysical captures enum value "physical"
	PortTypePhysical string = "physical"

	// BEGIN DEBUGGING
	// port
	// Port
	// type
	// Type
	// lag
	// END DEBUGGING
	// PortTypeLag captures enum value "lag"
	PortTypeLag string = "lag"

	// BEGIN DEBUGGING
	// port
	// Port
	// type
	// Type
	// pvlan
	// END DEBUGGING
	// PortTypePvlan captures enum value "pvlan"
	PortTypePvlan string = "pvlan"
)

// prop value enum
func (m *Port) validateTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, portTypeTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *Port) validateType(formats strfmt.Registry) error {
	if swag.IsZero(m.Type) { // not required
		return nil
	}

	// value enum
	if err := m.validateTypeEnum("type", "body", *m.Type); err != nil {
		return err
	}

	return nil
}

func (m *Port) validateVlan(formats strfmt.Registry) error {
	if swag.IsZero(m.Vlan) { // not required
		return nil
	}

	if m.Vlan != nil {
		if err := m.Vlan.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("vlan")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this port based on the context it is used
func (m *Port) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateBroadcastDomain(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateInterfaceCount(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLag(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMacAddress(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMetric(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMtu(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateName(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateNode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidatePortInlineDiscoveredDevices(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidatePortInlineReachableBroadcastDomains(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateRdmaProtocols(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSpeed(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStatistics(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateVlan(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *Port) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *Port) contextValidateBroadcastDomain(ctx context.Context, formats strfmt.Registry) error {

	if m.BroadcastDomain != nil {
		if err := m.BroadcastDomain.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("broadcast_domain")
			}
			return err
		}
	}

	return nil
}

func (m *Port) contextValidateInterfaceCount(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "interface_count", "body", m.InterfaceCount); err != nil {
		return err
	}

	return nil
}

func (m *Port) contextValidateLag(ctx context.Context, formats strfmt.Registry) error {

	if m.Lag != nil {
		if err := m.Lag.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("lag")
			}
			return err
		}
	}

	return nil
}

func (m *Port) contextValidateMacAddress(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "mac_address", "body", m.MacAddress); err != nil {
		return err
	}

	return nil
}

func (m *Port) contextValidateMetric(ctx context.Context, formats strfmt.Registry) error {

	if m.Metric != nil {
		if err := m.Metric.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric")
			}
			return err
		}
	}

	return nil
}

func (m *Port) contextValidateMtu(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "mtu", "body", m.Mtu); err != nil {
		return err
	}

	return nil
}

func (m *Port) contextValidateName(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "name", "body", m.Name); err != nil {
		return err
	}

	return nil
}

func (m *Port) contextValidateNode(ctx context.Context, formats strfmt.Registry) error {

	if m.Node != nil {
		if err := m.Node.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node")
			}
			return err
		}
	}

	return nil
}

func (m *Port) contextValidatePortInlineDiscoveredDevices(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "discovered_devices", "body", []*PortInlineDiscoveredDevicesInlineArrayItem(m.PortInlineDiscoveredDevices)); err != nil {
		return err
	}

	for i := 0; i < len(m.PortInlineDiscoveredDevices); i++ {

		if m.PortInlineDiscoveredDevices[i] != nil {
			if err := m.PortInlineDiscoveredDevices[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("discovered_devices" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *Port) contextValidatePortInlineReachableBroadcastDomains(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "reachable_broadcast_domains", "body", []*PortInlineReachableBroadcastDomainsInlineArrayItem(m.PortInlineReachableBroadcastDomains)); err != nil {
		return err
	}

	for i := 0; i < len(m.PortInlineReachableBroadcastDomains); i++ {

		if m.PortInlineReachableBroadcastDomains[i] != nil {
			if err := m.PortInlineReachableBroadcastDomains[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("reachable_broadcast_domains" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *Port) contextValidateRdmaProtocols(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "rdma_protocols", "body", []*string(m.RdmaProtocols)); err != nil {
		return err
	}

	return nil
}

func (m *Port) contextValidateSpeed(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "speed", "body", m.Speed); err != nil {
		return err
	}

	return nil
}

func (m *Port) contextValidateState(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "state", "body", m.State); err != nil {
		return err
	}

	return nil
}

func (m *Port) contextValidateStatistics(ctx context.Context, formats strfmt.Registry) error {

	if m.Statistics != nil {
		if err := m.Statistics.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics")
			}
			return err
		}
	}

	return nil
}

func (m *Port) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "uuid", "body", m.UUID); err != nil {
		return err
	}

	return nil
}

func (m *Port) contextValidateVlan(ctx context.Context, formats strfmt.Registry) error {

	if m.Vlan != nil {
		if err := m.Vlan.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("vlan")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *Port) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *Port) UnmarshalBinary(b []byte) error {
	var res Port
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// PortInlineBroadcastDomain Broadcast domain UUID along with a readable name. Either the UUID or both names may be provided on input.
//
// swagger:model port_inline_broadcast_domain
type PortInlineBroadcastDomain struct {

	// links
	Links *PortInlineBroadcastDomainInlineLinks `json:"_links,omitempty"`

	// ipspace
	Ipspace *PortInlineBroadcastDomainInlineIpspace `json:"ipspace,omitempty"`

	// Name of the broadcast domain, scoped to its IPspace
	// Example: bd1
	Name *string `json:"name,omitempty"`

	// Broadcast domain UUID
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this port inline broadcast domain
func (m *PortInlineBroadcastDomain) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateIpspace(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PortInlineBroadcastDomain) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("broadcast_domain" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (m *PortInlineBroadcastDomain) validateIpspace(formats strfmt.Registry) error {
	if swag.IsZero(m.Ipspace) { // not required
		return nil
	}

	if m.Ipspace != nil {
		if err := m.Ipspace.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("broadcast_domain" + "." + "ipspace")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this port inline broadcast domain based on the context it is used
func (m *PortInlineBroadcastDomain) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIpspace(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PortInlineBroadcastDomain) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("broadcast_domain" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (m *PortInlineBroadcastDomain) contextValidateIpspace(ctx context.Context, formats strfmt.Registry) error {

	if m.Ipspace != nil {
		if err := m.Ipspace.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("broadcast_domain" + "." + "ipspace")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *PortInlineBroadcastDomain) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PortInlineBroadcastDomain) UnmarshalBinary(b []byte) error {
	var res PortInlineBroadcastDomain
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// PortInlineBroadcastDomainInlineIpspace port inline broadcast domain inline ipspace
//
// swagger:model port_inline_broadcast_domain_inline_ipspace
type PortInlineBroadcastDomainInlineIpspace struct {

	// Name of the broadcast domain's IPspace
	// Example: ipspace1
	Name *string `json:"name,omitempty"`
}

// Validate validates this port inline broadcast domain inline ipspace
func (m *PortInlineBroadcastDomainInlineIpspace) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this port inline broadcast domain inline ipspace based on context it is used
func (m *PortInlineBroadcastDomainInlineIpspace) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *PortInlineBroadcastDomainInlineIpspace) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PortInlineBroadcastDomainInlineIpspace) UnmarshalBinary(b []byte) error {
	var res PortInlineBroadcastDomainInlineIpspace
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// PortInlineBroadcastDomainInlineLinks port inline broadcast domain inline links
//
// swagger:model port_inline_broadcast_domain_inline__links
type PortInlineBroadcastDomainInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this port inline broadcast domain inline links
func (m *PortInlineBroadcastDomainInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PortInlineBroadcastDomainInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("broadcast_domain" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this port inline broadcast domain inline links based on the context it is used
func (m *PortInlineBroadcastDomainInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PortInlineBroadcastDomainInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("broadcast_domain" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *PortInlineBroadcastDomainInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PortInlineBroadcastDomainInlineLinks) UnmarshalBinary(b []byte) error {
	var res PortInlineBroadcastDomainInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// PortInlineDiscoveredDevicesInlineArrayItem port inline discovered devices inline array item
//
// swagger:model port_inline_discovered_devices_inline_array_item
type PortInlineDiscoveredDevicesInlineArrayItem struct {

	// The list of the capabilities of the discovered device.
	// Example: ["router","switch"]
	Capabilities []*string `json:"capabilities"`

	// Identifier associated with this specific discovered device, useful for locating the device in a data center.
	ChassisID *string `json:"chassis_id,omitempty"`

	// The IP addresses on the discovered device.
	// Example: ["192.168.100.24","192.168.100.26"]
	IPAddresses []*IPAddressReadonly `json:"ip_addresses"`

	// Name of the discovered device.
	// Example: ETY-R1S4-510Q13.datacenter.example.com
	Name *string `json:"name,omitempty"`

	// Hardware platform of the discovered device.
	// Example: 93180YC-EX
	Platform *string `json:"platform,omitempty"`

	// The protocol used to identify the discovered device. This can have a value of CDP or LLDP.
	// Example: cdp
	// Enum: ["cdp","lldp"]
	Protocol *string `json:"protocol,omitempty"`

	// The number of seconds until the discovered device entry expires and is removed.
	RemainingHoldTime *int64 `json:"remaining_hold_time,omitempty"`

	// The name of the remote port on the discovered device. The format is dependent on the reporting device.
	// Example: FastEthernet0/12
	RemotePort *string `json:"remote_port,omitempty"`

	// Additional name used to identify a specific piece of equipment.
	SystemName *string `json:"system_name,omitempty"`

	// The version of the software running on the discovered device.
	// Example: Cisco Nexus Operating System (NX-OS) Software, Version 8.1
	Version *string `json:"version,omitempty"`
}

// Validate validates this port inline discovered devices inline array item
func (m *PortInlineDiscoveredDevicesInlineArrayItem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateCapabilities(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateIPAddresses(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateProtocol(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var portInlineDiscoveredDevicesInlineArrayItemCapabilitiesItemsEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["router","transparent_bridge","source_route_bridge","switch","host","igmp","repeater","phone"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		portInlineDiscoveredDevicesInlineArrayItemCapabilitiesItemsEnum = append(portInlineDiscoveredDevicesInlineArrayItemCapabilitiesItemsEnum, v)
	}
}

func (m *PortInlineDiscoveredDevicesInlineArrayItem) validateCapabilitiesItemsEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, portInlineDiscoveredDevicesInlineArrayItemCapabilitiesItemsEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *PortInlineDiscoveredDevicesInlineArrayItem) validateCapabilities(formats strfmt.Registry) error {
	if swag.IsZero(m.Capabilities) { // not required
		return nil
	}

	for i := 0; i < len(m.Capabilities); i++ {
		if swag.IsZero(m.Capabilities[i]) { // not required
			continue
		}

		// value enum
		if err := m.validateCapabilitiesItemsEnum("capabilities"+"."+strconv.Itoa(i), "body", *m.Capabilities[i]); err != nil {
			return err
		}

	}

	return nil
}

func (m *PortInlineDiscoveredDevicesInlineArrayItem) validateIPAddresses(formats strfmt.Registry) error {
	if swag.IsZero(m.IPAddresses) { // not required
		return nil
	}

	for i := 0; i < len(m.IPAddresses); i++ {
		if swag.IsZero(m.IPAddresses[i]) { // not required
			continue
		}

		if m.IPAddresses[i] != nil {
			if err := m.IPAddresses[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("ip_addresses" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

var portInlineDiscoveredDevicesInlineArrayItemTypeProtocolPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["cdp","lldp"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		portInlineDiscoveredDevicesInlineArrayItemTypeProtocolPropEnum = append(portInlineDiscoveredDevicesInlineArrayItemTypeProtocolPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// port_inline_discovered_devices_inline_array_item
	// PortInlineDiscoveredDevicesInlineArrayItem
	// protocol
	// Protocol
	// cdp
	// END DEBUGGING
	// PortInlineDiscoveredDevicesInlineArrayItemProtocolCdp captures enum value "cdp"
	PortInlineDiscoveredDevicesInlineArrayItemProtocolCdp string = "cdp"

	// BEGIN DEBUGGING
	// port_inline_discovered_devices_inline_array_item
	// PortInlineDiscoveredDevicesInlineArrayItem
	// protocol
	// Protocol
	// lldp
	// END DEBUGGING
	// PortInlineDiscoveredDevicesInlineArrayItemProtocolLldp captures enum value "lldp"
	PortInlineDiscoveredDevicesInlineArrayItemProtocolLldp string = "lldp"
)

// prop value enum
func (m *PortInlineDiscoveredDevicesInlineArrayItem) validateProtocolEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, portInlineDiscoveredDevicesInlineArrayItemTypeProtocolPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *PortInlineDiscoveredDevicesInlineArrayItem) validateProtocol(formats strfmt.Registry) error {
	if swag.IsZero(m.Protocol) { // not required
		return nil
	}

	// value enum
	if err := m.validateProtocolEnum("protocol", "body", *m.Protocol); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this port inline discovered devices inline array item based on the context it is used
func (m *PortInlineDiscoveredDevicesInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateIPAddresses(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PortInlineDiscoveredDevicesInlineArrayItem) contextValidateIPAddresses(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.IPAddresses); i++ {

		if m.IPAddresses[i] != nil {
			if err := m.IPAddresses[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("ip_addresses" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *PortInlineDiscoveredDevicesInlineArrayItem) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PortInlineDiscoveredDevicesInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res PortInlineDiscoveredDevicesInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// PortInlineLag port inline lag
//
// swagger:model port_inline_lag
type PortInlineLag struct {

	// Active ports of a LAG (ifgrp). (Some member ports may be inactive.)
	// Read Only: true
	ActivePorts []*PortLagActivePortsItems0 `json:"active_ports,omitempty"`

	// Policy for mapping flows to ports for outbound packets through a LAG (ifgrp).
	// Enum: ["port","ip","mac","sequential"]
	DistributionPolicy *string `json:"distribution_policy,omitempty"`

	// Array of ports belonging to the LAG, regardless of their state.
	MemberPorts []*PortLagMemberPortsItems0 `json:"member_ports,omitempty"`

	// Determines how the ports interact with the switch.
	// Enum: ["multimode_lacp","multimode","singlemode"]
	Mode *string `json:"mode,omitempty"`
}

// Validate validates this port inline lag
func (m *PortInlineLag) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateActivePorts(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDistributionPolicy(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateMemberPorts(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateMode(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PortInlineLag) validateActivePorts(formats strfmt.Registry) error {
	if swag.IsZero(m.ActivePorts) { // not required
		return nil
	}

	for i := 0; i < len(m.ActivePorts); i++ {
		if swag.IsZero(m.ActivePorts[i]) { // not required
			continue
		}

		if m.ActivePorts[i] != nil {
			if err := m.ActivePorts[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("lag" + "." + "active_ports" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

var portInlineLagTypeDistributionPolicyPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["port","ip","mac","sequential"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		portInlineLagTypeDistributionPolicyPropEnum = append(portInlineLagTypeDistributionPolicyPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// port_inline_lag
	// PortInlineLag
	// distribution_policy
	// DistributionPolicy
	// port
	// END DEBUGGING
	// PortInlineLagDistributionPolicyPort captures enum value "port"
	PortInlineLagDistributionPolicyPort string = "port"

	// BEGIN DEBUGGING
	// port_inline_lag
	// PortInlineLag
	// distribution_policy
	// DistributionPolicy
	// ip
	// END DEBUGGING
	// PortInlineLagDistributionPolicyIP captures enum value "ip"
	PortInlineLagDistributionPolicyIP string = "ip"

	// BEGIN DEBUGGING
	// port_inline_lag
	// PortInlineLag
	// distribution_policy
	// DistributionPolicy
	// mac
	// END DEBUGGING
	// PortInlineLagDistributionPolicyMac captures enum value "mac"
	PortInlineLagDistributionPolicyMac string = "mac"

	// BEGIN DEBUGGING
	// port_inline_lag
	// PortInlineLag
	// distribution_policy
	// DistributionPolicy
	// sequential
	// END DEBUGGING
	// PortInlineLagDistributionPolicySequential captures enum value "sequential"
	PortInlineLagDistributionPolicySequential string = "sequential"
)

// prop value enum
func (m *PortInlineLag) validateDistributionPolicyEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, portInlineLagTypeDistributionPolicyPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *PortInlineLag) validateDistributionPolicy(formats strfmt.Registry) error {
	if swag.IsZero(m.DistributionPolicy) { // not required
		return nil
	}

	// value enum
	if err := m.validateDistributionPolicyEnum("lag"+"."+"distribution_policy", "body", *m.DistributionPolicy); err != nil {
		return err
	}

	return nil
}

func (m *PortInlineLag) validateMemberPorts(formats strfmt.Registry) error {
	if swag.IsZero(m.MemberPorts) { // not required
		return nil
	}

	for i := 0; i < len(m.MemberPorts); i++ {
		if swag.IsZero(m.MemberPorts[i]) { // not required
			continue
		}

		if m.MemberPorts[i] != nil {
			if err := m.MemberPorts[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("lag" + "." + "member_ports" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

var portInlineLagTypeModePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["multimode_lacp","multimode","singlemode"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		portInlineLagTypeModePropEnum = append(portInlineLagTypeModePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// port_inline_lag
	// PortInlineLag
	// mode
	// Mode
	// multimode_lacp
	// END DEBUGGING
	// PortInlineLagModeMultimodeLacp captures enum value "multimode_lacp"
	PortInlineLagModeMultimodeLacp string = "multimode_lacp"

	// BEGIN DEBUGGING
	// port_inline_lag
	// PortInlineLag
	// mode
	// Mode
	// multimode
	// END DEBUGGING
	// PortInlineLagModeMultimode captures enum value "multimode"
	PortInlineLagModeMultimode string = "multimode"

	// BEGIN DEBUGGING
	// port_inline_lag
	// PortInlineLag
	// mode
	// Mode
	// singlemode
	// END DEBUGGING
	// PortInlineLagModeSinglemode captures enum value "singlemode"
	PortInlineLagModeSinglemode string = "singlemode"
)

// prop value enum
func (m *PortInlineLag) validateModeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, portInlineLagTypeModePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *PortInlineLag) validateMode(formats strfmt.Registry) error {
	if swag.IsZero(m.Mode) { // not required
		return nil
	}

	// value enum
	if err := m.validateModeEnum("lag"+"."+"mode", "body", *m.Mode); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this port inline lag based on the context it is used
func (m *PortInlineLag) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateActivePorts(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMemberPorts(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PortInlineLag) contextValidateActivePorts(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "lag"+"."+"active_ports", "body", []*PortLagActivePortsItems0(m.ActivePorts)); err != nil {
		return err
	}

	for i := 0; i < len(m.ActivePorts); i++ {

		if m.ActivePorts[i] != nil {
			if err := m.ActivePorts[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("lag" + "." + "active_ports" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *PortInlineLag) contextValidateMemberPorts(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.MemberPorts); i++ {

		if m.MemberPorts[i] != nil {
			if err := m.MemberPorts[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("lag" + "." + "member_ports" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *PortInlineLag) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PortInlineLag) UnmarshalBinary(b []byte) error {
	var res PortInlineLag
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// PortLagActivePortsItems0 Port UUID along with readable names. Either the UUID or both names may be supplied on input.
//
// swagger:model PortLagActivePortsItems0
type PortLagActivePortsItems0 struct {

	// links
	Links *PortLagActivePortsItems0Links `json:"_links,omitempty"`

	// name
	// Example: e1b
	Name *string `json:"name,omitempty"`

	// node
	Node *PortLagActivePortsItems0Node `json:"node,omitempty"`

	// uuid
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this port lag active ports items0
func (m *PortLagActivePortsItems0) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateNode(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PortLagActivePortsItems0) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *PortLagActivePortsItems0) validateNode(formats strfmt.Registry) error {
	if swag.IsZero(m.Node) { // not required
		return nil
	}

	if m.Node != nil {
		if err := m.Node.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this port lag active ports items0 based on the context it is used
func (m *PortLagActivePortsItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateNode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PortLagActivePortsItems0) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *PortLagActivePortsItems0) contextValidateNode(ctx context.Context, formats strfmt.Registry) error {

	if m.Node != nil {
		if err := m.Node.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *PortLagActivePortsItems0) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PortLagActivePortsItems0) UnmarshalBinary(b []byte) error {
	var res PortLagActivePortsItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// PortLagActivePortsItems0Links port lag active ports items0 links
//
// swagger:model PortLagActivePortsItems0Links
type PortLagActivePortsItems0Links struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this port lag active ports items0 links
func (m *PortLagActivePortsItems0Links) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PortLagActivePortsItems0Links) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this port lag active ports items0 links based on the context it is used
func (m *PortLagActivePortsItems0Links) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PortLagActivePortsItems0Links) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *PortLagActivePortsItems0Links) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PortLagActivePortsItems0Links) UnmarshalBinary(b []byte) error {
	var res PortLagActivePortsItems0Links
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// PortLagActivePortsItems0Node port lag active ports items0 node
//
// swagger:model PortLagActivePortsItems0Node
type PortLagActivePortsItems0Node struct {

	// Name of node on which the port is located.
	// Example: node1
	Name *string `json:"name,omitempty"`
}

// Validate validates this port lag active ports items0 node
func (m *PortLagActivePortsItems0Node) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this port lag active ports items0 node based on context it is used
func (m *PortLagActivePortsItems0Node) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *PortLagActivePortsItems0Node) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PortLagActivePortsItems0Node) UnmarshalBinary(b []byte) error {
	var res PortLagActivePortsItems0Node
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// PortLagMemberPortsItems0 Port UUID along with readable names. Either the UUID or both names may be supplied on input.
//
// swagger:model PortLagMemberPortsItems0
type PortLagMemberPortsItems0 struct {

	// links
	Links *PortLagMemberPortsItems0Links `json:"_links,omitempty"`

	// name
	// Example: e1b
	Name *string `json:"name,omitempty"`

	// node
	Node *PortLagMemberPortsItems0Node `json:"node,omitempty"`

	// uuid
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this port lag member ports items0
func (m *PortLagMemberPortsItems0) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateNode(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PortLagMemberPortsItems0) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *PortLagMemberPortsItems0) validateNode(formats strfmt.Registry) error {
	if swag.IsZero(m.Node) { // not required
		return nil
	}

	if m.Node != nil {
		if err := m.Node.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this port lag member ports items0 based on the context it is used
func (m *PortLagMemberPortsItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateNode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PortLagMemberPortsItems0) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *PortLagMemberPortsItems0) contextValidateNode(ctx context.Context, formats strfmt.Registry) error {

	if m.Node != nil {
		if err := m.Node.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *PortLagMemberPortsItems0) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PortLagMemberPortsItems0) UnmarshalBinary(b []byte) error {
	var res PortLagMemberPortsItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// PortLagMemberPortsItems0Links port lag member ports items0 links
//
// swagger:model PortLagMemberPortsItems0Links
type PortLagMemberPortsItems0Links struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this port lag member ports items0 links
func (m *PortLagMemberPortsItems0Links) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PortLagMemberPortsItems0Links) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this port lag member ports items0 links based on the context it is used
func (m *PortLagMemberPortsItems0Links) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PortLagMemberPortsItems0Links) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *PortLagMemberPortsItems0Links) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PortLagMemberPortsItems0Links) UnmarshalBinary(b []byte) error {
	var res PortLagMemberPortsItems0Links
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// PortLagMemberPortsItems0Node port lag member ports items0 node
//
// swagger:model PortLagMemberPortsItems0Node
type PortLagMemberPortsItems0Node struct {

	// Name of node on which the port is located.
	// Example: node1
	Name *string `json:"name,omitempty"`
}

// Validate validates this port lag member ports items0 node
func (m *PortLagMemberPortsItems0Node) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this port lag member ports items0 node based on context it is used
func (m *PortLagMemberPortsItems0Node) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *PortLagMemberPortsItems0Node) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PortLagMemberPortsItems0Node) UnmarshalBinary(b []byte) error {
	var res PortLagMemberPortsItems0Node
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// PortInlineLinks port inline links
//
// swagger:model port_inline__links
type PortInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this port inline links
func (m *PortInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PortInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this port inline links based on the context it is used
func (m *PortInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PortInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *PortInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PortInlineLinks) UnmarshalBinary(b []byte) error {
	var res PortInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// PortInlineMetric The most recent sample of I/O metrics for the port.
//
// swagger:model port_inline_metric
type PortInlineMetric struct {

	// links
	Links *PortInlineMetricInlineLinks `json:"_links,omitempty"`

	// The duration over which this sample is calculated. The time durations are represented in the ISO-8601 standard format. Samples can be calculated over the following durations:
	//
	// Example: PT15S
	// Enum: ["PT15S","PT4M","PT30M","PT2H","P1D","PT5M"]
	Duration *string `json:"duration,omitempty"`

	// Errors associated with the sample. For example, if the aggregation of data over multiple nodes fails, then any partial errors might return "ok" on success or "error" on an internal uncategorized failure. Whenever a sample collection is missed but done at a later time, it is back filled to the previous 15 second timestamp and tagged with "backfilled_data". "inconsistent_delta_time" is encountered when the time between two collections is not the same for all nodes. Therefore, the aggregated value might be over or under inflated. "Negative_delta" is returned when an expected monotonically increasing value has decreased in value. "inconsistent_old_data" is returned when one or more nodes do not have the latest data.
	// Example: ok
	// Enum: ["ok","error","partial_no_data","partial_no_uuid","partial_no_response","partial_other_error","negative_delta","backfilled_data","inconsistent_delta_time","inconsistent_old_data"]
	Status *string `json:"status,omitempty"`

	// throughput
	Throughput *PortInlineMetricInlineThroughput `json:"throughput,omitempty"`

	// The timestamp of the performance data.
	// Example: 2017-01-25 11:20:13+00:00
	// Format: date-time
	Timestamp *strfmt.DateTime `json:"timestamp,omitempty"`
}

// Validate validates this port inline metric
func (m *PortInlineMetric) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDuration(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateThroughput(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTimestamp(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PortInlineMetric) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

var portInlineMetricTypeDurationPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["PT15S","PT4M","PT30M","PT2H","P1D","PT5M"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		portInlineMetricTypeDurationPropEnum = append(portInlineMetricTypeDurationPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// port_inline_metric
	// PortInlineMetric
	// duration
	// Duration
	// PT15S
	// END DEBUGGING
	// PortInlineMetricDurationPT15S captures enum value "PT15S"
	PortInlineMetricDurationPT15S string = "PT15S"

	// BEGIN DEBUGGING
	// port_inline_metric
	// PortInlineMetric
	// duration
	// Duration
	// PT4M
	// END DEBUGGING
	// PortInlineMetricDurationPT4M captures enum value "PT4M"
	PortInlineMetricDurationPT4M string = "PT4M"

	// BEGIN DEBUGGING
	// port_inline_metric
	// PortInlineMetric
	// duration
	// Duration
	// PT30M
	// END DEBUGGING
	// PortInlineMetricDurationPT30M captures enum value "PT30M"
	PortInlineMetricDurationPT30M string = "PT30M"

	// BEGIN DEBUGGING
	// port_inline_metric
	// PortInlineMetric
	// duration
	// Duration
	// PT2H
	// END DEBUGGING
	// PortInlineMetricDurationPT2H captures enum value "PT2H"
	PortInlineMetricDurationPT2H string = "PT2H"

	// BEGIN DEBUGGING
	// port_inline_metric
	// PortInlineMetric
	// duration
	// Duration
	// P1D
	// END DEBUGGING
	// PortInlineMetricDurationP1D captures enum value "P1D"
	PortInlineMetricDurationP1D string = "P1D"

	// BEGIN DEBUGGING
	// port_inline_metric
	// PortInlineMetric
	// duration
	// Duration
	// PT5M
	// END DEBUGGING
	// PortInlineMetricDurationPT5M captures enum value "PT5M"
	PortInlineMetricDurationPT5M string = "PT5M"
)

// prop value enum
func (m *PortInlineMetric) validateDurationEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, portInlineMetricTypeDurationPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *PortInlineMetric) validateDuration(formats strfmt.Registry) error {
	if swag.IsZero(m.Duration) { // not required
		return nil
	}

	// value enum
	if err := m.validateDurationEnum("metric"+"."+"duration", "body", *m.Duration); err != nil {
		return err
	}

	return nil
}

var portInlineMetricTypeStatusPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ok","error","partial_no_data","partial_no_uuid","partial_no_response","partial_other_error","negative_delta","backfilled_data","inconsistent_delta_time","inconsistent_old_data"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		portInlineMetricTypeStatusPropEnum = append(portInlineMetricTypeStatusPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// port_inline_metric
	// PortInlineMetric
	// status
	// Status
	// ok
	// END DEBUGGING
	// PortInlineMetricStatusOk captures enum value "ok"
	PortInlineMetricStatusOk string = "ok"

	// BEGIN DEBUGGING
	// port_inline_metric
	// PortInlineMetric
	// status
	// Status
	// error
	// END DEBUGGING
	// PortInlineMetricStatusError captures enum value "error"
	PortInlineMetricStatusError string = "error"

	// BEGIN DEBUGGING
	// port_inline_metric
	// PortInlineMetric
	// status
	// Status
	// partial_no_data
	// END DEBUGGING
	// PortInlineMetricStatusPartialNoData captures enum value "partial_no_data"
	PortInlineMetricStatusPartialNoData string = "partial_no_data"

	// BEGIN DEBUGGING
	// port_inline_metric
	// PortInlineMetric
	// status
	// Status
	// partial_no_uuid
	// END DEBUGGING
	// PortInlineMetricStatusPartialNoUUID captures enum value "partial_no_uuid"
	PortInlineMetricStatusPartialNoUUID string = "partial_no_uuid"

	// BEGIN DEBUGGING
	// port_inline_metric
	// PortInlineMetric
	// status
	// Status
	// partial_no_response
	// END DEBUGGING
	// PortInlineMetricStatusPartialNoResponse captures enum value "partial_no_response"
	PortInlineMetricStatusPartialNoResponse string = "partial_no_response"

	// BEGIN DEBUGGING
	// port_inline_metric
	// PortInlineMetric
	// status
	// Status
	// partial_other_error
	// END DEBUGGING
	// PortInlineMetricStatusPartialOtherError captures enum value "partial_other_error"
	PortInlineMetricStatusPartialOtherError string = "partial_other_error"

	// BEGIN DEBUGGING
	// port_inline_metric
	// PortInlineMetric
	// status
	// Status
	// negative_delta
	// END DEBUGGING
	// PortInlineMetricStatusNegativeDelta captures enum value "negative_delta"
	PortInlineMetricStatusNegativeDelta string = "negative_delta"

	// BEGIN DEBUGGING
	// port_inline_metric
	// PortInlineMetric
	// status
	// Status
	// backfilled_data
	// END DEBUGGING
	// PortInlineMetricStatusBackfilledData captures enum value "backfilled_data"
	PortInlineMetricStatusBackfilledData string = "backfilled_data"

	// BEGIN DEBUGGING
	// port_inline_metric
	// PortInlineMetric
	// status
	// Status
	// inconsistent_delta_time
	// END DEBUGGING
	// PortInlineMetricStatusInconsistentDeltaTime captures enum value "inconsistent_delta_time"
	PortInlineMetricStatusInconsistentDeltaTime string = "inconsistent_delta_time"

	// BEGIN DEBUGGING
	// port_inline_metric
	// PortInlineMetric
	// status
	// Status
	// inconsistent_old_data
	// END DEBUGGING
	// PortInlineMetricStatusInconsistentOldData captures enum value "inconsistent_old_data"
	PortInlineMetricStatusInconsistentOldData string = "inconsistent_old_data"
)

// prop value enum
func (m *PortInlineMetric) validateStatusEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, portInlineMetricTypeStatusPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *PortInlineMetric) validateStatus(formats strfmt.Registry) error {
	if swag.IsZero(m.Status) { // not required
		return nil
	}

	// value enum
	if err := m.validateStatusEnum("metric"+"."+"status", "body", *m.Status); err != nil {
		return err
	}

	return nil
}

func (m *PortInlineMetric) validateThroughput(formats strfmt.Registry) error {
	if swag.IsZero(m.Throughput) { // not required
		return nil
	}

	if m.Throughput != nil {
		if err := m.Throughput.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "throughput")
			}
			return err
		}
	}

	return nil
}

func (m *PortInlineMetric) validateTimestamp(formats strfmt.Registry) error {
	if swag.IsZero(m.Timestamp) { // not required
		return nil
	}

	if err := validate.FormatOf("metric"+"."+"timestamp", "body", "date-time", m.Timestamp.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this port inline metric based on the context it is used
func (m *PortInlineMetric) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateThroughput(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PortInlineMetric) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (m *PortInlineMetric) contextValidateThroughput(ctx context.Context, formats strfmt.Registry) error {

	if m.Throughput != nil {
		if err := m.Throughput.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "throughput")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *PortInlineMetric) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PortInlineMetric) UnmarshalBinary(b []byte) error {
	var res PortInlineMetric
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// PortInlineMetricInlineLinks port inline metric inline links
//
// swagger:model port_inline_metric_inline__links
type PortInlineMetricInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this port inline metric inline links
func (m *PortInlineMetricInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PortInlineMetricInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this port inline metric inline links based on the context it is used
func (m *PortInlineMetricInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PortInlineMetricInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *PortInlineMetricInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PortInlineMetricInlineLinks) UnmarshalBinary(b []byte) error {
	var res PortInlineMetricInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// PortInlineMetricInlineThroughput The rate of throughput bytes per second observed at the interface.
//
// swagger:model port_inline_metric_inline_throughput
type PortInlineMetricInlineThroughput struct {

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this port inline metric inline throughput
func (m *PortInlineMetricInlineThroughput) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this port inline metric inline throughput based on context it is used
func (m *PortInlineMetricInlineThroughput) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *PortInlineMetricInlineThroughput) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PortInlineMetricInlineThroughput) UnmarshalBinary(b []byte) error {
	var res PortInlineMetricInlineThroughput
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// PortInlineNode port inline node
//
// swagger:model port_inline_node
type PortInlineNode struct {

	// links
	Links *PortInlineNodeInlineLinks `json:"_links,omitempty"`

	// name
	// Example: node1
	Name *string `json:"name,omitempty"`

	// uuid
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this port inline node
func (m *PortInlineNode) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PortInlineNode) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this port inline node based on the context it is used
func (m *PortInlineNode) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PortInlineNode) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *PortInlineNode) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PortInlineNode) UnmarshalBinary(b []byte) error {
	var res PortInlineNode
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// PortInlineNodeInlineLinks port inline node inline links
//
// swagger:model port_inline_node_inline__links
type PortInlineNodeInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this port inline node inline links
func (m *PortInlineNodeInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PortInlineNodeInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this port inline node inline links based on the context it is used
func (m *PortInlineNodeInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PortInlineNodeInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *PortInlineNodeInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PortInlineNodeInlineLinks) UnmarshalBinary(b []byte) error {
	var res PortInlineNodeInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// PortInlineReachableBroadcastDomainsInlineArrayItem Broadcast domain UUID along with a readable name. Either the UUID or both names may be provided on input.
//
// swagger:model port_inline_reachable_broadcast_domains_inline_array_item
type PortInlineReachableBroadcastDomainsInlineArrayItem struct {

	// links
	Links *PortInlineReachableBroadcastDomainsInlineArrayItemInlineLinks `json:"_links,omitempty"`

	// ipspace
	Ipspace *PortInlineReachableBroadcastDomainsInlineArrayItemInlineIpspace `json:"ipspace,omitempty"`

	// Name of the broadcast domain, scoped to its IPspace
	// Example: bd1
	Name *string `json:"name,omitempty"`

	// Broadcast domain UUID
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this port inline reachable broadcast domains inline array item
func (m *PortInlineReachableBroadcastDomainsInlineArrayItem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateIpspace(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PortInlineReachableBroadcastDomainsInlineArrayItem) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *PortInlineReachableBroadcastDomainsInlineArrayItem) validateIpspace(formats strfmt.Registry) error {
	if swag.IsZero(m.Ipspace) { // not required
		return nil
	}

	if m.Ipspace != nil {
		if err := m.Ipspace.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ipspace")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this port inline reachable broadcast domains inline array item based on the context it is used
func (m *PortInlineReachableBroadcastDomainsInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIpspace(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PortInlineReachableBroadcastDomainsInlineArrayItem) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *PortInlineReachableBroadcastDomainsInlineArrayItem) contextValidateIpspace(ctx context.Context, formats strfmt.Registry) error {

	if m.Ipspace != nil {
		if err := m.Ipspace.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ipspace")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *PortInlineReachableBroadcastDomainsInlineArrayItem) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PortInlineReachableBroadcastDomainsInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res PortInlineReachableBroadcastDomainsInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// PortInlineReachableBroadcastDomainsInlineArrayItemInlineIpspace port inline reachable broadcast domains inline array item inline ipspace
//
// swagger:model port_inline_reachable_broadcast_domains_inline_array_item_inline_ipspace
type PortInlineReachableBroadcastDomainsInlineArrayItemInlineIpspace struct {

	// Name of the broadcast domain's IPspace
	// Example: ipspace1
	Name *string `json:"name,omitempty"`
}

// Validate validates this port inline reachable broadcast domains inline array item inline ipspace
func (m *PortInlineReachableBroadcastDomainsInlineArrayItemInlineIpspace) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this port inline reachable broadcast domains inline array item inline ipspace based on context it is used
func (m *PortInlineReachableBroadcastDomainsInlineArrayItemInlineIpspace) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *PortInlineReachableBroadcastDomainsInlineArrayItemInlineIpspace) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PortInlineReachableBroadcastDomainsInlineArrayItemInlineIpspace) UnmarshalBinary(b []byte) error {
	var res PortInlineReachableBroadcastDomainsInlineArrayItemInlineIpspace
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// PortInlineReachableBroadcastDomainsInlineArrayItemInlineLinks port inline reachable broadcast domains inline array item inline links
//
// swagger:model port_inline_reachable_broadcast_domains_inline_array_item_inline__links
type PortInlineReachableBroadcastDomainsInlineArrayItemInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this port inline reachable broadcast domains inline array item inline links
func (m *PortInlineReachableBroadcastDomainsInlineArrayItemInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PortInlineReachableBroadcastDomainsInlineArrayItemInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this port inline reachable broadcast domains inline array item inline links based on the context it is used
func (m *PortInlineReachableBroadcastDomainsInlineArrayItemInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PortInlineReachableBroadcastDomainsInlineArrayItemInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *PortInlineReachableBroadcastDomainsInlineArrayItemInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PortInlineReachableBroadcastDomainsInlineArrayItemInlineLinks) UnmarshalBinary(b []byte) error {
	var res PortInlineReachableBroadcastDomainsInlineArrayItemInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// PortInlineStatistics The real time I/O statistics for the port.
//
// swagger:model port_inline_statistics
type PortInlineStatistics struct {

	// device
	Device *PortInlineStatisticsInlineDevice `json:"device,omitempty"`

	// Errors associated with the sample. For example, if the aggregation of data over multiple nodes fails, then any partial errors might return "ok" on success or "error" on an internal uncategorized failure. Whenever a sample collection is missed but done at a later time, it is back filled to the previous 15 second timestamp and tagged with "backfilled_data". "inconsistent_delta_time" is encountered when the time between two collections is not the same for all nodes. Therefore, the aggregated value might be over or under inflated. "Negative_delta" is returned when an expected monotonically increasing value has decreased in value. "inconsistent_old_data" is returned when one or more nodes do not have the latest data.
	// Example: ok
	// Enum: ["ok","error","partial_no_data","partial_no_uuid","partial_no_response","partial_other_error","negative_delta","backfilled_data","inconsistent_delta_time","inconsistent_old_data"]
	Status *string `json:"status,omitempty"`

	// throughput raw
	ThroughputRaw *PortInlineStatisticsInlineThroughputRaw `json:"throughput_raw,omitempty"`

	// The timestamp of the throughput_raw performance data.
	// Example: 2017-01-25 11:20:13+00:00
	// Format: date-time
	Timestamp *strfmt.DateTime `json:"timestamp,omitempty"`
}

// Validate validates this port inline statistics
func (m *PortInlineStatistics) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateDevice(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateThroughputRaw(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTimestamp(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PortInlineStatistics) validateDevice(formats strfmt.Registry) error {
	if swag.IsZero(m.Device) { // not required
		return nil
	}

	if m.Device != nil {
		if err := m.Device.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "device")
			}
			return err
		}
	}

	return nil
}

var portInlineStatisticsTypeStatusPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ok","error","partial_no_data","partial_no_uuid","partial_no_response","partial_other_error","negative_delta","backfilled_data","inconsistent_delta_time","inconsistent_old_data"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		portInlineStatisticsTypeStatusPropEnum = append(portInlineStatisticsTypeStatusPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// port_inline_statistics
	// PortInlineStatistics
	// status
	// Status
	// ok
	// END DEBUGGING
	// PortInlineStatisticsStatusOk captures enum value "ok"
	PortInlineStatisticsStatusOk string = "ok"

	// BEGIN DEBUGGING
	// port_inline_statistics
	// PortInlineStatistics
	// status
	// Status
	// error
	// END DEBUGGING
	// PortInlineStatisticsStatusError captures enum value "error"
	PortInlineStatisticsStatusError string = "error"

	// BEGIN DEBUGGING
	// port_inline_statistics
	// PortInlineStatistics
	// status
	// Status
	// partial_no_data
	// END DEBUGGING
	// PortInlineStatisticsStatusPartialNoData captures enum value "partial_no_data"
	PortInlineStatisticsStatusPartialNoData string = "partial_no_data"

	// BEGIN DEBUGGING
	// port_inline_statistics
	// PortInlineStatistics
	// status
	// Status
	// partial_no_uuid
	// END DEBUGGING
	// PortInlineStatisticsStatusPartialNoUUID captures enum value "partial_no_uuid"
	PortInlineStatisticsStatusPartialNoUUID string = "partial_no_uuid"

	// BEGIN DEBUGGING
	// port_inline_statistics
	// PortInlineStatistics
	// status
	// Status
	// partial_no_response
	// END DEBUGGING
	// PortInlineStatisticsStatusPartialNoResponse captures enum value "partial_no_response"
	PortInlineStatisticsStatusPartialNoResponse string = "partial_no_response"

	// BEGIN DEBUGGING
	// port_inline_statistics
	// PortInlineStatistics
	// status
	// Status
	// partial_other_error
	// END DEBUGGING
	// PortInlineStatisticsStatusPartialOtherError captures enum value "partial_other_error"
	PortInlineStatisticsStatusPartialOtherError string = "partial_other_error"

	// BEGIN DEBUGGING
	// port_inline_statistics
	// PortInlineStatistics
	// status
	// Status
	// negative_delta
	// END DEBUGGING
	// PortInlineStatisticsStatusNegativeDelta captures enum value "negative_delta"
	PortInlineStatisticsStatusNegativeDelta string = "negative_delta"

	// BEGIN DEBUGGING
	// port_inline_statistics
	// PortInlineStatistics
	// status
	// Status
	// backfilled_data
	// END DEBUGGING
	// PortInlineStatisticsStatusBackfilledData captures enum value "backfilled_data"
	PortInlineStatisticsStatusBackfilledData string = "backfilled_data"

	// BEGIN DEBUGGING
	// port_inline_statistics
	// PortInlineStatistics
	// status
	// Status
	// inconsistent_delta_time
	// END DEBUGGING
	// PortInlineStatisticsStatusInconsistentDeltaTime captures enum value "inconsistent_delta_time"
	PortInlineStatisticsStatusInconsistentDeltaTime string = "inconsistent_delta_time"

	// BEGIN DEBUGGING
	// port_inline_statistics
	// PortInlineStatistics
	// status
	// Status
	// inconsistent_old_data
	// END DEBUGGING
	// PortInlineStatisticsStatusInconsistentOldData captures enum value "inconsistent_old_data"
	PortInlineStatisticsStatusInconsistentOldData string = "inconsistent_old_data"
)

// prop value enum
func (m *PortInlineStatistics) validateStatusEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, portInlineStatisticsTypeStatusPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *PortInlineStatistics) validateStatus(formats strfmt.Registry) error {
	if swag.IsZero(m.Status) { // not required
		return nil
	}

	// value enum
	if err := m.validateStatusEnum("statistics"+"."+"status", "body", *m.Status); err != nil {
		return err
	}

	return nil
}

func (m *PortInlineStatistics) validateThroughputRaw(formats strfmt.Registry) error {
	if swag.IsZero(m.ThroughputRaw) { // not required
		return nil
	}

	if m.ThroughputRaw != nil {
		if err := m.ThroughputRaw.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "throughput_raw")
			}
			return err
		}
	}

	return nil
}

func (m *PortInlineStatistics) validateTimestamp(formats strfmt.Registry) error {
	if swag.IsZero(m.Timestamp) { // not required
		return nil
	}

	if err := validate.FormatOf("statistics"+"."+"timestamp", "body", "date-time", m.Timestamp.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this port inline statistics based on the context it is used
func (m *PortInlineStatistics) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateDevice(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateThroughputRaw(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PortInlineStatistics) contextValidateDevice(ctx context.Context, formats strfmt.Registry) error {

	if m.Device != nil {
		if err := m.Device.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "device")
			}
			return err
		}
	}

	return nil
}

func (m *PortInlineStatistics) contextValidateThroughputRaw(ctx context.Context, formats strfmt.Registry) error {

	if m.ThroughputRaw != nil {
		if err := m.ThroughputRaw.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "throughput_raw")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *PortInlineStatistics) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PortInlineStatistics) UnmarshalBinary(b []byte) error {
	var res PortInlineStatistics
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// PortInlineStatisticsInlineDevice Device-related counters for the port object. These counters are applicable at the lowest layer of the networking stack. These values can be used to calculate both transmit and receive packet and error rates by comparing two samples taken at different times and calculating the increase in counter value divided by the elapsed time between the two samples.
//
// swagger:model port_inline_statistics_inline_device
type PortInlineStatisticsInlineDevice struct {

	// The number of link state changes from up to down seen on the device.
	// Example: 3
	LinkDownCountRaw *int64 `json:"link_down_count_raw,omitempty"`

	// receive raw
	ReceiveRaw *PortInlineStatisticsInlineDeviceInlineReceiveRaw `json:"receive_raw,omitempty"`

	// The timestamp when the device specific counters were collected.
	// Example: 2017-01-25 11:20:13+00:00
	// Format: date-time
	Timestamp *strfmt.DateTime `json:"timestamp,omitempty"`

	// transmit raw
	TransmitRaw *PortInlineStatisticsInlineDeviceInlineTransmitRaw `json:"transmit_raw,omitempty"`
}

// Validate validates this port inline statistics inline device
func (m *PortInlineStatisticsInlineDevice) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateReceiveRaw(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTimestamp(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTransmitRaw(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PortInlineStatisticsInlineDevice) validateReceiveRaw(formats strfmt.Registry) error {
	if swag.IsZero(m.ReceiveRaw) { // not required
		return nil
	}

	if m.ReceiveRaw != nil {
		if err := m.ReceiveRaw.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "device" + "." + "receive_raw")
			}
			return err
		}
	}

	return nil
}

func (m *PortInlineStatisticsInlineDevice) validateTimestamp(formats strfmt.Registry) error {
	if swag.IsZero(m.Timestamp) { // not required
		return nil
	}

	if err := validate.FormatOf("statistics"+"."+"device"+"."+"timestamp", "body", "date-time", m.Timestamp.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *PortInlineStatisticsInlineDevice) validateTransmitRaw(formats strfmt.Registry) error {
	if swag.IsZero(m.TransmitRaw) { // not required
		return nil
	}

	if m.TransmitRaw != nil {
		if err := m.TransmitRaw.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "device" + "." + "transmit_raw")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this port inline statistics inline device based on the context it is used
func (m *PortInlineStatisticsInlineDevice) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateReceiveRaw(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTransmitRaw(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PortInlineStatisticsInlineDevice) contextValidateReceiveRaw(ctx context.Context, formats strfmt.Registry) error {

	if m.ReceiveRaw != nil {
		if err := m.ReceiveRaw.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "device" + "." + "receive_raw")
			}
			return err
		}
	}

	return nil
}

func (m *PortInlineStatisticsInlineDevice) contextValidateTransmitRaw(ctx context.Context, formats strfmt.Registry) error {

	if m.TransmitRaw != nil {
		if err := m.TransmitRaw.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "device" + "." + "transmit_raw")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *PortInlineStatisticsInlineDevice) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PortInlineStatisticsInlineDevice) UnmarshalBinary(b []byte) error {
	var res PortInlineStatisticsInlineDevice
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// PortInlineStatisticsInlineDeviceInlineReceiveRaw Packet receive counters for the Ethernet port.
//
// swagger:model port_inline_statistics_inline_device_inline_receive_raw
type PortInlineStatisticsInlineDeviceInlineReceiveRaw struct {

	// Total number of discarded packets.
	// Example: 100
	Discards *int64 `json:"discards,omitempty"`

	// Number of packet errors.
	// Example: 200
	Errors *int64 `json:"errors,omitempty"`

	// Total packet count.
	// Example: 500
	Packets *int64 `json:"packets,omitempty"`
}

// Validate validates this port inline statistics inline device inline receive raw
func (m *PortInlineStatisticsInlineDeviceInlineReceiveRaw) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this port inline statistics inline device inline receive raw based on context it is used
func (m *PortInlineStatisticsInlineDeviceInlineReceiveRaw) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *PortInlineStatisticsInlineDeviceInlineReceiveRaw) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PortInlineStatisticsInlineDeviceInlineReceiveRaw) UnmarshalBinary(b []byte) error {
	var res PortInlineStatisticsInlineDeviceInlineReceiveRaw
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// PortInlineStatisticsInlineDeviceInlineTransmitRaw Packet transmit counters for the Ethernet port.
//
// swagger:model port_inline_statistics_inline_device_inline_transmit_raw
type PortInlineStatisticsInlineDeviceInlineTransmitRaw struct {

	// Total number of discarded packets.
	// Example: 100
	Discards *int64 `json:"discards,omitempty"`

	// Number of packet errors.
	// Example: 200
	Errors *int64 `json:"errors,omitempty"`

	// Total packet count.
	// Example: 500
	Packets *int64 `json:"packets,omitempty"`
}

// Validate validates this port inline statistics inline device inline transmit raw
func (m *PortInlineStatisticsInlineDeviceInlineTransmitRaw) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this port inline statistics inline device inline transmit raw based on context it is used
func (m *PortInlineStatisticsInlineDeviceInlineTransmitRaw) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *PortInlineStatisticsInlineDeviceInlineTransmitRaw) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PortInlineStatisticsInlineDeviceInlineTransmitRaw) UnmarshalBinary(b []byte) error {
	var res PortInlineStatisticsInlineDeviceInlineTransmitRaw
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// PortInlineStatisticsInlineThroughputRaw Throughput bytes observed at the port object. This can be used along with delta time to calculate the rate of throughput bytes per unit of time.
//
// swagger:model port_inline_statistics_inline_throughput_raw
type PortInlineStatisticsInlineThroughputRaw struct {

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this port inline statistics inline throughput raw
func (m *PortInlineStatisticsInlineThroughputRaw) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this port inline statistics inline throughput raw based on context it is used
func (m *PortInlineStatisticsInlineThroughputRaw) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *PortInlineStatisticsInlineThroughputRaw) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PortInlineStatisticsInlineThroughputRaw) UnmarshalBinary(b []byte) error {
	var res PortInlineStatisticsInlineThroughputRaw
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// PortInlineVlan port inline vlan
//
// swagger:model port_inline_vlan
type PortInlineVlan struct {

	// base port
	BasePort *PortInlineVlanInlineBasePort `json:"base_port,omitempty"`

	// VLAN ID
	// Example: 100
	// Maximum: 4094
	// Minimum: 1
	Tag *int64 `json:"tag,omitempty"`
}

// Validate validates this port inline vlan
func (m *PortInlineVlan) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateBasePort(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTag(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PortInlineVlan) validateBasePort(formats strfmt.Registry) error {
	if swag.IsZero(m.BasePort) { // not required
		return nil
	}

	if m.BasePort != nil {
		if err := m.BasePort.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("vlan" + "." + "base_port")
			}
			return err
		}
	}

	return nil
}

func (m *PortInlineVlan) validateTag(formats strfmt.Registry) error {
	if swag.IsZero(m.Tag) { // not required
		return nil
	}

	if err := validate.MinimumInt("vlan"+"."+"tag", "body", *m.Tag, 1, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("vlan"+"."+"tag", "body", *m.Tag, 4094, false); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this port inline vlan based on the context it is used
func (m *PortInlineVlan) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateBasePort(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PortInlineVlan) contextValidateBasePort(ctx context.Context, formats strfmt.Registry) error {

	if m.BasePort != nil {
		if err := m.BasePort.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("vlan" + "." + "base_port")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *PortInlineVlan) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PortInlineVlan) UnmarshalBinary(b []byte) error {
	var res PortInlineVlan
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// PortInlineVlanInlineBasePort Port UUID along with readable names. Either the UUID or both names may be supplied on input.
//
// swagger:model port_inline_vlan_inline_base_port
type PortInlineVlanInlineBasePort struct {

	// links
	Links *PortInlineVlanInlineBasePortInlineLinks `json:"_links,omitempty"`

	// name
	// Example: e1b
	Name *string `json:"name,omitempty"`

	// node
	Node *PortInlineVlanInlineBasePortInlineNode `json:"node,omitempty"`

	// uuid
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this port inline vlan inline base port
func (m *PortInlineVlanInlineBasePort) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateNode(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PortInlineVlanInlineBasePort) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("vlan" + "." + "base_port" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (m *PortInlineVlanInlineBasePort) validateNode(formats strfmt.Registry) error {
	if swag.IsZero(m.Node) { // not required
		return nil
	}

	if m.Node != nil {
		if err := m.Node.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("vlan" + "." + "base_port" + "." + "node")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this port inline vlan inline base port based on the context it is used
func (m *PortInlineVlanInlineBasePort) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateNode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PortInlineVlanInlineBasePort) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("vlan" + "." + "base_port" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (m *PortInlineVlanInlineBasePort) contextValidateNode(ctx context.Context, formats strfmt.Registry) error {

	if m.Node != nil {
		if err := m.Node.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("vlan" + "." + "base_port" + "." + "node")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *PortInlineVlanInlineBasePort) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PortInlineVlanInlineBasePort) UnmarshalBinary(b []byte) error {
	var res PortInlineVlanInlineBasePort
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// PortInlineVlanInlineBasePortInlineLinks port inline vlan inline base port inline links
//
// swagger:model port_inline_vlan_inline_base_port_inline__links
type PortInlineVlanInlineBasePortInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this port inline vlan inline base port inline links
func (m *PortInlineVlanInlineBasePortInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PortInlineVlanInlineBasePortInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("vlan" + "." + "base_port" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this port inline vlan inline base port inline links based on the context it is used
func (m *PortInlineVlanInlineBasePortInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PortInlineVlanInlineBasePortInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("vlan" + "." + "base_port" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *PortInlineVlanInlineBasePortInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PortInlineVlanInlineBasePortInlineLinks) UnmarshalBinary(b []byte) error {
	var res PortInlineVlanInlineBasePortInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// PortInlineVlanInlineBasePortInlineNode port inline vlan inline base port inline node
//
// swagger:model port_inline_vlan_inline_base_port_inline_node
type PortInlineVlanInlineBasePortInlineNode struct {

	// Name of node on which the port is located.
	// Example: node1
	Name *string `json:"name,omitempty"`
}

// Validate validates this port inline vlan inline base port inline node
func (m *PortInlineVlanInlineBasePortInlineNode) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this port inline vlan inline base port inline node based on context it is used
func (m *PortInlineVlanInlineBasePortInlineNode) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *PortInlineVlanInlineBasePortInlineNode) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PortInlineVlanInlineBasePortInlineNode) UnmarshalBinary(b []byte) error {
	var res PortInlineVlanInlineBasePortInlineNode
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
