// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// PortsetInterface portset interface
//
// swagger:model portset_interface
type PortsetInterface struct {

	// links
	Links *PortsetInterfaceInlineLinks `json:"_links,omitempty"`

	// fc
	Fc *PortsetInterfaceInlineFc `json:"fc,omitempty"`

	// ip
	IP *PortsetInterfaceInlineIP `json:"ip,omitempty"`

	// portset
	Portset *PortsetInterfaceInlinePortset `json:"portset,omitempty"`

	// An array of network interfaces specified to add multiple interfaces to a portset in a single API call. Valid in POST only and not allowed when the `fc` or `ip` property is used.
	//
	PortsetInterfaceInlineRecords []*PortsetInterfaceInlineRecordsInlineArrayItem `json:"records,omitempty"`

	// The unique identifier of the network interface.
	//
	// Example: 4ea7a442-86d1-11e0-ae1c-123478563412
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this portset interface
func (m *PortsetInterface) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateFc(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateIP(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePortset(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePortsetInterfaceInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PortsetInterface) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *PortsetInterface) validateFc(formats strfmt.Registry) error {
	if swag.IsZero(m.Fc) { // not required
		return nil
	}

	if m.Fc != nil {
		if err := m.Fc.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("fc")
			}
			return err
		}
	}

	return nil
}

func (m *PortsetInterface) validateIP(formats strfmt.Registry) error {
	if swag.IsZero(m.IP) { // not required
		return nil
	}

	if m.IP != nil {
		if err := m.IP.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ip")
			}
			return err
		}
	}

	return nil
}

func (m *PortsetInterface) validatePortset(formats strfmt.Registry) error {
	if swag.IsZero(m.Portset) { // not required
		return nil
	}

	if m.Portset != nil {
		if err := m.Portset.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("portset")
			}
			return err
		}
	}

	return nil
}

func (m *PortsetInterface) validatePortsetInterfaceInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(m.PortsetInterfaceInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(m.PortsetInterfaceInlineRecords); i++ {
		if swag.IsZero(m.PortsetInterfaceInlineRecords[i]) { // not required
			continue
		}

		if m.PortsetInterfaceInlineRecords[i] != nil {
			if err := m.PortsetInterfaceInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this portset interface based on the context it is used
func (m *PortsetInterface) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateFc(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIP(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidatePortset(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidatePortsetInterfaceInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PortsetInterface) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *PortsetInterface) contextValidateFc(ctx context.Context, formats strfmt.Registry) error {

	if m.Fc != nil {
		if err := m.Fc.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("fc")
			}
			return err
		}
	}

	return nil
}

func (m *PortsetInterface) contextValidateIP(ctx context.Context, formats strfmt.Registry) error {

	if m.IP != nil {
		if err := m.IP.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ip")
			}
			return err
		}
	}

	return nil
}

func (m *PortsetInterface) contextValidatePortset(ctx context.Context, formats strfmt.Registry) error {

	if m.Portset != nil {
		if err := m.Portset.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("portset")
			}
			return err
		}
	}

	return nil
}

func (m *PortsetInterface) contextValidatePortsetInterfaceInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.PortsetInterfaceInlineRecords); i++ {

		if m.PortsetInterfaceInlineRecords[i] != nil {
			if err := m.PortsetInterfaceInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *PortsetInterface) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "uuid", "body", m.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *PortsetInterface) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PortsetInterface) UnmarshalBinary(b []byte) error {
	var res PortsetInterface
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// PortsetInterfaceInlineFc An FC interface.
//
// swagger:model portset_interface_inline_fc
type PortsetInterfaceInlineFc struct {

	// links
	Links *PortsetInterfaceInlineFcInlineLinks `json:"_links,omitempty"`

	// The name of the FC interface.
	//
	// Example: fc_lif1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the FC interface.
	//
	// Example: 3a09ab42-4da1-32cf-9d35-3385a6101a0b
	UUID *string `json:"uuid,omitempty"`

	// The WWPN of the FC interface.
	//
	// Example: 20:00:00:50:56:b4:13:a8
	// Read Only: true
	Wwpn *string `json:"wwpn,omitempty"`
}

// Validate validates this portset interface inline fc
func (m *PortsetInterfaceInlineFc) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PortsetInterfaceInlineFc) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("fc" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this portset interface inline fc based on the context it is used
func (m *PortsetInterfaceInlineFc) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateWwpn(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PortsetInterfaceInlineFc) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("fc" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (m *PortsetInterfaceInlineFc) contextValidateWwpn(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "fc"+"."+"wwpn", "body", m.Wwpn); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *PortsetInterfaceInlineFc) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PortsetInterfaceInlineFc) UnmarshalBinary(b []byte) error {
	var res PortsetInterfaceInlineFc
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// PortsetInterfaceInlineFcInlineLinks portset interface inline fc inline links
//
// swagger:model portset_interface_inline_fc_inline__links
type PortsetInterfaceInlineFcInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this portset interface inline fc inline links
func (m *PortsetInterfaceInlineFcInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PortsetInterfaceInlineFcInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("fc" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this portset interface inline fc inline links based on the context it is used
func (m *PortsetInterfaceInlineFcInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PortsetInterfaceInlineFcInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("fc" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *PortsetInterfaceInlineFcInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PortsetInterfaceInlineFcInlineLinks) UnmarshalBinary(b []byte) error {
	var res PortsetInterfaceInlineFcInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// PortsetInterfaceInlineIP A network interface. Either UUID or name may be supplied on input.
//
// swagger:model portset_interface_inline_ip
type PortsetInterfaceInlineIP struct {

	// links
	Links *PortsetInterfaceInlineIPInlineLinks `json:"_links,omitempty"`

	// ip
	IP *PortsetInterfaceInlineIPInlineIP `json:"ip,omitempty"`

	// The name of the interface. If only the name is provided, the SVM scope
	// must be provided by the object this object is embedded in.
	//
	// Example: lif1
	Name *string `json:"name,omitempty"`

	// The UUID that uniquely identifies the interface.
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this portset interface inline ip
func (m *PortsetInterfaceInlineIP) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateIP(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PortsetInterfaceInlineIP) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ip" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (m *PortsetInterfaceInlineIP) validateIP(formats strfmt.Registry) error {
	if swag.IsZero(m.IP) { // not required
		return nil
	}

	if m.IP != nil {
		if err := m.IP.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ip" + "." + "ip")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this portset interface inline ip based on the context it is used
func (m *PortsetInterfaceInlineIP) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIP(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PortsetInterfaceInlineIP) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ip" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (m *PortsetInterfaceInlineIP) contextValidateIP(ctx context.Context, formats strfmt.Registry) error {

	if m.IP != nil {
		if err := m.IP.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ip" + "." + "ip")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *PortsetInterfaceInlineIP) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PortsetInterfaceInlineIP) UnmarshalBinary(b []byte) error {
	var res PortsetInterfaceInlineIP
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// PortsetInterfaceInlineIPInlineIP IP information
//
// swagger:model portset_interface_inline_ip_inline_ip
type PortsetInterfaceInlineIPInlineIP struct {

	// address
	Address *IPAddressReadonly `json:"address,omitempty"`
}

// Validate validates this portset interface inline ip inline ip
func (m *PortsetInterfaceInlineIPInlineIP) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateAddress(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PortsetInterfaceInlineIPInlineIP) validateAddress(formats strfmt.Registry) error {
	if swag.IsZero(m.Address) { // not required
		return nil
	}

	if m.Address != nil {
		if err := m.Address.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ip" + "." + "ip" + "." + "address")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this portset interface inline ip inline ip based on the context it is used
func (m *PortsetInterfaceInlineIPInlineIP) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateAddress(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PortsetInterfaceInlineIPInlineIP) contextValidateAddress(ctx context.Context, formats strfmt.Registry) error {

	if m.Address != nil {
		if err := m.Address.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ip" + "." + "ip" + "." + "address")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *PortsetInterfaceInlineIPInlineIP) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PortsetInterfaceInlineIPInlineIP) UnmarshalBinary(b []byte) error {
	var res PortsetInterfaceInlineIPInlineIP
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// PortsetInterfaceInlineIPInlineLinks portset interface inline ip inline links
//
// swagger:model portset_interface_inline_ip_inline__links
type PortsetInterfaceInlineIPInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this portset interface inline ip inline links
func (m *PortsetInterfaceInlineIPInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PortsetInterfaceInlineIPInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ip" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this portset interface inline ip inline links based on the context it is used
func (m *PortsetInterfaceInlineIPInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PortsetInterfaceInlineIPInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ip" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *PortsetInterfaceInlineIPInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PortsetInterfaceInlineIPInlineLinks) UnmarshalBinary(b []byte) error {
	var res PortsetInterfaceInlineIPInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// PortsetInterfaceInlineLinks portset interface inline links
//
// swagger:model portset_interface_inline__links
type PortsetInterfaceInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this portset interface inline links
func (m *PortsetInterfaceInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PortsetInterfaceInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this portset interface inline links based on the context it is used
func (m *PortsetInterfaceInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PortsetInterfaceInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *PortsetInterfaceInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PortsetInterfaceInlineLinks) UnmarshalBinary(b []byte) error {
	var res PortsetInterfaceInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// PortsetInterfaceInlinePortset The portset in which the network interface is found.<br/>
// Note that this does not mean that the network interface cannot also be found in other portsets.
//
// swagger:model portset_interface_inline_portset
type PortsetInterfaceInlinePortset struct {

	// links
	Links *PortsetInterfaceInlinePortsetInlineLinks `json:"_links,omitempty"`

	// The unique identifier of the portset.
	//
	// Example: 4ea7a442-86d1-11e0-ae1c-123478563412
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this portset interface inline portset
func (m *PortsetInterfaceInlinePortset) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PortsetInterfaceInlinePortset) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("portset" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this portset interface inline portset based on the context it is used
func (m *PortsetInterfaceInlinePortset) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PortsetInterfaceInlinePortset) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("portset" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (m *PortsetInterfaceInlinePortset) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "portset"+"."+"uuid", "body", m.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *PortsetInterfaceInlinePortset) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PortsetInterfaceInlinePortset) UnmarshalBinary(b []byte) error {
	var res PortsetInterfaceInlinePortset
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// PortsetInterfaceInlinePortsetInlineLinks portset interface inline portset inline links
//
// swagger:model portset_interface_inline_portset_inline__links
type PortsetInterfaceInlinePortsetInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this portset interface inline portset inline links
func (m *PortsetInterfaceInlinePortsetInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PortsetInterfaceInlinePortsetInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("portset" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this portset interface inline portset inline links based on the context it is used
func (m *PortsetInterfaceInlinePortsetInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PortsetInterfaceInlinePortsetInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("portset" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *PortsetInterfaceInlinePortsetInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PortsetInterfaceInlinePortsetInlineLinks) UnmarshalBinary(b []byte) error {
	var res PortsetInterfaceInlinePortsetInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// PortsetInterfaceInlineRecordsInlineArrayItem A container for either a Fibre Channel network interface or an IP network interface. On POST `fc` and `ip` are mutually exclusive.
//
// swagger:model portset_interface_inline_records_inline_array_item
type PortsetInterfaceInlineRecordsInlineArrayItem struct {

	// links
	Links *PortsetInterfaceInlineRecordsInlineArrayItemInlineLinks `json:"_links,omitempty"`

	// fc
	Fc *PortsetInterfaceInlineRecordsInlineArrayItemInlineFc `json:"fc,omitempty"`

	// ip
	IP *PortsetInterfaceInlineRecordsInlineArrayItemInlineIP `json:"ip,omitempty"`

	// The unique identifier of the network interface.
	//
	// Example: 4ea7a442-86d1-11e0-ae1c-123478563412
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this portset interface inline records inline array item
func (m *PortsetInterfaceInlineRecordsInlineArrayItem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateFc(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateIP(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PortsetInterfaceInlineRecordsInlineArrayItem) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *PortsetInterfaceInlineRecordsInlineArrayItem) validateFc(formats strfmt.Registry) error {
	if swag.IsZero(m.Fc) { // not required
		return nil
	}

	if m.Fc != nil {
		if err := m.Fc.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("fc")
			}
			return err
		}
	}

	return nil
}

func (m *PortsetInterfaceInlineRecordsInlineArrayItem) validateIP(formats strfmt.Registry) error {
	if swag.IsZero(m.IP) { // not required
		return nil
	}

	if m.IP != nil {
		if err := m.IP.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ip")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this portset interface inline records inline array item based on the context it is used
func (m *PortsetInterfaceInlineRecordsInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateFc(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIP(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PortsetInterfaceInlineRecordsInlineArrayItem) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *PortsetInterfaceInlineRecordsInlineArrayItem) contextValidateFc(ctx context.Context, formats strfmt.Registry) error {

	if m.Fc != nil {
		if err := m.Fc.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("fc")
			}
			return err
		}
	}

	return nil
}

func (m *PortsetInterfaceInlineRecordsInlineArrayItem) contextValidateIP(ctx context.Context, formats strfmt.Registry) error {

	if m.IP != nil {
		if err := m.IP.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ip")
			}
			return err
		}
	}

	return nil
}

func (m *PortsetInterfaceInlineRecordsInlineArrayItem) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "uuid", "body", m.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *PortsetInterfaceInlineRecordsInlineArrayItem) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PortsetInterfaceInlineRecordsInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res PortsetInterfaceInlineRecordsInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// PortsetInterfaceInlineRecordsInlineArrayItemInlineFc An FC interface.
//
// swagger:model portset_interface_inline_records_inline_array_item_inline_fc
type PortsetInterfaceInlineRecordsInlineArrayItemInlineFc struct {

	// links
	Links *PortsetInterfaceInlineRecordsInlineArrayItemInlineFcInlineLinks `json:"_links,omitempty"`

	// The name of the FC interface.
	//
	// Example: fc_lif1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the FC interface.
	//
	// Example: 3a09ab42-4da1-32cf-9d35-3385a6101a0b
	UUID *string `json:"uuid,omitempty"`

	// The WWPN of the FC interface.
	//
	// Example: 20:00:00:50:56:b4:13:a8
	// Read Only: true
	Wwpn *string `json:"wwpn,omitempty"`
}

// Validate validates this portset interface inline records inline array item inline fc
func (m *PortsetInterfaceInlineRecordsInlineArrayItemInlineFc) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PortsetInterfaceInlineRecordsInlineArrayItemInlineFc) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("fc" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this portset interface inline records inline array item inline fc based on the context it is used
func (m *PortsetInterfaceInlineRecordsInlineArrayItemInlineFc) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateWwpn(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PortsetInterfaceInlineRecordsInlineArrayItemInlineFc) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("fc" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (m *PortsetInterfaceInlineRecordsInlineArrayItemInlineFc) contextValidateWwpn(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "fc"+"."+"wwpn", "body", m.Wwpn); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *PortsetInterfaceInlineRecordsInlineArrayItemInlineFc) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PortsetInterfaceInlineRecordsInlineArrayItemInlineFc) UnmarshalBinary(b []byte) error {
	var res PortsetInterfaceInlineRecordsInlineArrayItemInlineFc
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// PortsetInterfaceInlineRecordsInlineArrayItemInlineFcInlineLinks portset interface inline records inline array item inline fc inline links
//
// swagger:model portset_interface_inline_records_inline_array_item_inline_fc_inline__links
type PortsetInterfaceInlineRecordsInlineArrayItemInlineFcInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this portset interface inline records inline array item inline fc inline links
func (m *PortsetInterfaceInlineRecordsInlineArrayItemInlineFcInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PortsetInterfaceInlineRecordsInlineArrayItemInlineFcInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("fc" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this portset interface inline records inline array item inline fc inline links based on the context it is used
func (m *PortsetInterfaceInlineRecordsInlineArrayItemInlineFcInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PortsetInterfaceInlineRecordsInlineArrayItemInlineFcInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("fc" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *PortsetInterfaceInlineRecordsInlineArrayItemInlineFcInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PortsetInterfaceInlineRecordsInlineArrayItemInlineFcInlineLinks) UnmarshalBinary(b []byte) error {
	var res PortsetInterfaceInlineRecordsInlineArrayItemInlineFcInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// PortsetInterfaceInlineRecordsInlineArrayItemInlineIP A network interface. Either UUID or name may be supplied on input.
//
// swagger:model portset_interface_inline_records_inline_array_item_inline_ip
type PortsetInterfaceInlineRecordsInlineArrayItemInlineIP struct {

	// links
	Links *PortsetInterfaceInlineRecordsInlineArrayItemInlineIPInlineLinks `json:"_links,omitempty"`

	// ip
	IP *PortsetInterfaceInlineRecordsInlineArrayItemInlineIPInlineIP `json:"ip,omitempty"`

	// The name of the interface. If only the name is provided, the SVM scope
	// must be provided by the object this object is embedded in.
	//
	// Example: lif1
	Name *string `json:"name,omitempty"`

	// The UUID that uniquely identifies the interface.
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this portset interface inline records inline array item inline ip
func (m *PortsetInterfaceInlineRecordsInlineArrayItemInlineIP) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateIP(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PortsetInterfaceInlineRecordsInlineArrayItemInlineIP) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ip" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (m *PortsetInterfaceInlineRecordsInlineArrayItemInlineIP) validateIP(formats strfmt.Registry) error {
	if swag.IsZero(m.IP) { // not required
		return nil
	}

	if m.IP != nil {
		if err := m.IP.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ip" + "." + "ip")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this portset interface inline records inline array item inline ip based on the context it is used
func (m *PortsetInterfaceInlineRecordsInlineArrayItemInlineIP) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIP(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PortsetInterfaceInlineRecordsInlineArrayItemInlineIP) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ip" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (m *PortsetInterfaceInlineRecordsInlineArrayItemInlineIP) contextValidateIP(ctx context.Context, formats strfmt.Registry) error {

	if m.IP != nil {
		if err := m.IP.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ip" + "." + "ip")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *PortsetInterfaceInlineRecordsInlineArrayItemInlineIP) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PortsetInterfaceInlineRecordsInlineArrayItemInlineIP) UnmarshalBinary(b []byte) error {
	var res PortsetInterfaceInlineRecordsInlineArrayItemInlineIP
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// PortsetInterfaceInlineRecordsInlineArrayItemInlineIPInlineIP IP information
//
// swagger:model portset_interface_inline_records_inline_array_item_inline_ip_inline_ip
type PortsetInterfaceInlineRecordsInlineArrayItemInlineIPInlineIP struct {

	// address
	Address *IPAddressReadonly `json:"address,omitempty"`
}

// Validate validates this portset interface inline records inline array item inline ip inline ip
func (m *PortsetInterfaceInlineRecordsInlineArrayItemInlineIPInlineIP) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateAddress(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PortsetInterfaceInlineRecordsInlineArrayItemInlineIPInlineIP) validateAddress(formats strfmt.Registry) error {
	if swag.IsZero(m.Address) { // not required
		return nil
	}

	if m.Address != nil {
		if err := m.Address.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ip" + "." + "ip" + "." + "address")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this portset interface inline records inline array item inline ip inline ip based on the context it is used
func (m *PortsetInterfaceInlineRecordsInlineArrayItemInlineIPInlineIP) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateAddress(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PortsetInterfaceInlineRecordsInlineArrayItemInlineIPInlineIP) contextValidateAddress(ctx context.Context, formats strfmt.Registry) error {

	if m.Address != nil {
		if err := m.Address.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ip" + "." + "ip" + "." + "address")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *PortsetInterfaceInlineRecordsInlineArrayItemInlineIPInlineIP) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PortsetInterfaceInlineRecordsInlineArrayItemInlineIPInlineIP) UnmarshalBinary(b []byte) error {
	var res PortsetInterfaceInlineRecordsInlineArrayItemInlineIPInlineIP
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// PortsetInterfaceInlineRecordsInlineArrayItemInlineIPInlineLinks portset interface inline records inline array item inline ip inline links
//
// swagger:model portset_interface_inline_records_inline_array_item_inline_ip_inline__links
type PortsetInterfaceInlineRecordsInlineArrayItemInlineIPInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this portset interface inline records inline array item inline ip inline links
func (m *PortsetInterfaceInlineRecordsInlineArrayItemInlineIPInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PortsetInterfaceInlineRecordsInlineArrayItemInlineIPInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ip" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this portset interface inline records inline array item inline ip inline links based on the context it is used
func (m *PortsetInterfaceInlineRecordsInlineArrayItemInlineIPInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PortsetInterfaceInlineRecordsInlineArrayItemInlineIPInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ip" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *PortsetInterfaceInlineRecordsInlineArrayItemInlineIPInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PortsetInterfaceInlineRecordsInlineArrayItemInlineIPInlineLinks) UnmarshalBinary(b []byte) error {
	var res PortsetInterfaceInlineRecordsInlineArrayItemInlineIPInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// PortsetInterfaceInlineRecordsInlineArrayItemInlineLinks portset interface inline records inline array item inline links
//
// swagger:model portset_interface_inline_records_inline_array_item_inline__links
type PortsetInterfaceInlineRecordsInlineArrayItemInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this portset interface inline records inline array item inline links
func (m *PortsetInterfaceInlineRecordsInlineArrayItemInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PortsetInterfaceInlineRecordsInlineArrayItemInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this portset interface inline records inline array item inline links based on the context it is used
func (m *PortsetInterfaceInlineRecordsInlineArrayItemInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PortsetInterfaceInlineRecordsInlineArrayItemInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *PortsetInterfaceInlineRecordsInlineArrayItemInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PortsetInterfaceInlineRecordsInlineArrayItemInlineLinks) UnmarshalBinary(b []byte) error {
	var res PortsetInterfaceInlineRecordsInlineArrayItemInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
