// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// Ppk Post-quantum pre-shared key information.
//
// swagger:model ppk
type Ppk struct {

	// Post-quantum pre-shared key identity.
	// Max Length: 64
	// Min Length: 6
	Identity *string `json:"identity,omitempty"`

	// Post-quantum pre-shared key.
	// Max Length: 128
	// Min Length: 18
	SharedKey *string `json:"shared_key,omitempty"`
}

// Validate validates this ppk
func (m *Ppk) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateIdentity(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSharedKey(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *Ppk) validateIdentity(formats strfmt.Registry) error {
	if swag.IsZero(m.Identity) { // not required
		return nil
	}

	if err := validate.MinLength("identity", "body", *m.Identity, 6); err != nil {
		return err
	}

	if err := validate.MaxLength("identity", "body", *m.Identity, 64); err != nil {
		return err
	}

	return nil
}

func (m *Ppk) validateSharedKey(formats strfmt.Registry) error {
	if swag.IsZero(m.SharedKey) { // not required
		return nil
	}

	if err := validate.MinLength("shared_key", "body", *m.SharedKey, 18); err != nil {
		return err
	}

	if err := validate.MaxLength("shared_key", "body", *m.SharedKey, 128); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this ppk based on context it is used
func (m *Ppk) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *Ppk) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *Ppk) UnmarshalBinary(b []byte) error {
	var res Ppk
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
