// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// PreferredDcs preferred dcs
//
// swagger:model preferred_dcs
type PreferredDcs struct {

	// Fully Qualified Domain Name.
	//
	// Example: test.com
	// Read Only: true
	Fqdn *string `json:"fqdn,omitempty"`

	// IP address of the preferred domain controller (DC). The address can be either an IPv4 or an IPv6 address.
	//
	// Example: 4.4.4.4
	// Read Only: true
	ServerIP *string `json:"server_ip,omitempty"`
}

// Validate validates this preferred dcs
func (m *PreferredDcs) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this preferred dcs based on the context it is used
func (m *PreferredDcs) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateFqdn(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateServerIP(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PreferredDcs) contextValidateFqdn(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "fqdn", "body", m.Fqdn); err != nil {
		return err
	}

	return nil
}

func (m *PreferredDcs) contextValidateServerIP(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "server_ip", "body", m.ServerIP); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *PreferredDcs) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PreferredDcs) UnmarshalBinary(b []byte) error {
	var res PreferredDcs
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
