// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// Publickey The public key for the user account (to access SSH).
//
// swagger:model publickey
type Publickey struct {

	// links
	Links *PublickeyInlineLinks `json:"_links,omitempty"`

	// account
	Account *AccountReference `json:"account,omitempty"`

	// Optional certificate for the public key.
	Certificate *string `json:"certificate,omitempty"`

	// The details present in the certificate (READONLY).
	// Read Only: true
	CertificateDetails *string `json:"certificate_details,omitempty"`

	// The expiration details of the certificate (READONLY).
	// Read Only: true
	CertificateExpired *string `json:"certificate_expired,omitempty"`

	// The revocation details of the certificate (READONLY).
	// Read Only: true
	CertificateRevoked *string `json:"certificate_revoked,omitempty"`

	// Optional comment for the public key.
	Comment *string `json:"comment,omitempty"`

	// Index number for the public key (where there are multiple keys for the same account).
	// Maximum: 99
	// Minimum: 0
	Index *int64 `json:"index,omitempty"`

	// The obfuscated fingerprint for the public key (READONLY).
	// Read Only: true
	ObfuscatedFingerprint *string `json:"obfuscated_fingerprint,omitempty"`

	// owner
	Owner *PublickeyInlineOwner `json:"owner,omitempty"`

	// The public key
	PublicKey *string `json:"public_key,omitempty"`

	// Scope of the entity. Set to "cluster" for cluster owned objects and to "svm" for SVM owned objects.
	// Read Only: true
	// Enum: ["cluster","svm"]
	Scope *string `json:"scope,omitempty"`

	// The SHA fingerprint for the public key (READONLY).
	// Read Only: true
	ShaFingerprint *string `json:"sha_fingerprint,omitempty"`
}

// Validate validates this publickey
func (m *Publickey) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateAccount(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateIndex(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateOwner(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateScope(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *Publickey) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *Publickey) validateAccount(formats strfmt.Registry) error {
	if swag.IsZero(m.Account) { // not required
		return nil
	}

	if m.Account != nil {
		if err := m.Account.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("account")
			}
			return err
		}
	}

	return nil
}

func (m *Publickey) validateIndex(formats strfmt.Registry) error {
	if swag.IsZero(m.Index) { // not required
		return nil
	}

	if err := validate.MinimumInt("index", "body", *m.Index, 0, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("index", "body", *m.Index, 99, false); err != nil {
		return err
	}

	return nil
}

func (m *Publickey) validateOwner(formats strfmt.Registry) error {
	if swag.IsZero(m.Owner) { // not required
		return nil
	}

	if m.Owner != nil {
		if err := m.Owner.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("owner")
			}
			return err
		}
	}

	return nil
}

var publickeyTypeScopePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["cluster","svm"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		publickeyTypeScopePropEnum = append(publickeyTypeScopePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// publickey
	// Publickey
	// scope
	// Scope
	// cluster
	// END DEBUGGING
	// PublickeyScopeCluster captures enum value "cluster"
	PublickeyScopeCluster string = "cluster"

	// BEGIN DEBUGGING
	// publickey
	// Publickey
	// scope
	// Scope
	// svm
	// END DEBUGGING
	// PublickeyScopeSvm captures enum value "svm"
	PublickeyScopeSvm string = "svm"
)

// prop value enum
func (m *Publickey) validateScopeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, publickeyTypeScopePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *Publickey) validateScope(formats strfmt.Registry) error {
	if swag.IsZero(m.Scope) { // not required
		return nil
	}

	// value enum
	if err := m.validateScopeEnum("scope", "body", *m.Scope); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this publickey based on the context it is used
func (m *Publickey) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateAccount(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateCertificateDetails(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateCertificateExpired(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateCertificateRevoked(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateObfuscatedFingerprint(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateOwner(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateScope(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateShaFingerprint(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *Publickey) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *Publickey) contextValidateAccount(ctx context.Context, formats strfmt.Registry) error {

	if m.Account != nil {
		if err := m.Account.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("account")
			}
			return err
		}
	}

	return nil
}

func (m *Publickey) contextValidateCertificateDetails(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "certificate_details", "body", m.CertificateDetails); err != nil {
		return err
	}

	return nil
}

func (m *Publickey) contextValidateCertificateExpired(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "certificate_expired", "body", m.CertificateExpired); err != nil {
		return err
	}

	return nil
}

func (m *Publickey) contextValidateCertificateRevoked(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "certificate_revoked", "body", m.CertificateRevoked); err != nil {
		return err
	}

	return nil
}

func (m *Publickey) contextValidateObfuscatedFingerprint(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "obfuscated_fingerprint", "body", m.ObfuscatedFingerprint); err != nil {
		return err
	}

	return nil
}

func (m *Publickey) contextValidateOwner(ctx context.Context, formats strfmt.Registry) error {

	if m.Owner != nil {
		if err := m.Owner.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("owner")
			}
			return err
		}
	}

	return nil
}

func (m *Publickey) contextValidateScope(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "scope", "body", m.Scope); err != nil {
		return err
	}

	return nil
}

func (m *Publickey) contextValidateShaFingerprint(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "sha_fingerprint", "body", m.ShaFingerprint); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *Publickey) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *Publickey) UnmarshalBinary(b []byte) error {
	var res Publickey
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// PublickeyInlineLinks publickey inline links
//
// swagger:model publickey_inline__links
type PublickeyInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this publickey inline links
func (m *PublickeyInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PublickeyInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this publickey inline links based on the context it is used
func (m *PublickeyInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PublickeyInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *PublickeyInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PublickeyInlineLinks) UnmarshalBinary(b []byte) error {
	var res PublickeyInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// PublickeyInlineOwner Owner name and UUID that uniquely identifies the public key.
//
// swagger:model publickey_inline_owner
type PublickeyInlineOwner struct {

	// links
	Links *PublickeyInlineOwnerInlineLinks `json:"_links,omitempty"`

	// The name of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: svm1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: 02c9e252-41be-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this publickey inline owner
func (m *PublickeyInlineOwner) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PublickeyInlineOwner) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("owner" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this publickey inline owner based on the context it is used
func (m *PublickeyInlineOwner) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PublickeyInlineOwner) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("owner" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *PublickeyInlineOwner) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PublickeyInlineOwner) UnmarshalBinary(b []byte) error {
	var res PublickeyInlineOwner
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// PublickeyInlineOwnerInlineLinks publickey inline owner inline links
//
// swagger:model publickey_inline_owner_inline__links
type PublickeyInlineOwnerInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this publickey inline owner inline links
func (m *PublickeyInlineOwnerInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PublickeyInlineOwnerInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("owner" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this publickey inline owner inline links based on the context it is used
func (m *PublickeyInlineOwnerInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PublickeyInlineOwnerInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("owner" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *PublickeyInlineOwnerInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PublickeyInlineOwnerInlineLinks) UnmarshalBinary(b []byte) error {
	var res PublickeyInlineOwnerInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
