// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// QosPolicy qos policy
//
// swagger:model qos_policy
type QosPolicy struct {

	// links
	Links *QosPolicyInlineLinks `json:"_links,omitempty"`

	// adaptive
	Adaptive *QosPolicyInlineAdaptive `json:"adaptive,omitempty"`

	// fixed
	Fixed *QosPolicyInlineFixed `json:"fixed,omitempty"`

	// Name of the QoS policy.
	// Example: extreme
	Name *string `json:"name,omitempty"`

	// Number of objects attached to this policy.
	// Read Only: true
	ObjectCount *int64 `json:"object_count,omitempty"`

	// Policy group ID of the QoS policy.
	// Read Only: true
	Pgid *int64 `json:"pgid,omitempty"`

	// Class of the QoS policy.
	// Read Only: true
	// Enum: ["undefined","preset","user_defined","system_defined","autovolume","load_control"]
	PolicyClass *string `json:"policy_class,omitempty"`

	// Scope of the entity. Set to "cluster" for cluster owned objects and to "svm" for SVM owned objects.
	// Read Only: true
	// Enum: ["cluster","svm"]
	Scope *string `json:"scope,omitempty"`

	// svm
	Svm *QosPolicyInlineSvm `json:"svm,omitempty"`

	// uuid
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this qos policy
func (m *QosPolicy) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateAdaptive(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateFixed(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePolicyClass(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateScope(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSvm(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *QosPolicy) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *QosPolicy) validateAdaptive(formats strfmt.Registry) error {
	if swag.IsZero(m.Adaptive) { // not required
		return nil
	}

	if m.Adaptive != nil {
		if err := m.Adaptive.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("adaptive")
			}
			return err
		}
	}

	return nil
}

func (m *QosPolicy) validateFixed(formats strfmt.Registry) error {
	if swag.IsZero(m.Fixed) { // not required
		return nil
	}

	if m.Fixed != nil {
		if err := m.Fixed.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("fixed")
			}
			return err
		}
	}

	return nil
}

var qosPolicyTypePolicyClassPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["undefined","preset","user_defined","system_defined","autovolume","load_control"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		qosPolicyTypePolicyClassPropEnum = append(qosPolicyTypePolicyClassPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// qos_policy
	// QosPolicy
	// policy_class
	// PolicyClass
	// undefined
	// END DEBUGGING
	// QosPolicyPolicyClassUndefined captures enum value "undefined"
	QosPolicyPolicyClassUndefined string = "undefined"

	// BEGIN DEBUGGING
	// qos_policy
	// QosPolicy
	// policy_class
	// PolicyClass
	// preset
	// END DEBUGGING
	// QosPolicyPolicyClassPreset captures enum value "preset"
	QosPolicyPolicyClassPreset string = "preset"

	// BEGIN DEBUGGING
	// qos_policy
	// QosPolicy
	// policy_class
	// PolicyClass
	// user_defined
	// END DEBUGGING
	// QosPolicyPolicyClassUserDefined captures enum value "user_defined"
	QosPolicyPolicyClassUserDefined string = "user_defined"

	// BEGIN DEBUGGING
	// qos_policy
	// QosPolicy
	// policy_class
	// PolicyClass
	// system_defined
	// END DEBUGGING
	// QosPolicyPolicyClassSystemDefined captures enum value "system_defined"
	QosPolicyPolicyClassSystemDefined string = "system_defined"

	// BEGIN DEBUGGING
	// qos_policy
	// QosPolicy
	// policy_class
	// PolicyClass
	// autovolume
	// END DEBUGGING
	// QosPolicyPolicyClassAutovolume captures enum value "autovolume"
	QosPolicyPolicyClassAutovolume string = "autovolume"

	// BEGIN DEBUGGING
	// qos_policy
	// QosPolicy
	// policy_class
	// PolicyClass
	// load_control
	// END DEBUGGING
	// QosPolicyPolicyClassLoadControl captures enum value "load_control"
	QosPolicyPolicyClassLoadControl string = "load_control"
)

// prop value enum
func (m *QosPolicy) validatePolicyClassEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, qosPolicyTypePolicyClassPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *QosPolicy) validatePolicyClass(formats strfmt.Registry) error {
	if swag.IsZero(m.PolicyClass) { // not required
		return nil
	}

	// value enum
	if err := m.validatePolicyClassEnum("policy_class", "body", *m.PolicyClass); err != nil {
		return err
	}

	return nil
}

var qosPolicyTypeScopePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["cluster","svm"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		qosPolicyTypeScopePropEnum = append(qosPolicyTypeScopePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// qos_policy
	// QosPolicy
	// scope
	// Scope
	// cluster
	// END DEBUGGING
	// QosPolicyScopeCluster captures enum value "cluster"
	QosPolicyScopeCluster string = "cluster"

	// BEGIN DEBUGGING
	// qos_policy
	// QosPolicy
	// scope
	// Scope
	// svm
	// END DEBUGGING
	// QosPolicyScopeSvm captures enum value "svm"
	QosPolicyScopeSvm string = "svm"
)

// prop value enum
func (m *QosPolicy) validateScopeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, qosPolicyTypeScopePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *QosPolicy) validateScope(formats strfmt.Registry) error {
	if swag.IsZero(m.Scope) { // not required
		return nil
	}

	// value enum
	if err := m.validateScopeEnum("scope", "body", *m.Scope); err != nil {
		return err
	}

	return nil
}

func (m *QosPolicy) validateSvm(formats strfmt.Registry) error {
	if swag.IsZero(m.Svm) { // not required
		return nil
	}

	if m.Svm != nil {
		if err := m.Svm.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this qos policy based on the context it is used
func (m *QosPolicy) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateAdaptive(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateFixed(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateObjectCount(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidatePgid(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidatePolicyClass(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateScope(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSvm(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *QosPolicy) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *QosPolicy) contextValidateAdaptive(ctx context.Context, formats strfmt.Registry) error {

	if m.Adaptive != nil {
		if err := m.Adaptive.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("adaptive")
			}
			return err
		}
	}

	return nil
}

func (m *QosPolicy) contextValidateFixed(ctx context.Context, formats strfmt.Registry) error {

	if m.Fixed != nil {
		if err := m.Fixed.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("fixed")
			}
			return err
		}
	}

	return nil
}

func (m *QosPolicy) contextValidateObjectCount(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "object_count", "body", m.ObjectCount); err != nil {
		return err
	}

	return nil
}

func (m *QosPolicy) contextValidatePgid(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "pgid", "body", m.Pgid); err != nil {
		return err
	}

	return nil
}

func (m *QosPolicy) contextValidatePolicyClass(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "policy_class", "body", m.PolicyClass); err != nil {
		return err
	}

	return nil
}

func (m *QosPolicy) contextValidateScope(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "scope", "body", m.Scope); err != nil {
		return err
	}

	return nil
}

func (m *QosPolicy) contextValidateSvm(ctx context.Context, formats strfmt.Registry) error {

	if m.Svm != nil {
		if err := m.Svm.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm")
			}
			return err
		}
	}

	return nil
}

func (m *QosPolicy) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "uuid", "body", m.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *QosPolicy) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *QosPolicy) UnmarshalBinary(b []byte) error {
	var res QosPolicy
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// QosPolicyInlineAdaptive Adaptive QoS policy-groups define measurable service level objectives (SLOs) that adjust based on the storage object used space and the storage object allocated space.
//
// swagger:model qos_policy_inline_adaptive
type QosPolicyInlineAdaptive struct {

	// Specifies the absolute minimum IOPS that is used as an override when the expected_iops is less than this value. These floors are not guaranteed on non-AFF platforms or when FabricPool tiering policies are set.
	AbsoluteMinIops *int64 `json:"absolute_min_iops,omitempty"`

	// Specifies the block size
	// Enum: ["any","4k","8k","16k","32k","64k","128k"]
	BlockSize *string `json:"block_size,omitempty"`

	// Expected IOPS. Specifies the minimum expected IOPS per TB allocated based on the storage object allocated size. These floors are not guaranteed on non-AFF platforms or when FabricPool tiering policies are set.
	ExpectedIops *int64 `json:"expected_iops,omitempty"`

	// Specifies the size to be used to calculate expected IOPS per TB. The size options are either the storage object allocated space or the storage object used space.
	// Enum: ["used_space","allocated_space"]
	ExpectedIopsAllocation *string `json:"expected_iops_allocation,omitempty"`

	// Peak IOPS. Specifies the maximum possible IOPS per TB allocated based on the storage object allocated size or the storage object used size.
	PeakIops *int64 `json:"peak_iops,omitempty"`

	// Specifies the size to be used to calculate peak IOPS per TB. The size options are either the storage object allocated space or the storage object used space.
	// Enum: ["used_space","allocated_space"]
	PeakIopsAllocation *string `json:"peak_iops_allocation,omitempty"`
}

// Validate validates this qos policy inline adaptive
func (m *QosPolicyInlineAdaptive) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateBlockSize(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateExpectedIopsAllocation(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePeakIopsAllocation(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var qosPolicyInlineAdaptiveTypeBlockSizePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["any","4k","8k","16k","32k","64k","128k"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		qosPolicyInlineAdaptiveTypeBlockSizePropEnum = append(qosPolicyInlineAdaptiveTypeBlockSizePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// qos_policy_inline_adaptive
	// QosPolicyInlineAdaptive
	// block_size
	// BlockSize
	// any
	// END DEBUGGING
	// QosPolicyInlineAdaptiveBlockSizeAny captures enum value "any"
	QosPolicyInlineAdaptiveBlockSizeAny string = "any"

	// BEGIN DEBUGGING
	// qos_policy_inline_adaptive
	// QosPolicyInlineAdaptive
	// block_size
	// BlockSize
	// 4k
	// END DEBUGGING
	// QosPolicyInlineAdaptiveBlockSizeNr4k captures enum value "4k"
	QosPolicyInlineAdaptiveBlockSizeNr4k string = "4k"

	// BEGIN DEBUGGING
	// qos_policy_inline_adaptive
	// QosPolicyInlineAdaptive
	// block_size
	// BlockSize
	// 8k
	// END DEBUGGING
	// QosPolicyInlineAdaptiveBlockSizeNr8k captures enum value "8k"
	QosPolicyInlineAdaptiveBlockSizeNr8k string = "8k"

	// BEGIN DEBUGGING
	// qos_policy_inline_adaptive
	// QosPolicyInlineAdaptive
	// block_size
	// BlockSize
	// 16k
	// END DEBUGGING
	// QosPolicyInlineAdaptiveBlockSizeNr16k captures enum value "16k"
	QosPolicyInlineAdaptiveBlockSizeNr16k string = "16k"

	// BEGIN DEBUGGING
	// qos_policy_inline_adaptive
	// QosPolicyInlineAdaptive
	// block_size
	// BlockSize
	// 32k
	// END DEBUGGING
	// QosPolicyInlineAdaptiveBlockSizeNr32k captures enum value "32k"
	QosPolicyInlineAdaptiveBlockSizeNr32k string = "32k"

	// BEGIN DEBUGGING
	// qos_policy_inline_adaptive
	// QosPolicyInlineAdaptive
	// block_size
	// BlockSize
	// 64k
	// END DEBUGGING
	// QosPolicyInlineAdaptiveBlockSizeNr64k captures enum value "64k"
	QosPolicyInlineAdaptiveBlockSizeNr64k string = "64k"

	// BEGIN DEBUGGING
	// qos_policy_inline_adaptive
	// QosPolicyInlineAdaptive
	// block_size
	// BlockSize
	// 128k
	// END DEBUGGING
	// QosPolicyInlineAdaptiveBlockSizeNr128k captures enum value "128k"
	QosPolicyInlineAdaptiveBlockSizeNr128k string = "128k"
)

// prop value enum
func (m *QosPolicyInlineAdaptive) validateBlockSizeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, qosPolicyInlineAdaptiveTypeBlockSizePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *QosPolicyInlineAdaptive) validateBlockSize(formats strfmt.Registry) error {
	if swag.IsZero(m.BlockSize) { // not required
		return nil
	}

	// value enum
	if err := m.validateBlockSizeEnum("adaptive"+"."+"block_size", "body", *m.BlockSize); err != nil {
		return err
	}

	return nil
}

var qosPolicyInlineAdaptiveTypeExpectedIopsAllocationPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["used_space","allocated_space"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		qosPolicyInlineAdaptiveTypeExpectedIopsAllocationPropEnum = append(qosPolicyInlineAdaptiveTypeExpectedIopsAllocationPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// qos_policy_inline_adaptive
	// QosPolicyInlineAdaptive
	// expected_iops_allocation
	// ExpectedIopsAllocation
	// used_space
	// END DEBUGGING
	// QosPolicyInlineAdaptiveExpectedIopsAllocationUsedSpace captures enum value "used_space"
	QosPolicyInlineAdaptiveExpectedIopsAllocationUsedSpace string = "used_space"

	// BEGIN DEBUGGING
	// qos_policy_inline_adaptive
	// QosPolicyInlineAdaptive
	// expected_iops_allocation
	// ExpectedIopsAllocation
	// allocated_space
	// END DEBUGGING
	// QosPolicyInlineAdaptiveExpectedIopsAllocationAllocatedSpace captures enum value "allocated_space"
	QosPolicyInlineAdaptiveExpectedIopsAllocationAllocatedSpace string = "allocated_space"
)

// prop value enum
func (m *QosPolicyInlineAdaptive) validateExpectedIopsAllocationEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, qosPolicyInlineAdaptiveTypeExpectedIopsAllocationPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *QosPolicyInlineAdaptive) validateExpectedIopsAllocation(formats strfmt.Registry) error {
	if swag.IsZero(m.ExpectedIopsAllocation) { // not required
		return nil
	}

	// value enum
	if err := m.validateExpectedIopsAllocationEnum("adaptive"+"."+"expected_iops_allocation", "body", *m.ExpectedIopsAllocation); err != nil {
		return err
	}

	return nil
}

var qosPolicyInlineAdaptiveTypePeakIopsAllocationPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["used_space","allocated_space"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		qosPolicyInlineAdaptiveTypePeakIopsAllocationPropEnum = append(qosPolicyInlineAdaptiveTypePeakIopsAllocationPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// qos_policy_inline_adaptive
	// QosPolicyInlineAdaptive
	// peak_iops_allocation
	// PeakIopsAllocation
	// used_space
	// END DEBUGGING
	// QosPolicyInlineAdaptivePeakIopsAllocationUsedSpace captures enum value "used_space"
	QosPolicyInlineAdaptivePeakIopsAllocationUsedSpace string = "used_space"

	// BEGIN DEBUGGING
	// qos_policy_inline_adaptive
	// QosPolicyInlineAdaptive
	// peak_iops_allocation
	// PeakIopsAllocation
	// allocated_space
	// END DEBUGGING
	// QosPolicyInlineAdaptivePeakIopsAllocationAllocatedSpace captures enum value "allocated_space"
	QosPolicyInlineAdaptivePeakIopsAllocationAllocatedSpace string = "allocated_space"
)

// prop value enum
func (m *QosPolicyInlineAdaptive) validatePeakIopsAllocationEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, qosPolicyInlineAdaptiveTypePeakIopsAllocationPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *QosPolicyInlineAdaptive) validatePeakIopsAllocation(formats strfmt.Registry) error {
	if swag.IsZero(m.PeakIopsAllocation) { // not required
		return nil
	}

	// value enum
	if err := m.validatePeakIopsAllocationEnum("adaptive"+"."+"peak_iops_allocation", "body", *m.PeakIopsAllocation); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this qos policy inline adaptive based on context it is used
func (m *QosPolicyInlineAdaptive) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *QosPolicyInlineAdaptive) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *QosPolicyInlineAdaptive) UnmarshalBinary(b []byte) error {
	var res QosPolicyInlineAdaptive
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// QosPolicyInlineFixed QoS policy-groups define a fixed service level objective (SLO) for a storage object.
//
// swagger:model qos_policy_inline_fixed
type QosPolicyInlineFixed struct {

	// Specifies whether the capacities are shared across all objects that use this QoS policy-group. Default is false.
	CapacityShared *bool `json:"capacity_shared,omitempty"`

	// Maximum throughput defined by this policy. It is specified in terms of Kbps, Mbps or Gbps along with or without IOPS. 0 means no maximum throughput is enforced.
	// Example: ["900KB/s","500MB/s","120GB/s","5000IOPS","5000IOPS,500KB/s","2500IOPS,100MB/s","1000IOPS,25MB/s"]
	MaxThroughput *string `json:"max_throughput,omitempty"`

	// Maximum throughput defined by this policy. It is specified in terms of IOPS. 0 means no maximum throughput is enforced.
	// Maximum: 2.147483647e+09
	// Minimum: 0
	MaxThroughputIops *int64 `json:"max_throughput_iops,omitempty"`

	// Maximum throughput defined by this policy. It is specified in terms of Mbps. 0 means no maximum throughput is enforced.
	// Maximum: 4.194303e+06
	// Minimum: 0
	MaxThroughputMbps *int64 `json:"max_throughput_mbps,omitempty"`

	// Minimum throughput defined by this policy. It is specified in terms of Kbps, Mbps or Gbps along with or without IOPS. 0 means no minimum throughput is enforced.
	// Example: ["900KB/s","500MB/s","120GB/s","5000IOPS","5000IOPS,500KB/s","2500IOPS,100MB/s","1000IOPS,25MB/s"]
	MinThroughput *string `json:"min_throughput,omitempty"`

	// Minimum throughput defined by this policy. It is specified in terms of IOPS. 0 means no minimum throughput is enforced. These floors are not guaranteed on non-AFF platforms or when FabricPool tiering policies are set.
	// Maximum: 2.147483647e+09
	// Minimum: 0
	MinThroughputIops *int64 `json:"min_throughput_iops,omitempty"`

	// Minimum throughput defined by this policy. It is specified in terms of Mbps. 0 means no minimum throughput is enforced.
	// Maximum: 4.194303e+06
	// Minimum: 0
	MinThroughputMbps *int64 `json:"min_throughput_mbps,omitempty"`
}

// Validate validates this qos policy inline fixed
func (m *QosPolicyInlineFixed) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateMaxThroughputIops(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateMaxThroughputMbps(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateMinThroughputIops(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateMinThroughputMbps(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *QosPolicyInlineFixed) validateMaxThroughputIops(formats strfmt.Registry) error {
	if swag.IsZero(m.MaxThroughputIops) { // not required
		return nil
	}

	if err := validate.MinimumInt("fixed"+"."+"max_throughput_iops", "body", *m.MaxThroughputIops, 0, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("fixed"+"."+"max_throughput_iops", "body", *m.MaxThroughputIops, 2.147483647e+09, false); err != nil {
		return err
	}

	return nil
}

func (m *QosPolicyInlineFixed) validateMaxThroughputMbps(formats strfmt.Registry) error {
	if swag.IsZero(m.MaxThroughputMbps) { // not required
		return nil
	}

	if err := validate.MinimumInt("fixed"+"."+"max_throughput_mbps", "body", *m.MaxThroughputMbps, 0, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("fixed"+"."+"max_throughput_mbps", "body", *m.MaxThroughputMbps, 4.194303e+06, false); err != nil {
		return err
	}

	return nil
}

func (m *QosPolicyInlineFixed) validateMinThroughputIops(formats strfmt.Registry) error {
	if swag.IsZero(m.MinThroughputIops) { // not required
		return nil
	}

	if err := validate.MinimumInt("fixed"+"."+"min_throughput_iops", "body", *m.MinThroughputIops, 0, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("fixed"+"."+"min_throughput_iops", "body", *m.MinThroughputIops, 2.147483647e+09, false); err != nil {
		return err
	}

	return nil
}

func (m *QosPolicyInlineFixed) validateMinThroughputMbps(formats strfmt.Registry) error {
	if swag.IsZero(m.MinThroughputMbps) { // not required
		return nil
	}

	if err := validate.MinimumInt("fixed"+"."+"min_throughput_mbps", "body", *m.MinThroughputMbps, 0, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("fixed"+"."+"min_throughput_mbps", "body", *m.MinThroughputMbps, 4.194303e+06, false); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this qos policy inline fixed based on context it is used
func (m *QosPolicyInlineFixed) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *QosPolicyInlineFixed) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *QosPolicyInlineFixed) UnmarshalBinary(b []byte) error {
	var res QosPolicyInlineFixed
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// QosPolicyInlineLinks qos policy inline links
//
// swagger:model qos_policy_inline__links
type QosPolicyInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this qos policy inline links
func (m *QosPolicyInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *QosPolicyInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this qos policy inline links based on the context it is used
func (m *QosPolicyInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *QosPolicyInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *QosPolicyInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *QosPolicyInlineLinks) UnmarshalBinary(b []byte) error {
	var res QosPolicyInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// QosPolicyInlineSvm SVM, applies only to SVM-scoped objects.
//
// swagger:model qos_policy_inline_svm
type QosPolicyInlineSvm struct {

	// links
	Links *QosPolicyInlineSvmInlineLinks `json:"_links,omitempty"`

	// The name of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: svm1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: 02c9e252-41be-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this qos policy inline svm
func (m *QosPolicyInlineSvm) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *QosPolicyInlineSvm) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this qos policy inline svm based on the context it is used
func (m *QosPolicyInlineSvm) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *QosPolicyInlineSvm) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *QosPolicyInlineSvm) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *QosPolicyInlineSvm) UnmarshalBinary(b []byte) error {
	var res QosPolicyInlineSvm
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// QosPolicyInlineSvmInlineLinks qos policy inline svm inline links
//
// swagger:model qos_policy_inline_svm_inline__links
type QosPolicyInlineSvmInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this qos policy inline svm inline links
func (m *QosPolicyInlineSvmInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *QosPolicyInlineSvmInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this qos policy inline svm inline links based on the context it is used
func (m *QosPolicyInlineSvmInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *QosPolicyInlineSvmInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *QosPolicyInlineSvmInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *QosPolicyInlineSvmInlineLinks) UnmarshalBinary(b []byte) error {
	var res QosPolicyInlineSvmInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
