// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// QosWorkload qos workload
//
// swagger:model qos_workload
type QosWorkload struct {

	// links
	Links *QosWorkloadInlineLinks `json:"_links,omitempty"`

	// Name of the file.
	// Read Only: true
	File *string `json:"file,omitempty"`

	// Name of the LUN. The name of the LUN will be displayed as "(unknown)" if the name cannot be retrieved.
	// Read Only: true
	Lun *string `json:"lun,omitempty"`

	// Name of the QoS workload.
	// Example: volume1-wid123
	Name *string `json:"name,omitempty"`

	// policy
	Policy *QosWorkloadInlinePolicy `json:"policy,omitempty"`

	// Name of the Qtree.
	// Read Only: true
	Qtree *string `json:"qtree,omitempty"`

	// svm
	Svm *QosWorkloadInlineSvm `json:"svm,omitempty"`

	// uuid
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`

	// Name of the volume. The name of the volume will be displayed as "(unknown)" if the name cannot be retrieved.
	// Example: volume1
	// Read Only: true
	Volume *string `json:"volume,omitempty"`

	// Workload ID of the QoS workload.
	// Example: 123
	// Read Only: true
	Wid *int64 `json:"wid,omitempty"`

	// Class of the QoS workload.
	// Example: autovolume
	// Read Only: true
	// Enum: ["undefined","preset","user_defined","system_defined","autovolume","load_control"]
	WorkloadClass *string `json:"workload_class,omitempty"`
}

// Validate validates this qos workload
func (m *QosWorkload) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePolicy(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSvm(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateWorkloadClass(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *QosWorkload) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *QosWorkload) validatePolicy(formats strfmt.Registry) error {
	if swag.IsZero(m.Policy) { // not required
		return nil
	}

	if m.Policy != nil {
		if err := m.Policy.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("policy")
			}
			return err
		}
	}

	return nil
}

func (m *QosWorkload) validateSvm(formats strfmt.Registry) error {
	if swag.IsZero(m.Svm) { // not required
		return nil
	}

	if m.Svm != nil {
		if err := m.Svm.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm")
			}
			return err
		}
	}

	return nil
}

var qosWorkloadTypeWorkloadClassPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["undefined","preset","user_defined","system_defined","autovolume","load_control"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		qosWorkloadTypeWorkloadClassPropEnum = append(qosWorkloadTypeWorkloadClassPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// qos_workload
	// QosWorkload
	// workload_class
	// WorkloadClass
	// undefined
	// END DEBUGGING
	// QosWorkloadWorkloadClassUndefined captures enum value "undefined"
	QosWorkloadWorkloadClassUndefined string = "undefined"

	// BEGIN DEBUGGING
	// qos_workload
	// QosWorkload
	// workload_class
	// WorkloadClass
	// preset
	// END DEBUGGING
	// QosWorkloadWorkloadClassPreset captures enum value "preset"
	QosWorkloadWorkloadClassPreset string = "preset"

	// BEGIN DEBUGGING
	// qos_workload
	// QosWorkload
	// workload_class
	// WorkloadClass
	// user_defined
	// END DEBUGGING
	// QosWorkloadWorkloadClassUserDefined captures enum value "user_defined"
	QosWorkloadWorkloadClassUserDefined string = "user_defined"

	// BEGIN DEBUGGING
	// qos_workload
	// QosWorkload
	// workload_class
	// WorkloadClass
	// system_defined
	// END DEBUGGING
	// QosWorkloadWorkloadClassSystemDefined captures enum value "system_defined"
	QosWorkloadWorkloadClassSystemDefined string = "system_defined"

	// BEGIN DEBUGGING
	// qos_workload
	// QosWorkload
	// workload_class
	// WorkloadClass
	// autovolume
	// END DEBUGGING
	// QosWorkloadWorkloadClassAutovolume captures enum value "autovolume"
	QosWorkloadWorkloadClassAutovolume string = "autovolume"

	// BEGIN DEBUGGING
	// qos_workload
	// QosWorkload
	// workload_class
	// WorkloadClass
	// load_control
	// END DEBUGGING
	// QosWorkloadWorkloadClassLoadControl captures enum value "load_control"
	QosWorkloadWorkloadClassLoadControl string = "load_control"
)

// prop value enum
func (m *QosWorkload) validateWorkloadClassEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, qosWorkloadTypeWorkloadClassPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *QosWorkload) validateWorkloadClass(formats strfmt.Registry) error {
	if swag.IsZero(m.WorkloadClass) { // not required
		return nil
	}

	// value enum
	if err := m.validateWorkloadClassEnum("workload_class", "body", *m.WorkloadClass); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this qos workload based on the context it is used
func (m *QosWorkload) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateFile(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLun(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidatePolicy(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateQtree(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSvm(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateVolume(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateWid(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateWorkloadClass(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *QosWorkload) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *QosWorkload) contextValidateFile(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "file", "body", m.File); err != nil {
		return err
	}

	return nil
}

func (m *QosWorkload) contextValidateLun(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "lun", "body", m.Lun); err != nil {
		return err
	}

	return nil
}

func (m *QosWorkload) contextValidatePolicy(ctx context.Context, formats strfmt.Registry) error {

	if m.Policy != nil {
		if err := m.Policy.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("policy")
			}
			return err
		}
	}

	return nil
}

func (m *QosWorkload) contextValidateQtree(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "qtree", "body", m.Qtree); err != nil {
		return err
	}

	return nil
}

func (m *QosWorkload) contextValidateSvm(ctx context.Context, formats strfmt.Registry) error {

	if m.Svm != nil {
		if err := m.Svm.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm")
			}
			return err
		}
	}

	return nil
}

func (m *QosWorkload) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "uuid", "body", m.UUID); err != nil {
		return err
	}

	return nil
}

func (m *QosWorkload) contextValidateVolume(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "volume", "body", m.Volume); err != nil {
		return err
	}

	return nil
}

func (m *QosWorkload) contextValidateWid(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "wid", "body", m.Wid); err != nil {
		return err
	}

	return nil
}

func (m *QosWorkload) contextValidateWorkloadClass(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "workload_class", "body", m.WorkloadClass); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *QosWorkload) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *QosWorkload) UnmarshalBinary(b []byte) error {
	var res QosWorkload
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// QosWorkloadInlineLinks qos workload inline links
//
// swagger:model qos_workload_inline__links
type QosWorkloadInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this qos workload inline links
func (m *QosWorkloadInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *QosWorkloadInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this qos workload inline links based on the context it is used
func (m *QosWorkloadInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *QosWorkloadInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *QosWorkloadInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *QosWorkloadInlineLinks) UnmarshalBinary(b []byte) error {
	var res QosWorkloadInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// QosWorkloadInlinePolicy QoS policy group reference.
//
// swagger:model qos_workload_inline_policy
type QosWorkloadInlinePolicy struct {

	// links
	Links *QosWorkloadInlinePolicyInlineLinks `json:"_links,omitempty"`

	// The QoS policy group name. This is mutually exclusive with UUID and other QoS attributes during POST and PATCH.
	// Example: performance
	Name *string `json:"name,omitempty"`

	// The QoS policy group UUID. This is mutually exclusive with name and other QoS attributes during POST and PATCH.
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this qos workload inline policy
func (m *QosWorkloadInlinePolicy) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *QosWorkloadInlinePolicy) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("policy" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this qos workload inline policy based on the context it is used
func (m *QosWorkloadInlinePolicy) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *QosWorkloadInlinePolicy) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("policy" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *QosWorkloadInlinePolicy) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *QosWorkloadInlinePolicy) UnmarshalBinary(b []byte) error {
	var res QosWorkloadInlinePolicy
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// QosWorkloadInlinePolicyInlineLinks qos workload inline policy inline links
//
// swagger:model qos_workload_inline_policy_inline__links
type QosWorkloadInlinePolicyInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this qos workload inline policy inline links
func (m *QosWorkloadInlinePolicyInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *QosWorkloadInlinePolicyInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("policy" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this qos workload inline policy inline links based on the context it is used
func (m *QosWorkloadInlinePolicyInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *QosWorkloadInlinePolicyInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("policy" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *QosWorkloadInlinePolicyInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *QosWorkloadInlinePolicyInlineLinks) UnmarshalBinary(b []byte) error {
	var res QosWorkloadInlinePolicyInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// QosWorkloadInlineSvm SVM, applies only to SVM-scoped objects.
//
// swagger:model qos_workload_inline_svm
type QosWorkloadInlineSvm struct {

	// links
	Links *QosWorkloadInlineSvmInlineLinks `json:"_links,omitempty"`

	// The name of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: svm1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: 02c9e252-41be-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this qos workload inline svm
func (m *QosWorkloadInlineSvm) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *QosWorkloadInlineSvm) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this qos workload inline svm based on the context it is used
func (m *QosWorkloadInlineSvm) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *QosWorkloadInlineSvm) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *QosWorkloadInlineSvm) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *QosWorkloadInlineSvm) UnmarshalBinary(b []byte) error {
	var res QosWorkloadInlineSvm
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// QosWorkloadInlineSvmInlineLinks qos workload inline svm inline links
//
// swagger:model qos_workload_inline_svm_inline__links
type QosWorkloadInlineSvmInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this qos workload inline svm inline links
func (m *QosWorkloadInlineSvmInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *QosWorkloadInlineSvmInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this qos workload inline svm inline links based on the context it is used
func (m *QosWorkloadInlineSvmInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *QosWorkloadInlineSvmInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *QosWorkloadInlineSvmInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *QosWorkloadInlineSvmInlineLinks) UnmarshalBinary(b []byte) error {
	var res QosWorkloadInlineSvmInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
