// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// Qtree A qtree is a directory at the top level of a volume to which a custom export policy (for fine-grained access control) and a quota rule can be applied, if required.
//
// swagger:model qtree
type Qtree struct {

	// links
	Links *QtreeInlineLinks `json:"_links,omitempty"`

	// export policy
	ExportPolicy *QtreeInlineExportPolicy `json:"export_policy,omitempty"`

	// ext performance monitoring
	ExtPerformanceMonitoring *QtreeInlineExtPerformanceMonitoring `json:"ext_performance_monitoring,omitempty"`

	// group
	Group *QtreeInlineGroup `json:"group,omitempty"`

	// The identifier for the qtree, unique within the qtree's volume.
	//
	// Example: 1
	// Read Only: true
	// Maximum: 4994
	// Minimum: 0
	ID *int64 `json:"id,omitempty"`

	// metric
	Metric *QtreeInlineMetric `json:"metric,omitempty"`

	// The name of the qtree. Required in POST; optional in PATCH.
	Name *string `json:"name,omitempty"`

	// nas
	Nas *QtreeInlineNas `json:"nas,omitempty"`

	// Client visible path to the qtree. This field is not available if the volume does not have a junction-path configured. Not valid in POST or PATCH. This field is to be deprecated and replaced with nas.path.
	// Example: /volume3/qtree1
	// Read Only: true
	Path *string `json:"path,omitempty"`

	// qos policy
	QosPolicy *QtreeInlineQosPolicy `json:"qos_policy,omitempty"`

	// Tags are an optional way to track the uses of a resource. Tag values must be formatted as key:value strings.
	// Example: ["team:csi","environment:test"]
	// Max Items: 64
	QtreeInlineTags []*string `json:"_tags,omitempty"`

	// security style
	SecurityStyle *SecurityStyle `json:"security_style,omitempty"`

	// statistics
	Statistics *QtreeInlineStatistics `json:"statistics,omitempty"`

	// svm
	Svm *QtreeInlineSvm `json:"svm,omitempty"`

	// The UNIX permissions for the qtree. Valid in POST or PATCH.
	// Example: 493
	UnixPermissions *int64 `json:"unix_permissions,omitempty"`

	// user
	User *QtreeInlineUser `json:"user,omitempty"`

	// volume
	Volume *QtreeInlineVolume `json:"volume,omitempty"`
}

// Validate validates this qtree
func (m *Qtree) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateExportPolicy(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateExtPerformanceMonitoring(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateGroup(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateID(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateMetric(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateNas(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateQosPolicy(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateQtreeInlineTags(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSecurityStyle(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStatistics(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSvm(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateUser(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateVolume(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *Qtree) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *Qtree) validateExportPolicy(formats strfmt.Registry) error {
	if swag.IsZero(m.ExportPolicy) { // not required
		return nil
	}

	if m.ExportPolicy != nil {
		if err := m.ExportPolicy.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("export_policy")
			}
			return err
		}
	}

	return nil
}

func (m *Qtree) validateExtPerformanceMonitoring(formats strfmt.Registry) error {
	if swag.IsZero(m.ExtPerformanceMonitoring) { // not required
		return nil
	}

	if m.ExtPerformanceMonitoring != nil {
		if err := m.ExtPerformanceMonitoring.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ext_performance_monitoring")
			}
			return err
		}
	}

	return nil
}

func (m *Qtree) validateGroup(formats strfmt.Registry) error {
	if swag.IsZero(m.Group) { // not required
		return nil
	}

	if m.Group != nil {
		if err := m.Group.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("group")
			}
			return err
		}
	}

	return nil
}

func (m *Qtree) validateID(formats strfmt.Registry) error {
	if swag.IsZero(m.ID) { // not required
		return nil
	}

	if err := validate.MinimumInt("id", "body", *m.ID, 0, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("id", "body", *m.ID, 4994, false); err != nil {
		return err
	}

	return nil
}

func (m *Qtree) validateMetric(formats strfmt.Registry) error {
	if swag.IsZero(m.Metric) { // not required
		return nil
	}

	if m.Metric != nil {
		if err := m.Metric.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric")
			}
			return err
		}
	}

	return nil
}

func (m *Qtree) validateNas(formats strfmt.Registry) error {
	if swag.IsZero(m.Nas) { // not required
		return nil
	}

	if m.Nas != nil {
		if err := m.Nas.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nas")
			}
			return err
		}
	}

	return nil
}

func (m *Qtree) validateQosPolicy(formats strfmt.Registry) error {
	if swag.IsZero(m.QosPolicy) { // not required
		return nil
	}

	if m.QosPolicy != nil {
		if err := m.QosPolicy.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos_policy")
			}
			return err
		}
	}

	return nil
}

func (m *Qtree) validateQtreeInlineTags(formats strfmt.Registry) error {
	if swag.IsZero(m.QtreeInlineTags) { // not required
		return nil
	}

	iQtreeInlineTagsSize := int64(len(m.QtreeInlineTags))

	if err := validate.MaxItems("_tags", "body", iQtreeInlineTagsSize, 64); err != nil {
		return err
	}

	return nil
}

func (m *Qtree) validateSecurityStyle(formats strfmt.Registry) error {
	if swag.IsZero(m.SecurityStyle) { // not required
		return nil
	}

	if m.SecurityStyle != nil {
		if err := m.SecurityStyle.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("security_style")
			}
			return err
		}
	}

	return nil
}

func (m *Qtree) validateStatistics(formats strfmt.Registry) error {
	if swag.IsZero(m.Statistics) { // not required
		return nil
	}

	if m.Statistics != nil {
		if err := m.Statistics.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics")
			}
			return err
		}
	}

	return nil
}

func (m *Qtree) validateSvm(formats strfmt.Registry) error {
	if swag.IsZero(m.Svm) { // not required
		return nil
	}

	if m.Svm != nil {
		if err := m.Svm.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm")
			}
			return err
		}
	}

	return nil
}

func (m *Qtree) validateUser(formats strfmt.Registry) error {
	if swag.IsZero(m.User) { // not required
		return nil
	}

	if m.User != nil {
		if err := m.User.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("user")
			}
			return err
		}
	}

	return nil
}

func (m *Qtree) validateVolume(formats strfmt.Registry) error {
	if swag.IsZero(m.Volume) { // not required
		return nil
	}

	if m.Volume != nil {
		if err := m.Volume.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("volume")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this qtree based on the context it is used
func (m *Qtree) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateExportPolicy(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateExtPerformanceMonitoring(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateGroup(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMetric(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateNas(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidatePath(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateQosPolicy(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSecurityStyle(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStatistics(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSvm(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUser(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateVolume(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *Qtree) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *Qtree) contextValidateExportPolicy(ctx context.Context, formats strfmt.Registry) error {

	if m.ExportPolicy != nil {
		if err := m.ExportPolicy.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("export_policy")
			}
			return err
		}
	}

	return nil
}

func (m *Qtree) contextValidateExtPerformanceMonitoring(ctx context.Context, formats strfmt.Registry) error {

	if m.ExtPerformanceMonitoring != nil {
		if err := m.ExtPerformanceMonitoring.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ext_performance_monitoring")
			}
			return err
		}
	}

	return nil
}

func (m *Qtree) contextValidateGroup(ctx context.Context, formats strfmt.Registry) error {

	if m.Group != nil {
		if err := m.Group.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("group")
			}
			return err
		}
	}

	return nil
}

func (m *Qtree) contextValidateID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "id", "body", m.ID); err != nil {
		return err
	}

	return nil
}

func (m *Qtree) contextValidateMetric(ctx context.Context, formats strfmt.Registry) error {

	if m.Metric != nil {
		if err := m.Metric.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric")
			}
			return err
		}
	}

	return nil
}

func (m *Qtree) contextValidateNas(ctx context.Context, formats strfmt.Registry) error {

	if m.Nas != nil {
		if err := m.Nas.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nas")
			}
			return err
		}
	}

	return nil
}

func (m *Qtree) contextValidatePath(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "path", "body", m.Path); err != nil {
		return err
	}

	return nil
}

func (m *Qtree) contextValidateQosPolicy(ctx context.Context, formats strfmt.Registry) error {

	if m.QosPolicy != nil {
		if err := m.QosPolicy.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos_policy")
			}
			return err
		}
	}

	return nil
}

func (m *Qtree) contextValidateSecurityStyle(ctx context.Context, formats strfmt.Registry) error {

	if m.SecurityStyle != nil {
		if err := m.SecurityStyle.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("security_style")
			}
			return err
		}
	}

	return nil
}

func (m *Qtree) contextValidateStatistics(ctx context.Context, formats strfmt.Registry) error {

	if m.Statistics != nil {
		if err := m.Statistics.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics")
			}
			return err
		}
	}

	return nil
}

func (m *Qtree) contextValidateSvm(ctx context.Context, formats strfmt.Registry) error {

	if m.Svm != nil {
		if err := m.Svm.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm")
			}
			return err
		}
	}

	return nil
}

func (m *Qtree) contextValidateUser(ctx context.Context, formats strfmt.Registry) error {

	if m.User != nil {
		if err := m.User.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("user")
			}
			return err
		}
	}

	return nil
}

func (m *Qtree) contextValidateVolume(ctx context.Context, formats strfmt.Registry) error {

	if m.Volume != nil {
		if err := m.Volume.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("volume")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *Qtree) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *Qtree) UnmarshalBinary(b []byte) error {
	var res Qtree
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// QtreeInlineExportPolicy Export Policy
//
// swagger:model qtree_inline_export_policy
type QtreeInlineExportPolicy struct {

	// links
	Links *QtreeInlineExportPolicyInlineLinks `json:"_links,omitempty"`

	// id
	// Example: 100
	ID *int64 `json:"id,omitempty"`

	// name
	// Example: default
	Name *string `json:"name,omitempty"`
}

// Validate validates this qtree inline export policy
func (m *QtreeInlineExportPolicy) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *QtreeInlineExportPolicy) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("export_policy" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this qtree inline export policy based on the context it is used
func (m *QtreeInlineExportPolicy) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *QtreeInlineExportPolicy) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("export_policy" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *QtreeInlineExportPolicy) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *QtreeInlineExportPolicy) UnmarshalBinary(b []byte) error {
	var res QtreeInlineExportPolicy
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// QtreeInlineExportPolicyInlineLinks qtree inline export policy inline links
//
// swagger:model qtree_inline_export_policy_inline__links
type QtreeInlineExportPolicyInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this qtree inline export policy inline links
func (m *QtreeInlineExportPolicyInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *QtreeInlineExportPolicyInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("export_policy" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this qtree inline export policy inline links based on the context it is used
func (m *QtreeInlineExportPolicyInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *QtreeInlineExportPolicyInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("export_policy" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *QtreeInlineExportPolicyInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *QtreeInlineExportPolicyInlineLinks) UnmarshalBinary(b []byte) error {
	var res QtreeInlineExportPolicyInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// QtreeInlineExtPerformanceMonitoring qtree inline ext performance monitoring
//
// swagger:model qtree_inline_ext_performance_monitoring
type QtreeInlineExtPerformanceMonitoring struct {

	// Specifies whether extended performance monitoring is enabled for the qtree.
	Enabled *bool `json:"enabled,omitempty"`
}

// Validate validates this qtree inline ext performance monitoring
func (m *QtreeInlineExtPerformanceMonitoring) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this qtree inline ext performance monitoring based on context it is used
func (m *QtreeInlineExtPerformanceMonitoring) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *QtreeInlineExtPerformanceMonitoring) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *QtreeInlineExtPerformanceMonitoring) UnmarshalBinary(b []byte) error {
	var res QtreeInlineExtPerformanceMonitoring
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// QtreeInlineGroup The user set as owner of the qtree.
//
// swagger:model qtree_inline_group
type QtreeInlineGroup struct {

	// The numeric ID of the group that owns the qtree. Valid in POST or PATCH.
	// Example: 20001
	ID *string `json:"id,omitempty"`

	// Alphanumeric group name of group that owns the qtree. Valid in POST or PATCH.
	// Example: unix_group1
	Name *string `json:"name,omitempty"`
}

// Validate validates this qtree inline group
func (m *QtreeInlineGroup) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this qtree inline group based on context it is used
func (m *QtreeInlineGroup) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *QtreeInlineGroup) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *QtreeInlineGroup) UnmarshalBinary(b []byte) error {
	var res QtreeInlineGroup
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// QtreeInlineLinks qtree inline links
//
// swagger:model qtree_inline__links
type QtreeInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this qtree inline links
func (m *QtreeInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *QtreeInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this qtree inline links based on the context it is used
func (m *QtreeInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *QtreeInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *QtreeInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *QtreeInlineLinks) UnmarshalBinary(b []byte) error {
	var res QtreeInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// QtreeInlineMetric Performance numbers, such as IOPS latency and throughput.
//
// swagger:model qtree_inline_metric
type QtreeInlineMetric struct {

	// links
	Links *QtreeInlineMetricInlineLinks `json:"_links,omitempty"`

	// The duration over which this sample is calculated. The time durations are represented in the ISO-8601 standard format. Samples can be calculated over the following durations:
	//
	// Example: PT5M
	// Enum: ["PT4M","PT30M","PT2H","P1D","PT5M"]
	Duration *string `json:"duration,omitempty"`

	// iops
	Iops *QtreeInlineMetricInlineIops `json:"iops,omitempty"`

	// latency
	Latency *QtreeInlineMetricInlineLatency `json:"latency,omitempty"`

	// Errors associated with the sample. For example, if the aggregation of data over multiple nodes fails, then any partial errors might return "ok" on success or "error" on an internal uncategorized failure. Whenever a sample collection is missed but done at a later time, it is back filled to the previous 15 second timestamp and tagged with "backfilled_data". "Inconsistent_ delta_time" is encountered when the time between two collections is not the same for all nodes. Therefore, the aggregated value might be over or under inflated. "Negative_delta" is returned when an expected monotonically increasing value has decreased in value. "Inconsistent_old_data" is returned when one or more nodes do not have the latest data.
	// Example: ok
	// Read Only: true
	// Enum: ["ok","error","partial_no_data","partial_no_response","partial_other_error","negative_delta","not_found","backfilled_data","inconsistent_delta_time","inconsistent_old_data","partial_no_uuid"]
	Status *string `json:"status,omitempty"`

	// throughput
	Throughput *QtreeInlineMetricInlineThroughput `json:"throughput,omitempty"`

	// The timestamp of the performance data.
	// Example: 2017-01-25 11:20:13+00:00
	// Read Only: true
	// Format: date-time
	Timestamp *strfmt.DateTime `json:"timestamp,omitempty"`
}

// Validate validates this qtree inline metric
func (m *QtreeInlineMetric) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDuration(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateIops(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLatency(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateThroughput(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTimestamp(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *QtreeInlineMetric) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

var qtreeInlineMetricTypeDurationPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["PT4M","PT30M","PT2H","P1D","PT5M"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		qtreeInlineMetricTypeDurationPropEnum = append(qtreeInlineMetricTypeDurationPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// qtree_inline_metric
	// QtreeInlineMetric
	// duration
	// Duration
	// PT4M
	// END DEBUGGING
	// QtreeInlineMetricDurationPT4M captures enum value "PT4M"
	QtreeInlineMetricDurationPT4M string = "PT4M"

	// BEGIN DEBUGGING
	// qtree_inline_metric
	// QtreeInlineMetric
	// duration
	// Duration
	// PT30M
	// END DEBUGGING
	// QtreeInlineMetricDurationPT30M captures enum value "PT30M"
	QtreeInlineMetricDurationPT30M string = "PT30M"

	// BEGIN DEBUGGING
	// qtree_inline_metric
	// QtreeInlineMetric
	// duration
	// Duration
	// PT2H
	// END DEBUGGING
	// QtreeInlineMetricDurationPT2H captures enum value "PT2H"
	QtreeInlineMetricDurationPT2H string = "PT2H"

	// BEGIN DEBUGGING
	// qtree_inline_metric
	// QtreeInlineMetric
	// duration
	// Duration
	// P1D
	// END DEBUGGING
	// QtreeInlineMetricDurationP1D captures enum value "P1D"
	QtreeInlineMetricDurationP1D string = "P1D"

	// BEGIN DEBUGGING
	// qtree_inline_metric
	// QtreeInlineMetric
	// duration
	// Duration
	// PT5M
	// END DEBUGGING
	// QtreeInlineMetricDurationPT5M captures enum value "PT5M"
	QtreeInlineMetricDurationPT5M string = "PT5M"
)

// prop value enum
func (m *QtreeInlineMetric) validateDurationEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, qtreeInlineMetricTypeDurationPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *QtreeInlineMetric) validateDuration(formats strfmt.Registry) error {
	if swag.IsZero(m.Duration) { // not required
		return nil
	}

	// value enum
	if err := m.validateDurationEnum("metric"+"."+"duration", "body", *m.Duration); err != nil {
		return err
	}

	return nil
}

func (m *QtreeInlineMetric) validateIops(formats strfmt.Registry) error {
	if swag.IsZero(m.Iops) { // not required
		return nil
	}

	if m.Iops != nil {
		if err := m.Iops.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "iops")
			}
			return err
		}
	}

	return nil
}

func (m *QtreeInlineMetric) validateLatency(formats strfmt.Registry) error {
	if swag.IsZero(m.Latency) { // not required
		return nil
	}

	if m.Latency != nil {
		if err := m.Latency.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "latency")
			}
			return err
		}
	}

	return nil
}

var qtreeInlineMetricTypeStatusPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ok","error","partial_no_data","partial_no_response","partial_other_error","negative_delta","not_found","backfilled_data","inconsistent_delta_time","inconsistent_old_data","partial_no_uuid"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		qtreeInlineMetricTypeStatusPropEnum = append(qtreeInlineMetricTypeStatusPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// qtree_inline_metric
	// QtreeInlineMetric
	// status
	// Status
	// ok
	// END DEBUGGING
	// QtreeInlineMetricStatusOk captures enum value "ok"
	QtreeInlineMetricStatusOk string = "ok"

	// BEGIN DEBUGGING
	// qtree_inline_metric
	// QtreeInlineMetric
	// status
	// Status
	// error
	// END DEBUGGING
	// QtreeInlineMetricStatusError captures enum value "error"
	QtreeInlineMetricStatusError string = "error"

	// BEGIN DEBUGGING
	// qtree_inline_metric
	// QtreeInlineMetric
	// status
	// Status
	// partial_no_data
	// END DEBUGGING
	// QtreeInlineMetricStatusPartialNoData captures enum value "partial_no_data"
	QtreeInlineMetricStatusPartialNoData string = "partial_no_data"

	// BEGIN DEBUGGING
	// qtree_inline_metric
	// QtreeInlineMetric
	// status
	// Status
	// partial_no_response
	// END DEBUGGING
	// QtreeInlineMetricStatusPartialNoResponse captures enum value "partial_no_response"
	QtreeInlineMetricStatusPartialNoResponse string = "partial_no_response"

	// BEGIN DEBUGGING
	// qtree_inline_metric
	// QtreeInlineMetric
	// status
	// Status
	// partial_other_error
	// END DEBUGGING
	// QtreeInlineMetricStatusPartialOtherError captures enum value "partial_other_error"
	QtreeInlineMetricStatusPartialOtherError string = "partial_other_error"

	// BEGIN DEBUGGING
	// qtree_inline_metric
	// QtreeInlineMetric
	// status
	// Status
	// negative_delta
	// END DEBUGGING
	// QtreeInlineMetricStatusNegativeDelta captures enum value "negative_delta"
	QtreeInlineMetricStatusNegativeDelta string = "negative_delta"

	// BEGIN DEBUGGING
	// qtree_inline_metric
	// QtreeInlineMetric
	// status
	// Status
	// not_found
	// END DEBUGGING
	// QtreeInlineMetricStatusNotFound captures enum value "not_found"
	QtreeInlineMetricStatusNotFound string = "not_found"

	// BEGIN DEBUGGING
	// qtree_inline_metric
	// QtreeInlineMetric
	// status
	// Status
	// backfilled_data
	// END DEBUGGING
	// QtreeInlineMetricStatusBackfilledData captures enum value "backfilled_data"
	QtreeInlineMetricStatusBackfilledData string = "backfilled_data"

	// BEGIN DEBUGGING
	// qtree_inline_metric
	// QtreeInlineMetric
	// status
	// Status
	// inconsistent_delta_time
	// END DEBUGGING
	// QtreeInlineMetricStatusInconsistentDeltaTime captures enum value "inconsistent_delta_time"
	QtreeInlineMetricStatusInconsistentDeltaTime string = "inconsistent_delta_time"

	// BEGIN DEBUGGING
	// qtree_inline_metric
	// QtreeInlineMetric
	// status
	// Status
	// inconsistent_old_data
	// END DEBUGGING
	// QtreeInlineMetricStatusInconsistentOldData captures enum value "inconsistent_old_data"
	QtreeInlineMetricStatusInconsistentOldData string = "inconsistent_old_data"

	// BEGIN DEBUGGING
	// qtree_inline_metric
	// QtreeInlineMetric
	// status
	// Status
	// partial_no_uuid
	// END DEBUGGING
	// QtreeInlineMetricStatusPartialNoUUID captures enum value "partial_no_uuid"
	QtreeInlineMetricStatusPartialNoUUID string = "partial_no_uuid"
)

// prop value enum
func (m *QtreeInlineMetric) validateStatusEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, qtreeInlineMetricTypeStatusPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *QtreeInlineMetric) validateStatus(formats strfmt.Registry) error {
	if swag.IsZero(m.Status) { // not required
		return nil
	}

	// value enum
	if err := m.validateStatusEnum("metric"+"."+"status", "body", *m.Status); err != nil {
		return err
	}

	return nil
}

func (m *QtreeInlineMetric) validateThroughput(formats strfmt.Registry) error {
	if swag.IsZero(m.Throughput) { // not required
		return nil
	}

	if m.Throughput != nil {
		if err := m.Throughput.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "throughput")
			}
			return err
		}
	}

	return nil
}

func (m *QtreeInlineMetric) validateTimestamp(formats strfmt.Registry) error {
	if swag.IsZero(m.Timestamp) { // not required
		return nil
	}

	if err := validate.FormatOf("metric"+"."+"timestamp", "body", "date-time", m.Timestamp.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this qtree inline metric based on the context it is used
func (m *QtreeInlineMetric) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIops(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLatency(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStatus(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateThroughput(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTimestamp(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *QtreeInlineMetric) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (m *QtreeInlineMetric) contextValidateIops(ctx context.Context, formats strfmt.Registry) error {

	if m.Iops != nil {
		if err := m.Iops.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "iops")
			}
			return err
		}
	}

	return nil
}

func (m *QtreeInlineMetric) contextValidateLatency(ctx context.Context, formats strfmt.Registry) error {

	if m.Latency != nil {
		if err := m.Latency.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "latency")
			}
			return err
		}
	}

	return nil
}

func (m *QtreeInlineMetric) contextValidateStatus(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "metric"+"."+"status", "body", m.Status); err != nil {
		return err
	}

	return nil
}

func (m *QtreeInlineMetric) contextValidateThroughput(ctx context.Context, formats strfmt.Registry) error {

	if m.Throughput != nil {
		if err := m.Throughput.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "throughput")
			}
			return err
		}
	}

	return nil
}

func (m *QtreeInlineMetric) contextValidateTimestamp(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "metric"+"."+"timestamp", "body", m.Timestamp); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *QtreeInlineMetric) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *QtreeInlineMetric) UnmarshalBinary(b []byte) error {
	var res QtreeInlineMetric
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// QtreeInlineMetricInlineIops The rate of I/O operations observed at the storage object.
//
// swagger:model qtree_inline_metric_inline_iops
type QtreeInlineMetricInlineIops struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this qtree inline metric inline iops
func (m *QtreeInlineMetricInlineIops) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this qtree inline metric inline iops based on the context it is used
func (m *QtreeInlineMetricInlineIops) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *QtreeInlineMetricInlineIops) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *QtreeInlineMetricInlineIops) UnmarshalBinary(b []byte) error {
	var res QtreeInlineMetricInlineIops
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// QtreeInlineMetricInlineLatency The round trip latency in microseconds observed at the storage object.
//
// swagger:model qtree_inline_metric_inline_latency
type QtreeInlineMetricInlineLatency struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this qtree inline metric inline latency
func (m *QtreeInlineMetricInlineLatency) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this qtree inline metric inline latency based on the context it is used
func (m *QtreeInlineMetricInlineLatency) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *QtreeInlineMetricInlineLatency) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *QtreeInlineMetricInlineLatency) UnmarshalBinary(b []byte) error {
	var res QtreeInlineMetricInlineLatency
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// QtreeInlineMetricInlineLinks qtree inline metric inline links
//
// swagger:model qtree_inline_metric_inline__links
type QtreeInlineMetricInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this qtree inline metric inline links
func (m *QtreeInlineMetricInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *QtreeInlineMetricInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this qtree inline metric inline links based on the context it is used
func (m *QtreeInlineMetricInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *QtreeInlineMetricInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *QtreeInlineMetricInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *QtreeInlineMetricInlineLinks) UnmarshalBinary(b []byte) error {
	var res QtreeInlineMetricInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// QtreeInlineMetricInlineThroughput The rate of throughput bytes per second observed at the storage object.
//
// swagger:model qtree_inline_metric_inline_throughput
type QtreeInlineMetricInlineThroughput struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this qtree inline metric inline throughput
func (m *QtreeInlineMetricInlineThroughput) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this qtree inline metric inline throughput based on the context it is used
func (m *QtreeInlineMetricInlineThroughput) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *QtreeInlineMetricInlineThroughput) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *QtreeInlineMetricInlineThroughput) UnmarshalBinary(b []byte) error {
	var res QtreeInlineMetricInlineThroughput
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// QtreeInlineNas qtree inline nas
//
// swagger:model qtree_inline_nas
type QtreeInlineNas struct {

	// Client visible path to the qtree. This field is not available if the volume does not have a junction-path configured. Not valid in POST or PATCH.
	// Example: /volume3/qtree1
	// Read Only: true
	Path *string `json:"path,omitempty"`
}

// Validate validates this qtree inline nas
func (m *QtreeInlineNas) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this qtree inline nas based on the context it is used
func (m *QtreeInlineNas) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidatePath(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *QtreeInlineNas) contextValidatePath(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "nas"+"."+"path", "body", m.Path); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *QtreeInlineNas) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *QtreeInlineNas) UnmarshalBinary(b []byte) error {
	var res QtreeInlineNas
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// QtreeInlineQosPolicy When "min_throughput_iops", "min_throughput_mbps", "min_throughput", "max_throughput_iops", "max_throughput_mbps" or "max_throughput" attributes are specified, the storage object is assigned to an auto-generated QoS policy group. If the attributes are later modified, the auto-generated QoS policy-group attributes are modified. Attributes can be removed by specifying "0" and policy group by specifying "none". Upon deletion of the storage object or if the attributes are removed, then the QoS policy-group is also removed.
//
// swagger:model qtree_inline_qos_policy
type QtreeInlineQosPolicy struct {

	// links
	Links *QtreeInlineQosPolicyInlineLinks `json:"_links,omitempty"`

	// Specifies the maximum throughput in Kilobytes per sec, Megabytes per sec or Gigabytes per sec along with or without IOPS. 0 means none. This is mutually exclusive with name and UUID during POST and PATCH. This cannot be set when either max_throughput_mbps or max_throughput_iops are set during POST or PATCH. During GET, the returned value is rounded to the largest unit with a value greater than 1.
	// Example: ["900KB/s","500MB/s","120GB/s","5000IOPS","5000IOPS,500KB/s","2500IOPS,100MB/s","1000IOPS,25MB/s"]
	MaxThroughput *string `json:"max_throughput,omitempty"`

	// Specifies the maximum throughput in IOPS, 0 means none. This is mutually exclusive with name and UUID during POST and PATCH. This cannot be set when max_throughput is set during POST or PATCH.
	// Example: 10000
	// Maximum: 2.147483647e+09
	// Minimum: 0
	MaxThroughputIops *int64 `json:"max_throughput_iops,omitempty"`

	// Specifies the maximum throughput in Megabytes per sec, 0 means none. This is mutually exclusive with name and UUID during POST and PATCH. This cannot be set when max_throughput is set during POST or PATCH.
	// Example: 500
	// Maximum: 4.194303e+06
	// Minimum: 0
	MaxThroughputMbps *int64 `json:"max_throughput_mbps,omitempty"`

	// Specifies the minimum throughput in Kilobytes per sec, Megabytes per sec or Gigabytes per sec along with or without IOPS. 0 means none.Setting "min_throughput" is supported on AFF platforms only, unless FabricPool tiering policies are set. This is mutually exclusive with name and UUID during POST and PATCH. This cannot be set when either min_throughput_mbps or min_throughput_iops are set during POST or PATCH. During GET, the returned value is rounded to the largest unit with a value greater than 1.
	// Example: ["900KB/s","500MB/s","120GB/s","5000IOPS","5000IOPS,500KB/s","2500IOPS,100MB/s","1000IOPS,25MB/s"]
	MinThroughput *string `json:"min_throughput,omitempty"`

	// Specifies the minimum throughput in IOPS, 0 means none. Setting "min_throughput" is supported on AFF platforms only, unless FabricPool tiering policies are set. This is mutually exclusive with name and UUID during POST and PATCH. This cannot be set when min_throughput is set during POST or PATCH.
	// Example: 2000
	// Maximum: 2.147483647e+09
	// Minimum: 0
	MinThroughputIops *int64 `json:"min_throughput_iops,omitempty"`

	// Specifies the minimum throughput in Megabytes per sec, 0 means none. This is mutually exclusive with name and UUID during POST and PATCH.This cannot be set when min_throughput is set during POST or PATCH.
	// Example: 500
	// Maximum: 4.194303e+06
	// Minimum: 0
	MinThroughputMbps *int64 `json:"min_throughput_mbps,omitempty"`

	// The QoS policy group name. This is mutually exclusive with UUID and other QoS attributes during POST and PATCH.
	// Example: performance
	Name *string `json:"name,omitempty"`

	// The QoS policy group UUID. This is mutually exclusive with name and other QoS attributes during POST and PATCH.
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this qtree inline qos policy
func (m *QtreeInlineQosPolicy) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateMaxThroughputIops(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateMaxThroughputMbps(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateMinThroughputIops(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateMinThroughputMbps(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *QtreeInlineQosPolicy) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos_policy" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (m *QtreeInlineQosPolicy) validateMaxThroughputIops(formats strfmt.Registry) error {
	if swag.IsZero(m.MaxThroughputIops) { // not required
		return nil
	}

	if err := validate.MinimumInt("qos_policy"+"."+"max_throughput_iops", "body", *m.MaxThroughputIops, 0, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("qos_policy"+"."+"max_throughput_iops", "body", *m.MaxThroughputIops, 2.147483647e+09, false); err != nil {
		return err
	}

	return nil
}

func (m *QtreeInlineQosPolicy) validateMaxThroughputMbps(formats strfmt.Registry) error {
	if swag.IsZero(m.MaxThroughputMbps) { // not required
		return nil
	}

	if err := validate.MinimumInt("qos_policy"+"."+"max_throughput_mbps", "body", *m.MaxThroughputMbps, 0, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("qos_policy"+"."+"max_throughput_mbps", "body", *m.MaxThroughputMbps, 4.194303e+06, false); err != nil {
		return err
	}

	return nil
}

func (m *QtreeInlineQosPolicy) validateMinThroughputIops(formats strfmt.Registry) error {
	if swag.IsZero(m.MinThroughputIops) { // not required
		return nil
	}

	if err := validate.MinimumInt("qos_policy"+"."+"min_throughput_iops", "body", *m.MinThroughputIops, 0, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("qos_policy"+"."+"min_throughput_iops", "body", *m.MinThroughputIops, 2.147483647e+09, false); err != nil {
		return err
	}

	return nil
}

func (m *QtreeInlineQosPolicy) validateMinThroughputMbps(formats strfmt.Registry) error {
	if swag.IsZero(m.MinThroughputMbps) { // not required
		return nil
	}

	if err := validate.MinimumInt("qos_policy"+"."+"min_throughput_mbps", "body", *m.MinThroughputMbps, 0, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("qos_policy"+"."+"min_throughput_mbps", "body", *m.MinThroughputMbps, 4.194303e+06, false); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this qtree inline qos policy based on the context it is used
func (m *QtreeInlineQosPolicy) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *QtreeInlineQosPolicy) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos_policy" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *QtreeInlineQosPolicy) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *QtreeInlineQosPolicy) UnmarshalBinary(b []byte) error {
	var res QtreeInlineQosPolicy
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// QtreeInlineQosPolicyInlineLinks qtree inline qos policy inline links
//
// swagger:model qtree_inline_qos_policy_inline__links
type QtreeInlineQosPolicyInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this qtree inline qos policy inline links
func (m *QtreeInlineQosPolicyInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *QtreeInlineQosPolicyInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos_policy" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this qtree inline qos policy inline links based on the context it is used
func (m *QtreeInlineQosPolicyInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *QtreeInlineQosPolicyInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos_policy" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *QtreeInlineQosPolicyInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *QtreeInlineQosPolicyInlineLinks) UnmarshalBinary(b []byte) error {
	var res QtreeInlineQosPolicyInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// QtreeInlineStatistics These are raw IOPS and throughput performance numbers. These numbers are aggregated across all nodes in the cluster and increase with the uptime of the cluster.
//
// swagger:model qtree_inline_statistics
type QtreeInlineStatistics struct {

	// iops raw
	IopsRaw *QtreeInlineStatisticsInlineIopsRaw `json:"iops_raw,omitempty"`

	// latency raw
	LatencyRaw *QtreeInlineStatisticsInlineLatencyRaw `json:"latency_raw,omitempty"`

	// Any errors associated with the sample. For example, if the aggregation of data over multiple nodes fails then any of the partial errors might be returned, "ok" on success, or "error" on any internal uncategorized failure. Whenever a sample collection is missed but done at a later time, it is back filled with the next closest collection and tagged with "backfilled_data". "inconsistent_delta_time" is encountered when the time between two collections is not the same for all nodes. Therefore, the aggregated value might be over or under inflated. "negative_delta" is returned when an expected monotonically increasing value has decreased in value. "inconsistent_old_data" is returned when one or more nodes does not have the latest data.
	// Example: ok
	// Read Only: true
	// Enum: ["ok","error","partial_no_data","partial_no_uuid","partial_no_response","partial_other_error","negative_delta","backfilled_data","inconsistent_delta_time","inconsistent_old_data"]
	Status *string `json:"status,omitempty"`

	// throughput raw
	ThroughputRaw *QtreeInlineStatisticsInlineThroughputRaw `json:"throughput_raw,omitempty"`

	// The timestamp of the performance data.
	// Example: 2017-01-25 11:20:13+00:00
	// Read Only: true
	// Format: date-time
	Timestamp *strfmt.DateTime `json:"timestamp,omitempty"`
}

// Validate validates this qtree inline statistics
func (m *QtreeInlineStatistics) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateIopsRaw(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLatencyRaw(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateThroughputRaw(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTimestamp(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *QtreeInlineStatistics) validateIopsRaw(formats strfmt.Registry) error {
	if swag.IsZero(m.IopsRaw) { // not required
		return nil
	}

	if m.IopsRaw != nil {
		if err := m.IopsRaw.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "iops_raw")
			}
			return err
		}
	}

	return nil
}

func (m *QtreeInlineStatistics) validateLatencyRaw(formats strfmt.Registry) error {
	if swag.IsZero(m.LatencyRaw) { // not required
		return nil
	}

	if m.LatencyRaw != nil {
		if err := m.LatencyRaw.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "latency_raw")
			}
			return err
		}
	}

	return nil
}

var qtreeInlineStatisticsTypeStatusPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ok","error","partial_no_data","partial_no_uuid","partial_no_response","partial_other_error","negative_delta","backfilled_data","inconsistent_delta_time","inconsistent_old_data"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		qtreeInlineStatisticsTypeStatusPropEnum = append(qtreeInlineStatisticsTypeStatusPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// qtree_inline_statistics
	// QtreeInlineStatistics
	// status
	// Status
	// ok
	// END DEBUGGING
	// QtreeInlineStatisticsStatusOk captures enum value "ok"
	QtreeInlineStatisticsStatusOk string = "ok"

	// BEGIN DEBUGGING
	// qtree_inline_statistics
	// QtreeInlineStatistics
	// status
	// Status
	// error
	// END DEBUGGING
	// QtreeInlineStatisticsStatusError captures enum value "error"
	QtreeInlineStatisticsStatusError string = "error"

	// BEGIN DEBUGGING
	// qtree_inline_statistics
	// QtreeInlineStatistics
	// status
	// Status
	// partial_no_data
	// END DEBUGGING
	// QtreeInlineStatisticsStatusPartialNoData captures enum value "partial_no_data"
	QtreeInlineStatisticsStatusPartialNoData string = "partial_no_data"

	// BEGIN DEBUGGING
	// qtree_inline_statistics
	// QtreeInlineStatistics
	// status
	// Status
	// partial_no_uuid
	// END DEBUGGING
	// QtreeInlineStatisticsStatusPartialNoUUID captures enum value "partial_no_uuid"
	QtreeInlineStatisticsStatusPartialNoUUID string = "partial_no_uuid"

	// BEGIN DEBUGGING
	// qtree_inline_statistics
	// QtreeInlineStatistics
	// status
	// Status
	// partial_no_response
	// END DEBUGGING
	// QtreeInlineStatisticsStatusPartialNoResponse captures enum value "partial_no_response"
	QtreeInlineStatisticsStatusPartialNoResponse string = "partial_no_response"

	// BEGIN DEBUGGING
	// qtree_inline_statistics
	// QtreeInlineStatistics
	// status
	// Status
	// partial_other_error
	// END DEBUGGING
	// QtreeInlineStatisticsStatusPartialOtherError captures enum value "partial_other_error"
	QtreeInlineStatisticsStatusPartialOtherError string = "partial_other_error"

	// BEGIN DEBUGGING
	// qtree_inline_statistics
	// QtreeInlineStatistics
	// status
	// Status
	// negative_delta
	// END DEBUGGING
	// QtreeInlineStatisticsStatusNegativeDelta captures enum value "negative_delta"
	QtreeInlineStatisticsStatusNegativeDelta string = "negative_delta"

	// BEGIN DEBUGGING
	// qtree_inline_statistics
	// QtreeInlineStatistics
	// status
	// Status
	// backfilled_data
	// END DEBUGGING
	// QtreeInlineStatisticsStatusBackfilledData captures enum value "backfilled_data"
	QtreeInlineStatisticsStatusBackfilledData string = "backfilled_data"

	// BEGIN DEBUGGING
	// qtree_inline_statistics
	// QtreeInlineStatistics
	// status
	// Status
	// inconsistent_delta_time
	// END DEBUGGING
	// QtreeInlineStatisticsStatusInconsistentDeltaTime captures enum value "inconsistent_delta_time"
	QtreeInlineStatisticsStatusInconsistentDeltaTime string = "inconsistent_delta_time"

	// BEGIN DEBUGGING
	// qtree_inline_statistics
	// QtreeInlineStatistics
	// status
	// Status
	// inconsistent_old_data
	// END DEBUGGING
	// QtreeInlineStatisticsStatusInconsistentOldData captures enum value "inconsistent_old_data"
	QtreeInlineStatisticsStatusInconsistentOldData string = "inconsistent_old_data"
)

// prop value enum
func (m *QtreeInlineStatistics) validateStatusEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, qtreeInlineStatisticsTypeStatusPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *QtreeInlineStatistics) validateStatus(formats strfmt.Registry) error {
	if swag.IsZero(m.Status) { // not required
		return nil
	}

	// value enum
	if err := m.validateStatusEnum("statistics"+"."+"status", "body", *m.Status); err != nil {
		return err
	}

	return nil
}

func (m *QtreeInlineStatistics) validateThroughputRaw(formats strfmt.Registry) error {
	if swag.IsZero(m.ThroughputRaw) { // not required
		return nil
	}

	if m.ThroughputRaw != nil {
		if err := m.ThroughputRaw.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "throughput_raw")
			}
			return err
		}
	}

	return nil
}

func (m *QtreeInlineStatistics) validateTimestamp(formats strfmt.Registry) error {
	if swag.IsZero(m.Timestamp) { // not required
		return nil
	}

	if err := validate.FormatOf("statistics"+"."+"timestamp", "body", "date-time", m.Timestamp.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this qtree inline statistics based on the context it is used
func (m *QtreeInlineStatistics) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateIopsRaw(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLatencyRaw(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStatus(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateThroughputRaw(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTimestamp(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *QtreeInlineStatistics) contextValidateIopsRaw(ctx context.Context, formats strfmt.Registry) error {

	if m.IopsRaw != nil {
		if err := m.IopsRaw.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "iops_raw")
			}
			return err
		}
	}

	return nil
}

func (m *QtreeInlineStatistics) contextValidateLatencyRaw(ctx context.Context, formats strfmt.Registry) error {

	if m.LatencyRaw != nil {
		if err := m.LatencyRaw.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "latency_raw")
			}
			return err
		}
	}

	return nil
}

func (m *QtreeInlineStatistics) contextValidateStatus(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "statistics"+"."+"status", "body", m.Status); err != nil {
		return err
	}

	return nil
}

func (m *QtreeInlineStatistics) contextValidateThroughputRaw(ctx context.Context, formats strfmt.Registry) error {

	if m.ThroughputRaw != nil {
		if err := m.ThroughputRaw.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "throughput_raw")
			}
			return err
		}
	}

	return nil
}

func (m *QtreeInlineStatistics) contextValidateTimestamp(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "statistics"+"."+"timestamp", "body", m.Timestamp); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *QtreeInlineStatistics) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *QtreeInlineStatistics) UnmarshalBinary(b []byte) error {
	var res QtreeInlineStatistics
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// QtreeInlineStatisticsInlineIopsRaw The number of I/O operations observed at the storage object. This should be used along with delta time to calculate the rate of I/O operations per unit of time.
//
// swagger:model qtree_inline_statistics_inline_iops_raw
type QtreeInlineStatisticsInlineIopsRaw struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this qtree inline statistics inline iops raw
func (m *QtreeInlineStatisticsInlineIopsRaw) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this qtree inline statistics inline iops raw based on the context it is used
func (m *QtreeInlineStatisticsInlineIopsRaw) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *QtreeInlineStatisticsInlineIopsRaw) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *QtreeInlineStatisticsInlineIopsRaw) UnmarshalBinary(b []byte) error {
	var res QtreeInlineStatisticsInlineIopsRaw
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// QtreeInlineStatisticsInlineLatencyRaw The raw latency observed at the storage object, in microseconds. This can be divided by the raw IOPS value to calculate the average latency per I/O operation.
//
// swagger:model qtree_inline_statistics_inline_latency_raw
type QtreeInlineStatisticsInlineLatencyRaw struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this qtree inline statistics inline latency raw
func (m *QtreeInlineStatisticsInlineLatencyRaw) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this qtree inline statistics inline latency raw based on the context it is used
func (m *QtreeInlineStatisticsInlineLatencyRaw) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *QtreeInlineStatisticsInlineLatencyRaw) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *QtreeInlineStatisticsInlineLatencyRaw) UnmarshalBinary(b []byte) error {
	var res QtreeInlineStatisticsInlineLatencyRaw
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// QtreeInlineStatisticsInlineThroughputRaw Throughput bytes observed at the storage object. This should be used along with delta time to calculate the rate of throughput bytes per unit of time.
//
// swagger:model qtree_inline_statistics_inline_throughput_raw
type QtreeInlineStatisticsInlineThroughputRaw struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this qtree inline statistics inline throughput raw
func (m *QtreeInlineStatisticsInlineThroughputRaw) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this qtree inline statistics inline throughput raw based on the context it is used
func (m *QtreeInlineStatisticsInlineThroughputRaw) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *QtreeInlineStatisticsInlineThroughputRaw) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *QtreeInlineStatisticsInlineThroughputRaw) UnmarshalBinary(b []byte) error {
	var res QtreeInlineStatisticsInlineThroughputRaw
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// QtreeInlineSvm Required in POST
//
// swagger:model qtree_inline_svm
type QtreeInlineSvm struct {

	// links
	Links *QtreeInlineSvmInlineLinks `json:"_links,omitempty"`

	// The name of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: svm1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: 02c9e252-41be-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this qtree inline svm
func (m *QtreeInlineSvm) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *QtreeInlineSvm) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this qtree inline svm based on the context it is used
func (m *QtreeInlineSvm) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *QtreeInlineSvm) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *QtreeInlineSvm) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *QtreeInlineSvm) UnmarshalBinary(b []byte) error {
	var res QtreeInlineSvm
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// QtreeInlineSvmInlineLinks qtree inline svm inline links
//
// swagger:model qtree_inline_svm_inline__links
type QtreeInlineSvmInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this qtree inline svm inline links
func (m *QtreeInlineSvmInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *QtreeInlineSvmInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this qtree inline svm inline links based on the context it is used
func (m *QtreeInlineSvmInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *QtreeInlineSvmInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *QtreeInlineSvmInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *QtreeInlineSvmInlineLinks) UnmarshalBinary(b []byte) error {
	var res QtreeInlineSvmInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// QtreeInlineUser The user set as owner of the qtree.
//
// swagger:model qtree_inline_user
type QtreeInlineUser struct {

	// The numeric ID of the user who owns the qtree. Valid in POST or PATCH.
	// Example: 10001
	ID *string `json:"id,omitempty"`

	// Alphanumeric username of user who owns the qtree. Valid in POST or PATCH.
	// Example: unix_user1
	Name *string `json:"name,omitempty"`
}

// Validate validates this qtree inline user
func (m *QtreeInlineUser) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this qtree inline user based on context it is used
func (m *QtreeInlineUser) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *QtreeInlineUser) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *QtreeInlineUser) UnmarshalBinary(b []byte) error {
	var res QtreeInlineUser
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// QtreeInlineVolume Required in POST
//
// swagger:model qtree_inline_volume
type QtreeInlineVolume struct {

	// links
	Links *QtreeInlineVolumeInlineLinks `json:"_links,omitempty"`

	// The name of the volume. This field cannot be specified in a PATCH method.
	// Example: volume1
	Name *string `json:"name,omitempty"`

	// Unique identifier for the volume. This corresponds to the instance-uuid that is exposed in the CLI and ONTAPI. It does not change due to a volume move.
	// Example: 028baa66-41bd-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this qtree inline volume
func (m *QtreeInlineVolume) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *QtreeInlineVolume) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("volume" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this qtree inline volume based on the context it is used
func (m *QtreeInlineVolume) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *QtreeInlineVolume) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("volume" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *QtreeInlineVolume) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *QtreeInlineVolume) UnmarshalBinary(b []byte) error {
	var res QtreeInlineVolume
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// QtreeInlineVolumeInlineLinks qtree inline volume inline links
//
// swagger:model qtree_inline_volume_inline__links
type QtreeInlineVolumeInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this qtree inline volume inline links
func (m *QtreeInlineVolumeInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *QtreeInlineVolumeInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("volume" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this qtree inline volume inline links based on the context it is used
func (m *QtreeInlineVolumeInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *QtreeInlineVolumeInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("volume" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *QtreeInlineVolumeInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *QtreeInlineVolumeInlineLinks) UnmarshalBinary(b []byte) error {
	var res QtreeInlineVolumeInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
