// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// QuotaReport quota report
//
// swagger:model quota_report
type QuotaReport struct {

	// links
	Links *QuotaReportInlineLinks `json:"_links,omitempty"`

	// files
	Files *QuotaReportInlineFiles `json:"files,omitempty"`

	// group
	Group *QuotaReportInlineGroup `json:"group,omitempty"`

	// Index that identifies a unique quota record. Valid in URL.
	// Read Only: true
	Index *int64 `json:"index,omitempty"`

	// qtree
	Qtree *QuotaReportInlineQtree `json:"qtree,omitempty"`

	// This parameter specifies the target user or users associated with the given quota report record. This parameter is available for user quota records and is not available for group or tree quota records. The target user or users are identified by a user name and user identifier. The user name can be a UNIX user name or a Windows user name, and the identifier can be a UNIX user identifier or a Windows security identifier.
	QuotaReportInlineUsers []*QuotaReportInlineUsersInlineArrayItem `json:"users,omitempty"`

	// space
	Space *QuotaReportInlineSpace `json:"space,omitempty"`

	// svm
	Svm *QuotaReportInlineSvm `json:"svm,omitempty"`

	// Quota type associated with the quota record.
	// Read Only: true
	// Enum: ["tree","user","group"]
	Type *string `json:"type,omitempty"`

	// volume
	Volume *QuotaReportInlineVolume `json:"volume,omitempty"`
}

// Validate validates this quota report
func (m *QuotaReport) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateFiles(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateGroup(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateQtree(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateQuotaReportInlineUsers(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSpace(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSvm(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateType(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateVolume(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *QuotaReport) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *QuotaReport) validateFiles(formats strfmt.Registry) error {
	if swag.IsZero(m.Files) { // not required
		return nil
	}

	if m.Files != nil {
		if err := m.Files.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("files")
			}
			return err
		}
	}

	return nil
}

func (m *QuotaReport) validateGroup(formats strfmt.Registry) error {
	if swag.IsZero(m.Group) { // not required
		return nil
	}

	if m.Group != nil {
		if err := m.Group.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("group")
			}
			return err
		}
	}

	return nil
}

func (m *QuotaReport) validateQtree(formats strfmt.Registry) error {
	if swag.IsZero(m.Qtree) { // not required
		return nil
	}

	if m.Qtree != nil {
		if err := m.Qtree.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qtree")
			}
			return err
		}
	}

	return nil
}

func (m *QuotaReport) validateQuotaReportInlineUsers(formats strfmt.Registry) error {
	if swag.IsZero(m.QuotaReportInlineUsers) { // not required
		return nil
	}

	for i := 0; i < len(m.QuotaReportInlineUsers); i++ {
		if swag.IsZero(m.QuotaReportInlineUsers[i]) { // not required
			continue
		}

		if m.QuotaReportInlineUsers[i] != nil {
			if err := m.QuotaReportInlineUsers[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("users" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *QuotaReport) validateSpace(formats strfmt.Registry) error {
	if swag.IsZero(m.Space) { // not required
		return nil
	}

	if m.Space != nil {
		if err := m.Space.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space")
			}
			return err
		}
	}

	return nil
}

func (m *QuotaReport) validateSvm(formats strfmt.Registry) error {
	if swag.IsZero(m.Svm) { // not required
		return nil
	}

	if m.Svm != nil {
		if err := m.Svm.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm")
			}
			return err
		}
	}

	return nil
}

var quotaReportTypeTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["tree","user","group"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		quotaReportTypeTypePropEnum = append(quotaReportTypeTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// quota_report
	// QuotaReport
	// type
	// Type
	// tree
	// END DEBUGGING
	// QuotaReportTypeTree captures enum value "tree"
	QuotaReportTypeTree string = "tree"

	// BEGIN DEBUGGING
	// quota_report
	// QuotaReport
	// type
	// Type
	// user
	// END DEBUGGING
	// QuotaReportTypeUser captures enum value "user"
	QuotaReportTypeUser string = "user"

	// BEGIN DEBUGGING
	// quota_report
	// QuotaReport
	// type
	// Type
	// group
	// END DEBUGGING
	// QuotaReportTypeGroup captures enum value "group"
	QuotaReportTypeGroup string = "group"
)

// prop value enum
func (m *QuotaReport) validateTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, quotaReportTypeTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *QuotaReport) validateType(formats strfmt.Registry) error {
	if swag.IsZero(m.Type) { // not required
		return nil
	}

	// value enum
	if err := m.validateTypeEnum("type", "body", *m.Type); err != nil {
		return err
	}

	return nil
}

func (m *QuotaReport) validateVolume(formats strfmt.Registry) error {
	if swag.IsZero(m.Volume) { // not required
		return nil
	}

	if m.Volume != nil {
		if err := m.Volume.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("volume")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this quota report based on the context it is used
func (m *QuotaReport) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateFiles(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateGroup(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIndex(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateQtree(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateQuotaReportInlineUsers(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSpace(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSvm(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateType(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateVolume(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *QuotaReport) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *QuotaReport) contextValidateFiles(ctx context.Context, formats strfmt.Registry) error {

	if m.Files != nil {
		if err := m.Files.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("files")
			}
			return err
		}
	}

	return nil
}

func (m *QuotaReport) contextValidateGroup(ctx context.Context, formats strfmt.Registry) error {

	if m.Group != nil {
		if err := m.Group.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("group")
			}
			return err
		}
	}

	return nil
}

func (m *QuotaReport) contextValidateIndex(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "index", "body", m.Index); err != nil {
		return err
	}

	return nil
}

func (m *QuotaReport) contextValidateQtree(ctx context.Context, formats strfmt.Registry) error {

	if m.Qtree != nil {
		if err := m.Qtree.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qtree")
			}
			return err
		}
	}

	return nil
}

func (m *QuotaReport) contextValidateQuotaReportInlineUsers(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.QuotaReportInlineUsers); i++ {

		if m.QuotaReportInlineUsers[i] != nil {
			if err := m.QuotaReportInlineUsers[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("users" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *QuotaReport) contextValidateSpace(ctx context.Context, formats strfmt.Registry) error {

	if m.Space != nil {
		if err := m.Space.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space")
			}
			return err
		}
	}

	return nil
}

func (m *QuotaReport) contextValidateSvm(ctx context.Context, formats strfmt.Registry) error {

	if m.Svm != nil {
		if err := m.Svm.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm")
			}
			return err
		}
	}

	return nil
}

func (m *QuotaReport) contextValidateType(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "type", "body", m.Type); err != nil {
		return err
	}

	return nil
}

func (m *QuotaReport) contextValidateVolume(ctx context.Context, formats strfmt.Registry) error {

	if m.Volume != nil {
		if err := m.Volume.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("volume")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *QuotaReport) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *QuotaReport) UnmarshalBinary(b []byte) error {
	var res QuotaReport
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// QuotaReportInlineFiles quota report inline files
//
// swagger:model quota_report_inline_files
type QuotaReportInlineFiles struct {

	// File hard limit
	// Read Only: true
	HardLimit *int64 `json:"hard_limit,omitempty"`

	// File soft limit
	// Read Only: true
	SoftLimit *int64 `json:"soft_limit,omitempty"`

	// used
	Used *QuotaReportInlineFilesInlineUsed `json:"used,omitempty"`
}

// Validate validates this quota report inline files
func (m *QuotaReportInlineFiles) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateUsed(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *QuotaReportInlineFiles) validateUsed(formats strfmt.Registry) error {
	if swag.IsZero(m.Used) { // not required
		return nil
	}

	if m.Used != nil {
		if err := m.Used.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("files" + "." + "used")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this quota report inline files based on the context it is used
func (m *QuotaReportInlineFiles) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateHardLimit(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSoftLimit(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUsed(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *QuotaReportInlineFiles) contextValidateHardLimit(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "files"+"."+"hard_limit", "body", m.HardLimit); err != nil {
		return err
	}

	return nil
}

func (m *QuotaReportInlineFiles) contextValidateSoftLimit(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "files"+"."+"soft_limit", "body", m.SoftLimit); err != nil {
		return err
	}

	return nil
}

func (m *QuotaReportInlineFiles) contextValidateUsed(ctx context.Context, formats strfmt.Registry) error {

	if m.Used != nil {
		if err := m.Used.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("files" + "." + "used")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *QuotaReportInlineFiles) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *QuotaReportInlineFiles) UnmarshalBinary(b []byte) error {
	var res QuotaReportInlineFiles
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// QuotaReportInlineFilesInlineUsed quota report inline files inline used
//
// swagger:model quota_report_inline_files_inline_used
type QuotaReportInlineFilesInlineUsed struct {

	// Total files used as a percentage of file hard limit
	// Read Only: true
	HardLimitPercent *int64 `json:"hard_limit_percent,omitempty"`

	// Total files used as a percentage of file soft limit
	// Read Only: true
	SoftLimitPercent *int64 `json:"soft_limit_percent,omitempty"`

	// Total files used
	// Read Only: true
	Total *int64 `json:"total,omitempty"`
}

// Validate validates this quota report inline files inline used
func (m *QuotaReportInlineFilesInlineUsed) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this quota report inline files inline used based on the context it is used
func (m *QuotaReportInlineFilesInlineUsed) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateHardLimitPercent(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSoftLimitPercent(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTotal(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *QuotaReportInlineFilesInlineUsed) contextValidateHardLimitPercent(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "files"+"."+"used"+"."+"hard_limit_percent", "body", m.HardLimitPercent); err != nil {
		return err
	}

	return nil
}

func (m *QuotaReportInlineFilesInlineUsed) contextValidateSoftLimitPercent(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "files"+"."+"used"+"."+"soft_limit_percent", "body", m.SoftLimitPercent); err != nil {
		return err
	}

	return nil
}

func (m *QuotaReportInlineFilesInlineUsed) contextValidateTotal(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "files"+"."+"used"+"."+"total", "body", m.Total); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *QuotaReportInlineFilesInlineUsed) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *QuotaReportInlineFilesInlineUsed) UnmarshalBinary(b []byte) error {
	var res QuotaReportInlineFilesInlineUsed
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// QuotaReportInlineGroup This parameter specifies the target group associated with the given quota report record. This parameter is available for group quota records and is not available for user or tree quota records. The target group is identified by a UNIX group name and UNIX group identifier.
//
// swagger:model quota_report_inline_group
type QuotaReportInlineGroup struct {

	// Quota target group ID
	// Read Only: true
	ID *string `json:"id,omitempty"`

	// Quota target group name
	// Read Only: true
	Name *string `json:"name,omitempty"`
}

// Validate validates this quota report inline group
func (m *QuotaReportInlineGroup) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this quota report inline group based on the context it is used
func (m *QuotaReportInlineGroup) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateName(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *QuotaReportInlineGroup) contextValidateID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "group"+"."+"id", "body", m.ID); err != nil {
		return err
	}

	return nil
}

func (m *QuotaReportInlineGroup) contextValidateName(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "group"+"."+"name", "body", m.Name); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *QuotaReportInlineGroup) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *QuotaReportInlineGroup) UnmarshalBinary(b []byte) error {
	var res QuotaReportInlineGroup
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// QuotaReportInlineLinks quota report inline links
//
// swagger:model quota_report_inline__links
type QuotaReportInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this quota report inline links
func (m *QuotaReportInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *QuotaReportInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this quota report inline links based on the context it is used
func (m *QuotaReportInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *QuotaReportInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *QuotaReportInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *QuotaReportInlineLinks) UnmarshalBinary(b []byte) error {
	var res QuotaReportInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// QuotaReportInlineQtree This parameter specifies the target qtree associated with the user, group, or tree record. For a user/group quota policy rule at volume level, this parameter is not valid. For a default tree quota policy rule, this parameter is specified as "" or "*". For a tree quota policy rule at qtree level, this parameter specifies a qtree name and a qtree identifier.
//
// swagger:model quota_report_inline_qtree
type QuotaReportInlineQtree struct {

	// links
	Links *QuotaReportInlineQtreeInlineLinks `json:"_links,omitempty"`

	// The unique identifier for a qtree.
	// Example: 1
	ID *int64 `json:"id,omitempty"`

	// The name of the qtree.
	// Example: qt1
	Name *string `json:"name,omitempty"`
}

// Validate validates this quota report inline qtree
func (m *QuotaReportInlineQtree) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *QuotaReportInlineQtree) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qtree" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this quota report inline qtree based on the context it is used
func (m *QuotaReportInlineQtree) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *QuotaReportInlineQtree) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qtree" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *QuotaReportInlineQtree) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *QuotaReportInlineQtree) UnmarshalBinary(b []byte) error {
	var res QuotaReportInlineQtree
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// QuotaReportInlineQtreeInlineLinks quota report inline qtree inline links
//
// swagger:model quota_report_inline_qtree_inline__links
type QuotaReportInlineQtreeInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this quota report inline qtree inline links
func (m *QuotaReportInlineQtreeInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *QuotaReportInlineQtreeInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qtree" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this quota report inline qtree inline links based on the context it is used
func (m *QuotaReportInlineQtreeInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *QuotaReportInlineQtreeInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qtree" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *QuotaReportInlineQtreeInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *QuotaReportInlineQtreeInlineLinks) UnmarshalBinary(b []byte) error {
	var res QuotaReportInlineQtreeInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// QuotaReportInlineSpace quota report inline space
//
// swagger:model quota_report_inline_space
type QuotaReportInlineSpace struct {

	// Space hard limit in bytes
	// Read Only: true
	HardLimit *int64 `json:"hard_limit,omitempty"`

	// Space soft limit in bytes
	// Read Only: true
	SoftLimit *int64 `json:"soft_limit,omitempty"`

	// used
	Used *QuotaReportInlineSpaceInlineUsed `json:"used,omitempty"`
}

// Validate validates this quota report inline space
func (m *QuotaReportInlineSpace) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateUsed(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *QuotaReportInlineSpace) validateUsed(formats strfmt.Registry) error {
	if swag.IsZero(m.Used) { // not required
		return nil
	}

	if m.Used != nil {
		if err := m.Used.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space" + "." + "used")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this quota report inline space based on the context it is used
func (m *QuotaReportInlineSpace) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateHardLimit(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSoftLimit(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUsed(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *QuotaReportInlineSpace) contextValidateHardLimit(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"hard_limit", "body", m.HardLimit); err != nil {
		return err
	}

	return nil
}

func (m *QuotaReportInlineSpace) contextValidateSoftLimit(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"soft_limit", "body", m.SoftLimit); err != nil {
		return err
	}

	return nil
}

func (m *QuotaReportInlineSpace) contextValidateUsed(ctx context.Context, formats strfmt.Registry) error {

	if m.Used != nil {
		if err := m.Used.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space" + "." + "used")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *QuotaReportInlineSpace) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *QuotaReportInlineSpace) UnmarshalBinary(b []byte) error {
	var res QuotaReportInlineSpace
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// QuotaReportInlineSpaceInlineUsed quota report inline space inline used
//
// swagger:model quota_report_inline_space_inline_used
type QuotaReportInlineSpaceInlineUsed struct {

	// Total space used as a percentage of space hard limit
	// Read Only: true
	HardLimitPercent *int64 `json:"hard_limit_percent,omitempty"`

	// Total space used as a percentage of space soft limit
	// Read Only: true
	SoftLimitPercent *int64 `json:"soft_limit_percent,omitempty"`

	// Total space used
	// Read Only: true
	Total *int64 `json:"total,omitempty"`
}

// Validate validates this quota report inline space inline used
func (m *QuotaReportInlineSpaceInlineUsed) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this quota report inline space inline used based on the context it is used
func (m *QuotaReportInlineSpaceInlineUsed) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateHardLimitPercent(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSoftLimitPercent(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTotal(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *QuotaReportInlineSpaceInlineUsed) contextValidateHardLimitPercent(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"used"+"."+"hard_limit_percent", "body", m.HardLimitPercent); err != nil {
		return err
	}

	return nil
}

func (m *QuotaReportInlineSpaceInlineUsed) contextValidateSoftLimitPercent(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"used"+"."+"soft_limit_percent", "body", m.SoftLimitPercent); err != nil {
		return err
	}

	return nil
}

func (m *QuotaReportInlineSpaceInlineUsed) contextValidateTotal(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"used"+"."+"total", "body", m.Total); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *QuotaReportInlineSpaceInlineUsed) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *QuotaReportInlineSpaceInlineUsed) UnmarshalBinary(b []byte) error {
	var res QuotaReportInlineSpaceInlineUsed
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// QuotaReportInlineSvm SVM, applies only to SVM-scoped objects.
//
// swagger:model quota_report_inline_svm
type QuotaReportInlineSvm struct {

	// links
	Links *QuotaReportInlineSvmInlineLinks `json:"_links,omitempty"`

	// The name of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: svm1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: 02c9e252-41be-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this quota report inline svm
func (m *QuotaReportInlineSvm) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *QuotaReportInlineSvm) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this quota report inline svm based on the context it is used
func (m *QuotaReportInlineSvm) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *QuotaReportInlineSvm) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *QuotaReportInlineSvm) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *QuotaReportInlineSvm) UnmarshalBinary(b []byte) error {
	var res QuotaReportInlineSvm
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// QuotaReportInlineSvmInlineLinks quota report inline svm inline links
//
// swagger:model quota_report_inline_svm_inline__links
type QuotaReportInlineSvmInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this quota report inline svm inline links
func (m *QuotaReportInlineSvmInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *QuotaReportInlineSvmInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this quota report inline svm inline links based on the context it is used
func (m *QuotaReportInlineSvmInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *QuotaReportInlineSvmInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *QuotaReportInlineSvmInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *QuotaReportInlineSvmInlineLinks) UnmarshalBinary(b []byte) error {
	var res QuotaReportInlineSvmInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// QuotaReportInlineUsersInlineArrayItem quota report inline users inline array item
//
// swagger:model quota_report_inline_users_inline_array_item
type QuotaReportInlineUsersInlineArrayItem struct {

	// Quota target user ID
	// Read Only: true
	ID *string `json:"id,omitempty"`

	// Quota target user name
	// Read Only: true
	Name *string `json:"name,omitempty"`
}

// Validate validates this quota report inline users inline array item
func (m *QuotaReportInlineUsersInlineArrayItem) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this quota report inline users inline array item based on the context it is used
func (m *QuotaReportInlineUsersInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateName(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *QuotaReportInlineUsersInlineArrayItem) contextValidateID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "id", "body", m.ID); err != nil {
		return err
	}

	return nil
}

func (m *QuotaReportInlineUsersInlineArrayItem) contextValidateName(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "name", "body", m.Name); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *QuotaReportInlineUsersInlineArrayItem) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *QuotaReportInlineUsersInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res QuotaReportInlineUsersInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// QuotaReportInlineVolume quota report inline volume
//
// swagger:model quota_report_inline_volume
type QuotaReportInlineVolume struct {

	// links
	Links *QuotaReportInlineVolumeInlineLinks `json:"_links,omitempty"`

	// The name of the volume. This field cannot be specified in a PATCH method.
	// Example: volume1
	Name *string `json:"name,omitempty"`

	// Unique identifier for the volume. This corresponds to the instance-uuid that is exposed in the CLI and ONTAPI. It does not change due to a volume move.
	// Example: 028baa66-41bd-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this quota report inline volume
func (m *QuotaReportInlineVolume) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *QuotaReportInlineVolume) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("volume" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this quota report inline volume based on the context it is used
func (m *QuotaReportInlineVolume) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *QuotaReportInlineVolume) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("volume" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *QuotaReportInlineVolume) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *QuotaReportInlineVolume) UnmarshalBinary(b []byte) error {
	var res QuotaReportInlineVolume
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// QuotaReportInlineVolumeInlineLinks quota report inline volume inline links
//
// swagger:model quota_report_inline_volume_inline__links
type QuotaReportInlineVolumeInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this quota report inline volume inline links
func (m *QuotaReportInlineVolumeInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *QuotaReportInlineVolumeInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("volume" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this quota report inline volume inline links based on the context it is used
func (m *QuotaReportInlineVolumeInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *QuotaReportInlineVolumeInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("volume" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *QuotaReportInlineVolumeInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *QuotaReportInlineVolumeInlineLinks) UnmarshalBinary(b []byte) error {
	var res QuotaReportInlineVolumeInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
