// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// RaidGroup raid group
//
// swagger:model raid_group
type RaidGroup struct {

	// RAID group is a cache tier
	// Read Only: true
	CacheTier *bool `json:"cache_tier,omitempty"`

	// RAID group is degraded. A RAID group is degraded when at least one disk from that group has failed or is offline.
	// Read Only: true
	Degraded *bool `json:"degraded,omitempty"`

	// RAID group name
	// Example: rg0
	// Read Only: true
	Name *string `json:"name,omitempty"`

	// raid group inline disks
	// Read Only: true
	RaidGroupInlineDisks []*RaidGroupDisk `json:"disks,omitempty"`

	// RAID type of the raid group.
	// Example: raid_dp
	// Read Only: true
	// Enum: ["raid_dp","raid_tec","raid0","raid4"]
	RaidType *string `json:"raid_type,omitempty"`

	// recomputing parity
	RecomputingParity *RaidGroupInlineRecomputingParity `json:"recomputing_parity,omitempty"`

	// reconstruct
	Reconstruct *RaidGroupInlineReconstruct `json:"reconstruct,omitempty"`
}

// Validate validates this raid group
func (m *RaidGroup) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateRaidGroupInlineDisks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateRaidType(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateRecomputingParity(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateReconstruct(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *RaidGroup) validateRaidGroupInlineDisks(formats strfmt.Registry) error {
	if swag.IsZero(m.RaidGroupInlineDisks) { // not required
		return nil
	}

	for i := 0; i < len(m.RaidGroupInlineDisks); i++ {
		if swag.IsZero(m.RaidGroupInlineDisks[i]) { // not required
			continue
		}

		if m.RaidGroupInlineDisks[i] != nil {
			if err := m.RaidGroupInlineDisks[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("disks" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

var raidGroupTypeRaidTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["raid_dp","raid_tec","raid0","raid4"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		raidGroupTypeRaidTypePropEnum = append(raidGroupTypeRaidTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// raid_group
	// RaidGroup
	// raid_type
	// RaidType
	// raid_dp
	// END DEBUGGING
	// RaidGroupRaidTypeRaidDp captures enum value "raid_dp"
	RaidGroupRaidTypeRaidDp string = "raid_dp"

	// BEGIN DEBUGGING
	// raid_group
	// RaidGroup
	// raid_type
	// RaidType
	// raid_tec
	// END DEBUGGING
	// RaidGroupRaidTypeRaidTec captures enum value "raid_tec"
	RaidGroupRaidTypeRaidTec string = "raid_tec"

	// BEGIN DEBUGGING
	// raid_group
	// RaidGroup
	// raid_type
	// RaidType
	// raid0
	// END DEBUGGING
	// RaidGroupRaidTypeRaid0 captures enum value "raid0"
	RaidGroupRaidTypeRaid0 string = "raid0"

	// BEGIN DEBUGGING
	// raid_group
	// RaidGroup
	// raid_type
	// RaidType
	// raid4
	// END DEBUGGING
	// RaidGroupRaidTypeRaid4 captures enum value "raid4"
	RaidGroupRaidTypeRaid4 string = "raid4"
)

// prop value enum
func (m *RaidGroup) validateRaidTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, raidGroupTypeRaidTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *RaidGroup) validateRaidType(formats strfmt.Registry) error {
	if swag.IsZero(m.RaidType) { // not required
		return nil
	}

	// value enum
	if err := m.validateRaidTypeEnum("raid_type", "body", *m.RaidType); err != nil {
		return err
	}

	return nil
}

func (m *RaidGroup) validateRecomputingParity(formats strfmt.Registry) error {
	if swag.IsZero(m.RecomputingParity) { // not required
		return nil
	}

	if m.RecomputingParity != nil {
		if err := m.RecomputingParity.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("recomputing_parity")
			}
			return err
		}
	}

	return nil
}

func (m *RaidGroup) validateReconstruct(formats strfmt.Registry) error {
	if swag.IsZero(m.Reconstruct) { // not required
		return nil
	}

	if m.Reconstruct != nil {
		if err := m.Reconstruct.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("reconstruct")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this raid group based on the context it is used
func (m *RaidGroup) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateCacheTier(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDegraded(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateName(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateRaidGroupInlineDisks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateRaidType(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateRecomputingParity(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateReconstruct(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *RaidGroup) contextValidateCacheTier(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "cache_tier", "body", m.CacheTier); err != nil {
		return err
	}

	return nil
}

func (m *RaidGroup) contextValidateDegraded(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "degraded", "body", m.Degraded); err != nil {
		return err
	}

	return nil
}

func (m *RaidGroup) contextValidateName(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "name", "body", m.Name); err != nil {
		return err
	}

	return nil
}

func (m *RaidGroup) contextValidateRaidGroupInlineDisks(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "disks", "body", []*RaidGroupDisk(m.RaidGroupInlineDisks)); err != nil {
		return err
	}

	for i := 0; i < len(m.RaidGroupInlineDisks); i++ {

		if m.RaidGroupInlineDisks[i] != nil {
			if err := m.RaidGroupInlineDisks[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("disks" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *RaidGroup) contextValidateRaidType(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "raid_type", "body", m.RaidType); err != nil {
		return err
	}

	return nil
}

func (m *RaidGroup) contextValidateRecomputingParity(ctx context.Context, formats strfmt.Registry) error {

	if m.RecomputingParity != nil {
		if err := m.RecomputingParity.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("recomputing_parity")
			}
			return err
		}
	}

	return nil
}

func (m *RaidGroup) contextValidateReconstruct(ctx context.Context, formats strfmt.Registry) error {

	if m.Reconstruct != nil {
		if err := m.Reconstruct.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("reconstruct")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *RaidGroup) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *RaidGroup) UnmarshalBinary(b []byte) error {
	var res RaidGroup
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// RaidGroupInlineRecomputingParity raid group inline recomputing parity
//
// swagger:model raid_group_inline_recomputing_parity
type RaidGroupInlineRecomputingParity struct {

	// RAID group is recomputing parity
	// Read Only: true
	Active *bool `json:"active,omitempty"`

	// Recomputing parity percentage
	// Example: 10
	// Read Only: true
	Percent *int64 `json:"percent,omitempty"`
}

// Validate validates this raid group inline recomputing parity
func (m *RaidGroupInlineRecomputingParity) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this raid group inline recomputing parity based on the context it is used
func (m *RaidGroupInlineRecomputingParity) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateActive(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidatePercent(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *RaidGroupInlineRecomputingParity) contextValidateActive(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "recomputing_parity"+"."+"active", "body", m.Active); err != nil {
		return err
	}

	return nil
}

func (m *RaidGroupInlineRecomputingParity) contextValidatePercent(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "recomputing_parity"+"."+"percent", "body", m.Percent); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *RaidGroupInlineRecomputingParity) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *RaidGroupInlineRecomputingParity) UnmarshalBinary(b []byte) error {
	var res RaidGroupInlineRecomputingParity
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// RaidGroupInlineReconstruct raid group inline reconstruct
//
// swagger:model raid_group_inline_reconstruct
type RaidGroupInlineReconstruct struct {

	// One or more disks in this RAID group are being reconstructed.
	// Read Only: true
	Active *bool `json:"active,omitempty"`

	// Reconstruct percentage
	// Example: 10
	// Read Only: true
	Percent *int64 `json:"percent,omitempty"`
}

// Validate validates this raid group inline reconstruct
func (m *RaidGroupInlineReconstruct) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this raid group inline reconstruct based on the context it is used
func (m *RaidGroupInlineReconstruct) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateActive(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidatePercent(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *RaidGroupInlineReconstruct) contextValidateActive(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "reconstruct"+"."+"active", "body", m.Active); err != nil {
		return err
	}

	return nil
}

func (m *RaidGroupInlineReconstruct) contextValidatePercent(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "reconstruct"+"."+"percent", "body", m.Percent); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *RaidGroupInlineReconstruct) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *RaidGroupInlineReconstruct) UnmarshalBinary(b []byte) error {
	var res RaidGroupInlineReconstruct
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
