// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// RaidGroupDisk raid group disk
//
// swagger:model raid_group_disk
type RaidGroupDisk struct {

	// disk
	Disk *RaidGroupDiskInlineDisk `json:"disk,omitempty"`

	// The position of the disk within the RAID group.
	// Read Only: true
	// Enum: ["data","parity","dparity","tparity","copy"]
	Position *string `json:"position,omitempty"`

	// The state of the disk within the RAID group.
	// Read Only: true
	// Enum: ["normal","failed","zeroing","copy","replacing","evacuating","prefail","offline","reconstructing"]
	State *string `json:"state,omitempty"`

	// Disk interface type
	// Example: ssd
	// Read Only: true
	// Enum: ["ata","bsas","fcal","fsas","lun","sas","msata","ssd","vmdisk","unknown","ssd_cap","ssd_nvm","ssd_zns"]
	Type *string `json:"type,omitempty"`

	// Size in bytes that is usable by the aggregate.
	// Example: 947912704
	// Read Only: true
	UsableSize *int64 `json:"usable_size,omitempty"`
}

// Validate validates this raid group disk
func (m *RaidGroupDisk) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateDisk(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePosition(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateType(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *RaidGroupDisk) validateDisk(formats strfmt.Registry) error {
	if swag.IsZero(m.Disk) { // not required
		return nil
	}

	if m.Disk != nil {
		if err := m.Disk.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("disk")
			}
			return err
		}
	}

	return nil
}

var raidGroupDiskTypePositionPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["data","parity","dparity","tparity","copy"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		raidGroupDiskTypePositionPropEnum = append(raidGroupDiskTypePositionPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// raid_group_disk
	// RaidGroupDisk
	// position
	// Position
	// data
	// END DEBUGGING
	// RaidGroupDiskPositionData captures enum value "data"
	RaidGroupDiskPositionData string = "data"

	// BEGIN DEBUGGING
	// raid_group_disk
	// RaidGroupDisk
	// position
	// Position
	// parity
	// END DEBUGGING
	// RaidGroupDiskPositionParity captures enum value "parity"
	RaidGroupDiskPositionParity string = "parity"

	// BEGIN DEBUGGING
	// raid_group_disk
	// RaidGroupDisk
	// position
	// Position
	// dparity
	// END DEBUGGING
	// RaidGroupDiskPositionDparity captures enum value "dparity"
	RaidGroupDiskPositionDparity string = "dparity"

	// BEGIN DEBUGGING
	// raid_group_disk
	// RaidGroupDisk
	// position
	// Position
	// tparity
	// END DEBUGGING
	// RaidGroupDiskPositionTparity captures enum value "tparity"
	RaidGroupDiskPositionTparity string = "tparity"

	// BEGIN DEBUGGING
	// raid_group_disk
	// RaidGroupDisk
	// position
	// Position
	// copy
	// END DEBUGGING
	// RaidGroupDiskPositionCopy captures enum value "copy"
	RaidGroupDiskPositionCopy string = "copy"
)

// prop value enum
func (m *RaidGroupDisk) validatePositionEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, raidGroupDiskTypePositionPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *RaidGroupDisk) validatePosition(formats strfmt.Registry) error {
	if swag.IsZero(m.Position) { // not required
		return nil
	}

	// value enum
	if err := m.validatePositionEnum("position", "body", *m.Position); err != nil {
		return err
	}

	return nil
}

var raidGroupDiskTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["normal","failed","zeroing","copy","replacing","evacuating","prefail","offline","reconstructing"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		raidGroupDiskTypeStatePropEnum = append(raidGroupDiskTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// raid_group_disk
	// RaidGroupDisk
	// state
	// State
	// normal
	// END DEBUGGING
	// RaidGroupDiskStateNormal captures enum value "normal"
	RaidGroupDiskStateNormal string = "normal"

	// BEGIN DEBUGGING
	// raid_group_disk
	// RaidGroupDisk
	// state
	// State
	// failed
	// END DEBUGGING
	// RaidGroupDiskStateFailed captures enum value "failed"
	RaidGroupDiskStateFailed string = "failed"

	// BEGIN DEBUGGING
	// raid_group_disk
	// RaidGroupDisk
	// state
	// State
	// zeroing
	// END DEBUGGING
	// RaidGroupDiskStateZeroing captures enum value "zeroing"
	RaidGroupDiskStateZeroing string = "zeroing"

	// BEGIN DEBUGGING
	// raid_group_disk
	// RaidGroupDisk
	// state
	// State
	// copy
	// END DEBUGGING
	// RaidGroupDiskStateCopy captures enum value "copy"
	RaidGroupDiskStateCopy string = "copy"

	// BEGIN DEBUGGING
	// raid_group_disk
	// RaidGroupDisk
	// state
	// State
	// replacing
	// END DEBUGGING
	// RaidGroupDiskStateReplacing captures enum value "replacing"
	RaidGroupDiskStateReplacing string = "replacing"

	// BEGIN DEBUGGING
	// raid_group_disk
	// RaidGroupDisk
	// state
	// State
	// evacuating
	// END DEBUGGING
	// RaidGroupDiskStateEvacuating captures enum value "evacuating"
	RaidGroupDiskStateEvacuating string = "evacuating"

	// BEGIN DEBUGGING
	// raid_group_disk
	// RaidGroupDisk
	// state
	// State
	// prefail
	// END DEBUGGING
	// RaidGroupDiskStatePrefail captures enum value "prefail"
	RaidGroupDiskStatePrefail string = "prefail"

	// BEGIN DEBUGGING
	// raid_group_disk
	// RaidGroupDisk
	// state
	// State
	// offline
	// END DEBUGGING
	// RaidGroupDiskStateOffline captures enum value "offline"
	RaidGroupDiskStateOffline string = "offline"

	// BEGIN DEBUGGING
	// raid_group_disk
	// RaidGroupDisk
	// state
	// State
	// reconstructing
	// END DEBUGGING
	// RaidGroupDiskStateReconstructing captures enum value "reconstructing"
	RaidGroupDiskStateReconstructing string = "reconstructing"
)

// prop value enum
func (m *RaidGroupDisk) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, raidGroupDiskTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *RaidGroupDisk) validateState(formats strfmt.Registry) error {
	if swag.IsZero(m.State) { // not required
		return nil
	}

	// value enum
	if err := m.validateStateEnum("state", "body", *m.State); err != nil {
		return err
	}

	return nil
}

var raidGroupDiskTypeTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ata","bsas","fcal","fsas","lun","sas","msata","ssd","vmdisk","unknown","ssd_cap","ssd_nvm","ssd_zns"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		raidGroupDiskTypeTypePropEnum = append(raidGroupDiskTypeTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// raid_group_disk
	// RaidGroupDisk
	// type
	// Type
	// ata
	// END DEBUGGING
	// RaidGroupDiskTypeAta captures enum value "ata"
	RaidGroupDiskTypeAta string = "ata"

	// BEGIN DEBUGGING
	// raid_group_disk
	// RaidGroupDisk
	// type
	// Type
	// bsas
	// END DEBUGGING
	// RaidGroupDiskTypeBsas captures enum value "bsas"
	RaidGroupDiskTypeBsas string = "bsas"

	// BEGIN DEBUGGING
	// raid_group_disk
	// RaidGroupDisk
	// type
	// Type
	// fcal
	// END DEBUGGING
	// RaidGroupDiskTypeFcal captures enum value "fcal"
	RaidGroupDiskTypeFcal string = "fcal"

	// BEGIN DEBUGGING
	// raid_group_disk
	// RaidGroupDisk
	// type
	// Type
	// fsas
	// END DEBUGGING
	// RaidGroupDiskTypeFsas captures enum value "fsas"
	RaidGroupDiskTypeFsas string = "fsas"

	// BEGIN DEBUGGING
	// raid_group_disk
	// RaidGroupDisk
	// type
	// Type
	// lun
	// END DEBUGGING
	// RaidGroupDiskTypeLun captures enum value "lun"
	RaidGroupDiskTypeLun string = "lun"

	// BEGIN DEBUGGING
	// raid_group_disk
	// RaidGroupDisk
	// type
	// Type
	// sas
	// END DEBUGGING
	// RaidGroupDiskTypeSas captures enum value "sas"
	RaidGroupDiskTypeSas string = "sas"

	// BEGIN DEBUGGING
	// raid_group_disk
	// RaidGroupDisk
	// type
	// Type
	// msata
	// END DEBUGGING
	// RaidGroupDiskTypeMsata captures enum value "msata"
	RaidGroupDiskTypeMsata string = "msata"

	// BEGIN DEBUGGING
	// raid_group_disk
	// RaidGroupDisk
	// type
	// Type
	// ssd
	// END DEBUGGING
	// RaidGroupDiskTypeSsd captures enum value "ssd"
	RaidGroupDiskTypeSsd string = "ssd"

	// BEGIN DEBUGGING
	// raid_group_disk
	// RaidGroupDisk
	// type
	// Type
	// vmdisk
	// END DEBUGGING
	// RaidGroupDiskTypeVmdisk captures enum value "vmdisk"
	RaidGroupDiskTypeVmdisk string = "vmdisk"

	// BEGIN DEBUGGING
	// raid_group_disk
	// RaidGroupDisk
	// type
	// Type
	// unknown
	// END DEBUGGING
	// RaidGroupDiskTypeUnknown captures enum value "unknown"
	RaidGroupDiskTypeUnknown string = "unknown"

	// BEGIN DEBUGGING
	// raid_group_disk
	// RaidGroupDisk
	// type
	// Type
	// ssd_cap
	// END DEBUGGING
	// RaidGroupDiskTypeSsdCap captures enum value "ssd_cap"
	RaidGroupDiskTypeSsdCap string = "ssd_cap"

	// BEGIN DEBUGGING
	// raid_group_disk
	// RaidGroupDisk
	// type
	// Type
	// ssd_nvm
	// END DEBUGGING
	// RaidGroupDiskTypeSsdNvm captures enum value "ssd_nvm"
	RaidGroupDiskTypeSsdNvm string = "ssd_nvm"

	// BEGIN DEBUGGING
	// raid_group_disk
	// RaidGroupDisk
	// type
	// Type
	// ssd_zns
	// END DEBUGGING
	// RaidGroupDiskTypeSsdZns captures enum value "ssd_zns"
	RaidGroupDiskTypeSsdZns string = "ssd_zns"
)

// prop value enum
func (m *RaidGroupDisk) validateTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, raidGroupDiskTypeTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *RaidGroupDisk) validateType(formats strfmt.Registry) error {
	if swag.IsZero(m.Type) { // not required
		return nil
	}

	// value enum
	if err := m.validateTypeEnum("type", "body", *m.Type); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this raid group disk based on the context it is used
func (m *RaidGroupDisk) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateDisk(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidatePosition(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateType(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUsableSize(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *RaidGroupDisk) contextValidateDisk(ctx context.Context, formats strfmt.Registry) error {

	if m.Disk != nil {
		if err := m.Disk.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("disk")
			}
			return err
		}
	}

	return nil
}

func (m *RaidGroupDisk) contextValidatePosition(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "position", "body", m.Position); err != nil {
		return err
	}

	return nil
}

func (m *RaidGroupDisk) contextValidateState(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "state", "body", m.State); err != nil {
		return err
	}

	return nil
}

func (m *RaidGroupDisk) contextValidateType(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "type", "body", m.Type); err != nil {
		return err
	}

	return nil
}

func (m *RaidGroupDisk) contextValidateUsableSize(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "usable_size", "body", m.UsableSize); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *RaidGroupDisk) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *RaidGroupDisk) UnmarshalBinary(b []byte) error {
	var res RaidGroupDisk
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// RaidGroupDiskInlineDisk Disk
//
// swagger:model raid_group_disk_inline_disk
type RaidGroupDiskInlineDisk struct {

	// links
	Links *RaidGroupDiskInlineDiskInlineLinks `json:"_links,omitempty"`

	// name
	// Example: 1.0.1
	Name *string `json:"name,omitempty"`
}

// Validate validates this raid group disk inline disk
func (m *RaidGroupDiskInlineDisk) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *RaidGroupDiskInlineDisk) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("disk" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this raid group disk inline disk based on the context it is used
func (m *RaidGroupDiskInlineDisk) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *RaidGroupDiskInlineDisk) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("disk" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *RaidGroupDiskInlineDisk) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *RaidGroupDiskInlineDisk) UnmarshalBinary(b []byte) error {
	var res RaidGroupDiskInlineDisk
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// RaidGroupDiskInlineDiskInlineLinks raid group disk inline disk inline links
//
// swagger:model raid_group_disk_inline_disk_inline__links
type RaidGroupDiskInlineDiskInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this raid group disk inline disk inline links
func (m *RaidGroupDiskInlineDiskInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *RaidGroupDiskInlineDiskInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("disk" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this raid group disk inline disk inline links based on the context it is used
func (m *RaidGroupDiskInlineDiskInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *RaidGroupDiskInlineDiskInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("disk" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *RaidGroupDiskInlineDiskInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *RaidGroupDiskInlineDiskInlineLinks) UnmarshalBinary(b []byte) error {
	var res RaidGroupDiskInlineDiskInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
