// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// RecentWorkspacesArrayInline Workspace details aggregations.
//
// swagger:model recent_workspaces_array_inline
type RecentWorkspacesArrayInline []*RecentWorkspacesArrayInlineInlineArrayItem

// Validate validates this recent workspaces array inline
func (m RecentWorkspacesArrayInline) Validate(formats strfmt.Registry) error {
	var res []error

	for i := 0; i < len(m); i++ {
		if swag.IsZero(m[i]) { // not required
			continue
		}

		if m[i] != nil {
			if err := m[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName(strconv.Itoa(i))
				}
				return err
			}
		}

	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// ContextValidate validate this recent workspaces array inline based on the context it is used
func (m RecentWorkspacesArrayInline) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	for i := 0; i < len(m); i++ {

		if m[i] != nil {
			if err := m[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName(strconv.Itoa(i))
				}
				return err
			}
		}

	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// RecentWorkspacesArrayInlineInlineArrayItem recent workspaces array inline inline array item
//
// swagger:model recent_workspaces_array_inline_inline_array_item
type RecentWorkspacesArrayInlineInlineArrayItem struct {

	// Number of data collections in the workspace.
	// Example: 3
	DataCollectionCount *int64 `json:"data_collection_count,omitempty"`

	// Number of entities in the workspace.
	// Example: 1000
	EntityCount *int64 `json:"entity_count,omitempty"`

	// Name of the workspace.
	// Example: Finance
	Name *string `json:"name,omitempty"`

	// Scanned size of the workspace.
	// Example: 7663353
	ScannedSize *int64 `json:"scanned_size,omitempty"`

	// Number of sensitive entities in the workspace.
	// Example: 10
	SensitiveEntityCount *int64 `json:"sensitive_entity_count,omitempty"`

	// UUID of the workspace.
	// Example: 02c9e252-41be-11e9-81d5-00a0986138f7
	// Format: uuid
	UUID *strfmt.UUID `json:"uuid,omitempty"`
}

// Validate validates this recent workspaces array inline inline array item
func (m *RecentWorkspacesArrayInlineInlineArrayItem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateUUID(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *RecentWorkspacesArrayInlineInlineArrayItem) validateUUID(formats strfmt.Registry) error {
	if swag.IsZero(m.UUID) { // not required
		return nil
	}

	if err := validate.FormatOf("uuid", "body", "uuid", m.UUID.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this recent workspaces array inline inline array item based on context it is used
func (m *RecentWorkspacesArrayInlineInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *RecentWorkspacesArrayInlineInlineArrayItem) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *RecentWorkspacesArrayInlineInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res RecentWorkspacesArrayInlineInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
