// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// ReturnedError returned error
//
// swagger:model returned_error
type ReturnedError struct {

	// Error code
	// Example: 4
	// Read Only: true
	Code *string `json:"code,omitempty"`

	// Error message
	// Example: entry doesn't exist
	// Read Only: true
	Message *string `json:"message,omitempty"`

	// Message arguments
	// Read Only: true
	ReturnedErrorInlineArguments []*ErrorArguments `json:"arguments,omitempty"`

	// The target parameter that caused the error.
	// Example: uuid
	// Read Only: true
	Target *string `json:"target,omitempty"`
}

// Validate validates this returned error
func (m *ReturnedError) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateReturnedErrorInlineArguments(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ReturnedError) validateReturnedErrorInlineArguments(formats strfmt.Registry) error {
	if swag.IsZero(m.ReturnedErrorInlineArguments) { // not required
		return nil
	}

	for i := 0; i < len(m.ReturnedErrorInlineArguments); i++ {
		if swag.IsZero(m.ReturnedErrorInlineArguments[i]) { // not required
			continue
		}

		if m.ReturnedErrorInlineArguments[i] != nil {
			if err := m.ReturnedErrorInlineArguments[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("arguments" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this returned error based on the context it is used
func (m *ReturnedError) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateCode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMessage(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateReturnedErrorInlineArguments(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTarget(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ReturnedError) contextValidateCode(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "code", "body", m.Code); err != nil {
		return err
	}

	return nil
}

func (m *ReturnedError) contextValidateMessage(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "message", "body", m.Message); err != nil {
		return err
	}

	return nil
}

func (m *ReturnedError) contextValidateReturnedErrorInlineArguments(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "arguments", "body", []*ErrorArguments(m.ReturnedErrorInlineArguments)); err != nil {
		return err
	}

	for i := 0; i < len(m.ReturnedErrorInlineArguments); i++ {

		if m.ReturnedErrorInlineArguments[i] != nil {
			if err := m.ReturnedErrorInlineArguments[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("arguments" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *ReturnedError) contextValidateTarget(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "target", "body", m.Target); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ReturnedError) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ReturnedError) UnmarshalBinary(b []byte) error {
	var res ReturnedError
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
