// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// Rfc2307bis rfc2307bis
//
// swagger:model rfc2307bis
type Rfc2307bis struct {

	// Indicates whether RFC 2307bis is enabled for the client schema.
	// Example: false
	Enabled *bool `json:"enabled,omitempty"`

	// RFC 2307bis groupOfUniqueNames object class.
	// Example: groupOfUniqueNames
	GroupOfUniqueNames *string `json:"group_of_unique_names,omitempty"`

	// Maximum number of groups supported when RFC 2307bis is enabled.
	// Example: 256
	// Maximum: 1024
	// Minimum: 1
	MaximumGroups *int64 `json:"maximum_groups,omitempty"`

	// RFC 2307bis uniqueMember attribute.
	// Example: uniqueMember
	UniqueMember *string `json:"unique_member,omitempty"`
}

// Validate validates this rfc2307bis
func (m *Rfc2307bis) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateMaximumGroups(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *Rfc2307bis) validateMaximumGroups(formats strfmt.Registry) error {
	if swag.IsZero(m.MaximumGroups) { // not required
		return nil
	}

	if err := validate.MinimumInt("maximum_groups", "body", *m.MaximumGroups, 1, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("maximum_groups", "body", *m.MaximumGroups, 1024, false); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this rfc2307bis based on context it is used
func (m *Rfc2307bis) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *Rfc2307bis) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *Rfc2307bis) UnmarshalBinary(b []byte) error {
	var res Rfc2307bis
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
