// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/validate"
)

// Rights Specifies the access rights controlled by the ACE for the account specified.
// The "rights" parameter is mutually exclusive with the "advanced_rights"
// parameter. If you specify the "rights" parameter, you can specify one
// of the following "rights" values ("-" or "_" is accepted as the delimiter).
//
// Example: full_control
//
// swagger:model rights
type Rights string

func NewRights(value Rights) *Rights {
	return &value
}

// Pointer returns a pointer to a freshly-allocated Rights.
func (m Rights) Pointer() *Rights {
	return &m
}

const (

	// RightsNoAccess captures enum value "no_access"
	RightsNoAccess Rights = "no_access"

	// RightsFullControl captures enum value "full_control"
	RightsFullControl Rights = "full_control"

	// RightsModify captures enum value "modify"
	RightsModify Rights = "modify"

	// RightsReadAndExecute captures enum value "read_and_execute"
	RightsReadAndExecute Rights = "read_and_execute"

	// RightsRead captures enum value "read"
	RightsRead Rights = "read"

	// RightsWrite captures enum value "write"
	RightsWrite Rights = "write"
)

// for schema
var rightsEnum []interface{}

func init() {
	var res []Rights
	if err := json.Unmarshal([]byte(`["no_access","full_control","modify","read_and_execute","read","write"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		rightsEnum = append(rightsEnum, v)
	}
}

func (m Rights) validateRightsEnum(path, location string, value Rights) error {
	if err := validate.EnumCase(path, location, value, rightsEnum, true); err != nil {
		return err
	}
	return nil
}

// Validate validates this rights
func (m Rights) Validate(formats strfmt.Registry) error {
	var res []error

	// value enum
	if err := m.validateRightsEnum("", "body", m); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// ContextValidate validates this rights based on context it is used
func (m Rights) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}
