// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// RolePrivilege A tuple containing a REST endpoint or a command/command directory path and the access level assigned to that endpoint or command/command directory. If the "path" attribute refers to a command/command directory path, the tuple could additionally contain an optional query. The REST endpoint can be a resource-qualified endpoint. At present, the only supported resource-qualified endpoints are the following<br/>
// Snapshots APIs<br/><ul>
// <li><i>/api/storage/volumes/{volume.uuid}/snapshots</i></li></ul><br/>
// File System Analytics APIs<br/><ul>
// <li><i>/api/storage/volumes/{volume.uuid}/files</i></li>
// <li><i>/api/storage/volumes/{volume.uuid}/top-metrics/clients</i></li>
// <li><i>/api/storage/volumes/{volume.uuid}/top-metrics/directories</i></li>
// <li><i>/api/storage/volumes/{volume.uuid}/top-metrics/files</i></li>
// <li><i>/api/storage/volumes/{volume.uuid}/top-metrics/users</i></li>
// <li><i>/api/svm/svms/{svm.uuid}/top-metrics/clients</i></li>
// <li><i>/api/svm/svms/{svm.uuid}/top-metrics/directories</i></li>
// <li><i>/api/svm/svms/{svm.uuid}/top-metrics/files</i></li>
// <li><i>/api/svm/svms/{svm.uuid}/top-metrics/users</i></li>
// <li><i>/api/protocols/s3/services/{svm.uuid}/users</i></li><br/></ul><br/>
// In the above APIs, wildcard character &#42; could be used in place of <i>{volume.uuid}</i> or <i>{svm.uuid}</i> to denote <i>all</i> volumes or <i>all</i> SVMs, depending upon whether the REST endpoint references volumes or SVMs. The <i>{volume.uuid}</i> refers to the <i>-instance-uuid</i> field value in the \"volume show\" command output at diagnostic privilege level. It can also be fetched through REST endpoint <i>/api/storage/volumes</i>.
//
// swagger:model role_privilege
type RolePrivilege struct {

	// links
	Links *RolePrivilegeInlineLinks `json:"_links,omitempty"`

	// access
	Access *RolePrivilegeLevel `json:"access,omitempty"`

	// Either of REST URI/endpoint OR command/command directory path.
	// Example: volume move start
	Path *string `json:"path,omitempty"`

	// Optional attribute that can be specified only if the "path" attribute refers to a command/command directory path. The privilege tuple implicitly defines a set of objects the role can or cannot access at the specified access level. The query further reduces this set of objects to a subset of objects that the role is allowed to access. The query attribute must be applicable to the command/command directory specified by the "path" attribute. It is defined using one or more parameters of the command/command directory path specified by the "path" attribute.
	// Example: -vserver vs1|vs2|vs3 -destination-aggregate aggr1|aggr2
	Query *string `json:"query,omitempty"`
}

// Validate validates this role privilege
func (m *RolePrivilege) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateAccess(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *RolePrivilege) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *RolePrivilege) validateAccess(formats strfmt.Registry) error {
	if swag.IsZero(m.Access) { // not required
		return nil
	}

	if m.Access != nil {
		if err := m.Access.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("access")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this role privilege based on the context it is used
func (m *RolePrivilege) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateAccess(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *RolePrivilege) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *RolePrivilege) contextValidateAccess(ctx context.Context, formats strfmt.Registry) error {

	if m.Access != nil {
		if err := m.Access.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("access")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *RolePrivilege) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *RolePrivilege) UnmarshalBinary(b []byte) error {
	var res RolePrivilege
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// RolePrivilegeInlineLinks role privilege inline links
//
// swagger:model role_privilege_inline__links
type RolePrivilegeInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this role privilege inline links
func (m *RolePrivilegeInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *RolePrivilegeInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this role privilege inline links based on the context it is used
func (m *RolePrivilegeInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *RolePrivilegeInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *RolePrivilegeInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *RolePrivilegeInlineLinks) UnmarshalBinary(b []byte) error {
	var res RolePrivilegeInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
