// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// S3Bucket A bucket is a container of objects. Each bucket defines an object namespace. S3 requests specify objects using a bucket-name and object-name pair. An object resides within a bucket.
//
// swagger:model s3_bucket
type S3Bucket struct {

	// If this is set to true, an SVM administrator can manage the S3 service. If it is false, only the cluster administrator can manage the service. This field cannot be specified in a POST method.
	Allowed *bool `json:"allowed,omitempty"`

	// audit event selector
	AuditEventSelector *S3BucketInlineAuditEventSelector `json:"audit_event_selector,omitempty"`

	// Can contain any additional information about the bucket being created or modified.
	// Example: S3 bucket.
	// Max Length: 256
	// Min Length: 0
	Comment *string `json:"comment,omitempty"`

	// Specifies the number of constituents or FlexVol volumes per aggregate. A FlexGroup volume consisting of all such constituents across all specified aggregates is created. This option is used along with the aggregates option and cannot be used independently.
	// Example: 4
	// Maximum: 1000
	// Minimum: 1
	ConstituentsPerAggregate *int64 `json:"constituents_per_aggregate,omitempty"`

	// cors
	Cors *S3BucketInlineCors `json:"cors,omitempty"`

	// encryption
	Encryption *S3BucketInlineEncryption `json:"encryption,omitempty"`

	// Specifies whether the NAS bucket returns a consistent ETag across different S3 requests.
	IsConsistentEtag *bool `json:"is_consistent_etag,omitempty"`

	// Specifies whether the NAS bucket mapping or association with a NAS volume can change according to the changes in the NAS volume junction-path due to volume operations like mount and unmount and therefore the NAS bucket will have access to any path in a NAS volume that matches the specified nas-path. Or is immutable and therefore the NAS bucket will always have access to the same nas-path that was specified during bucket creation even if the volume junction-path has undergone changes after the bucket creation.
	IsNasPathMutable *bool `json:"is_nas_path_mutable,omitempty"`

	// lifecycle management
	LifecycleManagement *S3BucketInlineLifecycleManagement `json:"lifecycle_management,omitempty"`

	// Specifies the bucket logical used size up to this point. This field cannot be specified using a POST or PATCH method.
	// Read Only: true
	LogicalUsedSize *int64 `json:"logical_used_size,omitempty"`

	// Specifies the name of the bucket. Bucket name is a string that can only contain the following combination of ASCII-range alphanumeric characters 0-9, a-z, ".", and "-".
	// Example: bucket1
	// Max Length: 63
	// Min Length: 3
	Name *string `json:"name,omitempty"`

	// Specifies the NAS path to which the nas bucket corresponds to.
	// Example: /
	NasPath *string `json:"nas_path,omitempty"`

	// policy
	Policy *S3BucketInlinePolicy `json:"policy,omitempty"`

	// protection status
	ProtectionStatus *S3BucketInlineProtectionStatus `json:"protection_status,omitempty"`

	// qos policy
	QosPolicy *S3BucketInlineQosPolicy `json:"qos_policy,omitempty"`

	// retention
	Retention *S3BucketInlineRetention `json:"retention,omitempty"`

	// Specifies the role of the bucket. This field cannot be specified using a POST method.
	// Read Only: true
	// Enum: ["standalone","active","passive"]
	Role *string `json:"role,omitempty"`

	// A list of aggregates for FlexGroup volume constituents where the bucket is hosted. If this option is not specified, the bucket is auto-provisioned as a FlexGroup volume.
	S3BucketInlineAggregates []*S3BucketInlineAggregatesInlineArrayItem `json:"aggregates,omitempty"`

	// Specifies the bucket size in bytes; ranges from 100GB to 60PB.
	// Example: 214748364800
	// Maximum: 6.755399441055744e+16
	// Minimum: 1.073741824e+11
	Size *int64 `json:"size,omitempty"`

	// snapshot policy
	SnapshotPolicy *S3BucketInlineSnapshotPolicy `json:"snapshot_policy,omitempty"`

	// Specifies the storage service level of the FlexGroup volume on which the bucket should be created. Valid values are "value", "performance" or "extreme".
	// Example: value
	// Enum: ["value","performance","extreme"]
	StorageServiceLevel *string `json:"storage_service_level,omitempty"`

	// svm
	Svm *S3BucketInlineSvm `json:"svm,omitempty"`

	// Specifies the bucket type. Valid values are "s3"and "nas".
	// Example: s3
	// Enum: ["s3","nas"]
	Type *string `json:"type,omitempty"`

	// Specifies whether mirrored aggregates are selected when provisioning a FlexGroup. Only mirrored aggregates are used if this parameter is set to "true" and only unmirrored aggregates are used if this parameter is set to "false". The default value is "true" for a MetroCluster configuration and is "false" for a non-MetroCluster configuration.
	UseMirroredAggregates *bool `json:"use_mirrored_aggregates,omitempty"`

	// Specifies the unique identifier of the bucket.
	// Example: 414b29a1-3b26-11e9-bd58-0050568ea055
	// Read Only: true
	// Format: uuid
	UUID *strfmt.UUID `json:"uuid,omitempty"`

	// Specifies the versioning state of the bucket. Valid values are "disabled", "enabled" or "suspended". Note that the versioning state cannot be modified to 'disabled' from any other state.
	// Example: enabled
	// Enum: ["disabled","enabled","suspended"]
	VersioningState *string `json:"versioning_state,omitempty"`

	// volume
	Volume *S3BucketInlineVolume `json:"volume,omitempty"`
}

// Validate validates this s3 bucket
func (m *S3Bucket) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateAuditEventSelector(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateComment(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateConstituentsPerAggregate(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCors(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateEncryption(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLifecycleManagement(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateName(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePolicy(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateProtectionStatus(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateQosPolicy(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateRetention(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateRole(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateS3BucketInlineAggregates(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSize(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSnapshotPolicy(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStorageServiceLevel(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSvm(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateType(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateUUID(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateVersioningState(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateVolume(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *S3Bucket) validateAuditEventSelector(formats strfmt.Registry) error {
	if swag.IsZero(m.AuditEventSelector) { // not required
		return nil
	}

	if m.AuditEventSelector != nil {
		if err := m.AuditEventSelector.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("audit_event_selector")
			}
			return err
		}
	}

	return nil
}

func (m *S3Bucket) validateComment(formats strfmt.Registry) error {
	if swag.IsZero(m.Comment) { // not required
		return nil
	}

	if err := validate.MinLength("comment", "body", *m.Comment, 0); err != nil {
		return err
	}

	if err := validate.MaxLength("comment", "body", *m.Comment, 256); err != nil {
		return err
	}

	return nil
}

func (m *S3Bucket) validateConstituentsPerAggregate(formats strfmt.Registry) error {
	if swag.IsZero(m.ConstituentsPerAggregate) { // not required
		return nil
	}

	if err := validate.MinimumInt("constituents_per_aggregate", "body", *m.ConstituentsPerAggregate, 1, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("constituents_per_aggregate", "body", *m.ConstituentsPerAggregate, 1000, false); err != nil {
		return err
	}

	return nil
}

func (m *S3Bucket) validateCors(formats strfmt.Registry) error {
	if swag.IsZero(m.Cors) { // not required
		return nil
	}

	if m.Cors != nil {
		if err := m.Cors.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("cors")
			}
			return err
		}
	}

	return nil
}

func (m *S3Bucket) validateEncryption(formats strfmt.Registry) error {
	if swag.IsZero(m.Encryption) { // not required
		return nil
	}

	if m.Encryption != nil {
		if err := m.Encryption.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("encryption")
			}
			return err
		}
	}

	return nil
}

func (m *S3Bucket) validateLifecycleManagement(formats strfmt.Registry) error {
	if swag.IsZero(m.LifecycleManagement) { // not required
		return nil
	}

	if m.LifecycleManagement != nil {
		if err := m.LifecycleManagement.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("lifecycle_management")
			}
			return err
		}
	}

	return nil
}

func (m *S3Bucket) validateName(formats strfmt.Registry) error {
	if swag.IsZero(m.Name) { // not required
		return nil
	}

	if err := validate.MinLength("name", "body", *m.Name, 3); err != nil {
		return err
	}

	if err := validate.MaxLength("name", "body", *m.Name, 63); err != nil {
		return err
	}

	return nil
}

func (m *S3Bucket) validatePolicy(formats strfmt.Registry) error {
	if swag.IsZero(m.Policy) { // not required
		return nil
	}

	if m.Policy != nil {
		if err := m.Policy.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("policy")
			}
			return err
		}
	}

	return nil
}

func (m *S3Bucket) validateProtectionStatus(formats strfmt.Registry) error {
	if swag.IsZero(m.ProtectionStatus) { // not required
		return nil
	}

	if m.ProtectionStatus != nil {
		if err := m.ProtectionStatus.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("protection_status")
			}
			return err
		}
	}

	return nil
}

func (m *S3Bucket) validateQosPolicy(formats strfmt.Registry) error {
	if swag.IsZero(m.QosPolicy) { // not required
		return nil
	}

	if m.QosPolicy != nil {
		if err := m.QosPolicy.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos_policy")
			}
			return err
		}
	}

	return nil
}

func (m *S3Bucket) validateRetention(formats strfmt.Registry) error {
	if swag.IsZero(m.Retention) { // not required
		return nil
	}

	if m.Retention != nil {
		if err := m.Retention.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("retention")
			}
			return err
		}
	}

	return nil
}

var s3BucketTypeRolePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["standalone","active","passive"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		s3BucketTypeRolePropEnum = append(s3BucketTypeRolePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// s3_bucket
	// S3Bucket
	// role
	// Role
	// standalone
	// END DEBUGGING
	// S3BucketRoleStandalone captures enum value "standalone"
	S3BucketRoleStandalone string = "standalone"

	// BEGIN DEBUGGING
	// s3_bucket
	// S3Bucket
	// role
	// Role
	// active
	// END DEBUGGING
	// S3BucketRoleActive captures enum value "active"
	S3BucketRoleActive string = "active"

	// BEGIN DEBUGGING
	// s3_bucket
	// S3Bucket
	// role
	// Role
	// passive
	// END DEBUGGING
	// S3BucketRolePassive captures enum value "passive"
	S3BucketRolePassive string = "passive"
)

// prop value enum
func (m *S3Bucket) validateRoleEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, s3BucketTypeRolePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *S3Bucket) validateRole(formats strfmt.Registry) error {
	if swag.IsZero(m.Role) { // not required
		return nil
	}

	// value enum
	if err := m.validateRoleEnum("role", "body", *m.Role); err != nil {
		return err
	}

	return nil
}

func (m *S3Bucket) validateS3BucketInlineAggregates(formats strfmt.Registry) error {
	if swag.IsZero(m.S3BucketInlineAggregates) { // not required
		return nil
	}

	for i := 0; i < len(m.S3BucketInlineAggregates); i++ {
		if swag.IsZero(m.S3BucketInlineAggregates[i]) { // not required
			continue
		}

		if m.S3BucketInlineAggregates[i] != nil {
			if err := m.S3BucketInlineAggregates[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("aggregates" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *S3Bucket) validateSize(formats strfmt.Registry) error {
	if swag.IsZero(m.Size) { // not required
		return nil
	}

	if err := validate.MinimumInt("size", "body", *m.Size, 1.073741824e+11, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("size", "body", *m.Size, 6.755399441055744e+16, false); err != nil {
		return err
	}

	return nil
}

func (m *S3Bucket) validateSnapshotPolicy(formats strfmt.Registry) error {
	if swag.IsZero(m.SnapshotPolicy) { // not required
		return nil
	}

	if m.SnapshotPolicy != nil {
		if err := m.SnapshotPolicy.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("snapshot_policy")
			}
			return err
		}
	}

	return nil
}

var s3BucketTypeStorageServiceLevelPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["value","performance","extreme"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		s3BucketTypeStorageServiceLevelPropEnum = append(s3BucketTypeStorageServiceLevelPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// s3_bucket
	// S3Bucket
	// storage_service_level
	// StorageServiceLevel
	// value
	// END DEBUGGING
	// S3BucketStorageServiceLevelValue captures enum value "value"
	S3BucketStorageServiceLevelValue string = "value"

	// BEGIN DEBUGGING
	// s3_bucket
	// S3Bucket
	// storage_service_level
	// StorageServiceLevel
	// performance
	// END DEBUGGING
	// S3BucketStorageServiceLevelPerformance captures enum value "performance"
	S3BucketStorageServiceLevelPerformance string = "performance"

	// BEGIN DEBUGGING
	// s3_bucket
	// S3Bucket
	// storage_service_level
	// StorageServiceLevel
	// extreme
	// END DEBUGGING
	// S3BucketStorageServiceLevelExtreme captures enum value "extreme"
	S3BucketStorageServiceLevelExtreme string = "extreme"
)

// prop value enum
func (m *S3Bucket) validateStorageServiceLevelEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, s3BucketTypeStorageServiceLevelPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *S3Bucket) validateStorageServiceLevel(formats strfmt.Registry) error {
	if swag.IsZero(m.StorageServiceLevel) { // not required
		return nil
	}

	// value enum
	if err := m.validateStorageServiceLevelEnum("storage_service_level", "body", *m.StorageServiceLevel); err != nil {
		return err
	}

	return nil
}

func (m *S3Bucket) validateSvm(formats strfmt.Registry) error {
	if swag.IsZero(m.Svm) { // not required
		return nil
	}

	if m.Svm != nil {
		if err := m.Svm.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm")
			}
			return err
		}
	}

	return nil
}

var s3BucketTypeTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["s3","nas"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		s3BucketTypeTypePropEnum = append(s3BucketTypeTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// s3_bucket
	// S3Bucket
	// type
	// Type
	// s3
	// END DEBUGGING
	// S3BucketTypeS3 captures enum value "s3"
	S3BucketTypeS3 string = "s3"

	// BEGIN DEBUGGING
	// s3_bucket
	// S3Bucket
	// type
	// Type
	// nas
	// END DEBUGGING
	// S3BucketTypeNas captures enum value "nas"
	S3BucketTypeNas string = "nas"
)

// prop value enum
func (m *S3Bucket) validateTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, s3BucketTypeTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *S3Bucket) validateType(formats strfmt.Registry) error {
	if swag.IsZero(m.Type) { // not required
		return nil
	}

	// value enum
	if err := m.validateTypeEnum("type", "body", *m.Type); err != nil {
		return err
	}

	return nil
}

func (m *S3Bucket) validateUUID(formats strfmt.Registry) error {
	if swag.IsZero(m.UUID) { // not required
		return nil
	}

	if err := validate.FormatOf("uuid", "body", "uuid", m.UUID.String(), formats); err != nil {
		return err
	}

	return nil
}

var s3BucketTypeVersioningStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["disabled","enabled","suspended"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		s3BucketTypeVersioningStatePropEnum = append(s3BucketTypeVersioningStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// s3_bucket
	// S3Bucket
	// versioning_state
	// VersioningState
	// disabled
	// END DEBUGGING
	// S3BucketVersioningStateDisabled captures enum value "disabled"
	S3BucketVersioningStateDisabled string = "disabled"

	// BEGIN DEBUGGING
	// s3_bucket
	// S3Bucket
	// versioning_state
	// VersioningState
	// enabled
	// END DEBUGGING
	// S3BucketVersioningStateEnabled captures enum value "enabled"
	S3BucketVersioningStateEnabled string = "enabled"

	// BEGIN DEBUGGING
	// s3_bucket
	// S3Bucket
	// versioning_state
	// VersioningState
	// suspended
	// END DEBUGGING
	// S3BucketVersioningStateSuspended captures enum value "suspended"
	S3BucketVersioningStateSuspended string = "suspended"
)

// prop value enum
func (m *S3Bucket) validateVersioningStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, s3BucketTypeVersioningStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *S3Bucket) validateVersioningState(formats strfmt.Registry) error {
	if swag.IsZero(m.VersioningState) { // not required
		return nil
	}

	// value enum
	if err := m.validateVersioningStateEnum("versioning_state", "body", *m.VersioningState); err != nil {
		return err
	}

	return nil
}

func (m *S3Bucket) validateVolume(formats strfmt.Registry) error {
	if swag.IsZero(m.Volume) { // not required
		return nil
	}

	if m.Volume != nil {
		if err := m.Volume.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("volume")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this s3 bucket based on the context it is used
func (m *S3Bucket) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateAuditEventSelector(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateCors(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateEncryption(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLifecycleManagement(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLogicalUsedSize(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidatePolicy(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateProtectionStatus(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateQosPolicy(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateRetention(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateRole(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateS3BucketInlineAggregates(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSnapshotPolicy(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSvm(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateVolume(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *S3Bucket) contextValidateAuditEventSelector(ctx context.Context, formats strfmt.Registry) error {

	if m.AuditEventSelector != nil {
		if err := m.AuditEventSelector.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("audit_event_selector")
			}
			return err
		}
	}

	return nil
}

func (m *S3Bucket) contextValidateCors(ctx context.Context, formats strfmt.Registry) error {

	if m.Cors != nil {
		if err := m.Cors.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("cors")
			}
			return err
		}
	}

	return nil
}

func (m *S3Bucket) contextValidateEncryption(ctx context.Context, formats strfmt.Registry) error {

	if m.Encryption != nil {
		if err := m.Encryption.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("encryption")
			}
			return err
		}
	}

	return nil
}

func (m *S3Bucket) contextValidateLifecycleManagement(ctx context.Context, formats strfmt.Registry) error {

	if m.LifecycleManagement != nil {
		if err := m.LifecycleManagement.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("lifecycle_management")
			}
			return err
		}
	}

	return nil
}

func (m *S3Bucket) contextValidateLogicalUsedSize(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "logical_used_size", "body", m.LogicalUsedSize); err != nil {
		return err
	}

	return nil
}

func (m *S3Bucket) contextValidatePolicy(ctx context.Context, formats strfmt.Registry) error {

	if m.Policy != nil {
		if err := m.Policy.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("policy")
			}
			return err
		}
	}

	return nil
}

func (m *S3Bucket) contextValidateProtectionStatus(ctx context.Context, formats strfmt.Registry) error {

	if m.ProtectionStatus != nil {
		if err := m.ProtectionStatus.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("protection_status")
			}
			return err
		}
	}

	return nil
}

func (m *S3Bucket) contextValidateQosPolicy(ctx context.Context, formats strfmt.Registry) error {

	if m.QosPolicy != nil {
		if err := m.QosPolicy.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos_policy")
			}
			return err
		}
	}

	return nil
}

func (m *S3Bucket) contextValidateRetention(ctx context.Context, formats strfmt.Registry) error {

	if m.Retention != nil {
		if err := m.Retention.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("retention")
			}
			return err
		}
	}

	return nil
}

func (m *S3Bucket) contextValidateRole(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "role", "body", m.Role); err != nil {
		return err
	}

	return nil
}

func (m *S3Bucket) contextValidateS3BucketInlineAggregates(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.S3BucketInlineAggregates); i++ {

		if m.S3BucketInlineAggregates[i] != nil {
			if err := m.S3BucketInlineAggregates[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("aggregates" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *S3Bucket) contextValidateSnapshotPolicy(ctx context.Context, formats strfmt.Registry) error {

	if m.SnapshotPolicy != nil {
		if err := m.SnapshotPolicy.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("snapshot_policy")
			}
			return err
		}
	}

	return nil
}

func (m *S3Bucket) contextValidateSvm(ctx context.Context, formats strfmt.Registry) error {

	if m.Svm != nil {
		if err := m.Svm.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm")
			}
			return err
		}
	}

	return nil
}

func (m *S3Bucket) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "uuid", "body", m.UUID); err != nil {
		return err
	}

	return nil
}

func (m *S3Bucket) contextValidateVolume(ctx context.Context, formats strfmt.Registry) error {

	if m.Volume != nil {
		if err := m.Volume.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("volume")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *S3Bucket) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *S3Bucket) UnmarshalBinary(b []byte) error {
	var res S3Bucket
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// S3BucketInlineAggregatesInlineArrayItem Aggregate
//
// swagger:model s3_bucket_inline_aggregates_inline_array_item
type S3BucketInlineAggregatesInlineArrayItem struct {

	// links
	Links *S3BucketInlineAggregatesInlineArrayItemInlineLinks `json:"_links,omitempty"`

	// name
	// Example: aggr1
	Name *string `json:"name,omitempty"`

	// uuid
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this s3 bucket inline aggregates inline array item
func (m *S3BucketInlineAggregatesInlineArrayItem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *S3BucketInlineAggregatesInlineArrayItem) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this s3 bucket inline aggregates inline array item based on the context it is used
func (m *S3BucketInlineAggregatesInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *S3BucketInlineAggregatesInlineArrayItem) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *S3BucketInlineAggregatesInlineArrayItem) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *S3BucketInlineAggregatesInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res S3BucketInlineAggregatesInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// S3BucketInlineAggregatesInlineArrayItemInlineLinks s3 bucket inline aggregates inline array item inline links
//
// swagger:model s3_bucket_inline_aggregates_inline_array_item_inline__links
type S3BucketInlineAggregatesInlineArrayItemInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this s3 bucket inline aggregates inline array item inline links
func (m *S3BucketInlineAggregatesInlineArrayItemInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *S3BucketInlineAggregatesInlineArrayItemInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this s3 bucket inline aggregates inline array item inline links based on the context it is used
func (m *S3BucketInlineAggregatesInlineArrayItemInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *S3BucketInlineAggregatesInlineArrayItemInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *S3BucketInlineAggregatesInlineArrayItemInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *S3BucketInlineAggregatesInlineArrayItemInlineLinks) UnmarshalBinary(b []byte) error {
	var res S3BucketInlineAggregatesInlineArrayItemInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// S3BucketInlineAuditEventSelector Audit event selector allows you to specify access and permission types to audit.
//
// swagger:model s3_bucket_inline_audit_event_selector
type S3BucketInlineAuditEventSelector struct {

	// Specifies read and write access types.
	//
	// Enum: ["read","write","all","none"]
	Access *string `json:"access,omitempty"`

	// Specifies allow and deny permission types.
	//
	// Enum: ["deny","allow","all","none"]
	Permission *string `json:"permission,omitempty"`
}

// Validate validates this s3 bucket inline audit event selector
func (m *S3BucketInlineAuditEventSelector) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateAccess(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePermission(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var s3BucketInlineAuditEventSelectorTypeAccessPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["read","write","all","none"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		s3BucketInlineAuditEventSelectorTypeAccessPropEnum = append(s3BucketInlineAuditEventSelectorTypeAccessPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// s3_bucket_inline_audit_event_selector
	// S3BucketInlineAuditEventSelector
	// access
	// Access
	// read
	// END DEBUGGING
	// S3BucketInlineAuditEventSelectorAccessRead captures enum value "read"
	S3BucketInlineAuditEventSelectorAccessRead string = "read"

	// BEGIN DEBUGGING
	// s3_bucket_inline_audit_event_selector
	// S3BucketInlineAuditEventSelector
	// access
	// Access
	// write
	// END DEBUGGING
	// S3BucketInlineAuditEventSelectorAccessWrite captures enum value "write"
	S3BucketInlineAuditEventSelectorAccessWrite string = "write"

	// BEGIN DEBUGGING
	// s3_bucket_inline_audit_event_selector
	// S3BucketInlineAuditEventSelector
	// access
	// Access
	// all
	// END DEBUGGING
	// S3BucketInlineAuditEventSelectorAccessAll captures enum value "all"
	S3BucketInlineAuditEventSelectorAccessAll string = "all"

	// BEGIN DEBUGGING
	// s3_bucket_inline_audit_event_selector
	// S3BucketInlineAuditEventSelector
	// access
	// Access
	// none
	// END DEBUGGING
	// S3BucketInlineAuditEventSelectorAccessNone captures enum value "none"
	S3BucketInlineAuditEventSelectorAccessNone string = "none"
)

// prop value enum
func (m *S3BucketInlineAuditEventSelector) validateAccessEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, s3BucketInlineAuditEventSelectorTypeAccessPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *S3BucketInlineAuditEventSelector) validateAccess(formats strfmt.Registry) error {
	if swag.IsZero(m.Access) { // not required
		return nil
	}

	// value enum
	if err := m.validateAccessEnum("audit_event_selector"+"."+"access", "body", *m.Access); err != nil {
		return err
	}

	return nil
}

var s3BucketInlineAuditEventSelectorTypePermissionPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["deny","allow","all","none"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		s3BucketInlineAuditEventSelectorTypePermissionPropEnum = append(s3BucketInlineAuditEventSelectorTypePermissionPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// s3_bucket_inline_audit_event_selector
	// S3BucketInlineAuditEventSelector
	// permission
	// Permission
	// deny
	// END DEBUGGING
	// S3BucketInlineAuditEventSelectorPermissionDeny captures enum value "deny"
	S3BucketInlineAuditEventSelectorPermissionDeny string = "deny"

	// BEGIN DEBUGGING
	// s3_bucket_inline_audit_event_selector
	// S3BucketInlineAuditEventSelector
	// permission
	// Permission
	// allow
	// END DEBUGGING
	// S3BucketInlineAuditEventSelectorPermissionAllow captures enum value "allow"
	S3BucketInlineAuditEventSelectorPermissionAllow string = "allow"

	// BEGIN DEBUGGING
	// s3_bucket_inline_audit_event_selector
	// S3BucketInlineAuditEventSelector
	// permission
	// Permission
	// all
	// END DEBUGGING
	// S3BucketInlineAuditEventSelectorPermissionAll captures enum value "all"
	S3BucketInlineAuditEventSelectorPermissionAll string = "all"

	// BEGIN DEBUGGING
	// s3_bucket_inline_audit_event_selector
	// S3BucketInlineAuditEventSelector
	// permission
	// Permission
	// none
	// END DEBUGGING
	// S3BucketInlineAuditEventSelectorPermissionNone captures enum value "none"
	S3BucketInlineAuditEventSelectorPermissionNone string = "none"
)

// prop value enum
func (m *S3BucketInlineAuditEventSelector) validatePermissionEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, s3BucketInlineAuditEventSelectorTypePermissionPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *S3BucketInlineAuditEventSelector) validatePermission(formats strfmt.Registry) error {
	if swag.IsZero(m.Permission) { // not required
		return nil
	}

	// value enum
	if err := m.validatePermissionEnum("audit_event_selector"+"."+"permission", "body", *m.Permission); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this s3 bucket inline audit event selector based on context it is used
func (m *S3BucketInlineAuditEventSelector) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *S3BucketInlineAuditEventSelector) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *S3BucketInlineAuditEventSelector) UnmarshalBinary(b []byte) error {
	var res S3BucketInlineAuditEventSelector
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// S3BucketInlineCors Cross-origin resource sharing (CORS) specifies an object associated with a bucket. The CORS configuration enables the bucket to service the cross-origin requests. A request might typically come from an origin with a domain that is different to that of the bucket. By configuring a CORS rule, you can define a combination of allowed origins, HTTP headers and methods that a bucket can use to filter out the cross-origin requests that it can service successfully.
//
// swagger:model s3_bucket_inline_cors
type S3BucketInlineCors struct {

	// Specifies an object store bucket CORS rule.
	Rules []*S3BucketCorsRulesItems0 `json:"rules,omitempty"`
}

// Validate validates this s3 bucket inline cors
func (m *S3BucketInlineCors) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateRules(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *S3BucketInlineCors) validateRules(formats strfmt.Registry) error {
	if swag.IsZero(m.Rules) { // not required
		return nil
	}

	for i := 0; i < len(m.Rules); i++ {
		if swag.IsZero(m.Rules[i]) { // not required
			continue
		}

		if m.Rules[i] != nil {
			if err := m.Rules[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("cors" + "." + "rules" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this s3 bucket inline cors based on the context it is used
func (m *S3BucketInlineCors) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateRules(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *S3BucketInlineCors) contextValidateRules(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.Rules); i++ {

		if m.Rules[i] != nil {
			if err := m.Rules[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("cors" + "." + "rules" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *S3BucketInlineCors) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *S3BucketInlineCors) UnmarshalBinary(b []byte) error {
	var res S3BucketInlineCors
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// S3BucketCorsRulesItems0 Information about the CORS rule of an S3 bucket.
//
// swagger:model S3BucketCorsRulesItems0
type S3BucketCorsRulesItems0 struct {

	// links
	Links *S3BucketCorsRulesItems0Links `json:"_links,omitempty"`

	// An array of HTTP headers allowed in the cross-origin requests.
	//
	// Example: ["x-amz-request-id"]
	AllowedHeaders []*string `json:"allowed_headers"`

	// An array of HTTP methods allowed in the cross-origin requests.
	//
	// Example: ["PUT","DELETE"]
	AllowedMethods []*string `json:"allowed_methods"`

	// List of origins from where a cross-origin request is allowed to originate from for the S3 bucket.
	//
	// Example: ["http://www.example.com"]
	AllowedOrigins []*string `json:"allowed_origins"`

	// List of extra headers sent in the response that customers can access from their applications.
	//
	// Example: ["x-amz-date"]
	ExposeHeaders []*string `json:"expose_headers"`

	// Bucket CORS rule identifier. The length of the name can range from 0 to 256 characters.
	// Max Length: 256
	// Min Length: 0
	ID *string `json:"id,omitempty"`

	// The time in seconds for your browser to cache the preflight response for the specified resource.
	// Example: 1024
	MaxAgeSeconds *int64 `json:"max_age_seconds,omitempty"`
}

// Validate validates this s3 bucket cors rules items0
func (m *S3BucketCorsRulesItems0) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateID(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *S3BucketCorsRulesItems0) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *S3BucketCorsRulesItems0) validateID(formats strfmt.Registry) error {
	if swag.IsZero(m.ID) { // not required
		return nil
	}

	if err := validate.MinLength("id", "body", *m.ID, 0); err != nil {
		return err
	}

	if err := validate.MaxLength("id", "body", *m.ID, 256); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this s3 bucket cors rules items0 based on the context it is used
func (m *S3BucketCorsRulesItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *S3BucketCorsRulesItems0) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *S3BucketCorsRulesItems0) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *S3BucketCorsRulesItems0) UnmarshalBinary(b []byte) error {
	var res S3BucketCorsRulesItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// S3BucketCorsRulesItems0Links s3 bucket cors rules items0 links
//
// swagger:model S3BucketCorsRulesItems0Links
type S3BucketCorsRulesItems0Links struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this s3 bucket cors rules items0 links
func (m *S3BucketCorsRulesItems0Links) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *S3BucketCorsRulesItems0Links) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this s3 bucket cors rules items0 links based on the context it is used
func (m *S3BucketCorsRulesItems0Links) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *S3BucketCorsRulesItems0Links) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *S3BucketCorsRulesItems0Links) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *S3BucketCorsRulesItems0Links) UnmarshalBinary(b []byte) error {
	var res S3BucketCorsRulesItems0Links
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// S3BucketInlineEncryption s3 bucket inline encryption
//
// swagger:model s3_bucket_inline_encryption
type S3BucketInlineEncryption struct {

	// Specifies whether encryption is enabled on the bucket. By default, encryption is disabled on a bucket. This field cannot be specified in a POST method.
	Enabled *bool `json:"enabled,omitempty"`
}

// Validate validates this s3 bucket inline encryption
func (m *S3BucketInlineEncryption) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this s3 bucket inline encryption based on the context it is used
func (m *S3BucketInlineEncryption) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *S3BucketInlineEncryption) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *S3BucketInlineEncryption) UnmarshalBinary(b []byte) error {
	var res S3BucketInlineEncryption
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// S3BucketInlineLifecycleManagement Lifecycle management is implemented as an object associated with a bucket. It defines rules to be applied against objects within a bucket. These rules are applied in the background and can delete objects.
//
// swagger:model s3_bucket_inline_lifecycle_management
type S3BucketInlineLifecycleManagement struct {

	// Specifies an object store lifecycle management policy.
	Rules []*S3BucketLifecycleManagementRulesItems0 `json:"rules,omitempty"`
}

// Validate validates this s3 bucket inline lifecycle management
func (m *S3BucketInlineLifecycleManagement) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateRules(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *S3BucketInlineLifecycleManagement) validateRules(formats strfmt.Registry) error {
	if swag.IsZero(m.Rules) { // not required
		return nil
	}

	for i := 0; i < len(m.Rules); i++ {
		if swag.IsZero(m.Rules[i]) { // not required
			continue
		}

		if m.Rules[i] != nil {
			if err := m.Rules[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("lifecycle_management" + "." + "rules" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this s3 bucket inline lifecycle management based on the context it is used
func (m *S3BucketInlineLifecycleManagement) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateRules(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *S3BucketInlineLifecycleManagement) contextValidateRules(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.Rules); i++ {

		if m.Rules[i] != nil {
			if err := m.Rules[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("lifecycle_management" + "." + "rules" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *S3BucketInlineLifecycleManagement) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *S3BucketInlineLifecycleManagement) UnmarshalBinary(b []byte) error {
	var res S3BucketInlineLifecycleManagement
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// S3BucketLifecycleManagementRulesItems0 Information about the lifecycle management rule of a bucket.
//
// swagger:model S3BucketLifecycleManagementRulesItems0
type S3BucketLifecycleManagementRulesItems0 struct {

	// links
	Links *S3BucketLifecycleManagementRulesItems0Links `json:"_links,omitempty"`

	// abort incomplete multipart upload
	AbortIncompleteMultipartUpload *S3BucketLifecycleManagementRulesItems0AbortIncompleteMultipartUpload `json:"abort_incomplete_multipart_upload,omitempty"`

	// Specifies the name of the bucket. Bucket name is a string that can only contain the following combination of ASCII-range alphanumeric characters 0-9, a-z, ".", and "-".
	// Example: bucket1
	// Max Length: 63
	// Min Length: 3
	BucketName *string `json:"bucket_name,omitempty"`

	// Specifies whether or not the associated rule is enabled.
	Enabled *bool `json:"enabled,omitempty"`

	// expiration
	Expiration *S3BucketLifecycleManagementRulesItems0Expiration `json:"expiration,omitempty"`

	// Bucket lifecycle management rule identifier. The length of the name can range from 0 to 256 characters.
	// Max Length: 256
	// Min Length: 0
	Name *string `json:"name,omitempty"`

	// non current version expiration
	NonCurrentVersionExpiration *S3BucketLifecycleManagementRulesItems0NonCurrentVersionExpiration `json:"non_current_version_expiration,omitempty"`

	// object filter
	ObjectFilter *S3BucketLifecycleManagementRulesItems0ObjectFilter `json:"object_filter,omitempty"`

	// svm
	Svm *S3BucketLifecycleManagementRulesItems0Svm `json:"svm,omitempty"`

	// Specifies the unique identifier of the bucket.
	// Example: 414b29a1-3b26-11e9-bd58-0050568ea055
	// Read Only: true
	// Format: uuid
	UUID *strfmt.UUID `json:"uuid,omitempty"`
}

// Validate validates this s3 bucket lifecycle management rules items0
func (m *S3BucketLifecycleManagementRulesItems0) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateAbortIncompleteMultipartUpload(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateBucketName(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateExpiration(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateName(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateNonCurrentVersionExpiration(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateObjectFilter(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSvm(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateUUID(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *S3BucketLifecycleManagementRulesItems0) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *S3BucketLifecycleManagementRulesItems0) validateAbortIncompleteMultipartUpload(formats strfmt.Registry) error {
	if swag.IsZero(m.AbortIncompleteMultipartUpload) { // not required
		return nil
	}

	if m.AbortIncompleteMultipartUpload != nil {
		if err := m.AbortIncompleteMultipartUpload.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("abort_incomplete_multipart_upload")
			}
			return err
		}
	}

	return nil
}

func (m *S3BucketLifecycleManagementRulesItems0) validateBucketName(formats strfmt.Registry) error {
	if swag.IsZero(m.BucketName) { // not required
		return nil
	}

	if err := validate.MinLength("bucket_name", "body", *m.BucketName, 3); err != nil {
		return err
	}

	if err := validate.MaxLength("bucket_name", "body", *m.BucketName, 63); err != nil {
		return err
	}

	return nil
}

func (m *S3BucketLifecycleManagementRulesItems0) validateExpiration(formats strfmt.Registry) error {
	if swag.IsZero(m.Expiration) { // not required
		return nil
	}

	if m.Expiration != nil {
		if err := m.Expiration.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("expiration")
			}
			return err
		}
	}

	return nil
}

func (m *S3BucketLifecycleManagementRulesItems0) validateName(formats strfmt.Registry) error {
	if swag.IsZero(m.Name) { // not required
		return nil
	}

	if err := validate.MinLength("name", "body", *m.Name, 0); err != nil {
		return err
	}

	if err := validate.MaxLength("name", "body", *m.Name, 256); err != nil {
		return err
	}

	return nil
}

func (m *S3BucketLifecycleManagementRulesItems0) validateNonCurrentVersionExpiration(formats strfmt.Registry) error {
	if swag.IsZero(m.NonCurrentVersionExpiration) { // not required
		return nil
	}

	if m.NonCurrentVersionExpiration != nil {
		if err := m.NonCurrentVersionExpiration.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("non_current_version_expiration")
			}
			return err
		}
	}

	return nil
}

func (m *S3BucketLifecycleManagementRulesItems0) validateObjectFilter(formats strfmt.Registry) error {
	if swag.IsZero(m.ObjectFilter) { // not required
		return nil
	}

	if m.ObjectFilter != nil {
		if err := m.ObjectFilter.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("object_filter")
			}
			return err
		}
	}

	return nil
}

func (m *S3BucketLifecycleManagementRulesItems0) validateSvm(formats strfmt.Registry) error {
	if swag.IsZero(m.Svm) { // not required
		return nil
	}

	if m.Svm != nil {
		if err := m.Svm.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm")
			}
			return err
		}
	}

	return nil
}

func (m *S3BucketLifecycleManagementRulesItems0) validateUUID(formats strfmt.Registry) error {
	if swag.IsZero(m.UUID) { // not required
		return nil
	}

	if err := validate.FormatOf("uuid", "body", "uuid", m.UUID.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this s3 bucket lifecycle management rules items0 based on the context it is used
func (m *S3BucketLifecycleManagementRulesItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateAbortIncompleteMultipartUpload(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateExpiration(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateNonCurrentVersionExpiration(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateObjectFilter(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSvm(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *S3BucketLifecycleManagementRulesItems0) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *S3BucketLifecycleManagementRulesItems0) contextValidateAbortIncompleteMultipartUpload(ctx context.Context, formats strfmt.Registry) error {

	if m.AbortIncompleteMultipartUpload != nil {
		if err := m.AbortIncompleteMultipartUpload.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("abort_incomplete_multipart_upload")
			}
			return err
		}
	}

	return nil
}

func (m *S3BucketLifecycleManagementRulesItems0) contextValidateExpiration(ctx context.Context, formats strfmt.Registry) error {

	if m.Expiration != nil {
		if err := m.Expiration.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("expiration")
			}
			return err
		}
	}

	return nil
}

func (m *S3BucketLifecycleManagementRulesItems0) contextValidateNonCurrentVersionExpiration(ctx context.Context, formats strfmt.Registry) error {

	if m.NonCurrentVersionExpiration != nil {
		if err := m.NonCurrentVersionExpiration.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("non_current_version_expiration")
			}
			return err
		}
	}

	return nil
}

func (m *S3BucketLifecycleManagementRulesItems0) contextValidateObjectFilter(ctx context.Context, formats strfmt.Registry) error {

	if m.ObjectFilter != nil {
		if err := m.ObjectFilter.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("object_filter")
			}
			return err
		}
	}

	return nil
}

func (m *S3BucketLifecycleManagementRulesItems0) contextValidateSvm(ctx context.Context, formats strfmt.Registry) error {

	if m.Svm != nil {
		if err := m.Svm.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm")
			}
			return err
		}
	}

	return nil
}

func (m *S3BucketLifecycleManagementRulesItems0) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "uuid", "body", m.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *S3BucketLifecycleManagementRulesItems0) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *S3BucketLifecycleManagementRulesItems0) UnmarshalBinary(b []byte) error {
	var res S3BucketLifecycleManagementRulesItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// S3BucketLifecycleManagementRulesItems0AbortIncompleteMultipartUpload Specifies a way to perform abort_incomplete_multipart_upload action on filtered objects within a bucket. It cannot be specified with tags.
//
// swagger:model S3BucketLifecycleManagementRulesItems0AbortIncompleteMultipartUpload
type S3BucketLifecycleManagementRulesItems0AbortIncompleteMultipartUpload struct {

	// links
	Links *S3BucketLifecycleManagementRulesItems0AbortIncompleteMultipartUploadLinks `json:"_links,omitempty"`

	// Number of days of initiation after which uploads can be aborted.
	AfterInitiationDays *int64 `json:"after_initiation_days,omitempty"`
}

// Validate validates this s3 bucket lifecycle management rules items0 abort incomplete multipart upload
func (m *S3BucketLifecycleManagementRulesItems0AbortIncompleteMultipartUpload) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *S3BucketLifecycleManagementRulesItems0AbortIncompleteMultipartUpload) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("abort_incomplete_multipart_upload" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this s3 bucket lifecycle management rules items0 abort incomplete multipart upload based on the context it is used
func (m *S3BucketLifecycleManagementRulesItems0AbortIncompleteMultipartUpload) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *S3BucketLifecycleManagementRulesItems0AbortIncompleteMultipartUpload) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("abort_incomplete_multipart_upload" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *S3BucketLifecycleManagementRulesItems0AbortIncompleteMultipartUpload) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *S3BucketLifecycleManagementRulesItems0AbortIncompleteMultipartUpload) UnmarshalBinary(b []byte) error {
	var res S3BucketLifecycleManagementRulesItems0AbortIncompleteMultipartUpload
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// S3BucketLifecycleManagementRulesItems0AbortIncompleteMultipartUploadLinks s3 bucket lifecycle management rules items0 abort incomplete multipart upload links
//
// swagger:model S3BucketLifecycleManagementRulesItems0AbortIncompleteMultipartUploadLinks
type S3BucketLifecycleManagementRulesItems0AbortIncompleteMultipartUploadLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this s3 bucket lifecycle management rules items0 abort incomplete multipart upload links
func (m *S3BucketLifecycleManagementRulesItems0AbortIncompleteMultipartUploadLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *S3BucketLifecycleManagementRulesItems0AbortIncompleteMultipartUploadLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("abort_incomplete_multipart_upload" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this s3 bucket lifecycle management rules items0 abort incomplete multipart upload links based on the context it is used
func (m *S3BucketLifecycleManagementRulesItems0AbortIncompleteMultipartUploadLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *S3BucketLifecycleManagementRulesItems0AbortIncompleteMultipartUploadLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("abort_incomplete_multipart_upload" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *S3BucketLifecycleManagementRulesItems0AbortIncompleteMultipartUploadLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *S3BucketLifecycleManagementRulesItems0AbortIncompleteMultipartUploadLinks) UnmarshalBinary(b []byte) error {
	var res S3BucketLifecycleManagementRulesItems0AbortIncompleteMultipartUploadLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// S3BucketLifecycleManagementRulesItems0Expiration Specifies a way to perform expiration action on filtered objects within a bucket.
//
// swagger:model S3BucketLifecycleManagementRulesItems0Expiration
type S3BucketLifecycleManagementRulesItems0Expiration struct {

	// links
	Links *S3BucketLifecycleManagementRulesItems0ExpirationLinks `json:"_links,omitempty"`

	// Cleanup object delete markers.
	ExpiredObjectDeleteMarker *bool `json:"expired_object_delete_marker,omitempty"`

	// Number of days since creation after which objects can be deleted. This cannot be used along with object_expiry_date.
	// Example: 100
	ObjectAgeDays *int64 `json:"object_age_days,omitempty"`

	// Specific date from when objects can expire. This cannot be used with object_age_days.
	// Example: 2039-09-23 00:00:00+00:00
	// Format: date-time
	ObjectExpiryDate *strfmt.DateTime `json:"object_expiry_date,omitempty"`
}

// Validate validates this s3 bucket lifecycle management rules items0 expiration
func (m *S3BucketLifecycleManagementRulesItems0Expiration) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateObjectExpiryDate(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *S3BucketLifecycleManagementRulesItems0Expiration) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("expiration" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (m *S3BucketLifecycleManagementRulesItems0Expiration) validateObjectExpiryDate(formats strfmt.Registry) error {
	if swag.IsZero(m.ObjectExpiryDate) { // not required
		return nil
	}

	if err := validate.FormatOf("expiration"+"."+"object_expiry_date", "body", "date-time", m.ObjectExpiryDate.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this s3 bucket lifecycle management rules items0 expiration based on the context it is used
func (m *S3BucketLifecycleManagementRulesItems0Expiration) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *S3BucketLifecycleManagementRulesItems0Expiration) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("expiration" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *S3BucketLifecycleManagementRulesItems0Expiration) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *S3BucketLifecycleManagementRulesItems0Expiration) UnmarshalBinary(b []byte) error {
	var res S3BucketLifecycleManagementRulesItems0Expiration
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// S3BucketLifecycleManagementRulesItems0ExpirationLinks s3 bucket lifecycle management rules items0 expiration links
//
// swagger:model S3BucketLifecycleManagementRulesItems0ExpirationLinks
type S3BucketLifecycleManagementRulesItems0ExpirationLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this s3 bucket lifecycle management rules items0 expiration links
func (m *S3BucketLifecycleManagementRulesItems0ExpirationLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *S3BucketLifecycleManagementRulesItems0ExpirationLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("expiration" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this s3 bucket lifecycle management rules items0 expiration links based on the context it is used
func (m *S3BucketLifecycleManagementRulesItems0ExpirationLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *S3BucketLifecycleManagementRulesItems0ExpirationLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("expiration" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *S3BucketLifecycleManagementRulesItems0ExpirationLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *S3BucketLifecycleManagementRulesItems0ExpirationLinks) UnmarshalBinary(b []byte) error {
	var res S3BucketLifecycleManagementRulesItems0ExpirationLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// S3BucketLifecycleManagementRulesItems0Links s3 bucket lifecycle management rules items0 links
//
// swagger:model S3BucketLifecycleManagementRulesItems0Links
type S3BucketLifecycleManagementRulesItems0Links struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this s3 bucket lifecycle management rules items0 links
func (m *S3BucketLifecycleManagementRulesItems0Links) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *S3BucketLifecycleManagementRulesItems0Links) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this s3 bucket lifecycle management rules items0 links based on the context it is used
func (m *S3BucketLifecycleManagementRulesItems0Links) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *S3BucketLifecycleManagementRulesItems0Links) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *S3BucketLifecycleManagementRulesItems0Links) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *S3BucketLifecycleManagementRulesItems0Links) UnmarshalBinary(b []byte) error {
	var res S3BucketLifecycleManagementRulesItems0Links
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// S3BucketLifecycleManagementRulesItems0NonCurrentVersionExpiration Specifies a way to perform non_current_version_expiration action on filtered objects within a bucket.
//
// swagger:model S3BucketLifecycleManagementRulesItems0NonCurrentVersionExpiration
type S3BucketLifecycleManagementRulesItems0NonCurrentVersionExpiration struct {

	// links
	Links *S3BucketLifecycleManagementRulesItems0NonCurrentVersionExpirationLinks `json:"_links,omitempty"`

	// Number of latest non-current versions to be retained.
	NewNonCurrentVersions *int64 `json:"new_non_current_versions,omitempty"`

	// Number of days after which non-current versions can be deleted.
	NonCurrentDays *int64 `json:"non_current_days,omitempty"`
}

// Validate validates this s3 bucket lifecycle management rules items0 non current version expiration
func (m *S3BucketLifecycleManagementRulesItems0NonCurrentVersionExpiration) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *S3BucketLifecycleManagementRulesItems0NonCurrentVersionExpiration) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("non_current_version_expiration" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this s3 bucket lifecycle management rules items0 non current version expiration based on the context it is used
func (m *S3BucketLifecycleManagementRulesItems0NonCurrentVersionExpiration) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *S3BucketLifecycleManagementRulesItems0NonCurrentVersionExpiration) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("non_current_version_expiration" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *S3BucketLifecycleManagementRulesItems0NonCurrentVersionExpiration) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *S3BucketLifecycleManagementRulesItems0NonCurrentVersionExpiration) UnmarshalBinary(b []byte) error {
	var res S3BucketLifecycleManagementRulesItems0NonCurrentVersionExpiration
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// S3BucketLifecycleManagementRulesItems0NonCurrentVersionExpirationLinks s3 bucket lifecycle management rules items0 non current version expiration links
//
// swagger:model S3BucketLifecycleManagementRulesItems0NonCurrentVersionExpirationLinks
type S3BucketLifecycleManagementRulesItems0NonCurrentVersionExpirationLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this s3 bucket lifecycle management rules items0 non current version expiration links
func (m *S3BucketLifecycleManagementRulesItems0NonCurrentVersionExpirationLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *S3BucketLifecycleManagementRulesItems0NonCurrentVersionExpirationLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("non_current_version_expiration" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this s3 bucket lifecycle management rules items0 non current version expiration links based on the context it is used
func (m *S3BucketLifecycleManagementRulesItems0NonCurrentVersionExpirationLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *S3BucketLifecycleManagementRulesItems0NonCurrentVersionExpirationLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("non_current_version_expiration" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *S3BucketLifecycleManagementRulesItems0NonCurrentVersionExpirationLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *S3BucketLifecycleManagementRulesItems0NonCurrentVersionExpirationLinks) UnmarshalBinary(b []byte) error {
	var res S3BucketLifecycleManagementRulesItems0NonCurrentVersionExpirationLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// S3BucketLifecycleManagementRulesItems0ObjectFilter Specifies a way to filter objects within a bucket.
//
// swagger:model S3BucketLifecycleManagementRulesItems0ObjectFilter
type S3BucketLifecycleManagementRulesItems0ObjectFilter struct {

	// links
	Links *S3BucketLifecycleManagementRulesItems0ObjectFilterLinks `json:"_links,omitempty"`

	// A prefix that is matched against object-names within a bucket.
	// Example: /logs
	Prefix *string `json:"prefix,omitempty"`

	// Size of the object greater than specified for which the corresponding lifecycle rule is to be applied.
	// Example: 10240
	SizeGreaterThan *int64 `json:"size_greater_than,omitempty"`

	// Size of the object smaller than specified for which the corresponding lifecycle rule is to be applied.
	// Example: 10485760
	SizeLessThan *int64 `json:"size_less_than,omitempty"`

	// An array of key-value paired tags of the form <tag> or <tag=value>.
	//
	// Example: ["project1=projA","project2=projB"]
	Tags []*string `json:"tags"`
}

// Validate validates this s3 bucket lifecycle management rules items0 object filter
func (m *S3BucketLifecycleManagementRulesItems0ObjectFilter) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *S3BucketLifecycleManagementRulesItems0ObjectFilter) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("object_filter" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this s3 bucket lifecycle management rules items0 object filter based on the context it is used
func (m *S3BucketLifecycleManagementRulesItems0ObjectFilter) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *S3BucketLifecycleManagementRulesItems0ObjectFilter) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("object_filter" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *S3BucketLifecycleManagementRulesItems0ObjectFilter) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *S3BucketLifecycleManagementRulesItems0ObjectFilter) UnmarshalBinary(b []byte) error {
	var res S3BucketLifecycleManagementRulesItems0ObjectFilter
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// S3BucketLifecycleManagementRulesItems0ObjectFilterLinks s3 bucket lifecycle management rules items0 object filter links
//
// swagger:model S3BucketLifecycleManagementRulesItems0ObjectFilterLinks
type S3BucketLifecycleManagementRulesItems0ObjectFilterLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this s3 bucket lifecycle management rules items0 object filter links
func (m *S3BucketLifecycleManagementRulesItems0ObjectFilterLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *S3BucketLifecycleManagementRulesItems0ObjectFilterLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("object_filter" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this s3 bucket lifecycle management rules items0 object filter links based on the context it is used
func (m *S3BucketLifecycleManagementRulesItems0ObjectFilterLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *S3BucketLifecycleManagementRulesItems0ObjectFilterLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("object_filter" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *S3BucketLifecycleManagementRulesItems0ObjectFilterLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *S3BucketLifecycleManagementRulesItems0ObjectFilterLinks) UnmarshalBinary(b []byte) error {
	var res S3BucketLifecycleManagementRulesItems0ObjectFilterLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// S3BucketLifecycleManagementRulesItems0Svm Specifies the name of the SVM where this bucket exists.
//
// swagger:model S3BucketLifecycleManagementRulesItems0Svm
type S3BucketLifecycleManagementRulesItems0Svm struct {

	// links
	Links *S3BucketLifecycleManagementRulesItems0SvmLinks `json:"_links,omitempty"`

	// The name of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: svm1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: 02c9e252-41be-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this s3 bucket lifecycle management rules items0 svm
func (m *S3BucketLifecycleManagementRulesItems0Svm) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *S3BucketLifecycleManagementRulesItems0Svm) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this s3 bucket lifecycle management rules items0 svm based on the context it is used
func (m *S3BucketLifecycleManagementRulesItems0Svm) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *S3BucketLifecycleManagementRulesItems0Svm) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *S3BucketLifecycleManagementRulesItems0Svm) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *S3BucketLifecycleManagementRulesItems0Svm) UnmarshalBinary(b []byte) error {
	var res S3BucketLifecycleManagementRulesItems0Svm
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// S3BucketLifecycleManagementRulesItems0SvmLinks s3 bucket lifecycle management rules items0 svm links
//
// swagger:model S3BucketLifecycleManagementRulesItems0SvmLinks
type S3BucketLifecycleManagementRulesItems0SvmLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this s3 bucket lifecycle management rules items0 svm links
func (m *S3BucketLifecycleManagementRulesItems0SvmLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *S3BucketLifecycleManagementRulesItems0SvmLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this s3 bucket lifecycle management rules items0 svm links based on the context it is used
func (m *S3BucketLifecycleManagementRulesItems0SvmLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *S3BucketLifecycleManagementRulesItems0SvmLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *S3BucketLifecycleManagementRulesItems0SvmLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *S3BucketLifecycleManagementRulesItems0SvmLinks) UnmarshalBinary(b []byte) error {
	var res S3BucketLifecycleManagementRulesItems0SvmLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// S3BucketInlinePolicy A policy is an object associated with a bucket. It defines resource (bucket, folder, or object) permissions. These policies get evaluated when an S3 user makes a request by executing a specific command. The user must be part of the principal (user or group) specified in the policy. Permissions in the policies determine whether the request is allowed or denied.
//
// swagger:model s3_bucket_inline_policy
type S3BucketInlinePolicy struct {

	// Specifies bucket access policy statement.
	Statements []*S3BucketPolicyStatement `json:"statements,omitempty"`
}

// Validate validates this s3 bucket inline policy
func (m *S3BucketInlinePolicy) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateStatements(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *S3BucketInlinePolicy) validateStatements(formats strfmt.Registry) error {
	if swag.IsZero(m.Statements) { // not required
		return nil
	}

	for i := 0; i < len(m.Statements); i++ {
		if swag.IsZero(m.Statements[i]) { // not required
			continue
		}

		if m.Statements[i] != nil {
			if err := m.Statements[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("policy" + "." + "statements" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this s3 bucket inline policy based on the context it is used
func (m *S3BucketInlinePolicy) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateStatements(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *S3BucketInlinePolicy) contextValidateStatements(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.Statements); i++ {

		if m.Statements[i] != nil {
			if err := m.Statements[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("policy" + "." + "statements" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *S3BucketInlinePolicy) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *S3BucketInlinePolicy) UnmarshalBinary(b []byte) error {
	var res S3BucketInlinePolicy
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// S3BucketInlineProtectionStatus Specifies attributes of bucket protection.
//
// swagger:model s3_bucket_inline_protection_status
type S3BucketInlineProtectionStatus struct {

	// destination
	Destination *S3BucketInlineProtectionStatusInlineDestination `json:"destination,omitempty"`

	// Specifies whether a bucket is a source and if it is protected within ONTAP and/or an external cloud. This field cannot be specified using a POST method.
	// Read Only: true
	IsProtected *bool `json:"is_protected,omitempty"`
}

// Validate validates this s3 bucket inline protection status
func (m *S3BucketInlineProtectionStatus) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateDestination(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *S3BucketInlineProtectionStatus) validateDestination(formats strfmt.Registry) error {
	if swag.IsZero(m.Destination) { // not required
		return nil
	}

	if m.Destination != nil {
		if err := m.Destination.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("protection_status" + "." + "destination")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this s3 bucket inline protection status based on the context it is used
func (m *S3BucketInlineProtectionStatus) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateDestination(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIsProtected(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *S3BucketInlineProtectionStatus) contextValidateDestination(ctx context.Context, formats strfmt.Registry) error {

	if m.Destination != nil {
		if err := m.Destination.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("protection_status" + "." + "destination")
			}
			return err
		}
	}

	return nil
}

func (m *S3BucketInlineProtectionStatus) contextValidateIsProtected(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "protection_status"+"."+"is_protected", "body", m.IsProtected); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *S3BucketInlineProtectionStatus) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *S3BucketInlineProtectionStatus) UnmarshalBinary(b []byte) error {
	var res S3BucketInlineProtectionStatus
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// S3BucketInlineProtectionStatusInlineDestination s3 bucket inline protection status inline destination
//
// swagger:model s3_bucket_inline_protection_status_inline_destination
type S3BucketInlineProtectionStatusInlineDestination struct {

	// Specifies whether a bucket is protected within the Cloud. This field cannot be specified using a POST method.
	// Read Only: true
	IsCloud *bool `json:"is_cloud,omitempty"`

	// Specifies whether a bucket is protected on external Cloud providers. This field cannot be specified using a POST method.
	// Read Only: true
	IsExternalCloud *bool `json:"is_external_cloud,omitempty"`

	// Specifies whether a bucket is protected within ONTAP. This field cannot be specified using a POST method.
	// Read Only: true
	IsOntap *bool `json:"is_ontap,omitempty"`
}

// Validate validates this s3 bucket inline protection status inline destination
func (m *S3BucketInlineProtectionStatusInlineDestination) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this s3 bucket inline protection status inline destination based on the context it is used
func (m *S3BucketInlineProtectionStatusInlineDestination) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateIsCloud(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIsExternalCloud(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIsOntap(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *S3BucketInlineProtectionStatusInlineDestination) contextValidateIsCloud(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "protection_status"+"."+"destination"+"."+"is_cloud", "body", m.IsCloud); err != nil {
		return err
	}

	return nil
}

func (m *S3BucketInlineProtectionStatusInlineDestination) contextValidateIsExternalCloud(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "protection_status"+"."+"destination"+"."+"is_external_cloud", "body", m.IsExternalCloud); err != nil {
		return err
	}

	return nil
}

func (m *S3BucketInlineProtectionStatusInlineDestination) contextValidateIsOntap(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "protection_status"+"."+"destination"+"."+"is_ontap", "body", m.IsOntap); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *S3BucketInlineProtectionStatusInlineDestination) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *S3BucketInlineProtectionStatusInlineDestination) UnmarshalBinary(b []byte) error {
	var res S3BucketInlineProtectionStatusInlineDestination
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// S3BucketInlineQosPolicy Specifies "qos_policy.max_throughput_iops" and/or "qos_policy.max_throughput_mbps" or "qos_policy.min_throughput_iops" and/or "qos_policy.min_throughput_mbps". Specifying "min_throughput_iops" or "min_throughput_mbps" is only supported on volumes hosted on a node that is flash optimized. A pre-created QoS policy can also be used by specifying "qos_policy.name" or "qos_policy.uuid" properties. Setting or assigning a QoS policy to a bucket is not supported if its containing volume or SVM already has a QoS policy attached.
//
// swagger:model s3_bucket_inline_qos_policy
type S3BucketInlineQosPolicy struct {

	// links
	Links *S3BucketInlineQosPolicyInlineLinks `json:"_links,omitempty"`

	// Specifies the maximum throughput in Kilobytes per sec, Megabytes per sec or Gigabytes per sec along with or without IOPS. 0 means none. This is mutually exclusive with name and UUID during POST and PATCH. This cannot be set when either max_throughput_mbps or max_throughput_iops are set during POST or PATCH. During GET, the returned value is rounded to the largest unit with a value greater than 1.
	// Example: ["900KB/s","500MB/s","120GB/s","5000IOPS","5000IOPS,500KB/s","2500IOPS,100MB/s","1000IOPS,25MB/s"]
	MaxThroughput *string `json:"max_throughput,omitempty"`

	// Specifies the maximum throughput in IOPS, 0 means none. This is mutually exclusive with name and UUID during POST and PATCH. This cannot be set when max_throughput is set during POST or PATCH.
	// Example: 10000
	// Maximum: 2.147483647e+09
	// Minimum: 0
	MaxThroughputIops *int64 `json:"max_throughput_iops,omitempty"`

	// Specifies the maximum throughput in Megabytes per sec, 0 means none. This is mutually exclusive with name and UUID during POST and PATCH. This cannot be set when max_throughput is set during POST or PATCH.
	// Example: 500
	// Maximum: 4.194303e+06
	// Minimum: 0
	MaxThroughputMbps *int64 `json:"max_throughput_mbps,omitempty"`

	// Specifies the minimum throughput in Kilobytes per sec, Megabytes per sec or Gigabytes per sec along with or without IOPS. 0 means none.Setting "min_throughput" is supported on AFF platforms only, unless FabricPool tiering policies are set. This is mutually exclusive with name and UUID during POST and PATCH. This cannot be set when either min_throughput_mbps or min_throughput_iops are set during POST or PATCH. During GET, the returned value is rounded to the largest unit with a value greater than 1.
	// Example: ["900KB/s","500MB/s","120GB/s","5000IOPS","5000IOPS,500KB/s","2500IOPS,100MB/s","1000IOPS,25MB/s"]
	MinThroughput *string `json:"min_throughput,omitempty"`

	// Specifies the minimum throughput in IOPS, 0 means none. Setting "min_throughput" is supported on AFF platforms only, unless FabricPool tiering policies are set. This is mutually exclusive with name and UUID during POST and PATCH. This cannot be set when min_throughput is set during POST or PATCH.
	// Example: 2000
	// Maximum: 2.147483647e+09
	// Minimum: 0
	MinThroughputIops *int64 `json:"min_throughput_iops,omitempty"`

	// Specifies the minimum throughput in Megabytes per sec, 0 means none. This is mutually exclusive with name and UUID during POST and PATCH.This cannot be set when min_throughput is set during POST or PATCH.
	// Example: 500
	// Maximum: 4.194303e+06
	// Minimum: 0
	MinThroughputMbps *int64 `json:"min_throughput_mbps,omitempty"`

	// The QoS policy group name. This is mutually exclusive with UUID and other QoS attributes during POST and PATCH.
	// Example: performance
	Name *string `json:"name,omitempty"`

	// The QoS policy group UUID. This is mutually exclusive with name and other QoS attributes during POST and PATCH.
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this s3 bucket inline qos policy
func (m *S3BucketInlineQosPolicy) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateMaxThroughputIops(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateMaxThroughputMbps(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateMinThroughputIops(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateMinThroughputMbps(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *S3BucketInlineQosPolicy) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos_policy" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (m *S3BucketInlineQosPolicy) validateMaxThroughputIops(formats strfmt.Registry) error {
	if swag.IsZero(m.MaxThroughputIops) { // not required
		return nil
	}

	if err := validate.MinimumInt("qos_policy"+"."+"max_throughput_iops", "body", *m.MaxThroughputIops, 0, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("qos_policy"+"."+"max_throughput_iops", "body", *m.MaxThroughputIops, 2.147483647e+09, false); err != nil {
		return err
	}

	return nil
}

func (m *S3BucketInlineQosPolicy) validateMaxThroughputMbps(formats strfmt.Registry) error {
	if swag.IsZero(m.MaxThroughputMbps) { // not required
		return nil
	}

	if err := validate.MinimumInt("qos_policy"+"."+"max_throughput_mbps", "body", *m.MaxThroughputMbps, 0, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("qos_policy"+"."+"max_throughput_mbps", "body", *m.MaxThroughputMbps, 4.194303e+06, false); err != nil {
		return err
	}

	return nil
}

func (m *S3BucketInlineQosPolicy) validateMinThroughputIops(formats strfmt.Registry) error {
	if swag.IsZero(m.MinThroughputIops) { // not required
		return nil
	}

	if err := validate.MinimumInt("qos_policy"+"."+"min_throughput_iops", "body", *m.MinThroughputIops, 0, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("qos_policy"+"."+"min_throughput_iops", "body", *m.MinThroughputIops, 2.147483647e+09, false); err != nil {
		return err
	}

	return nil
}

func (m *S3BucketInlineQosPolicy) validateMinThroughputMbps(formats strfmt.Registry) error {
	if swag.IsZero(m.MinThroughputMbps) { // not required
		return nil
	}

	if err := validate.MinimumInt("qos_policy"+"."+"min_throughput_mbps", "body", *m.MinThroughputMbps, 0, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("qos_policy"+"."+"min_throughput_mbps", "body", *m.MinThroughputMbps, 4.194303e+06, false); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this s3 bucket inline qos policy based on the context it is used
func (m *S3BucketInlineQosPolicy) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *S3BucketInlineQosPolicy) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos_policy" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *S3BucketInlineQosPolicy) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *S3BucketInlineQosPolicy) UnmarshalBinary(b []byte) error {
	var res S3BucketInlineQosPolicy
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// S3BucketInlineQosPolicyInlineLinks s3 bucket inline qos policy inline links
//
// swagger:model s3_bucket_inline_qos_policy_inline__links
type S3BucketInlineQosPolicyInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this s3 bucket inline qos policy inline links
func (m *S3BucketInlineQosPolicyInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *S3BucketInlineQosPolicyInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos_policy" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this s3 bucket inline qos policy inline links based on the context it is used
func (m *S3BucketInlineQosPolicyInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *S3BucketInlineQosPolicyInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos_policy" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *S3BucketInlineQosPolicyInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *S3BucketInlineQosPolicyInlineLinks) UnmarshalBinary(b []byte) error {
	var res S3BucketInlineQosPolicyInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// S3BucketInlineRetention Specifies the retention mode and default retention period configured on the bucket.
//
// swagger:model s3_bucket_inline_retention
type S3BucketInlineRetention struct {

	// Specifies the default retention period that is applied to objects while committing them to the WORM state without an associated retention period. The retention period can be in years, or days. The retention period value represents a duration and must be specified in the ISO-8601 duration format.  A period specified for years and days is represented in the ISO-8601 format as "P<num>Y" and "P<num>D" respectively, for example "P10Y" represents a duration of 10 years. The period string must contain only a single time element that is, either years, or days. A duration which combines different periods is not supported, for example "P1Y10D" is not supported.
	// Example: P10Y
	DefaultPeriod *string `json:"default_period,omitempty"`

	// The lock mode of the bucket. <br>compliance &dash; A SnapLock Compliance (SLC) bucket provides the highest level of WORM protection and an administrator cannot destroy a compliance bucket if it contains unexpired WORM objects. <br> governance &dash; An administrator can delete a Governance bucket.<br> no_lock &dash; Indicates the bucket does not support object locking.
	// Example: governance
	// Enum: ["no_lock","compliance","governance"]
	Mode *string `json:"mode,omitempty"`
}

// Validate validates this s3 bucket inline retention
func (m *S3BucketInlineRetention) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateMode(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var s3BucketInlineRetentionTypeModePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["no_lock","compliance","governance"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		s3BucketInlineRetentionTypeModePropEnum = append(s3BucketInlineRetentionTypeModePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// s3_bucket_inline_retention
	// S3BucketInlineRetention
	// mode
	// Mode
	// no_lock
	// END DEBUGGING
	// S3BucketInlineRetentionModeNoLock captures enum value "no_lock"
	S3BucketInlineRetentionModeNoLock string = "no_lock"

	// BEGIN DEBUGGING
	// s3_bucket_inline_retention
	// S3BucketInlineRetention
	// mode
	// Mode
	// compliance
	// END DEBUGGING
	// S3BucketInlineRetentionModeCompliance captures enum value "compliance"
	S3BucketInlineRetentionModeCompliance string = "compliance"

	// BEGIN DEBUGGING
	// s3_bucket_inline_retention
	// S3BucketInlineRetention
	// mode
	// Mode
	// governance
	// END DEBUGGING
	// S3BucketInlineRetentionModeGovernance captures enum value "governance"
	S3BucketInlineRetentionModeGovernance string = "governance"
)

// prop value enum
func (m *S3BucketInlineRetention) validateModeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, s3BucketInlineRetentionTypeModePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *S3BucketInlineRetention) validateMode(formats strfmt.Registry) error {
	if swag.IsZero(m.Mode) { // not required
		return nil
	}

	// value enum
	if err := m.validateModeEnum("retention"+"."+"mode", "body", *m.Mode); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this s3 bucket inline retention based on context it is used
func (m *S3BucketInlineRetention) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *S3BucketInlineRetention) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *S3BucketInlineRetention) UnmarshalBinary(b []byte) error {
	var res S3BucketInlineRetention
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// S3BucketInlineSnapshotPolicy Specifies the bucket snapshot policy.
//
// swagger:model s3_bucket_inline_snapshot_policy
type S3BucketInlineSnapshotPolicy struct {

	// Specifies the name of the snapshot policy.
	// Example: default-1weekly
	Name *string `json:"name,omitempty"`

	// Specifies the unique identifier of the snapshot policy.
	// Example: 3675af31-431c-12fa-114a-20675afebc12
	// Format: uuid
	UUID *strfmt.UUID `json:"uuid,omitempty"`
}

// Validate validates this s3 bucket inline snapshot policy
func (m *S3BucketInlineSnapshotPolicy) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateUUID(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *S3BucketInlineSnapshotPolicy) validateUUID(formats strfmt.Registry) error {
	if swag.IsZero(m.UUID) { // not required
		return nil
	}

	if err := validate.FormatOf("snapshot_policy"+"."+"uuid", "body", "uuid", m.UUID.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this s3 bucket inline snapshot policy based on context it is used
func (m *S3BucketInlineSnapshotPolicy) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *S3BucketInlineSnapshotPolicy) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *S3BucketInlineSnapshotPolicy) UnmarshalBinary(b []byte) error {
	var res S3BucketInlineSnapshotPolicy
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// S3BucketInlineSvm SVM, applies only to SVM-scoped objects.
//
// swagger:model s3_bucket_inline_svm
type S3BucketInlineSvm struct {

	// links
	Links *S3BucketInlineSvmInlineLinks `json:"_links,omitempty"`

	// The name of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: svm1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: 02c9e252-41be-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this s3 bucket inline svm
func (m *S3BucketInlineSvm) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *S3BucketInlineSvm) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this s3 bucket inline svm based on the context it is used
func (m *S3BucketInlineSvm) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *S3BucketInlineSvm) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *S3BucketInlineSvm) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *S3BucketInlineSvm) UnmarshalBinary(b []byte) error {
	var res S3BucketInlineSvm
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// S3BucketInlineSvmInlineLinks s3 bucket inline svm inline links
//
// swagger:model s3_bucket_inline_svm_inline__links
type S3BucketInlineSvmInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this s3 bucket inline svm inline links
func (m *S3BucketInlineSvmInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *S3BucketInlineSvmInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this s3 bucket inline svm inline links based on the context it is used
func (m *S3BucketInlineSvmInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *S3BucketInlineSvmInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *S3BucketInlineSvmInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *S3BucketInlineSvmInlineLinks) UnmarshalBinary(b []byte) error {
	var res S3BucketInlineSvmInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// S3BucketInlineVolume Specifies the FlexGroup volume name and UUID where the bucket is hosted.
//
// swagger:model s3_bucket_inline_volume
type S3BucketInlineVolume struct {

	// links
	Links *S3BucketInlineVolumeInlineLinks `json:"_links,omitempty"`

	// The name of the volume. This field cannot be specified in a PATCH method.
	// Example: volume1
	Name *string `json:"name,omitempty"`

	// Unique identifier for the volume. This corresponds to the instance-uuid that is exposed in the CLI and ONTAPI. It does not change due to a volume move.
	// Example: 028baa66-41bd-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this s3 bucket inline volume
func (m *S3BucketInlineVolume) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *S3BucketInlineVolume) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("volume" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this s3 bucket inline volume based on the context it is used
func (m *S3BucketInlineVolume) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *S3BucketInlineVolume) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("volume" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *S3BucketInlineVolume) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *S3BucketInlineVolume) UnmarshalBinary(b []byte) error {
	var res S3BucketInlineVolume
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// S3BucketInlineVolumeInlineLinks s3 bucket inline volume inline links
//
// swagger:model s3_bucket_inline_volume_inline__links
type S3BucketInlineVolumeInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this s3 bucket inline volume inline links
func (m *S3BucketInlineVolumeInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *S3BucketInlineVolumeInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("volume" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this s3 bucket inline volume inline links based on the context it is used
func (m *S3BucketInlineVolumeInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *S3BucketInlineVolumeInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("volume" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *S3BucketInlineVolumeInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *S3BucketInlineVolumeInlineLinks) UnmarshalBinary(b []byte) error {
	var res S3BucketInlineVolumeInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
