// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// S3BucketCorsRule Information about the CORS rule of an S3 bucket.
//
// swagger:model s3_bucket_cors_rule
type S3BucketCorsRule struct {

	// links
	Links *S3BucketCorsRuleInlineLinks `json:"_links,omitempty"`

	// Bucket CORS rule identifier. The length of the name can range from 0 to 256 characters.
	// Max Length: 256
	// Min Length: 0
	ID *string `json:"id,omitempty"`

	// The time in seconds for your browser to cache the preflight response for the specified resource.
	// Example: 1024
	MaxAgeSeconds *int64 `json:"max_age_seconds,omitempty"`

	// An array of HTTP headers allowed in the cross-origin requests.
	//
	// Example: ["x-amz-request-id"]
	S3BucketCorsRuleInlineAllowedHeaders []*string `json:"allowed_headers,omitempty"`

	// An array of HTTP methods allowed in the cross-origin requests.
	//
	// Example: ["PUT","DELETE"]
	S3BucketCorsRuleInlineAllowedMethods []*string `json:"allowed_methods,omitempty"`

	// List of origins from where a cross-origin request is allowed to originate from for the S3 bucket.
	//
	// Example: ["http://www.example.com"]
	S3BucketCorsRuleInlineAllowedOrigins []*string `json:"allowed_origins,omitempty"`

	// List of extra headers sent in the response that customers can access from their applications.
	//
	// Example: ["x-amz-date"]
	S3BucketCorsRuleInlineExposeHeaders []*string `json:"expose_headers,omitempty"`
}

// Validate validates this s3 bucket cors rule
func (m *S3BucketCorsRule) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateID(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *S3BucketCorsRule) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *S3BucketCorsRule) validateID(formats strfmt.Registry) error {
	if swag.IsZero(m.ID) { // not required
		return nil
	}

	if err := validate.MinLength("id", "body", *m.ID, 0); err != nil {
		return err
	}

	if err := validate.MaxLength("id", "body", *m.ID, 256); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this s3 bucket cors rule based on the context it is used
func (m *S3BucketCorsRule) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *S3BucketCorsRule) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *S3BucketCorsRule) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *S3BucketCorsRule) UnmarshalBinary(b []byte) error {
	var res S3BucketCorsRule
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// S3BucketCorsRuleInlineLinks s3 bucket cors rule inline links
//
// swagger:model s3_bucket_cors_rule_inline__links
type S3BucketCorsRuleInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this s3 bucket cors rule inline links
func (m *S3BucketCorsRuleInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *S3BucketCorsRuleInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this s3 bucket cors rule inline links based on the context it is used
func (m *S3BucketCorsRuleInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *S3BucketCorsRuleInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *S3BucketCorsRuleInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *S3BucketCorsRuleInlineLinks) UnmarshalBinary(b []byte) error {
	var res S3BucketCorsRuleInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
