// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// S3BucketLifecycleObjectFilter Information about the lifecycle management rule of a bucket.
//
// swagger:model s3_bucket_lifecycle_object_filter
type S3BucketLifecycleObjectFilter struct {

	// links
	Links *S3BucketLifecycleObjectFilterInlineLinks `json:"_links,omitempty"`

	// A prefix that is matched against object-names within a bucket.
	// Example: /logs
	Prefix *string `json:"prefix,omitempty"`

	// An array of key-value paired tags of the form <tag> or <tag=value>.
	//
	// Example: ["project1=projA","project2=projB"]
	S3BucketLifecycleObjectFilterInlineTags []*string `json:"tags,omitempty"`

	// Size of the object greater than specified for which the corresponding lifecycle rule is to be applied.
	// Example: 10240
	SizeGreaterThan *int64 `json:"size_greater_than,omitempty"`

	// Size of the object smaller than specified for which the corresponding lifecycle rule is to be applied.
	// Example: 10485760
	SizeLessThan *int64 `json:"size_less_than,omitempty"`
}

// Validate validates this s3 bucket lifecycle object filter
func (m *S3BucketLifecycleObjectFilter) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *S3BucketLifecycleObjectFilter) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this s3 bucket lifecycle object filter based on the context it is used
func (m *S3BucketLifecycleObjectFilter) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *S3BucketLifecycleObjectFilter) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *S3BucketLifecycleObjectFilter) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *S3BucketLifecycleObjectFilter) UnmarshalBinary(b []byte) error {
	var res S3BucketLifecycleObjectFilter
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// S3BucketLifecycleObjectFilterInlineLinks s3 bucket lifecycle object filter inline links
//
// swagger:model s3_bucket_lifecycle_object_filter_inline__links
type S3BucketLifecycleObjectFilterInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this s3 bucket lifecycle object filter inline links
func (m *S3BucketLifecycleObjectFilterInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *S3BucketLifecycleObjectFilterInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this s3 bucket lifecycle object filter inline links based on the context it is used
func (m *S3BucketLifecycleObjectFilterInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *S3BucketLifecycleObjectFilterInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *S3BucketLifecycleObjectFilterInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *S3BucketLifecycleObjectFilterInlineLinks) UnmarshalBinary(b []byte) error {
	var res S3BucketLifecycleObjectFilterInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
