// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// S3BucketRetention Information about the retention-mode and default-retention-period configured on the bucket.
//
// swagger:model s3_bucket_retention
type S3BucketRetention struct {

	// Specifies the default retention period that is applied to objects while committing them to the WORM state without an associated retention period. The retention period can be in years, or days. The retention period value represents a duration and must be specified in the ISO-8601 duration format.  A period specified for years and days is represented in the ISO-8601 format as "P<num>Y" and "P<num>D" respectively, for example "P10Y" represents a duration of 10 years. The period string must contain only a single time element that is, either years, or days. A duration which combines different periods is not supported, for example "P1Y10D" is not supported.
	// Example: P10Y
	DefaultPeriod *string `json:"default_period,omitempty"`

	// The lock mode of the bucket. <br>compliance &dash; A SnapLock Compliance (SLC) bucket provides the highest level of WORM protection and an administrator cannot destroy a compliance bucket if it contains unexpired WORM objects. <br> governance &dash; An administrator can delete a Governance bucket.<br> no_lock &dash; Indicates the bucket does not support object locking.
	// Example: governance
	// Enum: ["no_lock","compliance","governance"]
	Mode *string `json:"mode,omitempty"`
}

// Validate validates this s3 bucket retention
func (m *S3BucketRetention) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateMode(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var s3BucketRetentionTypeModePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["no_lock","compliance","governance"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		s3BucketRetentionTypeModePropEnum = append(s3BucketRetentionTypeModePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// s3_bucket_retention
	// S3BucketRetention
	// mode
	// Mode
	// no_lock
	// END DEBUGGING
	// S3BucketRetentionModeNoLock captures enum value "no_lock"
	S3BucketRetentionModeNoLock string = "no_lock"

	// BEGIN DEBUGGING
	// s3_bucket_retention
	// S3BucketRetention
	// mode
	// Mode
	// compliance
	// END DEBUGGING
	// S3BucketRetentionModeCompliance captures enum value "compliance"
	S3BucketRetentionModeCompliance string = "compliance"

	// BEGIN DEBUGGING
	// s3_bucket_retention
	// S3BucketRetention
	// mode
	// Mode
	// governance
	// END DEBUGGING
	// S3BucketRetentionModeGovernance captures enum value "governance"
	S3BucketRetentionModeGovernance string = "governance"
)

// prop value enum
func (m *S3BucketRetention) validateModeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, s3BucketRetentionTypeModePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *S3BucketRetention) validateMode(formats strfmt.Registry) error {
	if swag.IsZero(m.Mode) { // not required
		return nil
	}

	// value enum
	if err := m.validateModeEnum("mode", "body", *m.Mode); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this s3 bucket retention based on context it is used
func (m *S3BucketRetention) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *S3BucketRetention) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *S3BucketRetention) UnmarshalBinary(b []byte) error {
	var res S3BucketRetention
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
