// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// S3BucketSnapshotResponse s3 bucket snapshot response
//
// swagger:model s3_bucket_snapshot_response
type S3BucketSnapshotResponse struct {

	// links
	Links *CollectionLinks `json:"_links,omitempty"`

	// Number of records
	// Example: 1
	NumRecords *int64 `json:"num_records,omitempty"`

	// s3 bucket snapshot response inline records
	S3BucketSnapshotResponseInlineRecords []*S3BucketSnapshot `json:"records,omitempty"`
}

// Validate validates this s3 bucket snapshot response
func (m *S3BucketSnapshotResponse) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateS3BucketSnapshotResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *S3BucketSnapshotResponse) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *S3BucketSnapshotResponse) validateS3BucketSnapshotResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(m.S3BucketSnapshotResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(m.S3BucketSnapshotResponseInlineRecords); i++ {
		if swag.IsZero(m.S3BucketSnapshotResponseInlineRecords[i]) { // not required
			continue
		}

		if m.S3BucketSnapshotResponseInlineRecords[i] != nil {
			if err := m.S3BucketSnapshotResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this s3 bucket snapshot response based on the context it is used
func (m *S3BucketSnapshotResponse) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateS3BucketSnapshotResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *S3BucketSnapshotResponse) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *S3BucketSnapshotResponse) contextValidateS3BucketSnapshotResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.S3BucketSnapshotResponseInlineRecords); i++ {

		if m.S3BucketSnapshotResponseInlineRecords[i] != nil {
			if err := m.S3BucketSnapshotResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *S3BucketSnapshotResponse) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *S3BucketSnapshotResponse) UnmarshalBinary(b []byte) error {
	var res S3BucketSnapshotResponse
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
