// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// S3BucketSvm A bucket is a container of objects. Each bucket defines an object namespace. S3 requests specify objects using a bucket-name and object-name pair. An object resides within a bucket.
//
// swagger:model s3_bucket_svm
type S3BucketSvm struct {

	// audit event selector
	AuditEventSelector *S3BucketSvmInlineAuditEventSelector `json:"audit_event_selector,omitempty"`

	// Can contain any additional information about the bucket being created or modified.
	// Example: S3 bucket.
	// Max Length: 256
	// Min Length: 0
	Comment *string `json:"comment,omitempty"`

	// Specifies the number of constituents or FlexVol volumes per aggregate. A FlexGroup volume consisting of all such constituents across all specified aggregates is created. This option is used along with the aggregates option and cannot be used independently. This field cannot be set using the PATCH method.
	// Example: 4
	// Maximum: 1000
	// Minimum: 1
	ConstituentsPerAggregate *int64 `json:"constituents_per_aggregate,omitempty"`

	// cors
	Cors *S3BucketSvmInlineCors `json:"cors,omitempty"`

	// encryption
	Encryption *S3BucketSvmInlineEncryption `json:"encryption,omitempty"`

	// Specifies whether the NAS bucket returns a consistent ETag across different S3 requests.
	IsConsistentEtag *bool `json:"is_consistent_etag,omitempty"`

	// Specifies whether the NAS bucket mapping or association with a NAS volume can change according to the changes in the NAS volume junction-path due to volume operations like mount and unmount and therefore the NAS bucket will have access to any path in a NAS volume that matches the specified nas-path. Or is immutable and therefore the NAS bucket will always have access to the same nas-path that was specified during bucket creation even if the volume junction-path has undergone changes after the bucket creation.
	IsNasPathMutable *bool `json:"is_nas_path_mutable,omitempty"`

	// lifecycle management
	LifecycleManagement *S3BucketSvmInlineLifecycleManagement `json:"lifecycle_management,omitempty"`

	// Specifies the bucket logical used size up to this point. This field cannot be set using the PATCH method.
	// Read Only: true
	LogicalUsedSize *int64 `json:"logical_used_size,omitempty"`

	// Specifies the name of the bucket. Bucket name is a string that can only contain the following combination of ASCII-range alphanumeric characters 0-9, a-z, ".", and "-".
	// Example: bucket1
	// Max Length: 63
	// Min Length: 3
	Name *string `json:"name,omitempty"`

	// Specifies the NAS path to which the nas bucket corresponds to.
	// Example: /
	NasPath *string `json:"nas_path,omitempty"`

	// policy
	Policy *S3BucketSvmInlinePolicy `json:"policy,omitempty"`

	// protection status
	ProtectionStatus *S3BucketSvmInlineProtectionStatus `json:"protection_status,omitempty"`

	// qos policy
	QosPolicy *S3BucketSvmInlineQosPolicy `json:"qos_policy,omitempty"`

	// retention
	Retention *S3BucketSvmInlineRetention `json:"retention,omitempty"`

	// Specifies the role of the bucket. This field cannot be set in a POST method.
	// Read Only: true
	// Enum: ["standalone","active","passive"]
	Role *string `json:"role,omitempty"`

	// A list of aggregates for FlexGroup volume constituents where the bucket is hosted. If this option is not specified, the bucket is auto-provisioned as a FlexGroup volume. The "uuid" field cannot be used with the field "storage_service_level".
	S3BucketSvmInlineAggregates []*S3BucketSvmInlineAggregatesInlineArrayItem `json:"aggregates,omitempty"`

	// Specifies the bucket size in bytes; ranges from 190MB to 62PB.
	// Example: 819200000
	// Maximum: 6.2672162783232e+16
	// Minimum: 1.9922944e+08
	Size *int64 `json:"size,omitempty"`

	// snapshot policy
	SnapshotPolicy *S3BucketSvmInlineSnapshotPolicy `json:"snapshot_policy,omitempty"`

	// Specifies the storage service level of the FlexGroup volume on which the bucket should be created. Valid values are "value", "performance" or "extreme". This field cannot be used with the field "aggregates.uuid" or with the "constituents_per_aggregate" in a POST method. This field cannot be set using the PATCH method.
	// Example: value
	// Enum: ["value","performance","extreme"]
	StorageServiceLevel *string `json:"storage_service_level,omitempty"`

	// svm
	Svm *S3BucketSvmInlineSvm `json:"svm,omitempty"`

	// Specifies the bucket type. Valid values are "s3"and "nas". This field cannot be set using the PATCH method.
	// Example: s3
	// Enum: ["s3","nas"]
	Type *string `json:"type,omitempty"`

	// Specifies the unique identifier of the bucket. This field cannot be specified in a POST or PATCH method.
	// Read Only: true
	// Format: uuid
	UUID *strfmt.UUID `json:"uuid,omitempty"`

	// Specifies the versioning state of the bucket. Valid values are "disabled", "enabled" or "suspended". Note that the versioning state cannot be modified to 'disabled' from any other state.
	// Example: enabled
	// Enum: ["disabled","enabled","suspended"]
	VersioningState *string `json:"versioning_state,omitempty"`

	// volume
	Volume *S3BucketSvmInlineVolume `json:"volume,omitempty"`
}

// Validate validates this s3 bucket svm
func (m *S3BucketSvm) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateAuditEventSelector(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateComment(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateConstituentsPerAggregate(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCors(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateEncryption(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLifecycleManagement(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateName(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePolicy(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateProtectionStatus(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateQosPolicy(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateRetention(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateRole(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateS3BucketSvmInlineAggregates(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSize(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSnapshotPolicy(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStorageServiceLevel(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSvm(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateType(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateUUID(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateVersioningState(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateVolume(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *S3BucketSvm) validateAuditEventSelector(formats strfmt.Registry) error {
	if swag.IsZero(m.AuditEventSelector) { // not required
		return nil
	}

	if m.AuditEventSelector != nil {
		if err := m.AuditEventSelector.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("audit_event_selector")
			}
			return err
		}
	}

	return nil
}

func (m *S3BucketSvm) validateComment(formats strfmt.Registry) error {
	if swag.IsZero(m.Comment) { // not required
		return nil
	}

	if err := validate.MinLength("comment", "body", *m.Comment, 0); err != nil {
		return err
	}

	if err := validate.MaxLength("comment", "body", *m.Comment, 256); err != nil {
		return err
	}

	return nil
}

func (m *S3BucketSvm) validateConstituentsPerAggregate(formats strfmt.Registry) error {
	if swag.IsZero(m.ConstituentsPerAggregate) { // not required
		return nil
	}

	if err := validate.MinimumInt("constituents_per_aggregate", "body", *m.ConstituentsPerAggregate, 1, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("constituents_per_aggregate", "body", *m.ConstituentsPerAggregate, 1000, false); err != nil {
		return err
	}

	return nil
}

func (m *S3BucketSvm) validateCors(formats strfmt.Registry) error {
	if swag.IsZero(m.Cors) { // not required
		return nil
	}

	if m.Cors != nil {
		if err := m.Cors.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("cors")
			}
			return err
		}
	}

	return nil
}

func (m *S3BucketSvm) validateEncryption(formats strfmt.Registry) error {
	if swag.IsZero(m.Encryption) { // not required
		return nil
	}

	if m.Encryption != nil {
		if err := m.Encryption.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("encryption")
			}
			return err
		}
	}

	return nil
}

func (m *S3BucketSvm) validateLifecycleManagement(formats strfmt.Registry) error {
	if swag.IsZero(m.LifecycleManagement) { // not required
		return nil
	}

	if m.LifecycleManagement != nil {
		if err := m.LifecycleManagement.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("lifecycle_management")
			}
			return err
		}
	}

	return nil
}

func (m *S3BucketSvm) validateName(formats strfmt.Registry) error {
	if swag.IsZero(m.Name) { // not required
		return nil
	}

	if err := validate.MinLength("name", "body", *m.Name, 3); err != nil {
		return err
	}

	if err := validate.MaxLength("name", "body", *m.Name, 63); err != nil {
		return err
	}

	return nil
}

func (m *S3BucketSvm) validatePolicy(formats strfmt.Registry) error {
	if swag.IsZero(m.Policy) { // not required
		return nil
	}

	if m.Policy != nil {
		if err := m.Policy.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("policy")
			}
			return err
		}
	}

	return nil
}

func (m *S3BucketSvm) validateProtectionStatus(formats strfmt.Registry) error {
	if swag.IsZero(m.ProtectionStatus) { // not required
		return nil
	}

	if m.ProtectionStatus != nil {
		if err := m.ProtectionStatus.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("protection_status")
			}
			return err
		}
	}

	return nil
}

func (m *S3BucketSvm) validateQosPolicy(formats strfmt.Registry) error {
	if swag.IsZero(m.QosPolicy) { // not required
		return nil
	}

	if m.QosPolicy != nil {
		if err := m.QosPolicy.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos_policy")
			}
			return err
		}
	}

	return nil
}

func (m *S3BucketSvm) validateRetention(formats strfmt.Registry) error {
	if swag.IsZero(m.Retention) { // not required
		return nil
	}

	if m.Retention != nil {
		if err := m.Retention.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("retention")
			}
			return err
		}
	}

	return nil
}

var s3BucketSvmTypeRolePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["standalone","active","passive"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		s3BucketSvmTypeRolePropEnum = append(s3BucketSvmTypeRolePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// s3_bucket_svm
	// S3BucketSvm
	// role
	// Role
	// standalone
	// END DEBUGGING
	// S3BucketSvmRoleStandalone captures enum value "standalone"
	S3BucketSvmRoleStandalone string = "standalone"

	// BEGIN DEBUGGING
	// s3_bucket_svm
	// S3BucketSvm
	// role
	// Role
	// active
	// END DEBUGGING
	// S3BucketSvmRoleActive captures enum value "active"
	S3BucketSvmRoleActive string = "active"

	// BEGIN DEBUGGING
	// s3_bucket_svm
	// S3BucketSvm
	// role
	// Role
	// passive
	// END DEBUGGING
	// S3BucketSvmRolePassive captures enum value "passive"
	S3BucketSvmRolePassive string = "passive"
)

// prop value enum
func (m *S3BucketSvm) validateRoleEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, s3BucketSvmTypeRolePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *S3BucketSvm) validateRole(formats strfmt.Registry) error {
	if swag.IsZero(m.Role) { // not required
		return nil
	}

	// value enum
	if err := m.validateRoleEnum("role", "body", *m.Role); err != nil {
		return err
	}

	return nil
}

func (m *S3BucketSvm) validateS3BucketSvmInlineAggregates(formats strfmt.Registry) error {
	if swag.IsZero(m.S3BucketSvmInlineAggregates) { // not required
		return nil
	}

	for i := 0; i < len(m.S3BucketSvmInlineAggregates); i++ {
		if swag.IsZero(m.S3BucketSvmInlineAggregates[i]) { // not required
			continue
		}

		if m.S3BucketSvmInlineAggregates[i] != nil {
			if err := m.S3BucketSvmInlineAggregates[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("aggregates" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *S3BucketSvm) validateSize(formats strfmt.Registry) error {
	if swag.IsZero(m.Size) { // not required
		return nil
	}

	if err := validate.MinimumInt("size", "body", *m.Size, 1.9922944e+08, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("size", "body", *m.Size, 6.2672162783232e+16, false); err != nil {
		return err
	}

	return nil
}

func (m *S3BucketSvm) validateSnapshotPolicy(formats strfmt.Registry) error {
	if swag.IsZero(m.SnapshotPolicy) { // not required
		return nil
	}

	if m.SnapshotPolicy != nil {
		if err := m.SnapshotPolicy.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("snapshot_policy")
			}
			return err
		}
	}

	return nil
}

var s3BucketSvmTypeStorageServiceLevelPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["value","performance","extreme"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		s3BucketSvmTypeStorageServiceLevelPropEnum = append(s3BucketSvmTypeStorageServiceLevelPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// s3_bucket_svm
	// S3BucketSvm
	// storage_service_level
	// StorageServiceLevel
	// value
	// END DEBUGGING
	// S3BucketSvmStorageServiceLevelValue captures enum value "value"
	S3BucketSvmStorageServiceLevelValue string = "value"

	// BEGIN DEBUGGING
	// s3_bucket_svm
	// S3BucketSvm
	// storage_service_level
	// StorageServiceLevel
	// performance
	// END DEBUGGING
	// S3BucketSvmStorageServiceLevelPerformance captures enum value "performance"
	S3BucketSvmStorageServiceLevelPerformance string = "performance"

	// BEGIN DEBUGGING
	// s3_bucket_svm
	// S3BucketSvm
	// storage_service_level
	// StorageServiceLevel
	// extreme
	// END DEBUGGING
	// S3BucketSvmStorageServiceLevelExtreme captures enum value "extreme"
	S3BucketSvmStorageServiceLevelExtreme string = "extreme"
)

// prop value enum
func (m *S3BucketSvm) validateStorageServiceLevelEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, s3BucketSvmTypeStorageServiceLevelPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *S3BucketSvm) validateStorageServiceLevel(formats strfmt.Registry) error {
	if swag.IsZero(m.StorageServiceLevel) { // not required
		return nil
	}

	// value enum
	if err := m.validateStorageServiceLevelEnum("storage_service_level", "body", *m.StorageServiceLevel); err != nil {
		return err
	}

	return nil
}

func (m *S3BucketSvm) validateSvm(formats strfmt.Registry) error {
	if swag.IsZero(m.Svm) { // not required
		return nil
	}

	if m.Svm != nil {
		if err := m.Svm.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm")
			}
			return err
		}
	}

	return nil
}

var s3BucketSvmTypeTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["s3","nas"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		s3BucketSvmTypeTypePropEnum = append(s3BucketSvmTypeTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// s3_bucket_svm
	// S3BucketSvm
	// type
	// Type
	// s3
	// END DEBUGGING
	// S3BucketSvmTypeS3 captures enum value "s3"
	S3BucketSvmTypeS3 string = "s3"

	// BEGIN DEBUGGING
	// s3_bucket_svm
	// S3BucketSvm
	// type
	// Type
	// nas
	// END DEBUGGING
	// S3BucketSvmTypeNas captures enum value "nas"
	S3BucketSvmTypeNas string = "nas"
)

// prop value enum
func (m *S3BucketSvm) validateTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, s3BucketSvmTypeTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *S3BucketSvm) validateType(formats strfmt.Registry) error {
	if swag.IsZero(m.Type) { // not required
		return nil
	}

	// value enum
	if err := m.validateTypeEnum("type", "body", *m.Type); err != nil {
		return err
	}

	return nil
}

func (m *S3BucketSvm) validateUUID(formats strfmt.Registry) error {
	if swag.IsZero(m.UUID) { // not required
		return nil
	}

	if err := validate.FormatOf("uuid", "body", "uuid", m.UUID.String(), formats); err != nil {
		return err
	}

	return nil
}

var s3BucketSvmTypeVersioningStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["disabled","enabled","suspended"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		s3BucketSvmTypeVersioningStatePropEnum = append(s3BucketSvmTypeVersioningStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// s3_bucket_svm
	// S3BucketSvm
	// versioning_state
	// VersioningState
	// disabled
	// END DEBUGGING
	// S3BucketSvmVersioningStateDisabled captures enum value "disabled"
	S3BucketSvmVersioningStateDisabled string = "disabled"

	// BEGIN DEBUGGING
	// s3_bucket_svm
	// S3BucketSvm
	// versioning_state
	// VersioningState
	// enabled
	// END DEBUGGING
	// S3BucketSvmVersioningStateEnabled captures enum value "enabled"
	S3BucketSvmVersioningStateEnabled string = "enabled"

	// BEGIN DEBUGGING
	// s3_bucket_svm
	// S3BucketSvm
	// versioning_state
	// VersioningState
	// suspended
	// END DEBUGGING
	// S3BucketSvmVersioningStateSuspended captures enum value "suspended"
	S3BucketSvmVersioningStateSuspended string = "suspended"
)

// prop value enum
func (m *S3BucketSvm) validateVersioningStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, s3BucketSvmTypeVersioningStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *S3BucketSvm) validateVersioningState(formats strfmt.Registry) error {
	if swag.IsZero(m.VersioningState) { // not required
		return nil
	}

	// value enum
	if err := m.validateVersioningStateEnum("versioning_state", "body", *m.VersioningState); err != nil {
		return err
	}

	return nil
}

func (m *S3BucketSvm) validateVolume(formats strfmt.Registry) error {
	if swag.IsZero(m.Volume) { // not required
		return nil
	}

	if m.Volume != nil {
		if err := m.Volume.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("volume")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this s3 bucket svm based on the context it is used
func (m *S3BucketSvm) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateAuditEventSelector(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateCors(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateEncryption(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLifecycleManagement(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLogicalUsedSize(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidatePolicy(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateProtectionStatus(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateQosPolicy(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateRetention(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateRole(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateS3BucketSvmInlineAggregates(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSnapshotPolicy(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSvm(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateVolume(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *S3BucketSvm) contextValidateAuditEventSelector(ctx context.Context, formats strfmt.Registry) error {

	if m.AuditEventSelector != nil {
		if err := m.AuditEventSelector.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("audit_event_selector")
			}
			return err
		}
	}

	return nil
}

func (m *S3BucketSvm) contextValidateCors(ctx context.Context, formats strfmt.Registry) error {

	if m.Cors != nil {
		if err := m.Cors.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("cors")
			}
			return err
		}
	}

	return nil
}

func (m *S3BucketSvm) contextValidateEncryption(ctx context.Context, formats strfmt.Registry) error {

	if m.Encryption != nil {
		if err := m.Encryption.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("encryption")
			}
			return err
		}
	}

	return nil
}

func (m *S3BucketSvm) contextValidateLifecycleManagement(ctx context.Context, formats strfmt.Registry) error {

	if m.LifecycleManagement != nil {
		if err := m.LifecycleManagement.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("lifecycle_management")
			}
			return err
		}
	}

	return nil
}

func (m *S3BucketSvm) contextValidateLogicalUsedSize(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "logical_used_size", "body", m.LogicalUsedSize); err != nil {
		return err
	}

	return nil
}

func (m *S3BucketSvm) contextValidatePolicy(ctx context.Context, formats strfmt.Registry) error {

	if m.Policy != nil {
		if err := m.Policy.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("policy")
			}
			return err
		}
	}

	return nil
}

func (m *S3BucketSvm) contextValidateProtectionStatus(ctx context.Context, formats strfmt.Registry) error {

	if m.ProtectionStatus != nil {
		if err := m.ProtectionStatus.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("protection_status")
			}
			return err
		}
	}

	return nil
}

func (m *S3BucketSvm) contextValidateQosPolicy(ctx context.Context, formats strfmt.Registry) error {

	if m.QosPolicy != nil {
		if err := m.QosPolicy.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos_policy")
			}
			return err
		}
	}

	return nil
}

func (m *S3BucketSvm) contextValidateRetention(ctx context.Context, formats strfmt.Registry) error {

	if m.Retention != nil {
		if err := m.Retention.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("retention")
			}
			return err
		}
	}

	return nil
}

func (m *S3BucketSvm) contextValidateRole(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "role", "body", m.Role); err != nil {
		return err
	}

	return nil
}

func (m *S3BucketSvm) contextValidateS3BucketSvmInlineAggregates(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.S3BucketSvmInlineAggregates); i++ {

		if m.S3BucketSvmInlineAggregates[i] != nil {
			if err := m.S3BucketSvmInlineAggregates[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("aggregates" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *S3BucketSvm) contextValidateSnapshotPolicy(ctx context.Context, formats strfmt.Registry) error {

	if m.SnapshotPolicy != nil {
		if err := m.SnapshotPolicy.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("snapshot_policy")
			}
			return err
		}
	}

	return nil
}

func (m *S3BucketSvm) contextValidateSvm(ctx context.Context, formats strfmt.Registry) error {

	if m.Svm != nil {
		if err := m.Svm.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm")
			}
			return err
		}
	}

	return nil
}

func (m *S3BucketSvm) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "uuid", "body", m.UUID); err != nil {
		return err
	}

	return nil
}

func (m *S3BucketSvm) contextValidateVolume(ctx context.Context, formats strfmt.Registry) error {

	if m.Volume != nil {
		if err := m.Volume.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("volume")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *S3BucketSvm) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *S3BucketSvm) UnmarshalBinary(b []byte) error {
	var res S3BucketSvm
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// S3BucketSvmInlineAggregatesInlineArrayItem Aggregate
//
// swagger:model s3_bucket_svm_inline_aggregates_inline_array_item
type S3BucketSvmInlineAggregatesInlineArrayItem struct {

	// links
	Links *S3BucketSvmInlineAggregatesInlineArrayItemInlineLinks `json:"_links,omitempty"`

	// name
	// Example: aggr1
	Name *string `json:"name,omitempty"`

	// uuid
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this s3 bucket svm inline aggregates inline array item
func (m *S3BucketSvmInlineAggregatesInlineArrayItem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *S3BucketSvmInlineAggregatesInlineArrayItem) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this s3 bucket svm inline aggregates inline array item based on the context it is used
func (m *S3BucketSvmInlineAggregatesInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *S3BucketSvmInlineAggregatesInlineArrayItem) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *S3BucketSvmInlineAggregatesInlineArrayItem) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *S3BucketSvmInlineAggregatesInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res S3BucketSvmInlineAggregatesInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// S3BucketSvmInlineAggregatesInlineArrayItemInlineLinks s3 bucket svm inline aggregates inline array item inline links
//
// swagger:model s3_bucket_svm_inline_aggregates_inline_array_item_inline__links
type S3BucketSvmInlineAggregatesInlineArrayItemInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this s3 bucket svm inline aggregates inline array item inline links
func (m *S3BucketSvmInlineAggregatesInlineArrayItemInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *S3BucketSvmInlineAggregatesInlineArrayItemInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this s3 bucket svm inline aggregates inline array item inline links based on the context it is used
func (m *S3BucketSvmInlineAggregatesInlineArrayItemInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *S3BucketSvmInlineAggregatesInlineArrayItemInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *S3BucketSvmInlineAggregatesInlineArrayItemInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *S3BucketSvmInlineAggregatesInlineArrayItemInlineLinks) UnmarshalBinary(b []byte) error {
	var res S3BucketSvmInlineAggregatesInlineArrayItemInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// S3BucketSvmInlineAuditEventSelector Event selector allows you to specify access and permission types to audit.
//
// swagger:model s3_bucket_svm_inline_audit_event_selector
type S3BucketSvmInlineAuditEventSelector struct {

	// Specifies read and write access types.
	//
	// Enum: ["read","write","all","none"]
	Access *string `json:"access,omitempty"`

	// Specifies allow and deny permission types.
	//
	// Enum: ["deny","allow","all","none"]
	Permission *string `json:"permission,omitempty"`
}

// Validate validates this s3 bucket svm inline audit event selector
func (m *S3BucketSvmInlineAuditEventSelector) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateAccess(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePermission(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var s3BucketSvmInlineAuditEventSelectorTypeAccessPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["read","write","all","none"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		s3BucketSvmInlineAuditEventSelectorTypeAccessPropEnum = append(s3BucketSvmInlineAuditEventSelectorTypeAccessPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// s3_bucket_svm_inline_audit_event_selector
	// S3BucketSvmInlineAuditEventSelector
	// access
	// Access
	// read
	// END DEBUGGING
	// S3BucketSvmInlineAuditEventSelectorAccessRead captures enum value "read"
	S3BucketSvmInlineAuditEventSelectorAccessRead string = "read"

	// BEGIN DEBUGGING
	// s3_bucket_svm_inline_audit_event_selector
	// S3BucketSvmInlineAuditEventSelector
	// access
	// Access
	// write
	// END DEBUGGING
	// S3BucketSvmInlineAuditEventSelectorAccessWrite captures enum value "write"
	S3BucketSvmInlineAuditEventSelectorAccessWrite string = "write"

	// BEGIN DEBUGGING
	// s3_bucket_svm_inline_audit_event_selector
	// S3BucketSvmInlineAuditEventSelector
	// access
	// Access
	// all
	// END DEBUGGING
	// S3BucketSvmInlineAuditEventSelectorAccessAll captures enum value "all"
	S3BucketSvmInlineAuditEventSelectorAccessAll string = "all"

	// BEGIN DEBUGGING
	// s3_bucket_svm_inline_audit_event_selector
	// S3BucketSvmInlineAuditEventSelector
	// access
	// Access
	// none
	// END DEBUGGING
	// S3BucketSvmInlineAuditEventSelectorAccessNone captures enum value "none"
	S3BucketSvmInlineAuditEventSelectorAccessNone string = "none"
)

// prop value enum
func (m *S3BucketSvmInlineAuditEventSelector) validateAccessEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, s3BucketSvmInlineAuditEventSelectorTypeAccessPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *S3BucketSvmInlineAuditEventSelector) validateAccess(formats strfmt.Registry) error {
	if swag.IsZero(m.Access) { // not required
		return nil
	}

	// value enum
	if err := m.validateAccessEnum("audit_event_selector"+"."+"access", "body", *m.Access); err != nil {
		return err
	}

	return nil
}

var s3BucketSvmInlineAuditEventSelectorTypePermissionPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["deny","allow","all","none"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		s3BucketSvmInlineAuditEventSelectorTypePermissionPropEnum = append(s3BucketSvmInlineAuditEventSelectorTypePermissionPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// s3_bucket_svm_inline_audit_event_selector
	// S3BucketSvmInlineAuditEventSelector
	// permission
	// Permission
	// deny
	// END DEBUGGING
	// S3BucketSvmInlineAuditEventSelectorPermissionDeny captures enum value "deny"
	S3BucketSvmInlineAuditEventSelectorPermissionDeny string = "deny"

	// BEGIN DEBUGGING
	// s3_bucket_svm_inline_audit_event_selector
	// S3BucketSvmInlineAuditEventSelector
	// permission
	// Permission
	// allow
	// END DEBUGGING
	// S3BucketSvmInlineAuditEventSelectorPermissionAllow captures enum value "allow"
	S3BucketSvmInlineAuditEventSelectorPermissionAllow string = "allow"

	// BEGIN DEBUGGING
	// s3_bucket_svm_inline_audit_event_selector
	// S3BucketSvmInlineAuditEventSelector
	// permission
	// Permission
	// all
	// END DEBUGGING
	// S3BucketSvmInlineAuditEventSelectorPermissionAll captures enum value "all"
	S3BucketSvmInlineAuditEventSelectorPermissionAll string = "all"

	// BEGIN DEBUGGING
	// s3_bucket_svm_inline_audit_event_selector
	// S3BucketSvmInlineAuditEventSelector
	// permission
	// Permission
	// none
	// END DEBUGGING
	// S3BucketSvmInlineAuditEventSelectorPermissionNone captures enum value "none"
	S3BucketSvmInlineAuditEventSelectorPermissionNone string = "none"
)

// prop value enum
func (m *S3BucketSvmInlineAuditEventSelector) validatePermissionEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, s3BucketSvmInlineAuditEventSelectorTypePermissionPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *S3BucketSvmInlineAuditEventSelector) validatePermission(formats strfmt.Registry) error {
	if swag.IsZero(m.Permission) { // not required
		return nil
	}

	// value enum
	if err := m.validatePermissionEnum("audit_event_selector"+"."+"permission", "body", *m.Permission); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this s3 bucket svm inline audit event selector based on context it is used
func (m *S3BucketSvmInlineAuditEventSelector) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *S3BucketSvmInlineAuditEventSelector) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *S3BucketSvmInlineAuditEventSelector) UnmarshalBinary(b []byte) error {
	var res S3BucketSvmInlineAuditEventSelector
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// S3BucketSvmInlineCors Cross-origin resource sharing (CORS) specifies an object associated with a bucket. The CORS configuration enables the bucket to service the cross-origin requests. A request might typically come from an origin with a domain that is different to that of the bucket. By configuring a CORS rule, you can define a combination of allowed origins, HTTP headers and methods that a bucket can use to filter out the cross-origin requests that it can service successfully.
//
// swagger:model s3_bucket_svm_inline_cors
type S3BucketSvmInlineCors struct {

	// Specifies an object store bucket CORS rule.
	Rules []*S3BucketSvmCorsRulesItems0 `json:"rules,omitempty"`
}

// Validate validates this s3 bucket svm inline cors
func (m *S3BucketSvmInlineCors) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateRules(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *S3BucketSvmInlineCors) validateRules(formats strfmt.Registry) error {
	if swag.IsZero(m.Rules) { // not required
		return nil
	}

	for i := 0; i < len(m.Rules); i++ {
		if swag.IsZero(m.Rules[i]) { // not required
			continue
		}

		if m.Rules[i] != nil {
			if err := m.Rules[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("cors" + "." + "rules" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this s3 bucket svm inline cors based on the context it is used
func (m *S3BucketSvmInlineCors) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateRules(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *S3BucketSvmInlineCors) contextValidateRules(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.Rules); i++ {

		if m.Rules[i] != nil {
			if err := m.Rules[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("cors" + "." + "rules" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *S3BucketSvmInlineCors) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *S3BucketSvmInlineCors) UnmarshalBinary(b []byte) error {
	var res S3BucketSvmInlineCors
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// S3BucketSvmCorsRulesItems0 Information about the CORS rule of an S3 bucket.
//
// swagger:model S3BucketSvmCorsRulesItems0
type S3BucketSvmCorsRulesItems0 struct {

	// links
	Links *S3BucketSvmCorsRulesItems0Links `json:"_links,omitempty"`

	// An array of HTTP headers allowed in the cross-origin requests.
	//
	// Example: ["x-amz-request-id"]
	AllowedHeaders []*string `json:"allowed_headers"`

	// An array of HTTP methods allowed in the cross-origin requests.
	//
	// Example: ["PUT","DELETE"]
	AllowedMethods []*string `json:"allowed_methods"`

	// List of origins from where a cross-origin request is allowed to originate from for the S3 bucket.
	//
	// Example: ["http://www.example.com"]
	AllowedOrigins []*string `json:"allowed_origins"`

	// List of extra headers sent in the response that customers can access from their applications.
	//
	// Example: ["x-amz-date"]
	ExposeHeaders []*string `json:"expose_headers"`

	// Bucket CORS rule identifier. The length of the name can range from 0 to 256 characters.
	// Max Length: 256
	// Min Length: 0
	ID *string `json:"id,omitempty"`

	// The time in seconds for your browser to cache the preflight response for the specified resource.
	// Example: 1024
	MaxAgeSeconds *int64 `json:"max_age_seconds,omitempty"`
}

// Validate validates this s3 bucket svm cors rules items0
func (m *S3BucketSvmCorsRulesItems0) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateID(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *S3BucketSvmCorsRulesItems0) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *S3BucketSvmCorsRulesItems0) validateID(formats strfmt.Registry) error {
	if swag.IsZero(m.ID) { // not required
		return nil
	}

	if err := validate.MinLength("id", "body", *m.ID, 0); err != nil {
		return err
	}

	if err := validate.MaxLength("id", "body", *m.ID, 256); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this s3 bucket svm cors rules items0 based on the context it is used
func (m *S3BucketSvmCorsRulesItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *S3BucketSvmCorsRulesItems0) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *S3BucketSvmCorsRulesItems0) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *S3BucketSvmCorsRulesItems0) UnmarshalBinary(b []byte) error {
	var res S3BucketSvmCorsRulesItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// S3BucketSvmCorsRulesItems0Links s3 bucket svm cors rules items0 links
//
// swagger:model S3BucketSvmCorsRulesItems0Links
type S3BucketSvmCorsRulesItems0Links struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this s3 bucket svm cors rules items0 links
func (m *S3BucketSvmCorsRulesItems0Links) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *S3BucketSvmCorsRulesItems0Links) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this s3 bucket svm cors rules items0 links based on the context it is used
func (m *S3BucketSvmCorsRulesItems0Links) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *S3BucketSvmCorsRulesItems0Links) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *S3BucketSvmCorsRulesItems0Links) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *S3BucketSvmCorsRulesItems0Links) UnmarshalBinary(b []byte) error {
	var res S3BucketSvmCorsRulesItems0Links
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// S3BucketSvmInlineEncryption s3 bucket svm inline encryption
//
// swagger:model s3_bucket_svm_inline_encryption
type S3BucketSvmInlineEncryption struct {

	// Specifies whether encryption is enabled on the bucket. By default, encryption is disabled on a bucket. This field cannot be set in a POST or PATCH method.
	Enabled *bool `json:"enabled,omitempty"`
}

// Validate validates this s3 bucket svm inline encryption
func (m *S3BucketSvmInlineEncryption) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this s3 bucket svm inline encryption based on the context it is used
func (m *S3BucketSvmInlineEncryption) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *S3BucketSvmInlineEncryption) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *S3BucketSvmInlineEncryption) UnmarshalBinary(b []byte) error {
	var res S3BucketSvmInlineEncryption
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// S3BucketSvmInlineLifecycleManagement Lifecycle management is implemented as an object associated with a bucket. It defines rules to be applied against objects within a bucket. These rules are applied in the background and can delete objects.
//
// swagger:model s3_bucket_svm_inline_lifecycle_management
type S3BucketSvmInlineLifecycleManagement struct {

	// Specifies an object store lifecycle management policy. This field cannot be set using the PATCH method.
	Rules []*S3BucketSvmLifecycleManagementRulesItems0 `json:"rules,omitempty"`
}

// Validate validates this s3 bucket svm inline lifecycle management
func (m *S3BucketSvmInlineLifecycleManagement) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateRules(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *S3BucketSvmInlineLifecycleManagement) validateRules(formats strfmt.Registry) error {
	if swag.IsZero(m.Rules) { // not required
		return nil
	}

	for i := 0; i < len(m.Rules); i++ {
		if swag.IsZero(m.Rules[i]) { // not required
			continue
		}

		if m.Rules[i] != nil {
			if err := m.Rules[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("lifecycle_management" + "." + "rules" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this s3 bucket svm inline lifecycle management based on the context it is used
func (m *S3BucketSvmInlineLifecycleManagement) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateRules(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *S3BucketSvmInlineLifecycleManagement) contextValidateRules(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.Rules); i++ {

		if m.Rules[i] != nil {
			if err := m.Rules[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("lifecycle_management" + "." + "rules" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *S3BucketSvmInlineLifecycleManagement) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *S3BucketSvmInlineLifecycleManagement) UnmarshalBinary(b []byte) error {
	var res S3BucketSvmInlineLifecycleManagement
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// S3BucketSvmLifecycleManagementRulesItems0 Information about the lifecycle management rule of a bucket.
//
// swagger:model S3BucketSvmLifecycleManagementRulesItems0
type S3BucketSvmLifecycleManagementRulesItems0 struct {

	// links
	Links *S3BucketSvmLifecycleManagementRulesItems0Links `json:"_links,omitempty"`

	// abort incomplete multipart upload
	AbortIncompleteMultipartUpload *S3BucketSvmLifecycleManagementRulesItems0AbortIncompleteMultipartUpload `json:"abort_incomplete_multipart_upload,omitempty"`

	// Specifies the name of the bucket. Bucket name is a string that can only contain the following combination of ASCII-range alphanumeric characters 0-9, a-z, ".", and "-".
	// Example: bucket1
	// Max Length: 63
	// Min Length: 3
	BucketName *string `json:"bucket_name,omitempty"`

	// Specifies whether or not the associated rule is enabled.
	Enabled *bool `json:"enabled,omitempty"`

	// expiration
	Expiration *S3BucketSvmLifecycleManagementRulesItems0Expiration `json:"expiration,omitempty"`

	// Bucket lifecycle management rule identifier. The length of the name can range from 0 to 256 characters.
	// Max Length: 256
	// Min Length: 0
	Name *string `json:"name,omitempty"`

	// non current version expiration
	NonCurrentVersionExpiration *S3BucketSvmLifecycleManagementRulesItems0NonCurrentVersionExpiration `json:"non_current_version_expiration,omitempty"`

	// object filter
	ObjectFilter *S3BucketSvmLifecycleManagementRulesItems0ObjectFilter `json:"object_filter,omitempty"`

	// svm
	Svm *S3BucketSvmLifecycleManagementRulesItems0Svm `json:"svm,omitempty"`

	// Specifies the unique identifier of the bucket.
	// Example: 414b29a1-3b26-11e9-bd58-0050568ea055
	// Read Only: true
	// Format: uuid
	UUID *strfmt.UUID `json:"uuid,omitempty"`
}

// Validate validates this s3 bucket svm lifecycle management rules items0
func (m *S3BucketSvmLifecycleManagementRulesItems0) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateAbortIncompleteMultipartUpload(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateBucketName(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateExpiration(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateName(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateNonCurrentVersionExpiration(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateObjectFilter(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSvm(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateUUID(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *S3BucketSvmLifecycleManagementRulesItems0) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *S3BucketSvmLifecycleManagementRulesItems0) validateAbortIncompleteMultipartUpload(formats strfmt.Registry) error {
	if swag.IsZero(m.AbortIncompleteMultipartUpload) { // not required
		return nil
	}

	if m.AbortIncompleteMultipartUpload != nil {
		if err := m.AbortIncompleteMultipartUpload.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("abort_incomplete_multipart_upload")
			}
			return err
		}
	}

	return nil
}

func (m *S3BucketSvmLifecycleManagementRulesItems0) validateBucketName(formats strfmt.Registry) error {
	if swag.IsZero(m.BucketName) { // not required
		return nil
	}

	if err := validate.MinLength("bucket_name", "body", *m.BucketName, 3); err != nil {
		return err
	}

	if err := validate.MaxLength("bucket_name", "body", *m.BucketName, 63); err != nil {
		return err
	}

	return nil
}

func (m *S3BucketSvmLifecycleManagementRulesItems0) validateExpiration(formats strfmt.Registry) error {
	if swag.IsZero(m.Expiration) { // not required
		return nil
	}

	if m.Expiration != nil {
		if err := m.Expiration.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("expiration")
			}
			return err
		}
	}

	return nil
}

func (m *S3BucketSvmLifecycleManagementRulesItems0) validateName(formats strfmt.Registry) error {
	if swag.IsZero(m.Name) { // not required
		return nil
	}

	if err := validate.MinLength("name", "body", *m.Name, 0); err != nil {
		return err
	}

	if err := validate.MaxLength("name", "body", *m.Name, 256); err != nil {
		return err
	}

	return nil
}

func (m *S3BucketSvmLifecycleManagementRulesItems0) validateNonCurrentVersionExpiration(formats strfmt.Registry) error {
	if swag.IsZero(m.NonCurrentVersionExpiration) { // not required
		return nil
	}

	if m.NonCurrentVersionExpiration != nil {
		if err := m.NonCurrentVersionExpiration.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("non_current_version_expiration")
			}
			return err
		}
	}

	return nil
}

func (m *S3BucketSvmLifecycleManagementRulesItems0) validateObjectFilter(formats strfmt.Registry) error {
	if swag.IsZero(m.ObjectFilter) { // not required
		return nil
	}

	if m.ObjectFilter != nil {
		if err := m.ObjectFilter.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("object_filter")
			}
			return err
		}
	}

	return nil
}

func (m *S3BucketSvmLifecycleManagementRulesItems0) validateSvm(formats strfmt.Registry) error {
	if swag.IsZero(m.Svm) { // not required
		return nil
	}

	if m.Svm != nil {
		if err := m.Svm.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm")
			}
			return err
		}
	}

	return nil
}

func (m *S3BucketSvmLifecycleManagementRulesItems0) validateUUID(formats strfmt.Registry) error {
	if swag.IsZero(m.UUID) { // not required
		return nil
	}

	if err := validate.FormatOf("uuid", "body", "uuid", m.UUID.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this s3 bucket svm lifecycle management rules items0 based on the context it is used
func (m *S3BucketSvmLifecycleManagementRulesItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateAbortIncompleteMultipartUpload(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateExpiration(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateNonCurrentVersionExpiration(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateObjectFilter(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSvm(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *S3BucketSvmLifecycleManagementRulesItems0) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *S3BucketSvmLifecycleManagementRulesItems0) contextValidateAbortIncompleteMultipartUpload(ctx context.Context, formats strfmt.Registry) error {

	if m.AbortIncompleteMultipartUpload != nil {
		if err := m.AbortIncompleteMultipartUpload.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("abort_incomplete_multipart_upload")
			}
			return err
		}
	}

	return nil
}

func (m *S3BucketSvmLifecycleManagementRulesItems0) contextValidateExpiration(ctx context.Context, formats strfmt.Registry) error {

	if m.Expiration != nil {
		if err := m.Expiration.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("expiration")
			}
			return err
		}
	}

	return nil
}

func (m *S3BucketSvmLifecycleManagementRulesItems0) contextValidateNonCurrentVersionExpiration(ctx context.Context, formats strfmt.Registry) error {

	if m.NonCurrentVersionExpiration != nil {
		if err := m.NonCurrentVersionExpiration.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("non_current_version_expiration")
			}
			return err
		}
	}

	return nil
}

func (m *S3BucketSvmLifecycleManagementRulesItems0) contextValidateObjectFilter(ctx context.Context, formats strfmt.Registry) error {

	if m.ObjectFilter != nil {
		if err := m.ObjectFilter.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("object_filter")
			}
			return err
		}
	}

	return nil
}

func (m *S3BucketSvmLifecycleManagementRulesItems0) contextValidateSvm(ctx context.Context, formats strfmt.Registry) error {

	if m.Svm != nil {
		if err := m.Svm.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm")
			}
			return err
		}
	}

	return nil
}

func (m *S3BucketSvmLifecycleManagementRulesItems0) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "uuid", "body", m.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *S3BucketSvmLifecycleManagementRulesItems0) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *S3BucketSvmLifecycleManagementRulesItems0) UnmarshalBinary(b []byte) error {
	var res S3BucketSvmLifecycleManagementRulesItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// S3BucketSvmLifecycleManagementRulesItems0AbortIncompleteMultipartUpload Specifies a way to perform abort_incomplete_multipart_upload action on filtered objects within a bucket. It cannot be specified with tags.
//
// swagger:model S3BucketSvmLifecycleManagementRulesItems0AbortIncompleteMultipartUpload
type S3BucketSvmLifecycleManagementRulesItems0AbortIncompleteMultipartUpload struct {

	// links
	Links *S3BucketSvmLifecycleManagementRulesItems0AbortIncompleteMultipartUploadLinks `json:"_links,omitempty"`

	// Number of days of initiation after which uploads can be aborted.
	AfterInitiationDays *int64 `json:"after_initiation_days,omitempty"`
}

// Validate validates this s3 bucket svm lifecycle management rules items0 abort incomplete multipart upload
func (m *S3BucketSvmLifecycleManagementRulesItems0AbortIncompleteMultipartUpload) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *S3BucketSvmLifecycleManagementRulesItems0AbortIncompleteMultipartUpload) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("abort_incomplete_multipart_upload" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this s3 bucket svm lifecycle management rules items0 abort incomplete multipart upload based on the context it is used
func (m *S3BucketSvmLifecycleManagementRulesItems0AbortIncompleteMultipartUpload) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *S3BucketSvmLifecycleManagementRulesItems0AbortIncompleteMultipartUpload) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("abort_incomplete_multipart_upload" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *S3BucketSvmLifecycleManagementRulesItems0AbortIncompleteMultipartUpload) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *S3BucketSvmLifecycleManagementRulesItems0AbortIncompleteMultipartUpload) UnmarshalBinary(b []byte) error {
	var res S3BucketSvmLifecycleManagementRulesItems0AbortIncompleteMultipartUpload
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// S3BucketSvmLifecycleManagementRulesItems0AbortIncompleteMultipartUploadLinks s3 bucket svm lifecycle management rules items0 abort incomplete multipart upload links
//
// swagger:model S3BucketSvmLifecycleManagementRulesItems0AbortIncompleteMultipartUploadLinks
type S3BucketSvmLifecycleManagementRulesItems0AbortIncompleteMultipartUploadLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this s3 bucket svm lifecycle management rules items0 abort incomplete multipart upload links
func (m *S3BucketSvmLifecycleManagementRulesItems0AbortIncompleteMultipartUploadLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *S3BucketSvmLifecycleManagementRulesItems0AbortIncompleteMultipartUploadLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("abort_incomplete_multipart_upload" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this s3 bucket svm lifecycle management rules items0 abort incomplete multipart upload links based on the context it is used
func (m *S3BucketSvmLifecycleManagementRulesItems0AbortIncompleteMultipartUploadLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *S3BucketSvmLifecycleManagementRulesItems0AbortIncompleteMultipartUploadLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("abort_incomplete_multipart_upload" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *S3BucketSvmLifecycleManagementRulesItems0AbortIncompleteMultipartUploadLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *S3BucketSvmLifecycleManagementRulesItems0AbortIncompleteMultipartUploadLinks) UnmarshalBinary(b []byte) error {
	var res S3BucketSvmLifecycleManagementRulesItems0AbortIncompleteMultipartUploadLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// S3BucketSvmLifecycleManagementRulesItems0Expiration Specifies a way to perform expiration action on filtered objects within a bucket.
//
// swagger:model S3BucketSvmLifecycleManagementRulesItems0Expiration
type S3BucketSvmLifecycleManagementRulesItems0Expiration struct {

	// links
	Links *S3BucketSvmLifecycleManagementRulesItems0ExpirationLinks `json:"_links,omitempty"`

	// Cleanup object delete markers.
	ExpiredObjectDeleteMarker *bool `json:"expired_object_delete_marker,omitempty"`

	// Number of days since creation after which objects can be deleted. This cannot be used along with object_expiry_date.
	// Example: 100
	ObjectAgeDays *int64 `json:"object_age_days,omitempty"`

	// Specific date from when objects can expire. This cannot be used with object_age_days.
	// Example: 2039-09-23 00:00:00+00:00
	// Format: date-time
	ObjectExpiryDate *strfmt.DateTime `json:"object_expiry_date,omitempty"`
}

// Validate validates this s3 bucket svm lifecycle management rules items0 expiration
func (m *S3BucketSvmLifecycleManagementRulesItems0Expiration) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateObjectExpiryDate(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *S3BucketSvmLifecycleManagementRulesItems0Expiration) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("expiration" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (m *S3BucketSvmLifecycleManagementRulesItems0Expiration) validateObjectExpiryDate(formats strfmt.Registry) error {
	if swag.IsZero(m.ObjectExpiryDate) { // not required
		return nil
	}

	if err := validate.FormatOf("expiration"+"."+"object_expiry_date", "body", "date-time", m.ObjectExpiryDate.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this s3 bucket svm lifecycle management rules items0 expiration based on the context it is used
func (m *S3BucketSvmLifecycleManagementRulesItems0Expiration) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *S3BucketSvmLifecycleManagementRulesItems0Expiration) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("expiration" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *S3BucketSvmLifecycleManagementRulesItems0Expiration) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *S3BucketSvmLifecycleManagementRulesItems0Expiration) UnmarshalBinary(b []byte) error {
	var res S3BucketSvmLifecycleManagementRulesItems0Expiration
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// S3BucketSvmLifecycleManagementRulesItems0ExpirationLinks s3 bucket svm lifecycle management rules items0 expiration links
//
// swagger:model S3BucketSvmLifecycleManagementRulesItems0ExpirationLinks
type S3BucketSvmLifecycleManagementRulesItems0ExpirationLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this s3 bucket svm lifecycle management rules items0 expiration links
func (m *S3BucketSvmLifecycleManagementRulesItems0ExpirationLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *S3BucketSvmLifecycleManagementRulesItems0ExpirationLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("expiration" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this s3 bucket svm lifecycle management rules items0 expiration links based on the context it is used
func (m *S3BucketSvmLifecycleManagementRulesItems0ExpirationLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *S3BucketSvmLifecycleManagementRulesItems0ExpirationLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("expiration" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *S3BucketSvmLifecycleManagementRulesItems0ExpirationLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *S3BucketSvmLifecycleManagementRulesItems0ExpirationLinks) UnmarshalBinary(b []byte) error {
	var res S3BucketSvmLifecycleManagementRulesItems0ExpirationLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// S3BucketSvmLifecycleManagementRulesItems0Links s3 bucket svm lifecycle management rules items0 links
//
// swagger:model S3BucketSvmLifecycleManagementRulesItems0Links
type S3BucketSvmLifecycleManagementRulesItems0Links struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this s3 bucket svm lifecycle management rules items0 links
func (m *S3BucketSvmLifecycleManagementRulesItems0Links) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *S3BucketSvmLifecycleManagementRulesItems0Links) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this s3 bucket svm lifecycle management rules items0 links based on the context it is used
func (m *S3BucketSvmLifecycleManagementRulesItems0Links) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *S3BucketSvmLifecycleManagementRulesItems0Links) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *S3BucketSvmLifecycleManagementRulesItems0Links) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *S3BucketSvmLifecycleManagementRulesItems0Links) UnmarshalBinary(b []byte) error {
	var res S3BucketSvmLifecycleManagementRulesItems0Links
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// S3BucketSvmLifecycleManagementRulesItems0NonCurrentVersionExpiration Specifies a way to perform non_current_version_expiration action on filtered objects within a bucket.
//
// swagger:model S3BucketSvmLifecycleManagementRulesItems0NonCurrentVersionExpiration
type S3BucketSvmLifecycleManagementRulesItems0NonCurrentVersionExpiration struct {

	// links
	Links *S3BucketSvmLifecycleManagementRulesItems0NonCurrentVersionExpirationLinks `json:"_links,omitempty"`

	// Number of latest non-current versions to be retained.
	NewNonCurrentVersions *int64 `json:"new_non_current_versions,omitempty"`

	// Number of days after which non-current versions can be deleted.
	NonCurrentDays *int64 `json:"non_current_days,omitempty"`
}

// Validate validates this s3 bucket svm lifecycle management rules items0 non current version expiration
func (m *S3BucketSvmLifecycleManagementRulesItems0NonCurrentVersionExpiration) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *S3BucketSvmLifecycleManagementRulesItems0NonCurrentVersionExpiration) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("non_current_version_expiration" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this s3 bucket svm lifecycle management rules items0 non current version expiration based on the context it is used
func (m *S3BucketSvmLifecycleManagementRulesItems0NonCurrentVersionExpiration) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *S3BucketSvmLifecycleManagementRulesItems0NonCurrentVersionExpiration) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("non_current_version_expiration" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *S3BucketSvmLifecycleManagementRulesItems0NonCurrentVersionExpiration) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *S3BucketSvmLifecycleManagementRulesItems0NonCurrentVersionExpiration) UnmarshalBinary(b []byte) error {
	var res S3BucketSvmLifecycleManagementRulesItems0NonCurrentVersionExpiration
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// S3BucketSvmLifecycleManagementRulesItems0NonCurrentVersionExpirationLinks s3 bucket svm lifecycle management rules items0 non current version expiration links
//
// swagger:model S3BucketSvmLifecycleManagementRulesItems0NonCurrentVersionExpirationLinks
type S3BucketSvmLifecycleManagementRulesItems0NonCurrentVersionExpirationLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this s3 bucket svm lifecycle management rules items0 non current version expiration links
func (m *S3BucketSvmLifecycleManagementRulesItems0NonCurrentVersionExpirationLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *S3BucketSvmLifecycleManagementRulesItems0NonCurrentVersionExpirationLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("non_current_version_expiration" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this s3 bucket svm lifecycle management rules items0 non current version expiration links based on the context it is used
func (m *S3BucketSvmLifecycleManagementRulesItems0NonCurrentVersionExpirationLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *S3BucketSvmLifecycleManagementRulesItems0NonCurrentVersionExpirationLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("non_current_version_expiration" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *S3BucketSvmLifecycleManagementRulesItems0NonCurrentVersionExpirationLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *S3BucketSvmLifecycleManagementRulesItems0NonCurrentVersionExpirationLinks) UnmarshalBinary(b []byte) error {
	var res S3BucketSvmLifecycleManagementRulesItems0NonCurrentVersionExpirationLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// S3BucketSvmLifecycleManagementRulesItems0ObjectFilter Specifies a way to filter objects within a bucket.
//
// swagger:model S3BucketSvmLifecycleManagementRulesItems0ObjectFilter
type S3BucketSvmLifecycleManagementRulesItems0ObjectFilter struct {

	// links
	Links *S3BucketSvmLifecycleManagementRulesItems0ObjectFilterLinks `json:"_links,omitempty"`

	// A prefix that is matched against object-names within a bucket.
	// Example: /logs
	Prefix *string `json:"prefix,omitempty"`

	// Size of the object greater than specified for which the corresponding lifecycle rule is to be applied.
	// Example: 10240
	SizeGreaterThan *int64 `json:"size_greater_than,omitempty"`

	// Size of the object smaller than specified for which the corresponding lifecycle rule is to be applied.
	// Example: 10485760
	SizeLessThan *int64 `json:"size_less_than,omitempty"`

	// An array of key-value paired tags of the form <tag> or <tag=value>.
	//
	// Example: ["project1=projA","project2=projB"]
	Tags []*string `json:"tags"`
}

// Validate validates this s3 bucket svm lifecycle management rules items0 object filter
func (m *S3BucketSvmLifecycleManagementRulesItems0ObjectFilter) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *S3BucketSvmLifecycleManagementRulesItems0ObjectFilter) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("object_filter" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this s3 bucket svm lifecycle management rules items0 object filter based on the context it is used
func (m *S3BucketSvmLifecycleManagementRulesItems0ObjectFilter) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *S3BucketSvmLifecycleManagementRulesItems0ObjectFilter) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("object_filter" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *S3BucketSvmLifecycleManagementRulesItems0ObjectFilter) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *S3BucketSvmLifecycleManagementRulesItems0ObjectFilter) UnmarshalBinary(b []byte) error {
	var res S3BucketSvmLifecycleManagementRulesItems0ObjectFilter
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// S3BucketSvmLifecycleManagementRulesItems0ObjectFilterLinks s3 bucket svm lifecycle management rules items0 object filter links
//
// swagger:model S3BucketSvmLifecycleManagementRulesItems0ObjectFilterLinks
type S3BucketSvmLifecycleManagementRulesItems0ObjectFilterLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this s3 bucket svm lifecycle management rules items0 object filter links
func (m *S3BucketSvmLifecycleManagementRulesItems0ObjectFilterLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *S3BucketSvmLifecycleManagementRulesItems0ObjectFilterLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("object_filter" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this s3 bucket svm lifecycle management rules items0 object filter links based on the context it is used
func (m *S3BucketSvmLifecycleManagementRulesItems0ObjectFilterLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *S3BucketSvmLifecycleManagementRulesItems0ObjectFilterLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("object_filter" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *S3BucketSvmLifecycleManagementRulesItems0ObjectFilterLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *S3BucketSvmLifecycleManagementRulesItems0ObjectFilterLinks) UnmarshalBinary(b []byte) error {
	var res S3BucketSvmLifecycleManagementRulesItems0ObjectFilterLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// S3BucketSvmLifecycleManagementRulesItems0Svm Specifies the name of the SVM where this bucket exists.
//
// swagger:model S3BucketSvmLifecycleManagementRulesItems0Svm
type S3BucketSvmLifecycleManagementRulesItems0Svm struct {

	// links
	Links *S3BucketSvmLifecycleManagementRulesItems0SvmLinks `json:"_links,omitempty"`

	// The name of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: svm1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: 02c9e252-41be-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this s3 bucket svm lifecycle management rules items0 svm
func (m *S3BucketSvmLifecycleManagementRulesItems0Svm) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *S3BucketSvmLifecycleManagementRulesItems0Svm) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this s3 bucket svm lifecycle management rules items0 svm based on the context it is used
func (m *S3BucketSvmLifecycleManagementRulesItems0Svm) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *S3BucketSvmLifecycleManagementRulesItems0Svm) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *S3BucketSvmLifecycleManagementRulesItems0Svm) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *S3BucketSvmLifecycleManagementRulesItems0Svm) UnmarshalBinary(b []byte) error {
	var res S3BucketSvmLifecycleManagementRulesItems0Svm
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// S3BucketSvmLifecycleManagementRulesItems0SvmLinks s3 bucket svm lifecycle management rules items0 svm links
//
// swagger:model S3BucketSvmLifecycleManagementRulesItems0SvmLinks
type S3BucketSvmLifecycleManagementRulesItems0SvmLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this s3 bucket svm lifecycle management rules items0 svm links
func (m *S3BucketSvmLifecycleManagementRulesItems0SvmLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *S3BucketSvmLifecycleManagementRulesItems0SvmLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this s3 bucket svm lifecycle management rules items0 svm links based on the context it is used
func (m *S3BucketSvmLifecycleManagementRulesItems0SvmLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *S3BucketSvmLifecycleManagementRulesItems0SvmLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *S3BucketSvmLifecycleManagementRulesItems0SvmLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *S3BucketSvmLifecycleManagementRulesItems0SvmLinks) UnmarshalBinary(b []byte) error {
	var res S3BucketSvmLifecycleManagementRulesItems0SvmLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// S3BucketSvmInlinePolicy A policy is an object associated with a bucket. It defines resource (bucket, folder, or object) permissions. These policies get evaluated when an S3 user makes a request by executing a specific command. The user must be part of the principal (user or group) specified in the policy. Permissions in the policies determine whether the request is allowed or denied.
//
// swagger:model s3_bucket_svm_inline_policy
type S3BucketSvmInlinePolicy struct {

	// Specifies bucket access policy statement.
	Statements []*S3BucketPolicyStatement `json:"statements,omitempty"`
}

// Validate validates this s3 bucket svm inline policy
func (m *S3BucketSvmInlinePolicy) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateStatements(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *S3BucketSvmInlinePolicy) validateStatements(formats strfmt.Registry) error {
	if swag.IsZero(m.Statements) { // not required
		return nil
	}

	for i := 0; i < len(m.Statements); i++ {
		if swag.IsZero(m.Statements[i]) { // not required
			continue
		}

		if m.Statements[i] != nil {
			if err := m.Statements[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("policy" + "." + "statements" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this s3 bucket svm inline policy based on the context it is used
func (m *S3BucketSvmInlinePolicy) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateStatements(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *S3BucketSvmInlinePolicy) contextValidateStatements(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.Statements); i++ {

		if m.Statements[i] != nil {
			if err := m.Statements[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("policy" + "." + "statements" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *S3BucketSvmInlinePolicy) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *S3BucketSvmInlinePolicy) UnmarshalBinary(b []byte) error {
	var res S3BucketSvmInlinePolicy
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// S3BucketSvmInlineProtectionStatus Specifies attributes of bucket protection.
//
// swagger:model s3_bucket_svm_inline_protection_status
type S3BucketSvmInlineProtectionStatus struct {

	// destination
	Destination *S3BucketSvmInlineProtectionStatusInlineDestination `json:"destination,omitempty"`

	// Specifies whether a bucket is a source and if it is protected within ONTAP and/or an external cloud. This field cannot be set in a POST method.
	// Read Only: true
	IsProtected *bool `json:"is_protected,omitempty"`
}

// Validate validates this s3 bucket svm inline protection status
func (m *S3BucketSvmInlineProtectionStatus) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateDestination(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *S3BucketSvmInlineProtectionStatus) validateDestination(formats strfmt.Registry) error {
	if swag.IsZero(m.Destination) { // not required
		return nil
	}

	if m.Destination != nil {
		if err := m.Destination.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("protection_status" + "." + "destination")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this s3 bucket svm inline protection status based on the context it is used
func (m *S3BucketSvmInlineProtectionStatus) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateDestination(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIsProtected(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *S3BucketSvmInlineProtectionStatus) contextValidateDestination(ctx context.Context, formats strfmt.Registry) error {

	if m.Destination != nil {
		if err := m.Destination.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("protection_status" + "." + "destination")
			}
			return err
		}
	}

	return nil
}

func (m *S3BucketSvmInlineProtectionStatus) contextValidateIsProtected(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "protection_status"+"."+"is_protected", "body", m.IsProtected); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *S3BucketSvmInlineProtectionStatus) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *S3BucketSvmInlineProtectionStatus) UnmarshalBinary(b []byte) error {
	var res S3BucketSvmInlineProtectionStatus
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// S3BucketSvmInlineProtectionStatusInlineDestination s3 bucket svm inline protection status inline destination
//
// swagger:model s3_bucket_svm_inline_protection_status_inline_destination
type S3BucketSvmInlineProtectionStatusInlineDestination struct {

	// Specifies whether a bucket is protected within the Cloud.
	// Read Only: true
	IsCloud *bool `json:"is_cloud,omitempty"`

	// Specifies whether a bucket is protected on external Cloud providers.
	// Read Only: true
	IsExternalCloud *bool `json:"is_external_cloud,omitempty"`

	// Specifies whether a bucket is protected within ONTAP.
	// Read Only: true
	IsOntap *bool `json:"is_ontap,omitempty"`
}

// Validate validates this s3 bucket svm inline protection status inline destination
func (m *S3BucketSvmInlineProtectionStatusInlineDestination) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this s3 bucket svm inline protection status inline destination based on the context it is used
func (m *S3BucketSvmInlineProtectionStatusInlineDestination) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateIsCloud(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIsExternalCloud(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIsOntap(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *S3BucketSvmInlineProtectionStatusInlineDestination) contextValidateIsCloud(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "protection_status"+"."+"destination"+"."+"is_cloud", "body", m.IsCloud); err != nil {
		return err
	}

	return nil
}

func (m *S3BucketSvmInlineProtectionStatusInlineDestination) contextValidateIsExternalCloud(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "protection_status"+"."+"destination"+"."+"is_external_cloud", "body", m.IsExternalCloud); err != nil {
		return err
	}

	return nil
}

func (m *S3BucketSvmInlineProtectionStatusInlineDestination) contextValidateIsOntap(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "protection_status"+"."+"destination"+"."+"is_ontap", "body", m.IsOntap); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *S3BucketSvmInlineProtectionStatusInlineDestination) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *S3BucketSvmInlineProtectionStatusInlineDestination) UnmarshalBinary(b []byte) error {
	var res S3BucketSvmInlineProtectionStatusInlineDestination
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// S3BucketSvmInlineQosPolicy Specifies "qos_policy.max_throughput_iops" and/or "qos_policy.max_throughput_mbps" or "qos_policy.min_throughput_iops" and/or "qos_policy.min_throughput_mbps". Specifying "min_throughput_iops" or "min_throughput_mbps" is only supported on volumes hosted on a node that is flash optimized. A pre-created QoS policy can also be used by specifying "qos_policy.name" or "qos_policy.uuid" properties. Setting or assigning a QoS policy to a bucket is not supported if its containing volume or SVM already has a QoS policy attached.
//
// swagger:model s3_bucket_svm_inline_qos_policy
type S3BucketSvmInlineQosPolicy struct {

	// links
	Links *S3BucketSvmInlineQosPolicyInlineLinks `json:"_links,omitempty"`

	// Specifies the maximum throughput in Kilobytes per sec, Megabytes per sec or Gigabytes per sec along with or without IOPS. 0 means none. This is mutually exclusive with name and UUID during POST and PATCH. This cannot be set when either max_throughput_mbps or max_throughput_iops are set during POST or PATCH. During GET, the returned value is rounded to the largest unit with a value greater than 1.
	// Example: ["900KB/s","500MB/s","120GB/s","5000IOPS","5000IOPS,500KB/s","2500IOPS,100MB/s","1000IOPS,25MB/s"]
	MaxThroughput *string `json:"max_throughput,omitempty"`

	// Specifies the maximum throughput in IOPS, 0 means none. This is mutually exclusive with name and UUID during POST and PATCH. This cannot be set when max_throughput is set during POST or PATCH.
	// Example: 10000
	// Maximum: 2.147483647e+09
	// Minimum: 0
	MaxThroughputIops *int64 `json:"max_throughput_iops,omitempty"`

	// Specifies the maximum throughput in Megabytes per sec, 0 means none. This is mutually exclusive with name and UUID during POST and PATCH. This cannot be set when max_throughput is set during POST or PATCH.
	// Example: 500
	// Maximum: 4.194303e+06
	// Minimum: 0
	MaxThroughputMbps *int64 `json:"max_throughput_mbps,omitempty"`

	// Specifies the minimum throughput in Kilobytes per sec, Megabytes per sec or Gigabytes per sec along with or without IOPS. 0 means none.Setting "min_throughput" is supported on AFF platforms only, unless FabricPool tiering policies are set. This is mutually exclusive with name and UUID during POST and PATCH. This cannot be set when either min_throughput_mbps or min_throughput_iops are set during POST or PATCH. During GET, the returned value is rounded to the largest unit with a value greater than 1.
	// Example: ["900KB/s","500MB/s","120GB/s","5000IOPS","5000IOPS,500KB/s","2500IOPS,100MB/s","1000IOPS,25MB/s"]
	MinThroughput *string `json:"min_throughput,omitempty"`

	// Specifies the minimum throughput in IOPS, 0 means none. Setting "min_throughput" is supported on AFF platforms only, unless FabricPool tiering policies are set. This is mutually exclusive with name and UUID during POST and PATCH. This cannot be set when min_throughput is set during POST or PATCH.
	// Example: 2000
	// Maximum: 2.147483647e+09
	// Minimum: 0
	MinThroughputIops *int64 `json:"min_throughput_iops,omitempty"`

	// Specifies the minimum throughput in Megabytes per sec, 0 means none. This is mutually exclusive with name and UUID during POST and PATCH.This cannot be set when min_throughput is set during POST or PATCH.
	// Example: 500
	// Maximum: 4.194303e+06
	// Minimum: 0
	MinThroughputMbps *int64 `json:"min_throughput_mbps,omitempty"`

	// The QoS policy group name. This is mutually exclusive with UUID and other QoS attributes during POST and PATCH.
	// Example: performance
	Name *string `json:"name,omitempty"`

	// The QoS policy group UUID. This is mutually exclusive with name and other QoS attributes during POST and PATCH.
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this s3 bucket svm inline qos policy
func (m *S3BucketSvmInlineQosPolicy) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateMaxThroughputIops(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateMaxThroughputMbps(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateMinThroughputIops(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateMinThroughputMbps(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *S3BucketSvmInlineQosPolicy) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos_policy" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (m *S3BucketSvmInlineQosPolicy) validateMaxThroughputIops(formats strfmt.Registry) error {
	if swag.IsZero(m.MaxThroughputIops) { // not required
		return nil
	}

	if err := validate.MinimumInt("qos_policy"+"."+"max_throughput_iops", "body", *m.MaxThroughputIops, 0, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("qos_policy"+"."+"max_throughput_iops", "body", *m.MaxThroughputIops, 2.147483647e+09, false); err != nil {
		return err
	}

	return nil
}

func (m *S3BucketSvmInlineQosPolicy) validateMaxThroughputMbps(formats strfmt.Registry) error {
	if swag.IsZero(m.MaxThroughputMbps) { // not required
		return nil
	}

	if err := validate.MinimumInt("qos_policy"+"."+"max_throughput_mbps", "body", *m.MaxThroughputMbps, 0, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("qos_policy"+"."+"max_throughput_mbps", "body", *m.MaxThroughputMbps, 4.194303e+06, false); err != nil {
		return err
	}

	return nil
}

func (m *S3BucketSvmInlineQosPolicy) validateMinThroughputIops(formats strfmt.Registry) error {
	if swag.IsZero(m.MinThroughputIops) { // not required
		return nil
	}

	if err := validate.MinimumInt("qos_policy"+"."+"min_throughput_iops", "body", *m.MinThroughputIops, 0, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("qos_policy"+"."+"min_throughput_iops", "body", *m.MinThroughputIops, 2.147483647e+09, false); err != nil {
		return err
	}

	return nil
}

func (m *S3BucketSvmInlineQosPolicy) validateMinThroughputMbps(formats strfmt.Registry) error {
	if swag.IsZero(m.MinThroughputMbps) { // not required
		return nil
	}

	if err := validate.MinimumInt("qos_policy"+"."+"min_throughput_mbps", "body", *m.MinThroughputMbps, 0, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("qos_policy"+"."+"min_throughput_mbps", "body", *m.MinThroughputMbps, 4.194303e+06, false); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this s3 bucket svm inline qos policy based on the context it is used
func (m *S3BucketSvmInlineQosPolicy) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *S3BucketSvmInlineQosPolicy) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos_policy" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *S3BucketSvmInlineQosPolicy) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *S3BucketSvmInlineQosPolicy) UnmarshalBinary(b []byte) error {
	var res S3BucketSvmInlineQosPolicy
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// S3BucketSvmInlineQosPolicyInlineLinks s3 bucket svm inline qos policy inline links
//
// swagger:model s3_bucket_svm_inline_qos_policy_inline__links
type S3BucketSvmInlineQosPolicyInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this s3 bucket svm inline qos policy inline links
func (m *S3BucketSvmInlineQosPolicyInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *S3BucketSvmInlineQosPolicyInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos_policy" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this s3 bucket svm inline qos policy inline links based on the context it is used
func (m *S3BucketSvmInlineQosPolicyInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *S3BucketSvmInlineQosPolicyInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos_policy" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *S3BucketSvmInlineQosPolicyInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *S3BucketSvmInlineQosPolicyInlineLinks) UnmarshalBinary(b []byte) error {
	var res S3BucketSvmInlineQosPolicyInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// S3BucketSvmInlineRetention Specifies the retention mode and default retention period configured on the bucket.
//
// swagger:model s3_bucket_svm_inline_retention
type S3BucketSvmInlineRetention struct {

	// Specifies the default retention period that is applied to objects while committing them to the WORM state without an associated retention period. The retention period can be in years, or days. The retention period value represents a duration and must be specified in the ISO-8601 duration format.  A period specified for years and days is represented in the ISO-8601 format as "P<num>Y" and "P<num>D" respectively, for example "P10Y" represents a duration of 10 years. The period string must contain only a single time element that is, either years, or days. A duration which combines different periods is not supported, for example "P1Y10D" is not supported.
	// Example: P10Y
	DefaultPeriod *string `json:"default_period,omitempty"`

	// The lock mode of the bucket. <br>compliance &dash; A SnapLock Compliance (SLC) bucket provides the highest level of WORM protection and an administrator cannot destroy a compliance bucket if it contains unexpired WORM objects. <br> governance &dash; An administrator can delete a Governance bucket.<br> no_lock &dash; Indicates the bucket does not support object locking.
	// Example: governance
	// Enum: ["no_lock","compliance","governance"]
	Mode *string `json:"mode,omitempty"`
}

// Validate validates this s3 bucket svm inline retention
func (m *S3BucketSvmInlineRetention) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateMode(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var s3BucketSvmInlineRetentionTypeModePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["no_lock","compliance","governance"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		s3BucketSvmInlineRetentionTypeModePropEnum = append(s3BucketSvmInlineRetentionTypeModePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// s3_bucket_svm_inline_retention
	// S3BucketSvmInlineRetention
	// mode
	// Mode
	// no_lock
	// END DEBUGGING
	// S3BucketSvmInlineRetentionModeNoLock captures enum value "no_lock"
	S3BucketSvmInlineRetentionModeNoLock string = "no_lock"

	// BEGIN DEBUGGING
	// s3_bucket_svm_inline_retention
	// S3BucketSvmInlineRetention
	// mode
	// Mode
	// compliance
	// END DEBUGGING
	// S3BucketSvmInlineRetentionModeCompliance captures enum value "compliance"
	S3BucketSvmInlineRetentionModeCompliance string = "compliance"

	// BEGIN DEBUGGING
	// s3_bucket_svm_inline_retention
	// S3BucketSvmInlineRetention
	// mode
	// Mode
	// governance
	// END DEBUGGING
	// S3BucketSvmInlineRetentionModeGovernance captures enum value "governance"
	S3BucketSvmInlineRetentionModeGovernance string = "governance"
)

// prop value enum
func (m *S3BucketSvmInlineRetention) validateModeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, s3BucketSvmInlineRetentionTypeModePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *S3BucketSvmInlineRetention) validateMode(formats strfmt.Registry) error {
	if swag.IsZero(m.Mode) { // not required
		return nil
	}

	// value enum
	if err := m.validateModeEnum("retention"+"."+"mode", "body", *m.Mode); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this s3 bucket svm inline retention based on context it is used
func (m *S3BucketSvmInlineRetention) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *S3BucketSvmInlineRetention) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *S3BucketSvmInlineRetention) UnmarshalBinary(b []byte) error {
	var res S3BucketSvmInlineRetention
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// S3BucketSvmInlineSnapshotPolicy Specifies the bucket snapshot policy.
//
// swagger:model s3_bucket_svm_inline_snapshot_policy
type S3BucketSvmInlineSnapshotPolicy struct {

	// Specifies the name of the snapshot policy.
	// Example: default-1weekly
	Name *string `json:"name,omitempty"`

	// Specifies the unique identifier of the snapshot policy.
	// Example: 3675af31-431c-12fa-114a-20675afebc12
	// Format: uuid
	UUID *strfmt.UUID `json:"uuid,omitempty"`
}

// Validate validates this s3 bucket svm inline snapshot policy
func (m *S3BucketSvmInlineSnapshotPolicy) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateUUID(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *S3BucketSvmInlineSnapshotPolicy) validateUUID(formats strfmt.Registry) error {
	if swag.IsZero(m.UUID) { // not required
		return nil
	}

	if err := validate.FormatOf("snapshot_policy"+"."+"uuid", "body", "uuid", m.UUID.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this s3 bucket svm inline snapshot policy based on context it is used
func (m *S3BucketSvmInlineSnapshotPolicy) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *S3BucketSvmInlineSnapshotPolicy) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *S3BucketSvmInlineSnapshotPolicy) UnmarshalBinary(b []byte) error {
	var res S3BucketSvmInlineSnapshotPolicy
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// S3BucketSvmInlineSvm SVM, applies only to SVM-scoped objects.
//
// swagger:model s3_bucket_svm_inline_svm
type S3BucketSvmInlineSvm struct {

	// links
	Links *S3BucketSvmInlineSvmInlineLinks `json:"_links,omitempty"`

	// The name of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: svm1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: 02c9e252-41be-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this s3 bucket svm inline svm
func (m *S3BucketSvmInlineSvm) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *S3BucketSvmInlineSvm) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this s3 bucket svm inline svm based on the context it is used
func (m *S3BucketSvmInlineSvm) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *S3BucketSvmInlineSvm) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *S3BucketSvmInlineSvm) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *S3BucketSvmInlineSvm) UnmarshalBinary(b []byte) error {
	var res S3BucketSvmInlineSvm
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// S3BucketSvmInlineSvmInlineLinks s3 bucket svm inline svm inline links
//
// swagger:model s3_bucket_svm_inline_svm_inline__links
type S3BucketSvmInlineSvmInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this s3 bucket svm inline svm inline links
func (m *S3BucketSvmInlineSvmInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *S3BucketSvmInlineSvmInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this s3 bucket svm inline svm inline links based on the context it is used
func (m *S3BucketSvmInlineSvmInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *S3BucketSvmInlineSvmInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *S3BucketSvmInlineSvmInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *S3BucketSvmInlineSvmInlineLinks) UnmarshalBinary(b []byte) error {
	var res S3BucketSvmInlineSvmInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// S3BucketSvmInlineVolume Specifies the FlexGroup volume name and UUID where the bucket is hosted. This field cannot be set in a POST method.
//
// swagger:model s3_bucket_svm_inline_volume
type S3BucketSvmInlineVolume struct {

	// links
	Links *S3BucketSvmInlineVolumeInlineLinks `json:"_links,omitempty"`

	// The name of the volume. This field cannot be specified in a PATCH method.
	// Example: volume1
	Name *string `json:"name,omitempty"`

	// Unique identifier for the volume. This corresponds to the instance-uuid that is exposed in the CLI and ONTAPI. It does not change due to a volume move.
	// Example: 028baa66-41bd-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this s3 bucket svm inline volume
func (m *S3BucketSvmInlineVolume) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *S3BucketSvmInlineVolume) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("volume" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this s3 bucket svm inline volume based on the context it is used
func (m *S3BucketSvmInlineVolume) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *S3BucketSvmInlineVolume) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("volume" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *S3BucketSvmInlineVolume) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *S3BucketSvmInlineVolume) UnmarshalBinary(b []byte) error {
	var res S3BucketSvmInlineVolume
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// S3BucketSvmInlineVolumeInlineLinks s3 bucket svm inline volume inline links
//
// swagger:model s3_bucket_svm_inline_volume_inline__links
type S3BucketSvmInlineVolumeInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this s3 bucket svm inline volume inline links
func (m *S3BucketSvmInlineVolumeInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *S3BucketSvmInlineVolumeInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("volume" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this s3 bucket svm inline volume inline links based on the context it is used
func (m *S3BucketSvmInlineVolumeInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *S3BucketSvmInlineVolumeInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("volume" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *S3BucketSvmInlineVolumeInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *S3BucketSvmInlineVolumeInlineLinks) UnmarshalBinary(b []byte) error {
	var res S3BucketSvmInlineVolumeInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
