// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// S3Log s3 log
//
// swagger:model s3_log
type S3Log struct {

	// links
	Links *S3LogInlineLinks `json:"_links,omitempty"`

	// Format in which the logs are generated by the consolidation process.
	//   Possible values are:
	//   * json  - ONTAP-specific Json log format.
	//
	// Enum: ["json"]
	Format *string `json:"format,omitempty"`

	// retention
	Retention *S3LogInlineRetention `json:"retention,omitempty"`

	// rotation
	Rotation *Rotation `json:"rotation,omitempty"`
}

// Validate validates this s3 log
func (m *S3Log) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateFormat(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateRetention(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateRotation(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *S3Log) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

var s3LogTypeFormatPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["json"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		s3LogTypeFormatPropEnum = append(s3LogTypeFormatPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// s3_log
	// S3Log
	// format
	// Format
	// json
	// END DEBUGGING
	// S3LogFormatJSON captures enum value "json"
	S3LogFormatJSON string = "json"
)

// prop value enum
func (m *S3Log) validateFormatEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, s3LogTypeFormatPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *S3Log) validateFormat(formats strfmt.Registry) error {
	if swag.IsZero(m.Format) { // not required
		return nil
	}

	// value enum
	if err := m.validateFormatEnum("format", "body", *m.Format); err != nil {
		return err
	}

	return nil
}

func (m *S3Log) validateRetention(formats strfmt.Registry) error {
	if swag.IsZero(m.Retention) { // not required
		return nil
	}

	if m.Retention != nil {
		if err := m.Retention.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("retention")
			}
			return err
		}
	}

	return nil
}

func (m *S3Log) validateRotation(formats strfmt.Registry) error {
	if swag.IsZero(m.Rotation) { // not required
		return nil
	}

	if m.Rotation != nil {
		if err := m.Rotation.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("rotation")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this s3 log based on the context it is used
func (m *S3Log) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateRetention(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateRotation(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *S3Log) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *S3Log) contextValidateRetention(ctx context.Context, formats strfmt.Registry) error {

	if m.Retention != nil {
		if err := m.Retention.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("retention")
			}
			return err
		}
	}

	return nil
}

func (m *S3Log) contextValidateRotation(ctx context.Context, formats strfmt.Registry) error {

	if m.Rotation != nil {
		if err := m.Rotation.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("rotation")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *S3Log) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *S3Log) UnmarshalBinary(b []byte) error {
	var res S3Log
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// S3LogInlineLinks s3 log inline links
//
// swagger:model s3_log_inline__links
type S3LogInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this s3 log inline links
func (m *S3LogInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *S3LogInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this s3 log inline links based on the context it is used
func (m *S3LogInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *S3LogInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *S3LogInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *S3LogInlineLinks) UnmarshalBinary(b []byte) error {
	var res S3LogInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// S3LogInlineRetention s3 log inline retention
//
// swagger:model s3_log_inline_retention
type S3LogInlineRetention struct {

	// Determines how many audit log files to retain before rotating the
	// oldest log file out. This is mutually exclusive with "duration".
	//
	Count *int64 `json:"count,omitempty"`

	// Specifies an ISO-8601 format date and time to retain the audit log file. The audit log files are
	// deleted once they reach the specified date/time. This is mutually exclusive with "count".
	//
	// Example: P4DT12H30M5S
	Duration *string `json:"duration,omitempty"`
}

// Validate validates this s3 log inline retention
func (m *S3LogInlineRetention) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this s3 log inline retention based on context it is used
func (m *S3LogInlineRetention) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *S3LogInlineRetention) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *S3LogInlineRetention) UnmarshalBinary(b []byte) error {
	var res S3LogInlineRetention
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
