// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// S3ServiceDeleteResponse s3 service delete response
//
// swagger:model s3_service_delete_response
type S3ServiceDeleteResponse struct {

	// Number of Records
	// Example: 1
	NumRecords *int64 `json:"num_records,omitempty"`

	// s3 service delete response inline records
	S3ServiceDeleteResponseInlineRecords []*S3ServiceDeleteResponseInlineRecordsInlineArrayItem `json:"records,omitempty"`
}

// Validate validates this s3 service delete response
func (m *S3ServiceDeleteResponse) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateS3ServiceDeleteResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *S3ServiceDeleteResponse) validateS3ServiceDeleteResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(m.S3ServiceDeleteResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(m.S3ServiceDeleteResponseInlineRecords); i++ {
		if swag.IsZero(m.S3ServiceDeleteResponseInlineRecords[i]) { // not required
			continue
		}

		if m.S3ServiceDeleteResponseInlineRecords[i] != nil {
			if err := m.S3ServiceDeleteResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this s3 service delete response based on the context it is used
func (m *S3ServiceDeleteResponse) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateS3ServiceDeleteResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *S3ServiceDeleteResponse) contextValidateS3ServiceDeleteResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.S3ServiceDeleteResponseInlineRecords); i++ {

		if m.S3ServiceDeleteResponseInlineRecords[i] != nil {
			if err := m.S3ServiceDeleteResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *S3ServiceDeleteResponse) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *S3ServiceDeleteResponse) UnmarshalBinary(b []byte) error {
	var res S3ServiceDeleteResponse
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// S3ServiceDeleteResponseInlineRecordsInlineArrayItem s3 service delete response inline records inline array item
//
// swagger:model s3_service_delete_response_inline_records_inline_array_item
type S3ServiceDeleteResponseInlineRecordsInlineArrayItem struct {

	// job
	Job *JobLink `json:"job,omitempty"`
}

// Validate validates this s3 service delete response inline records inline array item
func (m *S3ServiceDeleteResponseInlineRecordsInlineArrayItem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateJob(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *S3ServiceDeleteResponseInlineRecordsInlineArrayItem) validateJob(formats strfmt.Registry) error {
	if swag.IsZero(m.Job) { // not required
		return nil
	}

	if m.Job != nil {
		if err := m.Job.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("job")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this s3 service delete response inline records inline array item based on the context it is used
func (m *S3ServiceDeleteResponseInlineRecordsInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateJob(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *S3ServiceDeleteResponseInlineRecordsInlineArrayItem) contextValidateJob(ctx context.Context, formats strfmt.Registry) error {

	if m.Job != nil {
		if err := m.Job.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("job")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *S3ServiceDeleteResponseInlineRecordsInlineArrayItem) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *S3ServiceDeleteResponseInlineRecordsInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res S3ServiceDeleteResponseInlineRecordsInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
