// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// S3ServicePostResponse s3 service post response
//
// swagger:model s3_service_post_response
type S3ServicePostResponse struct {

	// Number of Records
	// Example: 1
	NumRecords *int64 `json:"num_records,omitempty"`

	// s3 service post response inline records
	S3ServicePostResponseInlineRecords []*S3ServicePostResponseInlineRecordsInlineArrayItem `json:"records,omitempty"`
}

// Validate validates this s3 service post response
func (m *S3ServicePostResponse) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateS3ServicePostResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *S3ServicePostResponse) validateS3ServicePostResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(m.S3ServicePostResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(m.S3ServicePostResponseInlineRecords); i++ {
		if swag.IsZero(m.S3ServicePostResponseInlineRecords[i]) { // not required
			continue
		}

		if m.S3ServicePostResponseInlineRecords[i] != nil {
			if err := m.S3ServicePostResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this s3 service post response based on the context it is used
func (m *S3ServicePostResponse) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateS3ServicePostResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *S3ServicePostResponse) contextValidateS3ServicePostResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.S3ServicePostResponseInlineRecords); i++ {

		if m.S3ServicePostResponseInlineRecords[i] != nil {
			if err := m.S3ServicePostResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *S3ServicePostResponse) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *S3ServicePostResponse) UnmarshalBinary(b []byte) error {
	var res S3ServicePostResponse
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// S3ServicePostResponseInlineRecordsInlineArrayItem s3 service post response inline records inline array item
//
// swagger:model s3_service_post_response_inline_records_inline_array_item
type S3ServicePostResponseInlineRecordsInlineArrayItem struct {

	// links
	Links *CollectionLinks `json:"_links,omitempty"`

	// job
	Job *JobLink `json:"job,omitempty"`

	// users
	Users []*S3ServiceUserPostResponse `json:"users"`

	// warning
	Warning *S3ServicePostResponseInlineRecordsInlineArrayItemInlineWarning `json:"warning,omitempty"`
}

// Validate validates this s3 service post response inline records inline array item
func (m *S3ServicePostResponseInlineRecordsInlineArrayItem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateJob(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateUsers(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateWarning(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *S3ServicePostResponseInlineRecordsInlineArrayItem) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *S3ServicePostResponseInlineRecordsInlineArrayItem) validateJob(formats strfmt.Registry) error {
	if swag.IsZero(m.Job) { // not required
		return nil
	}

	if m.Job != nil {
		if err := m.Job.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("job")
			}
			return err
		}
	}

	return nil
}

func (m *S3ServicePostResponseInlineRecordsInlineArrayItem) validateUsers(formats strfmt.Registry) error {
	if swag.IsZero(m.Users) { // not required
		return nil
	}

	for i := 0; i < len(m.Users); i++ {
		if swag.IsZero(m.Users[i]) { // not required
			continue
		}

		if m.Users[i] != nil {
			if err := m.Users[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("users" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *S3ServicePostResponseInlineRecordsInlineArrayItem) validateWarning(formats strfmt.Registry) error {
	if swag.IsZero(m.Warning) { // not required
		return nil
	}

	if m.Warning != nil {
		if err := m.Warning.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("warning")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this s3 service post response inline records inline array item based on the context it is used
func (m *S3ServicePostResponseInlineRecordsInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateJob(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUsers(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateWarning(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *S3ServicePostResponseInlineRecordsInlineArrayItem) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *S3ServicePostResponseInlineRecordsInlineArrayItem) contextValidateJob(ctx context.Context, formats strfmt.Registry) error {

	if m.Job != nil {
		if err := m.Job.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("job")
			}
			return err
		}
	}

	return nil
}

func (m *S3ServicePostResponseInlineRecordsInlineArrayItem) contextValidateUsers(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.Users); i++ {

		if m.Users[i] != nil {
			if err := m.Users[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("users" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *S3ServicePostResponseInlineRecordsInlineArrayItem) contextValidateWarning(ctx context.Context, formats strfmt.Registry) error {

	if m.Warning != nil {
		if err := m.Warning.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("warning")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *S3ServicePostResponseInlineRecordsInlineArrayItem) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *S3ServicePostResponseInlineRecordsInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res S3ServicePostResponseInlineRecordsInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// S3ServicePostResponseInlineRecordsInlineArrayItemInlineWarning Specifies a warning message sent from the S3 server during a POST or PATCH operation.
//
// swagger:model s3_service_post_response_inline_records_inline_array_item_inline_warning
type S3ServicePostResponseInlineRecordsInlineArrayItemInlineWarning struct {

	// Warning code of the warning encountered.
	Code *int64 `json:"code,omitempty"`

	// Details of the warning sent from the S3 server.
	Message *string `json:"message,omitempty"`
}

// Validate validates this s3 service post response inline records inline array item inline warning
func (m *S3ServicePostResponseInlineRecordsInlineArrayItemInlineWarning) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this s3 service post response inline records inline array item inline warning based on context it is used
func (m *S3ServicePostResponseInlineRecordsInlineArrayItemInlineWarning) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *S3ServicePostResponseInlineRecordsInlineArrayItemInlineWarning) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *S3ServicePostResponseInlineRecordsInlineArrayItemInlineWarning) UnmarshalBinary(b []byte) error {
	var res S3ServicePostResponseInlineRecordsInlineArrayItemInlineWarning
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
