// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// S3ServiceUserPostResponse s3 service user post response
//
// swagger:model s3_service_user_post_response
type S3ServiceUserPostResponse struct {

	// links
	Links *CollectionLinks `json:"_links,omitempty"`

	// Specifies the access key for the user.
	// Example: HJAKU28M3SXTE2UXUACV
	// Read Only: true
	AccessKey *string `json:"access_key,omitempty"`

	// Specifies the date and time after which the keys expire and are no longer valid.
	// Example: 2024-01-01 00:00:00+00:00
	// Read Only: true
	// Format: date-time
	KeyExpiryTime *strfmt.DateTime `json:"key_expiry_time,omitempty"`

	// The name of the user.
	// Example: user-1
	// Read Only: true
	Name *string `json:"name,omitempty"`

	// Specifies the secret key for the user.
	// Example: BcA_HX6If458llhnx3n1TCO3mg4roCXG0ddYf_cJ
	// Read Only: true
	SecretKey *string `json:"secret_key,omitempty"`
}

// Validate validates this s3 service user post response
func (m *S3ServiceUserPostResponse) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateKeyExpiryTime(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *S3ServiceUserPostResponse) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *S3ServiceUserPostResponse) validateKeyExpiryTime(formats strfmt.Registry) error {
	if swag.IsZero(m.KeyExpiryTime) { // not required
		return nil
	}

	if err := validate.FormatOf("key_expiry_time", "body", "date-time", m.KeyExpiryTime.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this s3 service user post response based on the context it is used
func (m *S3ServiceUserPostResponse) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateAccessKey(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateKeyExpiryTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateName(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSecretKey(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *S3ServiceUserPostResponse) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *S3ServiceUserPostResponse) contextValidateAccessKey(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "access_key", "body", m.AccessKey); err != nil {
		return err
	}

	return nil
}

func (m *S3ServiceUserPostResponse) contextValidateKeyExpiryTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "key_expiry_time", "body", m.KeyExpiryTime); err != nil {
		return err
	}

	return nil
}

func (m *S3ServiceUserPostResponse) contextValidateName(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "name", "body", m.Name); err != nil {
		return err
	}

	return nil
}

func (m *S3ServiceUserPostResponse) contextValidateSecretKey(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "secret_key", "body", m.SecretKey); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *S3ServiceUserPostResponse) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *S3ServiceUserPostResponse) UnmarshalBinary(b []byte) error {
	var res S3ServiceUserPostResponse
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
