// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// S3UserPostPatchResponse s3 user post patch response
//
// swagger:model s3_user_post_patch_response
type S3UserPostPatchResponse struct {

	// Number of records
	// Example: 1
	NumRecords *int64 `json:"num_records,omitempty"`

	// s3 user post patch response inline records
	S3UserPostPatchResponseInlineRecords []*S3ServiceUserPostResponse `json:"records,omitempty"`
}

// Validate validates this s3 user post patch response
func (m *S3UserPostPatchResponse) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateS3UserPostPatchResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *S3UserPostPatchResponse) validateS3UserPostPatchResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(m.S3UserPostPatchResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(m.S3UserPostPatchResponseInlineRecords); i++ {
		if swag.IsZero(m.S3UserPostPatchResponseInlineRecords[i]) { // not required
			continue
		}

		if m.S3UserPostPatchResponseInlineRecords[i] != nil {
			if err := m.S3UserPostPatchResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this s3 user post patch response based on the context it is used
func (m *S3UserPostPatchResponse) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateS3UserPostPatchResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *S3UserPostPatchResponse) contextValidateS3UserPostPatchResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.S3UserPostPatchResponseInlineRecords); i++ {

		if m.S3UserPostPatchResponseInlineRecords[i] != nil {
			if err := m.S3UserPostPatchResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *S3UserPostPatchResponse) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *S3UserPostPatchResponse) UnmarshalBinary(b []byte) error {
	var res S3UserPostPatchResponse
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
