// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// San A generic SAN application.
//
// swagger:model san
type San struct {

	// The name of the host OS running the application.
	// Enum: ["aix","hpux","hyper_v","linux","netware","openvms","solaris","solaris_efi","vmware","windows","windows_2008","windows_gpt","xen"]
	OsType *string `json:"os_type,omitempty"`

	// protection type
	ProtectionType *SanInlineProtectionType `json:"protection_type,omitempty"`

	// san inline application components
	// Required: true
	// Max Items: 10
	// Min Items: 1
	SanInlineApplicationComponents []*SanInlineApplicationComponentsInlineArrayItem `json:"application_components"`

	// san inline exclude aggregates
	SanInlineExcludeAggregates []*SanInlineExcludeAggregatesInlineArrayItem `json:"exclude_aggregates,omitempty"`

	// The list of initiator groups to create.
	// Max Items: 10
	// Min Items: 0
	SanInlineNewIgroups []*SanNewIgroups `json:"new_igroups,omitempty"`
}

// Validate validates this san
func (m *San) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateOsType(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateProtectionType(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSanInlineApplicationComponents(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSanInlineExcludeAggregates(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSanInlineNewIgroups(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var sanTypeOsTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["aix","hpux","hyper_v","linux","netware","openvms","solaris","solaris_efi","vmware","windows","windows_2008","windows_gpt","xen"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		sanTypeOsTypePropEnum = append(sanTypeOsTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// san
	// San
	// os_type
	// OsType
	// aix
	// END DEBUGGING
	// SanOsTypeAix captures enum value "aix"
	SanOsTypeAix string = "aix"

	// BEGIN DEBUGGING
	// san
	// San
	// os_type
	// OsType
	// hpux
	// END DEBUGGING
	// SanOsTypeHpux captures enum value "hpux"
	SanOsTypeHpux string = "hpux"

	// BEGIN DEBUGGING
	// san
	// San
	// os_type
	// OsType
	// hyper_v
	// END DEBUGGING
	// SanOsTypeHyperv captures enum value "hyper_v"
	SanOsTypeHyperv string = "hyper_v"

	// BEGIN DEBUGGING
	// san
	// San
	// os_type
	// OsType
	// linux
	// END DEBUGGING
	// SanOsTypeLinux captures enum value "linux"
	SanOsTypeLinux string = "linux"

	// BEGIN DEBUGGING
	// san
	// San
	// os_type
	// OsType
	// netware
	// END DEBUGGING
	// SanOsTypeNetware captures enum value "netware"
	SanOsTypeNetware string = "netware"

	// BEGIN DEBUGGING
	// san
	// San
	// os_type
	// OsType
	// openvms
	// END DEBUGGING
	// SanOsTypeOpenvms captures enum value "openvms"
	SanOsTypeOpenvms string = "openvms"

	// BEGIN DEBUGGING
	// san
	// San
	// os_type
	// OsType
	// solaris
	// END DEBUGGING
	// SanOsTypeSolaris captures enum value "solaris"
	SanOsTypeSolaris string = "solaris"

	// BEGIN DEBUGGING
	// san
	// San
	// os_type
	// OsType
	// solaris_efi
	// END DEBUGGING
	// SanOsTypeSolarisEfi captures enum value "solaris_efi"
	SanOsTypeSolarisEfi string = "solaris_efi"

	// BEGIN DEBUGGING
	// san
	// San
	// os_type
	// OsType
	// vmware
	// END DEBUGGING
	// SanOsTypeVmware captures enum value "vmware"
	SanOsTypeVmware string = "vmware"

	// BEGIN DEBUGGING
	// san
	// San
	// os_type
	// OsType
	// windows
	// END DEBUGGING
	// SanOsTypeWindows captures enum value "windows"
	SanOsTypeWindows string = "windows"

	// BEGIN DEBUGGING
	// san
	// San
	// os_type
	// OsType
	// windows_2008
	// END DEBUGGING
	// SanOsTypeWindows2008 captures enum value "windows_2008"
	SanOsTypeWindows2008 string = "windows_2008"

	// BEGIN DEBUGGING
	// san
	// San
	// os_type
	// OsType
	// windows_gpt
	// END DEBUGGING
	// SanOsTypeWindowsGpt captures enum value "windows_gpt"
	SanOsTypeWindowsGpt string = "windows_gpt"

	// BEGIN DEBUGGING
	// san
	// San
	// os_type
	// OsType
	// xen
	// END DEBUGGING
	// SanOsTypeXen captures enum value "xen"
	SanOsTypeXen string = "xen"
)

// prop value enum
func (m *San) validateOsTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, sanTypeOsTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *San) validateOsType(formats strfmt.Registry) error {
	if swag.IsZero(m.OsType) { // not required
		return nil
	}

	// value enum
	if err := m.validateOsTypeEnum("os_type", "body", *m.OsType); err != nil {
		return err
	}

	return nil
}

func (m *San) validateProtectionType(formats strfmt.Registry) error {
	if swag.IsZero(m.ProtectionType) { // not required
		return nil
	}

	if m.ProtectionType != nil {
		if err := m.ProtectionType.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("protection_type")
			}
			return err
		}
	}

	return nil
}

func (m *San) validateSanInlineApplicationComponents(formats strfmt.Registry) error {

	if err := validate.Required("application_components", "body", m.SanInlineApplicationComponents); err != nil {
		return err
	}

	iSanInlineApplicationComponentsSize := int64(len(m.SanInlineApplicationComponents))

	if err := validate.MinItems("application_components", "body", iSanInlineApplicationComponentsSize, 1); err != nil {
		return err
	}

	if err := validate.MaxItems("application_components", "body", iSanInlineApplicationComponentsSize, 10); err != nil {
		return err
	}

	for i := 0; i < len(m.SanInlineApplicationComponents); i++ {
		if swag.IsZero(m.SanInlineApplicationComponents[i]) { // not required
			continue
		}

		if m.SanInlineApplicationComponents[i] != nil {
			if err := m.SanInlineApplicationComponents[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("application_components" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *San) validateSanInlineExcludeAggregates(formats strfmt.Registry) error {
	if swag.IsZero(m.SanInlineExcludeAggregates) { // not required
		return nil
	}

	for i := 0; i < len(m.SanInlineExcludeAggregates); i++ {
		if swag.IsZero(m.SanInlineExcludeAggregates[i]) { // not required
			continue
		}

		if m.SanInlineExcludeAggregates[i] != nil {
			if err := m.SanInlineExcludeAggregates[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("exclude_aggregates" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *San) validateSanInlineNewIgroups(formats strfmt.Registry) error {
	if swag.IsZero(m.SanInlineNewIgroups) { // not required
		return nil
	}

	iSanInlineNewIgroupsSize := int64(len(m.SanInlineNewIgroups))

	if err := validate.MinItems("new_igroups", "body", iSanInlineNewIgroupsSize, 0); err != nil {
		return err
	}

	if err := validate.MaxItems("new_igroups", "body", iSanInlineNewIgroupsSize, 10); err != nil {
		return err
	}

	for i := 0; i < len(m.SanInlineNewIgroups); i++ {
		if swag.IsZero(m.SanInlineNewIgroups[i]) { // not required
			continue
		}

		if m.SanInlineNewIgroups[i] != nil {
			if err := m.SanInlineNewIgroups[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("new_igroups" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this san based on the context it is used
func (m *San) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateProtectionType(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSanInlineApplicationComponents(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSanInlineExcludeAggregates(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSanInlineNewIgroups(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *San) contextValidateProtectionType(ctx context.Context, formats strfmt.Registry) error {

	if m.ProtectionType != nil {
		if err := m.ProtectionType.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("protection_type")
			}
			return err
		}
	}

	return nil
}

func (m *San) contextValidateSanInlineApplicationComponents(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.SanInlineApplicationComponents); i++ {

		if m.SanInlineApplicationComponents[i] != nil {
			if err := m.SanInlineApplicationComponents[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("application_components" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *San) contextValidateSanInlineExcludeAggregates(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.SanInlineExcludeAggregates); i++ {

		if m.SanInlineExcludeAggregates[i] != nil {
			if err := m.SanInlineExcludeAggregates[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("exclude_aggregates" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *San) contextValidateSanInlineNewIgroups(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.SanInlineNewIgroups); i++ {

		if m.SanInlineNewIgroups[i] != nil {
			if err := m.SanInlineNewIgroups[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("new_igroups" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *San) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *San) UnmarshalBinary(b []byte) error {
	var res San
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// SanInlineApplicationComponentsInlineArrayItem san inline application components inline array item
//
// swagger:model san_inline_application_components_inline_array_item
type SanInlineApplicationComponentsInlineArrayItem struct {

	// The name of the initiator group through which the contents of this application will be accessed. Modification of this parameter is a disruptive operation. All LUNs in the application component will be unmapped from the current igroup and re-mapped to the new igroup.
	// Max Length: 96
	// Min Length: 1
	IgroupName *string `json:"igroup_name,omitempty"`

	// The number of LUNs in the application component.
	// Maximum: 32
	// Minimum: 1
	LunCount *int64 `json:"lun_count,omitempty"`

	// The name of the application component.
	// Required: true
	// Max Length: 203
	// Min Length: 1
	Name *string `json:"name"`

	// The name of the host OS running the application.
	// Enum: ["aix","hpux","hyper_v","linux","netware","openvms","solaris","solaris_efi","vmware","windows","windows_2008","windows_gpt","xen"]
	OsType *string `json:"os_type,omitempty"`

	// qos
	Qos *SanInlineApplicationComponentsInlineArrayItemInlineQos `json:"qos,omitempty"`

	// storage service
	StorageService *SanInlineApplicationComponentsInlineArrayItemInlineStorageService `json:"storage_service,omitempty"`

	// tiering
	Tiering *SanApplicationComponentsTiering `json:"tiering,omitempty"`

	// The total size of the application component, split across the member LUNs. Usage: {&lt;integer&gt;[KB|MB|GB|TB|PB]}
	TotalSize *int64 `json:"total_size,omitempty"`
}

// Validate validates this san inline application components inline array item
func (m *SanInlineApplicationComponentsInlineArrayItem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateIgroupName(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLunCount(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateName(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateOsType(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateQos(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStorageService(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTiering(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SanInlineApplicationComponentsInlineArrayItem) validateIgroupName(formats strfmt.Registry) error {
	if swag.IsZero(m.IgroupName) { // not required
		return nil
	}

	if err := validate.MinLength("igroup_name", "body", *m.IgroupName, 1); err != nil {
		return err
	}

	if err := validate.MaxLength("igroup_name", "body", *m.IgroupName, 96); err != nil {
		return err
	}

	return nil
}

func (m *SanInlineApplicationComponentsInlineArrayItem) validateLunCount(formats strfmt.Registry) error {
	if swag.IsZero(m.LunCount) { // not required
		return nil
	}

	if err := validate.MinimumInt("lun_count", "body", *m.LunCount, 1, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("lun_count", "body", *m.LunCount, 32, false); err != nil {
		return err
	}

	return nil
}

func (m *SanInlineApplicationComponentsInlineArrayItem) validateName(formats strfmt.Registry) error {

	if err := validate.Required("name", "body", m.Name); err != nil {
		return err
	}

	if err := validate.MinLength("name", "body", *m.Name, 1); err != nil {
		return err
	}

	if err := validate.MaxLength("name", "body", *m.Name, 203); err != nil {
		return err
	}

	return nil
}

var sanInlineApplicationComponentsInlineArrayItemTypeOsTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["aix","hpux","hyper_v","linux","netware","openvms","solaris","solaris_efi","vmware","windows","windows_2008","windows_gpt","xen"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		sanInlineApplicationComponentsInlineArrayItemTypeOsTypePropEnum = append(sanInlineApplicationComponentsInlineArrayItemTypeOsTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// san_inline_application_components_inline_array_item
	// SanInlineApplicationComponentsInlineArrayItem
	// os_type
	// OsType
	// aix
	// END DEBUGGING
	// SanInlineApplicationComponentsInlineArrayItemOsTypeAix captures enum value "aix"
	SanInlineApplicationComponentsInlineArrayItemOsTypeAix string = "aix"

	// BEGIN DEBUGGING
	// san_inline_application_components_inline_array_item
	// SanInlineApplicationComponentsInlineArrayItem
	// os_type
	// OsType
	// hpux
	// END DEBUGGING
	// SanInlineApplicationComponentsInlineArrayItemOsTypeHpux captures enum value "hpux"
	SanInlineApplicationComponentsInlineArrayItemOsTypeHpux string = "hpux"

	// BEGIN DEBUGGING
	// san_inline_application_components_inline_array_item
	// SanInlineApplicationComponentsInlineArrayItem
	// os_type
	// OsType
	// hyper_v
	// END DEBUGGING
	// SanInlineApplicationComponentsInlineArrayItemOsTypeHyperv captures enum value "hyper_v"
	SanInlineApplicationComponentsInlineArrayItemOsTypeHyperv string = "hyper_v"

	// BEGIN DEBUGGING
	// san_inline_application_components_inline_array_item
	// SanInlineApplicationComponentsInlineArrayItem
	// os_type
	// OsType
	// linux
	// END DEBUGGING
	// SanInlineApplicationComponentsInlineArrayItemOsTypeLinux captures enum value "linux"
	SanInlineApplicationComponentsInlineArrayItemOsTypeLinux string = "linux"

	// BEGIN DEBUGGING
	// san_inline_application_components_inline_array_item
	// SanInlineApplicationComponentsInlineArrayItem
	// os_type
	// OsType
	// netware
	// END DEBUGGING
	// SanInlineApplicationComponentsInlineArrayItemOsTypeNetware captures enum value "netware"
	SanInlineApplicationComponentsInlineArrayItemOsTypeNetware string = "netware"

	// BEGIN DEBUGGING
	// san_inline_application_components_inline_array_item
	// SanInlineApplicationComponentsInlineArrayItem
	// os_type
	// OsType
	// openvms
	// END DEBUGGING
	// SanInlineApplicationComponentsInlineArrayItemOsTypeOpenvms captures enum value "openvms"
	SanInlineApplicationComponentsInlineArrayItemOsTypeOpenvms string = "openvms"

	// BEGIN DEBUGGING
	// san_inline_application_components_inline_array_item
	// SanInlineApplicationComponentsInlineArrayItem
	// os_type
	// OsType
	// solaris
	// END DEBUGGING
	// SanInlineApplicationComponentsInlineArrayItemOsTypeSolaris captures enum value "solaris"
	SanInlineApplicationComponentsInlineArrayItemOsTypeSolaris string = "solaris"

	// BEGIN DEBUGGING
	// san_inline_application_components_inline_array_item
	// SanInlineApplicationComponentsInlineArrayItem
	// os_type
	// OsType
	// solaris_efi
	// END DEBUGGING
	// SanInlineApplicationComponentsInlineArrayItemOsTypeSolarisEfi captures enum value "solaris_efi"
	SanInlineApplicationComponentsInlineArrayItemOsTypeSolarisEfi string = "solaris_efi"

	// BEGIN DEBUGGING
	// san_inline_application_components_inline_array_item
	// SanInlineApplicationComponentsInlineArrayItem
	// os_type
	// OsType
	// vmware
	// END DEBUGGING
	// SanInlineApplicationComponentsInlineArrayItemOsTypeVmware captures enum value "vmware"
	SanInlineApplicationComponentsInlineArrayItemOsTypeVmware string = "vmware"

	// BEGIN DEBUGGING
	// san_inline_application_components_inline_array_item
	// SanInlineApplicationComponentsInlineArrayItem
	// os_type
	// OsType
	// windows
	// END DEBUGGING
	// SanInlineApplicationComponentsInlineArrayItemOsTypeWindows captures enum value "windows"
	SanInlineApplicationComponentsInlineArrayItemOsTypeWindows string = "windows"

	// BEGIN DEBUGGING
	// san_inline_application_components_inline_array_item
	// SanInlineApplicationComponentsInlineArrayItem
	// os_type
	// OsType
	// windows_2008
	// END DEBUGGING
	// SanInlineApplicationComponentsInlineArrayItemOsTypeWindows2008 captures enum value "windows_2008"
	SanInlineApplicationComponentsInlineArrayItemOsTypeWindows2008 string = "windows_2008"

	// BEGIN DEBUGGING
	// san_inline_application_components_inline_array_item
	// SanInlineApplicationComponentsInlineArrayItem
	// os_type
	// OsType
	// windows_gpt
	// END DEBUGGING
	// SanInlineApplicationComponentsInlineArrayItemOsTypeWindowsGpt captures enum value "windows_gpt"
	SanInlineApplicationComponentsInlineArrayItemOsTypeWindowsGpt string = "windows_gpt"

	// BEGIN DEBUGGING
	// san_inline_application_components_inline_array_item
	// SanInlineApplicationComponentsInlineArrayItem
	// os_type
	// OsType
	// xen
	// END DEBUGGING
	// SanInlineApplicationComponentsInlineArrayItemOsTypeXen captures enum value "xen"
	SanInlineApplicationComponentsInlineArrayItemOsTypeXen string = "xen"
)

// prop value enum
func (m *SanInlineApplicationComponentsInlineArrayItem) validateOsTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, sanInlineApplicationComponentsInlineArrayItemTypeOsTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *SanInlineApplicationComponentsInlineArrayItem) validateOsType(formats strfmt.Registry) error {
	if swag.IsZero(m.OsType) { // not required
		return nil
	}

	// value enum
	if err := m.validateOsTypeEnum("os_type", "body", *m.OsType); err != nil {
		return err
	}

	return nil
}

func (m *SanInlineApplicationComponentsInlineArrayItem) validateQos(formats strfmt.Registry) error {
	if swag.IsZero(m.Qos) { // not required
		return nil
	}

	if m.Qos != nil {
		if err := m.Qos.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos")
			}
			return err
		}
	}

	return nil
}

func (m *SanInlineApplicationComponentsInlineArrayItem) validateStorageService(formats strfmt.Registry) error {
	if swag.IsZero(m.StorageService) { // not required
		return nil
	}

	if m.StorageService != nil {
		if err := m.StorageService.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("storage_service")
			}
			return err
		}
	}

	return nil
}

func (m *SanInlineApplicationComponentsInlineArrayItem) validateTiering(formats strfmt.Registry) error {
	if swag.IsZero(m.Tiering) { // not required
		return nil
	}

	if m.Tiering != nil {
		if err := m.Tiering.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("tiering")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this san inline application components inline array item based on the context it is used
func (m *SanInlineApplicationComponentsInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateQos(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStorageService(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTiering(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SanInlineApplicationComponentsInlineArrayItem) contextValidateQos(ctx context.Context, formats strfmt.Registry) error {

	if m.Qos != nil {
		if err := m.Qos.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos")
			}
			return err
		}
	}

	return nil
}

func (m *SanInlineApplicationComponentsInlineArrayItem) contextValidateStorageService(ctx context.Context, formats strfmt.Registry) error {

	if m.StorageService != nil {
		if err := m.StorageService.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("storage_service")
			}
			return err
		}
	}

	return nil
}

func (m *SanInlineApplicationComponentsInlineArrayItem) contextValidateTiering(ctx context.Context, formats strfmt.Registry) error {

	if m.Tiering != nil {
		if err := m.Tiering.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("tiering")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *SanInlineApplicationComponentsInlineArrayItem) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SanInlineApplicationComponentsInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res SanInlineApplicationComponentsInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// SanInlineApplicationComponentsInlineArrayItemInlineQos san inline application components inline array item inline qos
//
// swagger:model san_inline_application_components_inline_array_item_inline_qos
type SanInlineApplicationComponentsInlineArrayItemInlineQos struct {

	// policy
	Policy *SanInlineApplicationComponentsInlineArrayItemInlineQosInlinePolicy `json:"policy,omitempty"`
}

// Validate validates this san inline application components inline array item inline qos
func (m *SanInlineApplicationComponentsInlineArrayItemInlineQos) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validatePolicy(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SanInlineApplicationComponentsInlineArrayItemInlineQos) validatePolicy(formats strfmt.Registry) error {
	if swag.IsZero(m.Policy) { // not required
		return nil
	}

	if m.Policy != nil {
		if err := m.Policy.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos" + "." + "policy")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this san inline application components inline array item inline qos based on the context it is used
func (m *SanInlineApplicationComponentsInlineArrayItemInlineQos) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidatePolicy(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SanInlineApplicationComponentsInlineArrayItemInlineQos) contextValidatePolicy(ctx context.Context, formats strfmt.Registry) error {

	if m.Policy != nil {
		if err := m.Policy.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos" + "." + "policy")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *SanInlineApplicationComponentsInlineArrayItemInlineQos) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SanInlineApplicationComponentsInlineArrayItemInlineQos) UnmarshalBinary(b []byte) error {
	var res SanInlineApplicationComponentsInlineArrayItemInlineQos
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// SanInlineApplicationComponentsInlineArrayItemInlineQosInlinePolicy san inline application components inline array item inline qos inline policy
//
// swagger:model san_inline_application_components_inline_array_item_inline_qos_inline_policy
type SanInlineApplicationComponentsInlineArrayItemInlineQosInlinePolicy struct {

	// The name of an existing QoS policy.
	Name *string `json:"name,omitempty"`

	// The UUID of an existing QoS policy. Usage: &lt;UUID&gt;
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this san inline application components inline array item inline qos inline policy
func (m *SanInlineApplicationComponentsInlineArrayItemInlineQosInlinePolicy) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this san inline application components inline array item inline qos inline policy based on context it is used
func (m *SanInlineApplicationComponentsInlineArrayItemInlineQosInlinePolicy) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *SanInlineApplicationComponentsInlineArrayItemInlineQosInlinePolicy) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SanInlineApplicationComponentsInlineArrayItemInlineQosInlinePolicy) UnmarshalBinary(b []byte) error {
	var res SanInlineApplicationComponentsInlineArrayItemInlineQosInlinePolicy
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// SanInlineApplicationComponentsInlineArrayItemInlineStorageService san inline application components inline array item inline storage service
//
// swagger:model san_inline_application_components_inline_array_item_inline_storage_service
type SanInlineApplicationComponentsInlineArrayItemInlineStorageService struct {

	// The storage service of the application component.
	// Enum: ["extreme","performance","value"]
	Name *string `json:"name,omitempty"`
}

// Validate validates this san inline application components inline array item inline storage service
func (m *SanInlineApplicationComponentsInlineArrayItemInlineStorageService) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateName(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var sanInlineApplicationComponentsInlineArrayItemInlineStorageServiceTypeNamePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["extreme","performance","value"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		sanInlineApplicationComponentsInlineArrayItemInlineStorageServiceTypeNamePropEnum = append(sanInlineApplicationComponentsInlineArrayItemInlineStorageServiceTypeNamePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// san_inline_application_components_inline_array_item_inline_storage_service
	// SanInlineApplicationComponentsInlineArrayItemInlineStorageService
	// name
	// Name
	// extreme
	// END DEBUGGING
	// SanInlineApplicationComponentsInlineArrayItemInlineStorageServiceNameExtreme captures enum value "extreme"
	SanInlineApplicationComponentsInlineArrayItemInlineStorageServiceNameExtreme string = "extreme"

	// BEGIN DEBUGGING
	// san_inline_application_components_inline_array_item_inline_storage_service
	// SanInlineApplicationComponentsInlineArrayItemInlineStorageService
	// name
	// Name
	// performance
	// END DEBUGGING
	// SanInlineApplicationComponentsInlineArrayItemInlineStorageServiceNamePerformance captures enum value "performance"
	SanInlineApplicationComponentsInlineArrayItemInlineStorageServiceNamePerformance string = "performance"

	// BEGIN DEBUGGING
	// san_inline_application_components_inline_array_item_inline_storage_service
	// SanInlineApplicationComponentsInlineArrayItemInlineStorageService
	// name
	// Name
	// value
	// END DEBUGGING
	// SanInlineApplicationComponentsInlineArrayItemInlineStorageServiceNameValue captures enum value "value"
	SanInlineApplicationComponentsInlineArrayItemInlineStorageServiceNameValue string = "value"
)

// prop value enum
func (m *SanInlineApplicationComponentsInlineArrayItemInlineStorageService) validateNameEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, sanInlineApplicationComponentsInlineArrayItemInlineStorageServiceTypeNamePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *SanInlineApplicationComponentsInlineArrayItemInlineStorageService) validateName(formats strfmt.Registry) error {
	if swag.IsZero(m.Name) { // not required
		return nil
	}

	// value enum
	if err := m.validateNameEnum("storage_service"+"."+"name", "body", *m.Name); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this san inline application components inline array item inline storage service based on context it is used
func (m *SanInlineApplicationComponentsInlineArrayItemInlineStorageService) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *SanInlineApplicationComponentsInlineArrayItemInlineStorageService) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SanInlineApplicationComponentsInlineArrayItemInlineStorageService) UnmarshalBinary(b []byte) error {
	var res SanInlineApplicationComponentsInlineArrayItemInlineStorageService
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// SanInlineExcludeAggregatesInlineArrayItem san inline exclude aggregates inline array item
//
// swagger:model san_inline_exclude_aggregates_inline_array_item
type SanInlineExcludeAggregatesInlineArrayItem struct {

	// The name of the aggregate to exclude. Usage: &lt;aggregate name&gt;
	Name *string `json:"name,omitempty"`

	// The ID of the aggregate to exclude. Usage: &lt;UUID&gt;
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this san inline exclude aggregates inline array item
func (m *SanInlineExcludeAggregatesInlineArrayItem) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this san inline exclude aggregates inline array item based on context it is used
func (m *SanInlineExcludeAggregatesInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *SanInlineExcludeAggregatesInlineArrayItem) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SanInlineExcludeAggregatesInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res SanInlineExcludeAggregatesInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// SanInlineProtectionType san inline protection type
//
// swagger:model san_inline_protection_type
type SanInlineProtectionType struct {

	// The Snapshot copy policy to apply to each volume in the smart container. This property is only supported for smart containers. Usage: &lt;snapshot policy&gt;
	LocalPolicy *string `json:"local_policy,omitempty"`

	// The local RPO of the application.
	// Enum: ["hourly","none"]
	LocalRpo *string `json:"local_rpo,omitempty"`

	// The remote RPO of the application.
	// Enum: ["none","zero"]
	RemoteRpo *string `json:"remote_rpo,omitempty"`
}

// Validate validates this san inline protection type
func (m *SanInlineProtectionType) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLocalRpo(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateRemoteRpo(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var sanInlineProtectionTypeTypeLocalRpoPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["hourly","none"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		sanInlineProtectionTypeTypeLocalRpoPropEnum = append(sanInlineProtectionTypeTypeLocalRpoPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// san_inline_protection_type
	// SanInlineProtectionType
	// local_rpo
	// LocalRpo
	// hourly
	// END DEBUGGING
	// SanInlineProtectionTypeLocalRpoHourly captures enum value "hourly"
	SanInlineProtectionTypeLocalRpoHourly string = "hourly"

	// BEGIN DEBUGGING
	// san_inline_protection_type
	// SanInlineProtectionType
	// local_rpo
	// LocalRpo
	// none
	// END DEBUGGING
	// SanInlineProtectionTypeLocalRpoNone captures enum value "none"
	SanInlineProtectionTypeLocalRpoNone string = "none"
)

// prop value enum
func (m *SanInlineProtectionType) validateLocalRpoEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, sanInlineProtectionTypeTypeLocalRpoPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *SanInlineProtectionType) validateLocalRpo(formats strfmt.Registry) error {
	if swag.IsZero(m.LocalRpo) { // not required
		return nil
	}

	// value enum
	if err := m.validateLocalRpoEnum("protection_type"+"."+"local_rpo", "body", *m.LocalRpo); err != nil {
		return err
	}

	return nil
}

var sanInlineProtectionTypeTypeRemoteRpoPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["none","zero"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		sanInlineProtectionTypeTypeRemoteRpoPropEnum = append(sanInlineProtectionTypeTypeRemoteRpoPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// san_inline_protection_type
	// SanInlineProtectionType
	// remote_rpo
	// RemoteRpo
	// none
	// END DEBUGGING
	// SanInlineProtectionTypeRemoteRpoNone captures enum value "none"
	SanInlineProtectionTypeRemoteRpoNone string = "none"

	// BEGIN DEBUGGING
	// san_inline_protection_type
	// SanInlineProtectionType
	// remote_rpo
	// RemoteRpo
	// zero
	// END DEBUGGING
	// SanInlineProtectionTypeRemoteRpoZero captures enum value "zero"
	SanInlineProtectionTypeRemoteRpoZero string = "zero"
)

// prop value enum
func (m *SanInlineProtectionType) validateRemoteRpoEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, sanInlineProtectionTypeTypeRemoteRpoPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *SanInlineProtectionType) validateRemoteRpo(formats strfmt.Registry) error {
	if swag.IsZero(m.RemoteRpo) { // not required
		return nil
	}

	// value enum
	if err := m.validateRemoteRpoEnum("protection_type"+"."+"remote_rpo", "body", *m.RemoteRpo); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this san inline protection type based on context it is used
func (m *SanInlineProtectionType) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *SanInlineProtectionType) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SanInlineProtectionType) UnmarshalBinary(b []byte) error {
	var res SanInlineProtectionType
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
