// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// SanNewIgroups The list of initiator groups to create.
//
// swagger:model san_new_igroups
type SanNewIgroups struct {

	// A comment available for use by the administrator.
	Comment *string `json:"comment,omitempty"`

	// The name of the new initiator group.
	// Required: true
	// Max Length: 96
	// Min Length: 1
	Name *string `json:"name"`

	// The name of the host OS accessing the application. The default value is the host OS that is running the application.
	// Enum: ["aix","hpux","hyper_v","linux","netware","openvms","solaris","vmware","windows","xen"]
	OsType *string `json:"os_type,omitempty"`

	// The protocol of the new initiator group.
	// Enum: ["fcp","iscsi","mixed"]
	Protocol *string `json:"protocol,omitempty"`

	// san new igroups inline igroups
	SanNewIgroupsInlineIgroups []*SanNewIgroupsInlineIgroupsInlineArrayItem `json:"igroups,omitempty"`

	// san new igroups inline initiator objects
	SanNewIgroupsInlineInitiatorObjects []*SanNewIgroupsInlineInitiatorObjectsInlineArrayItem `json:"initiator_objects,omitempty"`

	// san new igroups inline initiators
	SanNewIgroupsInlineInitiators []*string `json:"initiators,omitempty"`
}

// Validate validates this san new igroups
func (m *SanNewIgroups) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateName(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateOsType(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateProtocol(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSanNewIgroupsInlineIgroups(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSanNewIgroupsInlineInitiatorObjects(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SanNewIgroups) validateName(formats strfmt.Registry) error {

	if err := validate.Required("name", "body", m.Name); err != nil {
		return err
	}

	if err := validate.MinLength("name", "body", *m.Name, 1); err != nil {
		return err
	}

	if err := validate.MaxLength("name", "body", *m.Name, 96); err != nil {
		return err
	}

	return nil
}

var sanNewIgroupsTypeOsTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["aix","hpux","hyper_v","linux","netware","openvms","solaris","vmware","windows","xen"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		sanNewIgroupsTypeOsTypePropEnum = append(sanNewIgroupsTypeOsTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// san_new_igroups
	// SanNewIgroups
	// os_type
	// OsType
	// aix
	// END DEBUGGING
	// SanNewIgroupsOsTypeAix captures enum value "aix"
	SanNewIgroupsOsTypeAix string = "aix"

	// BEGIN DEBUGGING
	// san_new_igroups
	// SanNewIgroups
	// os_type
	// OsType
	// hpux
	// END DEBUGGING
	// SanNewIgroupsOsTypeHpux captures enum value "hpux"
	SanNewIgroupsOsTypeHpux string = "hpux"

	// BEGIN DEBUGGING
	// san_new_igroups
	// SanNewIgroups
	// os_type
	// OsType
	// hyper_v
	// END DEBUGGING
	// SanNewIgroupsOsTypeHyperv captures enum value "hyper_v"
	SanNewIgroupsOsTypeHyperv string = "hyper_v"

	// BEGIN DEBUGGING
	// san_new_igroups
	// SanNewIgroups
	// os_type
	// OsType
	// linux
	// END DEBUGGING
	// SanNewIgroupsOsTypeLinux captures enum value "linux"
	SanNewIgroupsOsTypeLinux string = "linux"

	// BEGIN DEBUGGING
	// san_new_igroups
	// SanNewIgroups
	// os_type
	// OsType
	// netware
	// END DEBUGGING
	// SanNewIgroupsOsTypeNetware captures enum value "netware"
	SanNewIgroupsOsTypeNetware string = "netware"

	// BEGIN DEBUGGING
	// san_new_igroups
	// SanNewIgroups
	// os_type
	// OsType
	// openvms
	// END DEBUGGING
	// SanNewIgroupsOsTypeOpenvms captures enum value "openvms"
	SanNewIgroupsOsTypeOpenvms string = "openvms"

	// BEGIN DEBUGGING
	// san_new_igroups
	// SanNewIgroups
	// os_type
	// OsType
	// solaris
	// END DEBUGGING
	// SanNewIgroupsOsTypeSolaris captures enum value "solaris"
	SanNewIgroupsOsTypeSolaris string = "solaris"

	// BEGIN DEBUGGING
	// san_new_igroups
	// SanNewIgroups
	// os_type
	// OsType
	// vmware
	// END DEBUGGING
	// SanNewIgroupsOsTypeVmware captures enum value "vmware"
	SanNewIgroupsOsTypeVmware string = "vmware"

	// BEGIN DEBUGGING
	// san_new_igroups
	// SanNewIgroups
	// os_type
	// OsType
	// windows
	// END DEBUGGING
	// SanNewIgroupsOsTypeWindows captures enum value "windows"
	SanNewIgroupsOsTypeWindows string = "windows"

	// BEGIN DEBUGGING
	// san_new_igroups
	// SanNewIgroups
	// os_type
	// OsType
	// xen
	// END DEBUGGING
	// SanNewIgroupsOsTypeXen captures enum value "xen"
	SanNewIgroupsOsTypeXen string = "xen"
)

// prop value enum
func (m *SanNewIgroups) validateOsTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, sanNewIgroupsTypeOsTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *SanNewIgroups) validateOsType(formats strfmt.Registry) error {
	if swag.IsZero(m.OsType) { // not required
		return nil
	}

	// value enum
	if err := m.validateOsTypeEnum("os_type", "body", *m.OsType); err != nil {
		return err
	}

	return nil
}

var sanNewIgroupsTypeProtocolPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["fcp","iscsi","mixed"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		sanNewIgroupsTypeProtocolPropEnum = append(sanNewIgroupsTypeProtocolPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// san_new_igroups
	// SanNewIgroups
	// protocol
	// Protocol
	// fcp
	// END DEBUGGING
	// SanNewIgroupsProtocolFcp captures enum value "fcp"
	SanNewIgroupsProtocolFcp string = "fcp"

	// BEGIN DEBUGGING
	// san_new_igroups
	// SanNewIgroups
	// protocol
	// Protocol
	// iscsi
	// END DEBUGGING
	// SanNewIgroupsProtocolIscsi captures enum value "iscsi"
	SanNewIgroupsProtocolIscsi string = "iscsi"

	// BEGIN DEBUGGING
	// san_new_igroups
	// SanNewIgroups
	// protocol
	// Protocol
	// mixed
	// END DEBUGGING
	// SanNewIgroupsProtocolMixed captures enum value "mixed"
	SanNewIgroupsProtocolMixed string = "mixed"
)

// prop value enum
func (m *SanNewIgroups) validateProtocolEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, sanNewIgroupsTypeProtocolPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *SanNewIgroups) validateProtocol(formats strfmt.Registry) error {
	if swag.IsZero(m.Protocol) { // not required
		return nil
	}

	// value enum
	if err := m.validateProtocolEnum("protocol", "body", *m.Protocol); err != nil {
		return err
	}

	return nil
}

func (m *SanNewIgroups) validateSanNewIgroupsInlineIgroups(formats strfmt.Registry) error {
	if swag.IsZero(m.SanNewIgroupsInlineIgroups) { // not required
		return nil
	}

	for i := 0; i < len(m.SanNewIgroupsInlineIgroups); i++ {
		if swag.IsZero(m.SanNewIgroupsInlineIgroups[i]) { // not required
			continue
		}

		if m.SanNewIgroupsInlineIgroups[i] != nil {
			if err := m.SanNewIgroupsInlineIgroups[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("igroups" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *SanNewIgroups) validateSanNewIgroupsInlineInitiatorObjects(formats strfmt.Registry) error {
	if swag.IsZero(m.SanNewIgroupsInlineInitiatorObjects) { // not required
		return nil
	}

	for i := 0; i < len(m.SanNewIgroupsInlineInitiatorObjects); i++ {
		if swag.IsZero(m.SanNewIgroupsInlineInitiatorObjects[i]) { // not required
			continue
		}

		if m.SanNewIgroupsInlineInitiatorObjects[i] != nil {
			if err := m.SanNewIgroupsInlineInitiatorObjects[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("initiator_objects" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this san new igroups based on the context it is used
func (m *SanNewIgroups) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSanNewIgroupsInlineIgroups(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSanNewIgroupsInlineInitiatorObjects(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SanNewIgroups) contextValidateSanNewIgroupsInlineIgroups(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.SanNewIgroupsInlineIgroups); i++ {

		if m.SanNewIgroupsInlineIgroups[i] != nil {
			if err := m.SanNewIgroupsInlineIgroups[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("igroups" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *SanNewIgroups) contextValidateSanNewIgroupsInlineInitiatorObjects(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.SanNewIgroupsInlineInitiatorObjects); i++ {

		if m.SanNewIgroupsInlineInitiatorObjects[i] != nil {
			if err := m.SanNewIgroupsInlineInitiatorObjects[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("initiator_objects" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *SanNewIgroups) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SanNewIgroups) UnmarshalBinary(b []byte) error {
	var res SanNewIgroups
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// SanNewIgroupsInlineIgroupsInlineArrayItem san new igroups inline igroups inline array item
//
// swagger:model san_new_igroups_inline_igroups_inline_array_item
type SanNewIgroupsInlineIgroupsInlineArrayItem struct {

	// The name of an igroup to nest within a parent igroup. Mutually exclusive with initiators and initiator_objects.
	Name *string `json:"name,omitempty"`

	// The UUID of an igroup to nest within a parent igroup Usage: &lt;UUID&gt;
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this san new igroups inline igroups inline array item
func (m *SanNewIgroupsInlineIgroupsInlineArrayItem) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this san new igroups inline igroups inline array item based on context it is used
func (m *SanNewIgroupsInlineIgroupsInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *SanNewIgroupsInlineIgroupsInlineArrayItem) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SanNewIgroupsInlineIgroupsInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res SanNewIgroupsInlineIgroupsInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// SanNewIgroupsInlineInitiatorObjectsInlineArrayItem san new igroups inline initiator objects inline array item
//
// swagger:model san_new_igroups_inline_initiator_objects_inline_array_item
type SanNewIgroupsInlineInitiatorObjectsInlineArrayItem struct {

	// A comment available for use by the administrator.
	Comment *string `json:"comment,omitempty"`

	// The WWPN, IQN, or Alias of the initiator. Mutually exclusive with nested igroups and the initiators array.
	Name *string `json:"name,omitempty"`
}

// Validate validates this san new igroups inline initiator objects inline array item
func (m *SanNewIgroupsInlineInitiatorObjectsInlineArrayItem) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this san new igroups inline initiator objects inline array item based on context it is used
func (m *SanNewIgroupsInlineInitiatorObjectsInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *SanNewIgroupsInlineInitiatorObjectsInlineArrayItem) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SanNewIgroupsInlineInitiatorObjectsInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res SanNewIgroupsInlineInitiatorObjectsInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
