// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// ScannerPool Scanner pool is a set of attributes which are used to validate and manage connections between clustered ONTAP and external virus-scanning server, or "Vscan server".
//
// swagger:model scanner_pool
type ScannerPool struct {

	// cluster
	Cluster *ClusterReference `json:"cluster,omitempty"`

	// Specifies the name of the scanner pool. Scanner pool name can be up to 256 characters long and is a string that can only contain any combination of ASCII-range alphanumeric characters a-z, A-Z, 0-9), "_", "-" and ".".
	// Example: scanner-1
	// Max Length: 256
	// Min Length: 1
	Name *string `json:"name,omitempty"`

	// Specifies the role of the scanner pool. The possible values are:
	//   * primary   - Always active.
	//   * secondary - Active only when none of the primary external virus-scanning servers are connected.
	//   * idle      - Always inactive.
	//
	// Enum: ["primary","secondary","idle"]
	Role *string `json:"role,omitempty"`

	// Specifies a list of privileged users. A valid form of privileged user-name is "domain-name\user-name". Privileged user-names are stored and treated as case-insensitive strings. Virus scanners must use one of the registered privileged users for connecting to clustered Data ONTAP for exchanging virus-scanning protocol messages and to access file for scanning, remedying and quarantining operations.
	// Example: ["cifs\\u1","cifs\\u2"]
	ScannerPoolInlinePrivilegedUsers []*string `json:"privileged_users,omitempty"`

	// Specifies a list of IP addresses or FQDN for each Vscan server host names which are allowed to connect to clustered ONTAP.
	// Example: ["1.1.1.1","10.72.204.27","vmwin204-27.fsct.nb"]
	ScannerPoolInlineServers []*string `json:"servers,omitempty"`
}

// Validate validates this scanner pool
func (m *ScannerPool) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateCluster(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateName(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateRole(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ScannerPool) validateCluster(formats strfmt.Registry) error {
	if swag.IsZero(m.Cluster) { // not required
		return nil
	}

	if m.Cluster != nil {
		if err := m.Cluster.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("cluster")
			}
			return err
		}
	}

	return nil
}

func (m *ScannerPool) validateName(formats strfmt.Registry) error {
	if swag.IsZero(m.Name) { // not required
		return nil
	}

	if err := validate.MinLength("name", "body", *m.Name, 1); err != nil {
		return err
	}

	if err := validate.MaxLength("name", "body", *m.Name, 256); err != nil {
		return err
	}

	return nil
}

var scannerPoolTypeRolePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["primary","secondary","idle"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		scannerPoolTypeRolePropEnum = append(scannerPoolTypeRolePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// scanner_pool
	// ScannerPool
	// role
	// Role
	// primary
	// END DEBUGGING
	// ScannerPoolRolePrimary captures enum value "primary"
	ScannerPoolRolePrimary string = "primary"

	// BEGIN DEBUGGING
	// scanner_pool
	// ScannerPool
	// role
	// Role
	// secondary
	// END DEBUGGING
	// ScannerPoolRoleSecondary captures enum value "secondary"
	ScannerPoolRoleSecondary string = "secondary"

	// BEGIN DEBUGGING
	// scanner_pool
	// ScannerPool
	// role
	// Role
	// idle
	// END DEBUGGING
	// ScannerPoolRoleIdle captures enum value "idle"
	ScannerPoolRoleIdle string = "idle"
)

// prop value enum
func (m *ScannerPool) validateRoleEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, scannerPoolTypeRolePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ScannerPool) validateRole(formats strfmt.Registry) error {
	if swag.IsZero(m.Role) { // not required
		return nil
	}

	// value enum
	if err := m.validateRoleEnum("role", "body", *m.Role); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this scanner pool based on the context it is used
func (m *ScannerPool) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateCluster(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ScannerPool) contextValidateCluster(ctx context.Context, formats strfmt.Registry) error {

	if m.Cluster != nil {
		if err := m.Cluster.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("cluster")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ScannerPool) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ScannerPool) UnmarshalBinary(b []byte) error {
	var res ScannerPool
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
