// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// Schedule Complete schedule information
//
// swagger:model schedule
type Schedule struct {

	// links
	Links *ScheduleInlineLinks `json:"_links,omitempty"`

	// cluster
	Cluster *ScheduleInlineCluster `json:"cluster,omitempty"`

	// cron
	Cron *ScheduleInlineCron `json:"cron,omitempty"`

	// An ISO-8601 duration formatted string.
	// Example: P1DT2H3M4S
	Interval *string `json:"interval,omitempty"`

	// Schedule name. Required in the URL or POST body.
	// Max Length: 256
	// Min Length: 1
	Name *string `json:"name,omitempty"`

	// If the schedule is owned by a data SVM, then the scope is set to svm. Otherwise it will be set to cluster.
	// Read Only: true
	// Enum: ["cluster","svm"]
	Scope *string `json:"scope,omitempty"`

	// svm
	Svm *ScheduleInlineSvm `json:"svm,omitempty"`

	// Schedule type
	// Read Only: true
	// Enum: ["cron","interval"]
	Type *string `json:"type,omitempty"`

	// Job schedule UUID
	// Example: 4ea7a442-86d1-11e0-ae1c-123478563412
	// Read Only: true
	// Format: uuid
	UUID *strfmt.UUID `json:"uuid,omitempty"`
}

// Validate validates this schedule
func (m *Schedule) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCluster(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCron(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateName(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateScope(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSvm(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateType(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateUUID(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *Schedule) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *Schedule) validateCluster(formats strfmt.Registry) error {
	if swag.IsZero(m.Cluster) { // not required
		return nil
	}

	if m.Cluster != nil {
		if err := m.Cluster.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("cluster")
			}
			return err
		}
	}

	return nil
}

func (m *Schedule) validateCron(formats strfmt.Registry) error {
	if swag.IsZero(m.Cron) { // not required
		return nil
	}

	if m.Cron != nil {
		if err := m.Cron.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("cron")
			}
			return err
		}
	}

	return nil
}

func (m *Schedule) validateName(formats strfmt.Registry) error {
	if swag.IsZero(m.Name) { // not required
		return nil
	}

	if err := validate.MinLength("name", "body", *m.Name, 1); err != nil {
		return err
	}

	if err := validate.MaxLength("name", "body", *m.Name, 256); err != nil {
		return err
	}

	return nil
}

var scheduleTypeScopePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["cluster","svm"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		scheduleTypeScopePropEnum = append(scheduleTypeScopePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// schedule
	// Schedule
	// scope
	// Scope
	// cluster
	// END DEBUGGING
	// ScheduleScopeCluster captures enum value "cluster"
	ScheduleScopeCluster string = "cluster"

	// BEGIN DEBUGGING
	// schedule
	// Schedule
	// scope
	// Scope
	// svm
	// END DEBUGGING
	// ScheduleScopeSvm captures enum value "svm"
	ScheduleScopeSvm string = "svm"
)

// prop value enum
func (m *Schedule) validateScopeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, scheduleTypeScopePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *Schedule) validateScope(formats strfmt.Registry) error {
	if swag.IsZero(m.Scope) { // not required
		return nil
	}

	// value enum
	if err := m.validateScopeEnum("scope", "body", *m.Scope); err != nil {
		return err
	}

	return nil
}

func (m *Schedule) validateSvm(formats strfmt.Registry) error {
	if swag.IsZero(m.Svm) { // not required
		return nil
	}

	if m.Svm != nil {
		if err := m.Svm.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm")
			}
			return err
		}
	}

	return nil
}

var scheduleTypeTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["cron","interval"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		scheduleTypeTypePropEnum = append(scheduleTypeTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// schedule
	// Schedule
	// type
	// Type
	// cron
	// END DEBUGGING
	// ScheduleTypeCron captures enum value "cron"
	ScheduleTypeCron string = "cron"

	// BEGIN DEBUGGING
	// schedule
	// Schedule
	// type
	// Type
	// interval
	// END DEBUGGING
	// ScheduleTypeInterval captures enum value "interval"
	ScheduleTypeInterval string = "interval"
)

// prop value enum
func (m *Schedule) validateTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, scheduleTypeTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *Schedule) validateType(formats strfmt.Registry) error {
	if swag.IsZero(m.Type) { // not required
		return nil
	}

	// value enum
	if err := m.validateTypeEnum("type", "body", *m.Type); err != nil {
		return err
	}

	return nil
}

func (m *Schedule) validateUUID(formats strfmt.Registry) error {
	if swag.IsZero(m.UUID) { // not required
		return nil
	}

	if err := validate.FormatOf("uuid", "body", "uuid", m.UUID.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this schedule based on the context it is used
func (m *Schedule) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateCluster(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateCron(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateScope(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSvm(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateType(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *Schedule) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *Schedule) contextValidateCluster(ctx context.Context, formats strfmt.Registry) error {

	if m.Cluster != nil {
		if err := m.Cluster.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("cluster")
			}
			return err
		}
	}

	return nil
}

func (m *Schedule) contextValidateCron(ctx context.Context, formats strfmt.Registry) error {

	if m.Cron != nil {
		if err := m.Cron.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("cron")
			}
			return err
		}
	}

	return nil
}

func (m *Schedule) contextValidateScope(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "scope", "body", m.Scope); err != nil {
		return err
	}

	return nil
}

func (m *Schedule) contextValidateSvm(ctx context.Context, formats strfmt.Registry) error {

	if m.Svm != nil {
		if err := m.Svm.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm")
			}
			return err
		}
	}

	return nil
}

func (m *Schedule) contextValidateType(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "type", "body", m.Type); err != nil {
		return err
	}

	return nil
}

func (m *Schedule) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "uuid", "body", m.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *Schedule) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *Schedule) UnmarshalBinary(b []byte) error {
	var res Schedule
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ScheduleInlineCluster The cluster that owns the schedule. Defaults to the local cluster.
//
// swagger:model schedule_inline_cluster
type ScheduleInlineCluster struct {

	// Cluster name
	// Example: cluster1
	Name *string `json:"name,omitempty"`

	// Cluster UUID
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	// Format: uuid
	UUID *strfmt.UUID `json:"uuid,omitempty"`
}

// Validate validates this schedule inline cluster
func (m *ScheduleInlineCluster) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateUUID(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ScheduleInlineCluster) validateUUID(formats strfmt.Registry) error {
	if swag.IsZero(m.UUID) { // not required
		return nil
	}

	if err := validate.FormatOf("cluster"+"."+"uuid", "body", "uuid", m.UUID.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this schedule inline cluster based on context it is used
func (m *ScheduleInlineCluster) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *ScheduleInlineCluster) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ScheduleInlineCluster) UnmarshalBinary(b []byte) error {
	var res ScheduleInlineCluster
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ScheduleInlineCron Details for schedules of type cron.
//
// swagger:model schedule_inline_cron
type ScheduleInlineCron struct {

	// The days of the month the schedule runs. Leave empty for all.
	Days []*int64 `json:"days,omitempty"`

	// The hours of the day the schedule runs. Leave empty for all.
	Hours []*int64 `json:"hours,omitempty"`

	// The minutes the schedule runs. Required on POST for a cron schedule.
	Minutes []*int64 `json:"minutes,omitempty"`

	// The months of the year the schedule runs. Leave empty for all.
	Months []*int64 `json:"months,omitempty"`

	// The weekdays the schedule runs. Leave empty for all.
	Weekdays []*int64 `json:"weekdays,omitempty"`
}

// Validate validates this schedule inline cron
func (m *ScheduleInlineCron) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateDays(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateHours(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateMinutes(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateMonths(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateWeekdays(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ScheduleInlineCron) validateDays(formats strfmt.Registry) error {
	if swag.IsZero(m.Days) { // not required
		return nil
	}

	for i := 0; i < len(m.Days); i++ {
		if swag.IsZero(m.Days[i]) { // not required
			continue
		}

		if err := validate.MinimumInt("cron"+"."+"days"+"."+strconv.Itoa(i), "body", *m.Days[i], 1, false); err != nil {
			return err
		}

		if err := validate.MaximumInt("cron"+"."+"days"+"."+strconv.Itoa(i), "body", *m.Days[i], 31, false); err != nil {
			return err
		}

	}

	return nil
}

func (m *ScheduleInlineCron) validateHours(formats strfmt.Registry) error {
	if swag.IsZero(m.Hours) { // not required
		return nil
	}

	for i := 0; i < len(m.Hours); i++ {
		if swag.IsZero(m.Hours[i]) { // not required
			continue
		}

		if err := validate.MinimumInt("cron"+"."+"hours"+"."+strconv.Itoa(i), "body", *m.Hours[i], 0, false); err != nil {
			return err
		}

		if err := validate.MaximumInt("cron"+"."+"hours"+"."+strconv.Itoa(i), "body", *m.Hours[i], 23, false); err != nil {
			return err
		}

	}

	return nil
}

func (m *ScheduleInlineCron) validateMinutes(formats strfmt.Registry) error {
	if swag.IsZero(m.Minutes) { // not required
		return nil
	}

	for i := 0; i < len(m.Minutes); i++ {
		if swag.IsZero(m.Minutes[i]) { // not required
			continue
		}

		if err := validate.MinimumInt("cron"+"."+"minutes"+"."+strconv.Itoa(i), "body", *m.Minutes[i], 0, false); err != nil {
			return err
		}

		if err := validate.MaximumInt("cron"+"."+"minutes"+"."+strconv.Itoa(i), "body", *m.Minutes[i], 59, false); err != nil {
			return err
		}

	}

	return nil
}

func (m *ScheduleInlineCron) validateMonths(formats strfmt.Registry) error {
	if swag.IsZero(m.Months) { // not required
		return nil
	}

	for i := 0; i < len(m.Months); i++ {
		if swag.IsZero(m.Months[i]) { // not required
			continue
		}

		if err := validate.MinimumInt("cron"+"."+"months"+"."+strconv.Itoa(i), "body", *m.Months[i], 1, false); err != nil {
			return err
		}

		if err := validate.MaximumInt("cron"+"."+"months"+"."+strconv.Itoa(i), "body", *m.Months[i], 12, false); err != nil {
			return err
		}

	}

	return nil
}

func (m *ScheduleInlineCron) validateWeekdays(formats strfmt.Registry) error {
	if swag.IsZero(m.Weekdays) { // not required
		return nil
	}

	for i := 0; i < len(m.Weekdays); i++ {
		if swag.IsZero(m.Weekdays[i]) { // not required
			continue
		}

		if err := validate.MinimumInt("cron"+"."+"weekdays"+"."+strconv.Itoa(i), "body", *m.Weekdays[i], 0, false); err != nil {
			return err
		}

		if err := validate.MaximumInt("cron"+"."+"weekdays"+"."+strconv.Itoa(i), "body", *m.Weekdays[i], 6, false); err != nil {
			return err
		}

	}

	return nil
}

// ContextValidate validates this schedule inline cron based on context it is used
func (m *ScheduleInlineCron) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *ScheduleInlineCron) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ScheduleInlineCron) UnmarshalBinary(b []byte) error {
	var res ScheduleInlineCron
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ScheduleInlineLinks schedule inline links
//
// swagger:model schedule_inline__links
type ScheduleInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this schedule inline links
func (m *ScheduleInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ScheduleInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this schedule inline links based on the context it is used
func (m *ScheduleInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ScheduleInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ScheduleInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ScheduleInlineLinks) UnmarshalBinary(b []byte) error {
	var res ScheduleInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ScheduleInlineSvm SVM, applies only to SVM-scoped objects.
//
// swagger:model schedule_inline_svm
type ScheduleInlineSvm struct {

	// links
	Links *ScheduleInlineSvmInlineLinks `json:"_links,omitempty"`

	// The name of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: svm1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: 02c9e252-41be-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this schedule inline svm
func (m *ScheduleInlineSvm) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ScheduleInlineSvm) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this schedule inline svm based on the context it is used
func (m *ScheduleInlineSvm) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ScheduleInlineSvm) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ScheduleInlineSvm) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ScheduleInlineSvm) UnmarshalBinary(b []byte) error {
	var res ScheduleInlineSvm
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ScheduleInlineSvmInlineLinks schedule inline svm inline links
//
// swagger:model schedule_inline_svm_inline__links
type ScheduleInlineSvmInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this schedule inline svm inline links
func (m *ScheduleInlineSvmInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ScheduleInlineSvmInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this schedule inline svm inline links based on the context it is used
func (m *ScheduleInlineSvmInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ScheduleInlineSvmInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ScheduleInlineSvmInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ScheduleInlineSvmInlineLinks) UnmarshalBinary(b []byte) error {
	var res ScheduleInlineSvmInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
