// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// SecurityAssociation Security association object for IPsec security association and IKE (Internet Key Exchange) security association.
//
// swagger:model security_association
type SecurityAssociation struct {

	// Cipher suite for the security association.
	// Enum: ["suite_aescbc","suiteb_gcm256","suiteb_gmac256"]
	CipherSuite *string `json:"cipher_suite,omitempty"`

	// ike
	Ike *SecurityAssociationInlineIke `json:"ike,omitempty"`

	// ipsec
	Ipsec *SecurityAssociationInlineIpsec `json:"ipsec,omitempty"`

	// Lifetime for the security association in seconds.
	Lifetime *int64 `json:"lifetime,omitempty"`

	// Local address of the security association.
	LocalAddress *string `json:"local_address,omitempty"`

	// node
	Node *SecurityAssociationInlineNode `json:"node,omitempty"`

	// Policy name for the security association.
	PolicyName *string `json:"policy_name,omitempty"`

	// Remote address of the security association.
	RemoteAddress *string `json:"remote_address,omitempty"`

	// scope
	Scope *NetworkScopeReadonly `json:"scope,omitempty"`

	// svm
	Svm *SecurityAssociationInlineSvm `json:"svm,omitempty"`

	// Type of security association, it can be IPsec or IKE (Internet Key Exchange).
	// Enum: ["ipsec","ike"]
	Type *string `json:"type,omitempty"`

	// Unique identifier of the security association.
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this security association
func (m *SecurityAssociation) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateCipherSuite(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateIke(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateIpsec(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateNode(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateScope(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSvm(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateType(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var securityAssociationTypeCipherSuitePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["suite_aescbc","suiteb_gcm256","suiteb_gmac256"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		securityAssociationTypeCipherSuitePropEnum = append(securityAssociationTypeCipherSuitePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// security_association
	// SecurityAssociation
	// cipher_suite
	// CipherSuite
	// suite_aescbc
	// END DEBUGGING
	// SecurityAssociationCipherSuiteSuiteAescbc captures enum value "suite_aescbc"
	SecurityAssociationCipherSuiteSuiteAescbc string = "suite_aescbc"

	// BEGIN DEBUGGING
	// security_association
	// SecurityAssociation
	// cipher_suite
	// CipherSuite
	// suiteb_gcm256
	// END DEBUGGING
	// SecurityAssociationCipherSuiteSuitebGcm256 captures enum value "suiteb_gcm256"
	SecurityAssociationCipherSuiteSuitebGcm256 string = "suiteb_gcm256"

	// BEGIN DEBUGGING
	// security_association
	// SecurityAssociation
	// cipher_suite
	// CipherSuite
	// suiteb_gmac256
	// END DEBUGGING
	// SecurityAssociationCipherSuiteSuitebGmac256 captures enum value "suiteb_gmac256"
	SecurityAssociationCipherSuiteSuitebGmac256 string = "suiteb_gmac256"
)

// prop value enum
func (m *SecurityAssociation) validateCipherSuiteEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, securityAssociationTypeCipherSuitePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *SecurityAssociation) validateCipherSuite(formats strfmt.Registry) error {
	if swag.IsZero(m.CipherSuite) { // not required
		return nil
	}

	// value enum
	if err := m.validateCipherSuiteEnum("cipher_suite", "body", *m.CipherSuite); err != nil {
		return err
	}

	return nil
}

func (m *SecurityAssociation) validateIke(formats strfmt.Registry) error {
	if swag.IsZero(m.Ike) { // not required
		return nil
	}

	if m.Ike != nil {
		if err := m.Ike.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ike")
			}
			return err
		}
	}

	return nil
}

func (m *SecurityAssociation) validateIpsec(formats strfmt.Registry) error {
	if swag.IsZero(m.Ipsec) { // not required
		return nil
	}

	if m.Ipsec != nil {
		if err := m.Ipsec.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ipsec")
			}
			return err
		}
	}

	return nil
}

func (m *SecurityAssociation) validateNode(formats strfmt.Registry) error {
	if swag.IsZero(m.Node) { // not required
		return nil
	}

	if m.Node != nil {
		if err := m.Node.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node")
			}
			return err
		}
	}

	return nil
}

func (m *SecurityAssociation) validateScope(formats strfmt.Registry) error {
	if swag.IsZero(m.Scope) { // not required
		return nil
	}

	if m.Scope != nil {
		if err := m.Scope.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("scope")
			}
			return err
		}
	}

	return nil
}

func (m *SecurityAssociation) validateSvm(formats strfmt.Registry) error {
	if swag.IsZero(m.Svm) { // not required
		return nil
	}

	if m.Svm != nil {
		if err := m.Svm.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm")
			}
			return err
		}
	}

	return nil
}

var securityAssociationTypeTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ipsec","ike"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		securityAssociationTypeTypePropEnum = append(securityAssociationTypeTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// security_association
	// SecurityAssociation
	// type
	// Type
	// ipsec
	// END DEBUGGING
	// SecurityAssociationTypeIpsec captures enum value "ipsec"
	SecurityAssociationTypeIpsec string = "ipsec"

	// BEGIN DEBUGGING
	// security_association
	// SecurityAssociation
	// type
	// Type
	// ike
	// END DEBUGGING
	// SecurityAssociationTypeIke captures enum value "ike"
	SecurityAssociationTypeIke string = "ike"
)

// prop value enum
func (m *SecurityAssociation) validateTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, securityAssociationTypeTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *SecurityAssociation) validateType(formats strfmt.Registry) error {
	if swag.IsZero(m.Type) { // not required
		return nil
	}

	// value enum
	if err := m.validateTypeEnum("type", "body", *m.Type); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this security association based on the context it is used
func (m *SecurityAssociation) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateIke(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIpsec(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateNode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateScope(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSvm(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SecurityAssociation) contextValidateIke(ctx context.Context, formats strfmt.Registry) error {

	if m.Ike != nil {
		if err := m.Ike.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ike")
			}
			return err
		}
	}

	return nil
}

func (m *SecurityAssociation) contextValidateIpsec(ctx context.Context, formats strfmt.Registry) error {

	if m.Ipsec != nil {
		if err := m.Ipsec.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ipsec")
			}
			return err
		}
	}

	return nil
}

func (m *SecurityAssociation) contextValidateNode(ctx context.Context, formats strfmt.Registry) error {

	if m.Node != nil {
		if err := m.Node.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node")
			}
			return err
		}
	}

	return nil
}

func (m *SecurityAssociation) contextValidateScope(ctx context.Context, formats strfmt.Registry) error {

	if m.Scope != nil {
		if err := m.Scope.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("scope")
			}
			return err
		}
	}

	return nil
}

func (m *SecurityAssociation) contextValidateSvm(ctx context.Context, formats strfmt.Registry) error {

	if m.Svm != nil {
		if err := m.Svm.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *SecurityAssociation) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SecurityAssociation) UnmarshalBinary(b []byte) error {
	var res SecurityAssociation
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// SecurityAssociationInlineIke Objects containing parameters specific to IKE (Internet Key Exchange) security association.
//
// swagger:model security_association_inline_ike
type SecurityAssociationInlineIke struct {

	// Authentication method for internet key exchange protocol.
	// Enum: ["none","psk","cert"]
	Authentication *string `json:"authentication,omitempty"`

	// Initiator's security parameter index for the IKE security association.
	InitiatorSecurityParameterIndex *string `json:"initiator_security_parameter_index,omitempty"`

	// Indicates whether or not IKE has been initiated by this node.
	IsInitiator *bool `json:"is_initiator,omitempty"`

	// Responder's security parameter index for the IKE security association.
	ResponderSecurityParameterIndex *string `json:"responder_security_parameter_index,omitempty"`

	// State of the IKE connection.
	// Enum: ["none","connecting","established","dead_peer_probe"]
	State *string `json:"state,omitempty"`

	// Internet key exchange protocol version.
	Version *int64 `json:"version,omitempty"`
}

// Validate validates this security association inline ike
func (m *SecurityAssociationInlineIke) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateAuthentication(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var securityAssociationInlineIkeTypeAuthenticationPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["none","psk","cert"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		securityAssociationInlineIkeTypeAuthenticationPropEnum = append(securityAssociationInlineIkeTypeAuthenticationPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// security_association_inline_ike
	// SecurityAssociationInlineIke
	// authentication
	// Authentication
	// none
	// END DEBUGGING
	// SecurityAssociationInlineIkeAuthenticationNone captures enum value "none"
	SecurityAssociationInlineIkeAuthenticationNone string = "none"

	// BEGIN DEBUGGING
	// security_association_inline_ike
	// SecurityAssociationInlineIke
	// authentication
	// Authentication
	// psk
	// END DEBUGGING
	// SecurityAssociationInlineIkeAuthenticationPsk captures enum value "psk"
	SecurityAssociationInlineIkeAuthenticationPsk string = "psk"

	// BEGIN DEBUGGING
	// security_association_inline_ike
	// SecurityAssociationInlineIke
	// authentication
	// Authentication
	// cert
	// END DEBUGGING
	// SecurityAssociationInlineIkeAuthenticationCert captures enum value "cert"
	SecurityAssociationInlineIkeAuthenticationCert string = "cert"
)

// prop value enum
func (m *SecurityAssociationInlineIke) validateAuthenticationEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, securityAssociationInlineIkeTypeAuthenticationPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *SecurityAssociationInlineIke) validateAuthentication(formats strfmt.Registry) error {
	if swag.IsZero(m.Authentication) { // not required
		return nil
	}

	// value enum
	if err := m.validateAuthenticationEnum("ike"+"."+"authentication", "body", *m.Authentication); err != nil {
		return err
	}

	return nil
}

var securityAssociationInlineIkeTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["none","connecting","established","dead_peer_probe"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		securityAssociationInlineIkeTypeStatePropEnum = append(securityAssociationInlineIkeTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// security_association_inline_ike
	// SecurityAssociationInlineIke
	// state
	// State
	// none
	// END DEBUGGING
	// SecurityAssociationInlineIkeStateNone captures enum value "none"
	SecurityAssociationInlineIkeStateNone string = "none"

	// BEGIN DEBUGGING
	// security_association_inline_ike
	// SecurityAssociationInlineIke
	// state
	// State
	// connecting
	// END DEBUGGING
	// SecurityAssociationInlineIkeStateConnecting captures enum value "connecting"
	SecurityAssociationInlineIkeStateConnecting string = "connecting"

	// BEGIN DEBUGGING
	// security_association_inline_ike
	// SecurityAssociationInlineIke
	// state
	// State
	// established
	// END DEBUGGING
	// SecurityAssociationInlineIkeStateEstablished captures enum value "established"
	SecurityAssociationInlineIkeStateEstablished string = "established"

	// BEGIN DEBUGGING
	// security_association_inline_ike
	// SecurityAssociationInlineIke
	// state
	// State
	// dead_peer_probe
	// END DEBUGGING
	// SecurityAssociationInlineIkeStateDeadPeerProbe captures enum value "dead_peer_probe"
	SecurityAssociationInlineIkeStateDeadPeerProbe string = "dead_peer_probe"
)

// prop value enum
func (m *SecurityAssociationInlineIke) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, securityAssociationInlineIkeTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *SecurityAssociationInlineIke) validateState(formats strfmt.Registry) error {
	if swag.IsZero(m.State) { // not required
		return nil
	}

	// value enum
	if err := m.validateStateEnum("ike"+"."+"state", "body", *m.State); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this security association inline ike based on context it is used
func (m *SecurityAssociationInlineIke) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *SecurityAssociationInlineIke) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SecurityAssociationInlineIke) UnmarshalBinary(b []byte) error {
	var res SecurityAssociationInlineIke
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// SecurityAssociationInlineIpsec Objects containing parameters specific to IPsec security association.
//
// swagger:model security_association_inline_ipsec
type SecurityAssociationInlineIpsec struct {

	// Action for the IPsec security association.
	// Enum: ["bypass","discard","esp_transport"]
	Action *string `json:"action,omitempty"`

	// inbound
	Inbound *SecurityAssociationInlineIpsecInlineInbound `json:"inbound,omitempty"`

	// outbound
	Outbound *SecurityAssociationInlineIpsecInlineOutbound `json:"outbound,omitempty"`

	// State of the IPsec security association.
	State *string `json:"state,omitempty"`
}

// Validate validates this security association inline ipsec
func (m *SecurityAssociationInlineIpsec) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateAction(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateInbound(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateOutbound(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var securityAssociationInlineIpsecTypeActionPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["bypass","discard","esp_transport"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		securityAssociationInlineIpsecTypeActionPropEnum = append(securityAssociationInlineIpsecTypeActionPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// security_association_inline_ipsec
	// SecurityAssociationInlineIpsec
	// action
	// Action
	// bypass
	// END DEBUGGING
	// SecurityAssociationInlineIpsecActionBypass captures enum value "bypass"
	SecurityAssociationInlineIpsecActionBypass string = "bypass"

	// BEGIN DEBUGGING
	// security_association_inline_ipsec
	// SecurityAssociationInlineIpsec
	// action
	// Action
	// discard
	// END DEBUGGING
	// SecurityAssociationInlineIpsecActionDiscard captures enum value "discard"
	SecurityAssociationInlineIpsecActionDiscard string = "discard"

	// BEGIN DEBUGGING
	// security_association_inline_ipsec
	// SecurityAssociationInlineIpsec
	// action
	// Action
	// esp_transport
	// END DEBUGGING
	// SecurityAssociationInlineIpsecActionEspTransport captures enum value "esp_transport"
	SecurityAssociationInlineIpsecActionEspTransport string = "esp_transport"
)

// prop value enum
func (m *SecurityAssociationInlineIpsec) validateActionEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, securityAssociationInlineIpsecTypeActionPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *SecurityAssociationInlineIpsec) validateAction(formats strfmt.Registry) error {
	if swag.IsZero(m.Action) { // not required
		return nil
	}

	// value enum
	if err := m.validateActionEnum("ipsec"+"."+"action", "body", *m.Action); err != nil {
		return err
	}

	return nil
}

func (m *SecurityAssociationInlineIpsec) validateInbound(formats strfmt.Registry) error {
	if swag.IsZero(m.Inbound) { // not required
		return nil
	}

	if m.Inbound != nil {
		if err := m.Inbound.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ipsec" + "." + "inbound")
			}
			return err
		}
	}

	return nil
}

func (m *SecurityAssociationInlineIpsec) validateOutbound(formats strfmt.Registry) error {
	if swag.IsZero(m.Outbound) { // not required
		return nil
	}

	if m.Outbound != nil {
		if err := m.Outbound.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ipsec" + "." + "outbound")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this security association inline ipsec based on the context it is used
func (m *SecurityAssociationInlineIpsec) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateInbound(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateOutbound(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SecurityAssociationInlineIpsec) contextValidateInbound(ctx context.Context, formats strfmt.Registry) error {

	if m.Inbound != nil {
		if err := m.Inbound.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ipsec" + "." + "inbound")
			}
			return err
		}
	}

	return nil
}

func (m *SecurityAssociationInlineIpsec) contextValidateOutbound(ctx context.Context, formats strfmt.Registry) error {

	if m.Outbound != nil {
		if err := m.Outbound.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ipsec" + "." + "outbound")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *SecurityAssociationInlineIpsec) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SecurityAssociationInlineIpsec) UnmarshalBinary(b []byte) error {
	var res SecurityAssociationInlineIpsec
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// SecurityAssociationInlineIpsecInlineInbound Status for inbound parameters for the IPsec security association.
//
// swagger:model security_association_inline_ipsec_inline_inbound
type SecurityAssociationInlineIpsecInlineInbound struct {

	// Number of inbound bytes for the IPsec security association.
	Bytes *int64 `json:"bytes,omitempty"`

	// Number of inbound bytes processed by offload for the IPsec security association.
	OffloadBytes *int64 `json:"offload_bytes,omitempty"`

	// Number of inbound packets processed by offload for the IPsec security association.
	OffloadPackets *int64 `json:"offload_packets,omitempty"`

	// Number of inbound packets for the IPsec security association.
	Packets *int64 `json:"packets,omitempty"`

	// Inbound security parameter index for the IPSec security association.
	SecurityParameterIndex *string `json:"security_parameter_index,omitempty"`
}

// Validate validates this security association inline ipsec inline inbound
func (m *SecurityAssociationInlineIpsecInlineInbound) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this security association inline ipsec inline inbound based on context it is used
func (m *SecurityAssociationInlineIpsecInlineInbound) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *SecurityAssociationInlineIpsecInlineInbound) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SecurityAssociationInlineIpsecInlineInbound) UnmarshalBinary(b []byte) error {
	var res SecurityAssociationInlineIpsecInlineInbound
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// SecurityAssociationInlineIpsecInlineOutbound Status for outbound parameters for the IPsec security association.
//
// swagger:model security_association_inline_ipsec_inline_outbound
type SecurityAssociationInlineIpsecInlineOutbound struct {

	// Number of outbound bytes for the IPsec security association.
	Bytes *int64 `json:"bytes,omitempty"`

	// Number of outbound bytes processed by offload for the IPsec security association.
	OffloadBytes *int64 `json:"offload_bytes,omitempty"`

	// Number of outbound packets processed by offload for the IPsec security association.
	OffloadPackets *int64 `json:"offload_packets,omitempty"`

	// Number of outbound packets for the IPsec security association.
	Packets *int64 `json:"packets,omitempty"`

	// Outbound security parameter index for the IPSec security association.
	SecurityParameterIndex *string `json:"security_parameter_index,omitempty"`
}

// Validate validates this security association inline ipsec inline outbound
func (m *SecurityAssociationInlineIpsecInlineOutbound) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this security association inline ipsec inline outbound based on context it is used
func (m *SecurityAssociationInlineIpsecInlineOutbound) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *SecurityAssociationInlineIpsecInlineOutbound) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SecurityAssociationInlineIpsecInlineOutbound) UnmarshalBinary(b []byte) error {
	var res SecurityAssociationInlineIpsecInlineOutbound
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// SecurityAssociationInlineNode Node with the security association.
//
// swagger:model security_association_inline_node
type SecurityAssociationInlineNode struct {

	// links
	Links *SecurityAssociationInlineNodeInlineLinks `json:"_links,omitempty"`

	// name
	// Example: node1
	Name *string `json:"name,omitempty"`

	// uuid
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this security association inline node
func (m *SecurityAssociationInlineNode) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SecurityAssociationInlineNode) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this security association inline node based on the context it is used
func (m *SecurityAssociationInlineNode) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SecurityAssociationInlineNode) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *SecurityAssociationInlineNode) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SecurityAssociationInlineNode) UnmarshalBinary(b []byte) error {
	var res SecurityAssociationInlineNode
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// SecurityAssociationInlineNodeInlineLinks security association inline node inline links
//
// swagger:model security_association_inline_node_inline__links
type SecurityAssociationInlineNodeInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this security association inline node inline links
func (m *SecurityAssociationInlineNodeInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SecurityAssociationInlineNodeInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this security association inline node inline links based on the context it is used
func (m *SecurityAssociationInlineNodeInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SecurityAssociationInlineNodeInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *SecurityAssociationInlineNodeInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SecurityAssociationInlineNodeInlineLinks) UnmarshalBinary(b []byte) error {
	var res SecurityAssociationInlineNodeInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// SecurityAssociationInlineSvm SVM, applies only to SVM-scoped objects.
//
// swagger:model security_association_inline_svm
type SecurityAssociationInlineSvm struct {

	// links
	Links *SecurityAssociationInlineSvmInlineLinks `json:"_links,omitempty"`

	// The name of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: svm1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: 02c9e252-41be-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this security association inline svm
func (m *SecurityAssociationInlineSvm) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SecurityAssociationInlineSvm) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this security association inline svm based on the context it is used
func (m *SecurityAssociationInlineSvm) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SecurityAssociationInlineSvm) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *SecurityAssociationInlineSvm) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SecurityAssociationInlineSvm) UnmarshalBinary(b []byte) error {
	var res SecurityAssociationInlineSvm
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// SecurityAssociationInlineSvmInlineLinks security association inline svm inline links
//
// swagger:model security_association_inline_svm_inline__links
type SecurityAssociationInlineSvmInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this security association inline svm inline links
func (m *SecurityAssociationInlineSvmInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SecurityAssociationInlineSvmInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this security association inline svm inline links based on the context it is used
func (m *SecurityAssociationInlineSvmInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SecurityAssociationInlineSvmInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *SecurityAssociationInlineSvmInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SecurityAssociationInlineSvmInlineLinks) UnmarshalBinary(b []byte) error {
	var res SecurityAssociationInlineSvmInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
