// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// SecurityAssociationResponse security association response
//
// swagger:model security_association_response
type SecurityAssociationResponse struct {

	// links
	Links *SecurityAssociationResponseInlineLinks `json:"_links,omitempty"`

	// error
	Error *SecurityAssociationResponseInlineError `json:"error,omitempty"`

	// Number of records
	// Example: 1
	NumRecords *int64 `json:"num_records,omitempty"`

	// security association response inline records
	SecurityAssociationResponseInlineRecords []*SecurityAssociationResponseInlineRecordsInlineArrayItem `json:"records,omitempty"`
}

// Validate validates this security association response
func (m *SecurityAssociationResponse) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateError(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSecurityAssociationResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SecurityAssociationResponse) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *SecurityAssociationResponse) validateError(formats strfmt.Registry) error {
	if swag.IsZero(m.Error) { // not required
		return nil
	}

	if m.Error != nil {
		if err := m.Error.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("error")
			}
			return err
		}
	}

	return nil
}

func (m *SecurityAssociationResponse) validateSecurityAssociationResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(m.SecurityAssociationResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(m.SecurityAssociationResponseInlineRecords); i++ {
		if swag.IsZero(m.SecurityAssociationResponseInlineRecords[i]) { // not required
			continue
		}

		if m.SecurityAssociationResponseInlineRecords[i] != nil {
			if err := m.SecurityAssociationResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this security association response based on the context it is used
func (m *SecurityAssociationResponse) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateError(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSecurityAssociationResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SecurityAssociationResponse) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *SecurityAssociationResponse) contextValidateError(ctx context.Context, formats strfmt.Registry) error {

	if m.Error != nil {
		if err := m.Error.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("error")
			}
			return err
		}
	}

	return nil
}

func (m *SecurityAssociationResponse) contextValidateSecurityAssociationResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.SecurityAssociationResponseInlineRecords); i++ {

		if m.SecurityAssociationResponseInlineRecords[i] != nil {
			if err := m.SecurityAssociationResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *SecurityAssociationResponse) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SecurityAssociationResponse) UnmarshalBinary(b []byte) error {
	var res SecurityAssociationResponse
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// SecurityAssociationResponseInlineError security association response inline error
//
// swagger:model security_association_response_inline_error
type SecurityAssociationResponseInlineError struct {

	// Message arguments
	// Read Only: true
	Arguments []*ErrorArguments `json:"arguments,omitempty"`

	// Error code
	// Example: 4
	// Read Only: true
	Code *string `json:"code,omitempty"`

	// Error message
	// Example: entry doesn't exist
	// Read Only: true
	Message *string `json:"message,omitempty"`
}

// Validate validates this security association response inline error
func (m *SecurityAssociationResponseInlineError) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateArguments(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SecurityAssociationResponseInlineError) validateArguments(formats strfmt.Registry) error {
	if swag.IsZero(m.Arguments) { // not required
		return nil
	}

	for i := 0; i < len(m.Arguments); i++ {
		if swag.IsZero(m.Arguments[i]) { // not required
			continue
		}

		if m.Arguments[i] != nil {
			if err := m.Arguments[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("error" + "." + "arguments" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this security association response inline error based on the context it is used
func (m *SecurityAssociationResponseInlineError) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateArguments(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateCode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMessage(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SecurityAssociationResponseInlineError) contextValidateArguments(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "error"+"."+"arguments", "body", []*ErrorArguments(m.Arguments)); err != nil {
		return err
	}

	for i := 0; i < len(m.Arguments); i++ {

		if m.Arguments[i] != nil {
			if err := m.Arguments[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("error" + "." + "arguments" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *SecurityAssociationResponseInlineError) contextValidateCode(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "error"+"."+"code", "body", m.Code); err != nil {
		return err
	}

	return nil
}

func (m *SecurityAssociationResponseInlineError) contextValidateMessage(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "error"+"."+"message", "body", m.Message); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *SecurityAssociationResponseInlineError) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SecurityAssociationResponseInlineError) UnmarshalBinary(b []byte) error {
	var res SecurityAssociationResponseInlineError
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// SecurityAssociationResponseInlineLinks security association response inline links
//
// swagger:model security_association_response_inline__links
type SecurityAssociationResponseInlineLinks struct {

	// next
	Next *Href `json:"next,omitempty"`

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this security association response inline links
func (m *SecurityAssociationResponseInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateNext(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SecurityAssociationResponseInlineLinks) validateNext(formats strfmt.Registry) error {
	if swag.IsZero(m.Next) { // not required
		return nil
	}

	if m.Next != nil {
		if err := m.Next.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "next")
			}
			return err
		}
	}

	return nil
}

func (m *SecurityAssociationResponseInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this security association response inline links based on the context it is used
func (m *SecurityAssociationResponseInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateNext(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SecurityAssociationResponseInlineLinks) contextValidateNext(ctx context.Context, formats strfmt.Registry) error {

	if m.Next != nil {
		if err := m.Next.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "next")
			}
			return err
		}
	}

	return nil
}

func (m *SecurityAssociationResponseInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *SecurityAssociationResponseInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SecurityAssociationResponseInlineLinks) UnmarshalBinary(b []byte) error {
	var res SecurityAssociationResponseInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// SecurityAssociationResponseInlineRecordsInlineArrayItem Security association object for IPsec security association and IKE (Internet Key Exchange) security association.
//
// swagger:model security_association_response_inline_records_inline_array_item
type SecurityAssociationResponseInlineRecordsInlineArrayItem struct {

	// Cipher suite for the security association.
	// Enum: ["suite_aescbc","suiteb_gcm256","suiteb_gmac256"]
	CipherSuite *string `json:"cipher_suite,omitempty"`

	// ike
	Ike *SecurityAssociationResponseInlineRecordsInlineArrayItemInlineIke `json:"ike,omitempty"`

	// ipsec
	Ipsec *SecurityAssociationResponseInlineRecordsInlineArrayItemInlineIpsec `json:"ipsec,omitempty"`

	// Lifetime for the security association in seconds.
	Lifetime *int64 `json:"lifetime,omitempty"`

	// Local address of the security association.
	LocalAddress *string `json:"local_address,omitempty"`

	// node
	Node *SecurityAssociationResponseInlineRecordsInlineArrayItemInlineNode `json:"node,omitempty"`

	// Policy name for the security association.
	PolicyName *string `json:"policy_name,omitempty"`

	// Remote address of the security association.
	RemoteAddress *string `json:"remote_address,omitempty"`

	// scope
	Scope *NetworkScopeReadonly `json:"scope,omitempty"`

	// svm
	Svm *SecurityAssociationResponseInlineRecordsInlineArrayItemInlineSvm `json:"svm,omitempty"`

	// Type of security association, it can be IPsec or IKE (Internet Key Exchange).
	// Enum: ["ipsec","ike"]
	Type *string `json:"type,omitempty"`

	// Unique identifier of the security association.
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this security association response inline records inline array item
func (m *SecurityAssociationResponseInlineRecordsInlineArrayItem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateCipherSuite(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateIke(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateIpsec(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateNode(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateScope(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSvm(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateType(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var securityAssociationResponseInlineRecordsInlineArrayItemTypeCipherSuitePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["suite_aescbc","suiteb_gcm256","suiteb_gmac256"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		securityAssociationResponseInlineRecordsInlineArrayItemTypeCipherSuitePropEnum = append(securityAssociationResponseInlineRecordsInlineArrayItemTypeCipherSuitePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// security_association_response_inline_records_inline_array_item
	// SecurityAssociationResponseInlineRecordsInlineArrayItem
	// cipher_suite
	// CipherSuite
	// suite_aescbc
	// END DEBUGGING
	// SecurityAssociationResponseInlineRecordsInlineArrayItemCipherSuiteSuiteAescbc captures enum value "suite_aescbc"
	SecurityAssociationResponseInlineRecordsInlineArrayItemCipherSuiteSuiteAescbc string = "suite_aescbc"

	// BEGIN DEBUGGING
	// security_association_response_inline_records_inline_array_item
	// SecurityAssociationResponseInlineRecordsInlineArrayItem
	// cipher_suite
	// CipherSuite
	// suiteb_gcm256
	// END DEBUGGING
	// SecurityAssociationResponseInlineRecordsInlineArrayItemCipherSuiteSuitebGcm256 captures enum value "suiteb_gcm256"
	SecurityAssociationResponseInlineRecordsInlineArrayItemCipherSuiteSuitebGcm256 string = "suiteb_gcm256"

	// BEGIN DEBUGGING
	// security_association_response_inline_records_inline_array_item
	// SecurityAssociationResponseInlineRecordsInlineArrayItem
	// cipher_suite
	// CipherSuite
	// suiteb_gmac256
	// END DEBUGGING
	// SecurityAssociationResponseInlineRecordsInlineArrayItemCipherSuiteSuitebGmac256 captures enum value "suiteb_gmac256"
	SecurityAssociationResponseInlineRecordsInlineArrayItemCipherSuiteSuitebGmac256 string = "suiteb_gmac256"
)

// prop value enum
func (m *SecurityAssociationResponseInlineRecordsInlineArrayItem) validateCipherSuiteEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, securityAssociationResponseInlineRecordsInlineArrayItemTypeCipherSuitePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *SecurityAssociationResponseInlineRecordsInlineArrayItem) validateCipherSuite(formats strfmt.Registry) error {
	if swag.IsZero(m.CipherSuite) { // not required
		return nil
	}

	// value enum
	if err := m.validateCipherSuiteEnum("cipher_suite", "body", *m.CipherSuite); err != nil {
		return err
	}

	return nil
}

func (m *SecurityAssociationResponseInlineRecordsInlineArrayItem) validateIke(formats strfmt.Registry) error {
	if swag.IsZero(m.Ike) { // not required
		return nil
	}

	if m.Ike != nil {
		if err := m.Ike.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ike")
			}
			return err
		}
	}

	return nil
}

func (m *SecurityAssociationResponseInlineRecordsInlineArrayItem) validateIpsec(formats strfmt.Registry) error {
	if swag.IsZero(m.Ipsec) { // not required
		return nil
	}

	if m.Ipsec != nil {
		if err := m.Ipsec.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ipsec")
			}
			return err
		}
	}

	return nil
}

func (m *SecurityAssociationResponseInlineRecordsInlineArrayItem) validateNode(formats strfmt.Registry) error {
	if swag.IsZero(m.Node) { // not required
		return nil
	}

	if m.Node != nil {
		if err := m.Node.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node")
			}
			return err
		}
	}

	return nil
}

func (m *SecurityAssociationResponseInlineRecordsInlineArrayItem) validateScope(formats strfmt.Registry) error {
	if swag.IsZero(m.Scope) { // not required
		return nil
	}

	if m.Scope != nil {
		if err := m.Scope.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("scope")
			}
			return err
		}
	}

	return nil
}

func (m *SecurityAssociationResponseInlineRecordsInlineArrayItem) validateSvm(formats strfmt.Registry) error {
	if swag.IsZero(m.Svm) { // not required
		return nil
	}

	if m.Svm != nil {
		if err := m.Svm.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm")
			}
			return err
		}
	}

	return nil
}

var securityAssociationResponseInlineRecordsInlineArrayItemTypeTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ipsec","ike"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		securityAssociationResponseInlineRecordsInlineArrayItemTypeTypePropEnum = append(securityAssociationResponseInlineRecordsInlineArrayItemTypeTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// security_association_response_inline_records_inline_array_item
	// SecurityAssociationResponseInlineRecordsInlineArrayItem
	// type
	// Type
	// ipsec
	// END DEBUGGING
	// SecurityAssociationResponseInlineRecordsInlineArrayItemTypeIpsec captures enum value "ipsec"
	SecurityAssociationResponseInlineRecordsInlineArrayItemTypeIpsec string = "ipsec"

	// BEGIN DEBUGGING
	// security_association_response_inline_records_inline_array_item
	// SecurityAssociationResponseInlineRecordsInlineArrayItem
	// type
	// Type
	// ike
	// END DEBUGGING
	// SecurityAssociationResponseInlineRecordsInlineArrayItemTypeIke captures enum value "ike"
	SecurityAssociationResponseInlineRecordsInlineArrayItemTypeIke string = "ike"
)

// prop value enum
func (m *SecurityAssociationResponseInlineRecordsInlineArrayItem) validateTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, securityAssociationResponseInlineRecordsInlineArrayItemTypeTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *SecurityAssociationResponseInlineRecordsInlineArrayItem) validateType(formats strfmt.Registry) error {
	if swag.IsZero(m.Type) { // not required
		return nil
	}

	// value enum
	if err := m.validateTypeEnum("type", "body", *m.Type); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this security association response inline records inline array item based on the context it is used
func (m *SecurityAssociationResponseInlineRecordsInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateIke(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIpsec(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateNode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateScope(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSvm(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SecurityAssociationResponseInlineRecordsInlineArrayItem) contextValidateIke(ctx context.Context, formats strfmt.Registry) error {

	if m.Ike != nil {
		if err := m.Ike.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ike")
			}
			return err
		}
	}

	return nil
}

func (m *SecurityAssociationResponseInlineRecordsInlineArrayItem) contextValidateIpsec(ctx context.Context, formats strfmt.Registry) error {

	if m.Ipsec != nil {
		if err := m.Ipsec.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ipsec")
			}
			return err
		}
	}

	return nil
}

func (m *SecurityAssociationResponseInlineRecordsInlineArrayItem) contextValidateNode(ctx context.Context, formats strfmt.Registry) error {

	if m.Node != nil {
		if err := m.Node.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node")
			}
			return err
		}
	}

	return nil
}

func (m *SecurityAssociationResponseInlineRecordsInlineArrayItem) contextValidateScope(ctx context.Context, formats strfmt.Registry) error {

	if m.Scope != nil {
		if err := m.Scope.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("scope")
			}
			return err
		}
	}

	return nil
}

func (m *SecurityAssociationResponseInlineRecordsInlineArrayItem) contextValidateSvm(ctx context.Context, formats strfmt.Registry) error {

	if m.Svm != nil {
		if err := m.Svm.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *SecurityAssociationResponseInlineRecordsInlineArrayItem) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SecurityAssociationResponseInlineRecordsInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res SecurityAssociationResponseInlineRecordsInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// SecurityAssociationResponseInlineRecordsInlineArrayItemInlineIke Objects containing parameters specific to IKE (Internet Key Exchange) security association.
//
// swagger:model security_association_response_inline_records_inline_array_item_inline_ike
type SecurityAssociationResponseInlineRecordsInlineArrayItemInlineIke struct {

	// Authentication method for internet key exchange protocol.
	// Enum: ["none","psk","cert"]
	Authentication *string `json:"authentication,omitempty"`

	// Initiator's security parameter index for the IKE security association.
	InitiatorSecurityParameterIndex *string `json:"initiator_security_parameter_index,omitempty"`

	// Indicates whether or not IKE has been initiated by this node.
	IsInitiator *bool `json:"is_initiator,omitempty"`

	// Responder's security parameter index for the IKE security association.
	ResponderSecurityParameterIndex *string `json:"responder_security_parameter_index,omitempty"`

	// State of the IKE connection.
	// Enum: ["none","connecting","established","dead_peer_probe"]
	State *string `json:"state,omitempty"`

	// Internet key exchange protocol version.
	Version *int64 `json:"version,omitempty"`
}

// Validate validates this security association response inline records inline array item inline ike
func (m *SecurityAssociationResponseInlineRecordsInlineArrayItemInlineIke) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateAuthentication(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var securityAssociationResponseInlineRecordsInlineArrayItemInlineIkeTypeAuthenticationPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["none","psk","cert"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		securityAssociationResponseInlineRecordsInlineArrayItemInlineIkeTypeAuthenticationPropEnum = append(securityAssociationResponseInlineRecordsInlineArrayItemInlineIkeTypeAuthenticationPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// security_association_response_inline_records_inline_array_item_inline_ike
	// SecurityAssociationResponseInlineRecordsInlineArrayItemInlineIke
	// authentication
	// Authentication
	// none
	// END DEBUGGING
	// SecurityAssociationResponseInlineRecordsInlineArrayItemInlineIkeAuthenticationNone captures enum value "none"
	SecurityAssociationResponseInlineRecordsInlineArrayItemInlineIkeAuthenticationNone string = "none"

	// BEGIN DEBUGGING
	// security_association_response_inline_records_inline_array_item_inline_ike
	// SecurityAssociationResponseInlineRecordsInlineArrayItemInlineIke
	// authentication
	// Authentication
	// psk
	// END DEBUGGING
	// SecurityAssociationResponseInlineRecordsInlineArrayItemInlineIkeAuthenticationPsk captures enum value "psk"
	SecurityAssociationResponseInlineRecordsInlineArrayItemInlineIkeAuthenticationPsk string = "psk"

	// BEGIN DEBUGGING
	// security_association_response_inline_records_inline_array_item_inline_ike
	// SecurityAssociationResponseInlineRecordsInlineArrayItemInlineIke
	// authentication
	// Authentication
	// cert
	// END DEBUGGING
	// SecurityAssociationResponseInlineRecordsInlineArrayItemInlineIkeAuthenticationCert captures enum value "cert"
	SecurityAssociationResponseInlineRecordsInlineArrayItemInlineIkeAuthenticationCert string = "cert"
)

// prop value enum
func (m *SecurityAssociationResponseInlineRecordsInlineArrayItemInlineIke) validateAuthenticationEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, securityAssociationResponseInlineRecordsInlineArrayItemInlineIkeTypeAuthenticationPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *SecurityAssociationResponseInlineRecordsInlineArrayItemInlineIke) validateAuthentication(formats strfmt.Registry) error {
	if swag.IsZero(m.Authentication) { // not required
		return nil
	}

	// value enum
	if err := m.validateAuthenticationEnum("ike"+"."+"authentication", "body", *m.Authentication); err != nil {
		return err
	}

	return nil
}

var securityAssociationResponseInlineRecordsInlineArrayItemInlineIkeTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["none","connecting","established","dead_peer_probe"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		securityAssociationResponseInlineRecordsInlineArrayItemInlineIkeTypeStatePropEnum = append(securityAssociationResponseInlineRecordsInlineArrayItemInlineIkeTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// security_association_response_inline_records_inline_array_item_inline_ike
	// SecurityAssociationResponseInlineRecordsInlineArrayItemInlineIke
	// state
	// State
	// none
	// END DEBUGGING
	// SecurityAssociationResponseInlineRecordsInlineArrayItemInlineIkeStateNone captures enum value "none"
	SecurityAssociationResponseInlineRecordsInlineArrayItemInlineIkeStateNone string = "none"

	// BEGIN DEBUGGING
	// security_association_response_inline_records_inline_array_item_inline_ike
	// SecurityAssociationResponseInlineRecordsInlineArrayItemInlineIke
	// state
	// State
	// connecting
	// END DEBUGGING
	// SecurityAssociationResponseInlineRecordsInlineArrayItemInlineIkeStateConnecting captures enum value "connecting"
	SecurityAssociationResponseInlineRecordsInlineArrayItemInlineIkeStateConnecting string = "connecting"

	// BEGIN DEBUGGING
	// security_association_response_inline_records_inline_array_item_inline_ike
	// SecurityAssociationResponseInlineRecordsInlineArrayItemInlineIke
	// state
	// State
	// established
	// END DEBUGGING
	// SecurityAssociationResponseInlineRecordsInlineArrayItemInlineIkeStateEstablished captures enum value "established"
	SecurityAssociationResponseInlineRecordsInlineArrayItemInlineIkeStateEstablished string = "established"

	// BEGIN DEBUGGING
	// security_association_response_inline_records_inline_array_item_inline_ike
	// SecurityAssociationResponseInlineRecordsInlineArrayItemInlineIke
	// state
	// State
	// dead_peer_probe
	// END DEBUGGING
	// SecurityAssociationResponseInlineRecordsInlineArrayItemInlineIkeStateDeadPeerProbe captures enum value "dead_peer_probe"
	SecurityAssociationResponseInlineRecordsInlineArrayItemInlineIkeStateDeadPeerProbe string = "dead_peer_probe"
)

// prop value enum
func (m *SecurityAssociationResponseInlineRecordsInlineArrayItemInlineIke) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, securityAssociationResponseInlineRecordsInlineArrayItemInlineIkeTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *SecurityAssociationResponseInlineRecordsInlineArrayItemInlineIke) validateState(formats strfmt.Registry) error {
	if swag.IsZero(m.State) { // not required
		return nil
	}

	// value enum
	if err := m.validateStateEnum("ike"+"."+"state", "body", *m.State); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this security association response inline records inline array item inline ike based on context it is used
func (m *SecurityAssociationResponseInlineRecordsInlineArrayItemInlineIke) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *SecurityAssociationResponseInlineRecordsInlineArrayItemInlineIke) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SecurityAssociationResponseInlineRecordsInlineArrayItemInlineIke) UnmarshalBinary(b []byte) error {
	var res SecurityAssociationResponseInlineRecordsInlineArrayItemInlineIke
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// SecurityAssociationResponseInlineRecordsInlineArrayItemInlineIpsec Objects containing parameters specific to IPsec security association.
//
// swagger:model security_association_response_inline_records_inline_array_item_inline_ipsec
type SecurityAssociationResponseInlineRecordsInlineArrayItemInlineIpsec struct {

	// Action for the IPsec security association.
	// Enum: ["bypass","discard","esp_transport"]
	Action *string `json:"action,omitempty"`

	// inbound
	Inbound *SecurityAssociationResponseInlineRecordsInlineArrayItemInlineIpsecInlineInbound `json:"inbound,omitempty"`

	// outbound
	Outbound *SecurityAssociationResponseInlineRecordsInlineArrayItemInlineIpsecInlineOutbound `json:"outbound,omitempty"`

	// State of the IPsec security association.
	State *string `json:"state,omitempty"`
}

// Validate validates this security association response inline records inline array item inline ipsec
func (m *SecurityAssociationResponseInlineRecordsInlineArrayItemInlineIpsec) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateAction(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateInbound(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateOutbound(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var securityAssociationResponseInlineRecordsInlineArrayItemInlineIpsecTypeActionPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["bypass","discard","esp_transport"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		securityAssociationResponseInlineRecordsInlineArrayItemInlineIpsecTypeActionPropEnum = append(securityAssociationResponseInlineRecordsInlineArrayItemInlineIpsecTypeActionPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// security_association_response_inline_records_inline_array_item_inline_ipsec
	// SecurityAssociationResponseInlineRecordsInlineArrayItemInlineIpsec
	// action
	// Action
	// bypass
	// END DEBUGGING
	// SecurityAssociationResponseInlineRecordsInlineArrayItemInlineIpsecActionBypass captures enum value "bypass"
	SecurityAssociationResponseInlineRecordsInlineArrayItemInlineIpsecActionBypass string = "bypass"

	// BEGIN DEBUGGING
	// security_association_response_inline_records_inline_array_item_inline_ipsec
	// SecurityAssociationResponseInlineRecordsInlineArrayItemInlineIpsec
	// action
	// Action
	// discard
	// END DEBUGGING
	// SecurityAssociationResponseInlineRecordsInlineArrayItemInlineIpsecActionDiscard captures enum value "discard"
	SecurityAssociationResponseInlineRecordsInlineArrayItemInlineIpsecActionDiscard string = "discard"

	// BEGIN DEBUGGING
	// security_association_response_inline_records_inline_array_item_inline_ipsec
	// SecurityAssociationResponseInlineRecordsInlineArrayItemInlineIpsec
	// action
	// Action
	// esp_transport
	// END DEBUGGING
	// SecurityAssociationResponseInlineRecordsInlineArrayItemInlineIpsecActionEspTransport captures enum value "esp_transport"
	SecurityAssociationResponseInlineRecordsInlineArrayItemInlineIpsecActionEspTransport string = "esp_transport"
)

// prop value enum
func (m *SecurityAssociationResponseInlineRecordsInlineArrayItemInlineIpsec) validateActionEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, securityAssociationResponseInlineRecordsInlineArrayItemInlineIpsecTypeActionPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *SecurityAssociationResponseInlineRecordsInlineArrayItemInlineIpsec) validateAction(formats strfmt.Registry) error {
	if swag.IsZero(m.Action) { // not required
		return nil
	}

	// value enum
	if err := m.validateActionEnum("ipsec"+"."+"action", "body", *m.Action); err != nil {
		return err
	}

	return nil
}

func (m *SecurityAssociationResponseInlineRecordsInlineArrayItemInlineIpsec) validateInbound(formats strfmt.Registry) error {
	if swag.IsZero(m.Inbound) { // not required
		return nil
	}

	if m.Inbound != nil {
		if err := m.Inbound.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ipsec" + "." + "inbound")
			}
			return err
		}
	}

	return nil
}

func (m *SecurityAssociationResponseInlineRecordsInlineArrayItemInlineIpsec) validateOutbound(formats strfmt.Registry) error {
	if swag.IsZero(m.Outbound) { // not required
		return nil
	}

	if m.Outbound != nil {
		if err := m.Outbound.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ipsec" + "." + "outbound")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this security association response inline records inline array item inline ipsec based on the context it is used
func (m *SecurityAssociationResponseInlineRecordsInlineArrayItemInlineIpsec) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateInbound(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateOutbound(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SecurityAssociationResponseInlineRecordsInlineArrayItemInlineIpsec) contextValidateInbound(ctx context.Context, formats strfmt.Registry) error {

	if m.Inbound != nil {
		if err := m.Inbound.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ipsec" + "." + "inbound")
			}
			return err
		}
	}

	return nil
}

func (m *SecurityAssociationResponseInlineRecordsInlineArrayItemInlineIpsec) contextValidateOutbound(ctx context.Context, formats strfmt.Registry) error {

	if m.Outbound != nil {
		if err := m.Outbound.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ipsec" + "." + "outbound")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *SecurityAssociationResponseInlineRecordsInlineArrayItemInlineIpsec) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SecurityAssociationResponseInlineRecordsInlineArrayItemInlineIpsec) UnmarshalBinary(b []byte) error {
	var res SecurityAssociationResponseInlineRecordsInlineArrayItemInlineIpsec
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// SecurityAssociationResponseInlineRecordsInlineArrayItemInlineIpsecInlineInbound Status for inbound parameters for the IPsec security association.
//
// swagger:model security_association_response_inline_records_inline_array_item_inline_ipsec_inline_inbound
type SecurityAssociationResponseInlineRecordsInlineArrayItemInlineIpsecInlineInbound struct {

	// Number of inbound bytes for the IPsec security association.
	Bytes *int64 `json:"bytes,omitempty"`

	// Number of inbound bytes processed by offload for the IPsec security association.
	OffloadBytes *int64 `json:"offload_bytes,omitempty"`

	// Number of inbound packets processed by offload for the IPsec security association.
	OffloadPackets *int64 `json:"offload_packets,omitempty"`

	// Number of inbound packets for the IPsec security association.
	Packets *int64 `json:"packets,omitempty"`

	// Inbound security parameter index for the IPSec security association.
	SecurityParameterIndex *string `json:"security_parameter_index,omitempty"`
}

// Validate validates this security association response inline records inline array item inline ipsec inline inbound
func (m *SecurityAssociationResponseInlineRecordsInlineArrayItemInlineIpsecInlineInbound) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this security association response inline records inline array item inline ipsec inline inbound based on context it is used
func (m *SecurityAssociationResponseInlineRecordsInlineArrayItemInlineIpsecInlineInbound) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *SecurityAssociationResponseInlineRecordsInlineArrayItemInlineIpsecInlineInbound) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SecurityAssociationResponseInlineRecordsInlineArrayItemInlineIpsecInlineInbound) UnmarshalBinary(b []byte) error {
	var res SecurityAssociationResponseInlineRecordsInlineArrayItemInlineIpsecInlineInbound
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// SecurityAssociationResponseInlineRecordsInlineArrayItemInlineIpsecInlineOutbound Status for outbound parameters for the IPsec security association.
//
// swagger:model security_association_response_inline_records_inline_array_item_inline_ipsec_inline_outbound
type SecurityAssociationResponseInlineRecordsInlineArrayItemInlineIpsecInlineOutbound struct {

	// Number of outbound bytes for the IPsec security association.
	Bytes *int64 `json:"bytes,omitempty"`

	// Number of outbound bytes processed by offload for the IPsec security association.
	OffloadBytes *int64 `json:"offload_bytes,omitempty"`

	// Number of outbound packets processed by offload for the IPsec security association.
	OffloadPackets *int64 `json:"offload_packets,omitempty"`

	// Number of outbound packets for the IPsec security association.
	Packets *int64 `json:"packets,omitempty"`

	// Outbound security parameter index for the IPSec security association.
	SecurityParameterIndex *string `json:"security_parameter_index,omitempty"`
}

// Validate validates this security association response inline records inline array item inline ipsec inline outbound
func (m *SecurityAssociationResponseInlineRecordsInlineArrayItemInlineIpsecInlineOutbound) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this security association response inline records inline array item inline ipsec inline outbound based on context it is used
func (m *SecurityAssociationResponseInlineRecordsInlineArrayItemInlineIpsecInlineOutbound) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *SecurityAssociationResponseInlineRecordsInlineArrayItemInlineIpsecInlineOutbound) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SecurityAssociationResponseInlineRecordsInlineArrayItemInlineIpsecInlineOutbound) UnmarshalBinary(b []byte) error {
	var res SecurityAssociationResponseInlineRecordsInlineArrayItemInlineIpsecInlineOutbound
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// SecurityAssociationResponseInlineRecordsInlineArrayItemInlineNode Node with the security association.
//
// swagger:model security_association_response_inline_records_inline_array_item_inline_node
type SecurityAssociationResponseInlineRecordsInlineArrayItemInlineNode struct {

	// links
	Links *SecurityAssociationResponseInlineRecordsInlineArrayItemInlineNodeInlineLinks `json:"_links,omitempty"`

	// name
	// Example: node1
	Name *string `json:"name,omitempty"`

	// uuid
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this security association response inline records inline array item inline node
func (m *SecurityAssociationResponseInlineRecordsInlineArrayItemInlineNode) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SecurityAssociationResponseInlineRecordsInlineArrayItemInlineNode) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this security association response inline records inline array item inline node based on the context it is used
func (m *SecurityAssociationResponseInlineRecordsInlineArrayItemInlineNode) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SecurityAssociationResponseInlineRecordsInlineArrayItemInlineNode) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *SecurityAssociationResponseInlineRecordsInlineArrayItemInlineNode) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SecurityAssociationResponseInlineRecordsInlineArrayItemInlineNode) UnmarshalBinary(b []byte) error {
	var res SecurityAssociationResponseInlineRecordsInlineArrayItemInlineNode
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// SecurityAssociationResponseInlineRecordsInlineArrayItemInlineNodeInlineLinks security association response inline records inline array item inline node inline links
//
// swagger:model security_association_response_inline_records_inline_array_item_inline_node_inline__links
type SecurityAssociationResponseInlineRecordsInlineArrayItemInlineNodeInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this security association response inline records inline array item inline node inline links
func (m *SecurityAssociationResponseInlineRecordsInlineArrayItemInlineNodeInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SecurityAssociationResponseInlineRecordsInlineArrayItemInlineNodeInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this security association response inline records inline array item inline node inline links based on the context it is used
func (m *SecurityAssociationResponseInlineRecordsInlineArrayItemInlineNodeInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SecurityAssociationResponseInlineRecordsInlineArrayItemInlineNodeInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *SecurityAssociationResponseInlineRecordsInlineArrayItemInlineNodeInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SecurityAssociationResponseInlineRecordsInlineArrayItemInlineNodeInlineLinks) UnmarshalBinary(b []byte) error {
	var res SecurityAssociationResponseInlineRecordsInlineArrayItemInlineNodeInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// SecurityAssociationResponseInlineRecordsInlineArrayItemInlineSvm SVM, applies only to SVM-scoped objects.
//
// swagger:model security_association_response_inline_records_inline_array_item_inline_svm
type SecurityAssociationResponseInlineRecordsInlineArrayItemInlineSvm struct {

	// links
	Links *SecurityAssociationResponseInlineRecordsInlineArrayItemInlineSvmInlineLinks `json:"_links,omitempty"`

	// The name of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: svm1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: 02c9e252-41be-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this security association response inline records inline array item inline svm
func (m *SecurityAssociationResponseInlineRecordsInlineArrayItemInlineSvm) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SecurityAssociationResponseInlineRecordsInlineArrayItemInlineSvm) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this security association response inline records inline array item inline svm based on the context it is used
func (m *SecurityAssociationResponseInlineRecordsInlineArrayItemInlineSvm) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SecurityAssociationResponseInlineRecordsInlineArrayItemInlineSvm) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *SecurityAssociationResponseInlineRecordsInlineArrayItemInlineSvm) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SecurityAssociationResponseInlineRecordsInlineArrayItemInlineSvm) UnmarshalBinary(b []byte) error {
	var res SecurityAssociationResponseInlineRecordsInlineArrayItemInlineSvm
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// SecurityAssociationResponseInlineRecordsInlineArrayItemInlineSvmInlineLinks security association response inline records inline array item inline svm inline links
//
// swagger:model security_association_response_inline_records_inline_array_item_inline_svm_inline__links
type SecurityAssociationResponseInlineRecordsInlineArrayItemInlineSvmInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this security association response inline records inline array item inline svm inline links
func (m *SecurityAssociationResponseInlineRecordsInlineArrayItemInlineSvmInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SecurityAssociationResponseInlineRecordsInlineArrayItemInlineSvmInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this security association response inline records inline array item inline svm inline links based on the context it is used
func (m *SecurityAssociationResponseInlineRecordsInlineArrayItemInlineSvmInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SecurityAssociationResponseInlineRecordsInlineArrayItemInlineSvmInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *SecurityAssociationResponseInlineRecordsInlineArrayItemInlineSvmInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SecurityAssociationResponseInlineRecordsInlineArrayItemInlineSvmInlineLinks) UnmarshalBinary(b []byte) error {
	var res SecurityAssociationResponseInlineRecordsInlineArrayItemInlineSvmInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
