// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// SecurityAuditLogForward security audit log forward
//
// swagger:model security_audit_log_forward
type SecurityAuditLogForward struct {

	// Destination syslog|splunk host to forward audit records to. This can be an IP address (IPv4|IPv6) or a hostname.
	// Example: 1.1.1.1
	Address *string `json:"address,omitempty"`

	// This is the standard Syslog Facility value that is used when sending audit records to a remote server.
	// Enum: ["kern","user","local0","local1","local2","local3","local4","local5","local6","local7"]
	Facility *string `json:"facility,omitempty"`

	// Syslog Hostname Format Override
	// Enum: ["no_override","fqdn","hostname_only"]
	HostnameFormatOverride *string `json:"hostname_format_override,omitempty"`

	// ipspace
	Ipspace *SecurityAuditLogForwardInlineIpspace `json:"ipspace,omitempty"`

	// Syslog message format to be used. legacy_netapp format (variation of RFC-3164) is default message format.
	// Enum: ["legacy_netapp","rfc_5424"]
	MessageFormat *string `json:"message_format,omitempty"`

	// Destination Port. The default port depends on the protocol chosen:
	// For un-encrypted destinations the default port is 514.
	// For encrypted destinations the default port is 6514.
	//
	// Example: 514
	Port *int64 `json:"port,omitempty"`

	// Log forwarding protocol
	// Enum: ["udp_unencrypted","tcp_unencrypted","tcp_encrypted"]
	Protocol *string `json:"protocol,omitempty"`

	// Syslog Timestamp Format Override.
	// Enum: ["no_override","rfc_3164","iso_8601_utc","iso_8601_local_time"]
	TimestampFormatOverride *string `json:"timestamp_format_override,omitempty"`

	// This is only applicable when the protocol is tcp_encrypted. This controls whether the remote server's certificate is validated. Setting "verify_server" to "true" will enforce validation of remote server's certificate. Setting "verify_server" to "false" will not enforce validation of remote server's certificate.
	VerifyServer *bool `json:"verify_server,omitempty"`
}

// Validate validates this security audit log forward
func (m *SecurityAuditLogForward) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateFacility(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateHostnameFormatOverride(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateIpspace(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateMessageFormat(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateProtocol(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTimestampFormatOverride(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var securityAuditLogForwardTypeFacilityPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["kern","user","local0","local1","local2","local3","local4","local5","local6","local7"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		securityAuditLogForwardTypeFacilityPropEnum = append(securityAuditLogForwardTypeFacilityPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// security_audit_log_forward
	// SecurityAuditLogForward
	// facility
	// Facility
	// kern
	// END DEBUGGING
	// SecurityAuditLogForwardFacilityKern captures enum value "kern"
	SecurityAuditLogForwardFacilityKern string = "kern"

	// BEGIN DEBUGGING
	// security_audit_log_forward
	// SecurityAuditLogForward
	// facility
	// Facility
	// user
	// END DEBUGGING
	// SecurityAuditLogForwardFacilityUser captures enum value "user"
	SecurityAuditLogForwardFacilityUser string = "user"

	// BEGIN DEBUGGING
	// security_audit_log_forward
	// SecurityAuditLogForward
	// facility
	// Facility
	// local0
	// END DEBUGGING
	// SecurityAuditLogForwardFacilityLocal0 captures enum value "local0"
	SecurityAuditLogForwardFacilityLocal0 string = "local0"

	// BEGIN DEBUGGING
	// security_audit_log_forward
	// SecurityAuditLogForward
	// facility
	// Facility
	// local1
	// END DEBUGGING
	// SecurityAuditLogForwardFacilityLocal1 captures enum value "local1"
	SecurityAuditLogForwardFacilityLocal1 string = "local1"

	// BEGIN DEBUGGING
	// security_audit_log_forward
	// SecurityAuditLogForward
	// facility
	// Facility
	// local2
	// END DEBUGGING
	// SecurityAuditLogForwardFacilityLocal2 captures enum value "local2"
	SecurityAuditLogForwardFacilityLocal2 string = "local2"

	// BEGIN DEBUGGING
	// security_audit_log_forward
	// SecurityAuditLogForward
	// facility
	// Facility
	// local3
	// END DEBUGGING
	// SecurityAuditLogForwardFacilityLocal3 captures enum value "local3"
	SecurityAuditLogForwardFacilityLocal3 string = "local3"

	// BEGIN DEBUGGING
	// security_audit_log_forward
	// SecurityAuditLogForward
	// facility
	// Facility
	// local4
	// END DEBUGGING
	// SecurityAuditLogForwardFacilityLocal4 captures enum value "local4"
	SecurityAuditLogForwardFacilityLocal4 string = "local4"

	// BEGIN DEBUGGING
	// security_audit_log_forward
	// SecurityAuditLogForward
	// facility
	// Facility
	// local5
	// END DEBUGGING
	// SecurityAuditLogForwardFacilityLocal5 captures enum value "local5"
	SecurityAuditLogForwardFacilityLocal5 string = "local5"

	// BEGIN DEBUGGING
	// security_audit_log_forward
	// SecurityAuditLogForward
	// facility
	// Facility
	// local6
	// END DEBUGGING
	// SecurityAuditLogForwardFacilityLocal6 captures enum value "local6"
	SecurityAuditLogForwardFacilityLocal6 string = "local6"

	// BEGIN DEBUGGING
	// security_audit_log_forward
	// SecurityAuditLogForward
	// facility
	// Facility
	// local7
	// END DEBUGGING
	// SecurityAuditLogForwardFacilityLocal7 captures enum value "local7"
	SecurityAuditLogForwardFacilityLocal7 string = "local7"
)

// prop value enum
func (m *SecurityAuditLogForward) validateFacilityEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, securityAuditLogForwardTypeFacilityPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *SecurityAuditLogForward) validateFacility(formats strfmt.Registry) error {
	if swag.IsZero(m.Facility) { // not required
		return nil
	}

	// value enum
	if err := m.validateFacilityEnum("facility", "body", *m.Facility); err != nil {
		return err
	}

	return nil
}

var securityAuditLogForwardTypeHostnameFormatOverridePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["no_override","fqdn","hostname_only"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		securityAuditLogForwardTypeHostnameFormatOverridePropEnum = append(securityAuditLogForwardTypeHostnameFormatOverridePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// security_audit_log_forward
	// SecurityAuditLogForward
	// hostname_format_override
	// HostnameFormatOverride
	// no_override
	// END DEBUGGING
	// SecurityAuditLogForwardHostnameFormatOverrideNoOverride captures enum value "no_override"
	SecurityAuditLogForwardHostnameFormatOverrideNoOverride string = "no_override"

	// BEGIN DEBUGGING
	// security_audit_log_forward
	// SecurityAuditLogForward
	// hostname_format_override
	// HostnameFormatOverride
	// fqdn
	// END DEBUGGING
	// SecurityAuditLogForwardHostnameFormatOverrideFqdn captures enum value "fqdn"
	SecurityAuditLogForwardHostnameFormatOverrideFqdn string = "fqdn"

	// BEGIN DEBUGGING
	// security_audit_log_forward
	// SecurityAuditLogForward
	// hostname_format_override
	// HostnameFormatOverride
	// hostname_only
	// END DEBUGGING
	// SecurityAuditLogForwardHostnameFormatOverrideHostnameOnly captures enum value "hostname_only"
	SecurityAuditLogForwardHostnameFormatOverrideHostnameOnly string = "hostname_only"
)

// prop value enum
func (m *SecurityAuditLogForward) validateHostnameFormatOverrideEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, securityAuditLogForwardTypeHostnameFormatOverridePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *SecurityAuditLogForward) validateHostnameFormatOverride(formats strfmt.Registry) error {
	if swag.IsZero(m.HostnameFormatOverride) { // not required
		return nil
	}

	// value enum
	if err := m.validateHostnameFormatOverrideEnum("hostname_format_override", "body", *m.HostnameFormatOverride); err != nil {
		return err
	}

	return nil
}

func (m *SecurityAuditLogForward) validateIpspace(formats strfmt.Registry) error {
	if swag.IsZero(m.Ipspace) { // not required
		return nil
	}

	if m.Ipspace != nil {
		if err := m.Ipspace.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ipspace")
			}
			return err
		}
	}

	return nil
}

var securityAuditLogForwardTypeMessageFormatPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["legacy_netapp","rfc_5424"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		securityAuditLogForwardTypeMessageFormatPropEnum = append(securityAuditLogForwardTypeMessageFormatPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// security_audit_log_forward
	// SecurityAuditLogForward
	// message_format
	// MessageFormat
	// legacy_netapp
	// END DEBUGGING
	// SecurityAuditLogForwardMessageFormatLegacyNetapp captures enum value "legacy_netapp"
	SecurityAuditLogForwardMessageFormatLegacyNetapp string = "legacy_netapp"

	// BEGIN DEBUGGING
	// security_audit_log_forward
	// SecurityAuditLogForward
	// message_format
	// MessageFormat
	// rfc_5424
	// END DEBUGGING
	// SecurityAuditLogForwardMessageFormatRfc5424 captures enum value "rfc_5424"
	SecurityAuditLogForwardMessageFormatRfc5424 string = "rfc_5424"
)

// prop value enum
func (m *SecurityAuditLogForward) validateMessageFormatEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, securityAuditLogForwardTypeMessageFormatPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *SecurityAuditLogForward) validateMessageFormat(formats strfmt.Registry) error {
	if swag.IsZero(m.MessageFormat) { // not required
		return nil
	}

	// value enum
	if err := m.validateMessageFormatEnum("message_format", "body", *m.MessageFormat); err != nil {
		return err
	}

	return nil
}

var securityAuditLogForwardTypeProtocolPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["udp_unencrypted","tcp_unencrypted","tcp_encrypted"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		securityAuditLogForwardTypeProtocolPropEnum = append(securityAuditLogForwardTypeProtocolPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// security_audit_log_forward
	// SecurityAuditLogForward
	// protocol
	// Protocol
	// udp_unencrypted
	// END DEBUGGING
	// SecurityAuditLogForwardProtocolUDPUnencrypted captures enum value "udp_unencrypted"
	SecurityAuditLogForwardProtocolUDPUnencrypted string = "udp_unencrypted"

	// BEGIN DEBUGGING
	// security_audit_log_forward
	// SecurityAuditLogForward
	// protocol
	// Protocol
	// tcp_unencrypted
	// END DEBUGGING
	// SecurityAuditLogForwardProtocolTCPUnencrypted captures enum value "tcp_unencrypted"
	SecurityAuditLogForwardProtocolTCPUnencrypted string = "tcp_unencrypted"

	// BEGIN DEBUGGING
	// security_audit_log_forward
	// SecurityAuditLogForward
	// protocol
	// Protocol
	// tcp_encrypted
	// END DEBUGGING
	// SecurityAuditLogForwardProtocolTCPEncrypted captures enum value "tcp_encrypted"
	SecurityAuditLogForwardProtocolTCPEncrypted string = "tcp_encrypted"
)

// prop value enum
func (m *SecurityAuditLogForward) validateProtocolEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, securityAuditLogForwardTypeProtocolPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *SecurityAuditLogForward) validateProtocol(formats strfmt.Registry) error {
	if swag.IsZero(m.Protocol) { // not required
		return nil
	}

	// value enum
	if err := m.validateProtocolEnum("protocol", "body", *m.Protocol); err != nil {
		return err
	}

	return nil
}

var securityAuditLogForwardTypeTimestampFormatOverridePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["no_override","rfc_3164","iso_8601_utc","iso_8601_local_time"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		securityAuditLogForwardTypeTimestampFormatOverridePropEnum = append(securityAuditLogForwardTypeTimestampFormatOverridePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// security_audit_log_forward
	// SecurityAuditLogForward
	// timestamp_format_override
	// TimestampFormatOverride
	// no_override
	// END DEBUGGING
	// SecurityAuditLogForwardTimestampFormatOverrideNoOverride captures enum value "no_override"
	SecurityAuditLogForwardTimestampFormatOverrideNoOverride string = "no_override"

	// BEGIN DEBUGGING
	// security_audit_log_forward
	// SecurityAuditLogForward
	// timestamp_format_override
	// TimestampFormatOverride
	// rfc_3164
	// END DEBUGGING
	// SecurityAuditLogForwardTimestampFormatOverrideRfc3164 captures enum value "rfc_3164"
	SecurityAuditLogForwardTimestampFormatOverrideRfc3164 string = "rfc_3164"

	// BEGIN DEBUGGING
	// security_audit_log_forward
	// SecurityAuditLogForward
	// timestamp_format_override
	// TimestampFormatOverride
	// iso_8601_utc
	// END DEBUGGING
	// SecurityAuditLogForwardTimestampFormatOverrideIso8601Utc captures enum value "iso_8601_utc"
	SecurityAuditLogForwardTimestampFormatOverrideIso8601Utc string = "iso_8601_utc"

	// BEGIN DEBUGGING
	// security_audit_log_forward
	// SecurityAuditLogForward
	// timestamp_format_override
	// TimestampFormatOverride
	// iso_8601_local_time
	// END DEBUGGING
	// SecurityAuditLogForwardTimestampFormatOverrideIso8601LocalTime captures enum value "iso_8601_local_time"
	SecurityAuditLogForwardTimestampFormatOverrideIso8601LocalTime string = "iso_8601_local_time"
)

// prop value enum
func (m *SecurityAuditLogForward) validateTimestampFormatOverrideEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, securityAuditLogForwardTypeTimestampFormatOverridePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *SecurityAuditLogForward) validateTimestampFormatOverride(formats strfmt.Registry) error {
	if swag.IsZero(m.TimestampFormatOverride) { // not required
		return nil
	}

	// value enum
	if err := m.validateTimestampFormatOverrideEnum("timestamp_format_override", "body", *m.TimestampFormatOverride); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this security audit log forward based on the context it is used
func (m *SecurityAuditLogForward) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateIpspace(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SecurityAuditLogForward) contextValidateIpspace(ctx context.Context, formats strfmt.Registry) error {

	if m.Ipspace != nil {
		if err := m.Ipspace.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ipspace")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *SecurityAuditLogForward) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SecurityAuditLogForward) UnmarshalBinary(b []byte) error {
	var res SecurityAuditLogForward
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// SecurityAuditLogForwardInlineIpspace security audit log forward inline ipspace
//
// swagger:model security_audit_log_forward_inline_ipspace
type SecurityAuditLogForwardInlineIpspace struct {

	// links
	Links *SecurityAuditLogForwardInlineIpspaceInlineLinks `json:"_links,omitempty"`

	// IPspace name
	// Example: Default
	Name *string `json:"name,omitempty"`

	// IPspace UUID
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this security audit log forward inline ipspace
func (m *SecurityAuditLogForwardInlineIpspace) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SecurityAuditLogForwardInlineIpspace) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ipspace" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this security audit log forward inline ipspace based on the context it is used
func (m *SecurityAuditLogForwardInlineIpspace) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SecurityAuditLogForwardInlineIpspace) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ipspace" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *SecurityAuditLogForwardInlineIpspace) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SecurityAuditLogForwardInlineIpspace) UnmarshalBinary(b []byte) error {
	var res SecurityAuditLogForwardInlineIpspace
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// SecurityAuditLogForwardInlineIpspaceInlineLinks security audit log forward inline ipspace inline links
//
// swagger:model security_audit_log_forward_inline_ipspace_inline__links
type SecurityAuditLogForwardInlineIpspaceInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this security audit log forward inline ipspace inline links
func (m *SecurityAuditLogForwardInlineIpspaceInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SecurityAuditLogForwardInlineIpspaceInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ipspace" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this security audit log forward inline ipspace inline links based on the context it is used
func (m *SecurityAuditLogForwardInlineIpspaceInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SecurityAuditLogForwardInlineIpspaceInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ipspace" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *SecurityAuditLogForwardInlineIpspaceInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SecurityAuditLogForwardInlineIpspaceInlineLinks) UnmarshalBinary(b []byte) error {
	var res SecurityAuditLogForwardInlineIpspaceInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
