// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// SecurityAzure security azure
//
// swagger:model security_azure
type SecurityAzure struct {

	// PKCS12 certificate used by the application to prove its identity to AKV.
	// Example: PEM Cert
	// Format: password
	ClientCertificate *strfmt.Password `json:"client_certificate,omitempty"`

	// Application client ID of the deployed Azure application with appropriate access to an AKV.
	// Example: aaaaaaaa-bbbb-aaaa-bbbb-aaaaaaaaaaaa
	ClientID *string `json:"client_id,omitempty"`

	// Secret used by the application to prove its identity to AKV.
	// Example: abcdef
	// Format: password
	ClientSecret *strfmt.Password `json:"client_secret,omitempty"`

	// URI of the deployed AKV that is used by ONTAP for storing keys.
	// Example: https://kmip-akv-keyvault.vault.azure.net/
	// Format: uri
	KeyVault *strfmt.URI `json:"key_vault,omitempty"`

	// Open authorization server host name.
	// Example: login.microsoftonline.com
	OauthHost *string `json:"oauth_host,omitempty"`

	// proxy
	Proxy *SecurityAzureInlineProxy `json:"proxy,omitempty"`

	// Directory (tenant) ID of the deployed Azure application with appropriate access to an AKV.
	// Example: zzzzzzzz-yyyy-zzzz-yyyy-zzzzzzzzzzzz
	TenantID *string `json:"tenant_id,omitempty"`

	// AKV connection timeout, in seconds. The allowed range is between 0 to 30 seconds.
	// Example: 25
	Timeout *int64 `json:"timeout,omitempty"`

	// Verify the identity of the AKV host name. By default, verify_host is set to true.
	VerifyHost *bool `json:"verify_host,omitempty"`
}

// Validate validates this security azure
func (m *SecurityAzure) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateClientCertificate(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateClientSecret(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateKeyVault(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateProxy(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SecurityAzure) validateClientCertificate(formats strfmt.Registry) error {
	if swag.IsZero(m.ClientCertificate) { // not required
		return nil
	}

	if err := validate.FormatOf("client_certificate", "body", "password", m.ClientCertificate.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *SecurityAzure) validateClientSecret(formats strfmt.Registry) error {
	if swag.IsZero(m.ClientSecret) { // not required
		return nil
	}

	if err := validate.FormatOf("client_secret", "body", "password", m.ClientSecret.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *SecurityAzure) validateKeyVault(formats strfmt.Registry) error {
	if swag.IsZero(m.KeyVault) { // not required
		return nil
	}

	if err := validate.FormatOf("key_vault", "body", "uri", m.KeyVault.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *SecurityAzure) validateProxy(formats strfmt.Registry) error {
	if swag.IsZero(m.Proxy) { // not required
		return nil
	}

	if m.Proxy != nil {
		if err := m.Proxy.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("proxy")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this security azure based on the context it is used
func (m *SecurityAzure) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateProxy(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SecurityAzure) contextValidateProxy(ctx context.Context, formats strfmt.Registry) error {

	if m.Proxy != nil {
		if err := m.Proxy.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("proxy")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *SecurityAzure) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SecurityAzure) UnmarshalBinary(b []byte) error {
	var res SecurityAzure
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// SecurityAzureInlineProxy security azure inline proxy
//
// swagger:model security_azure_inline_proxy
type SecurityAzureInlineProxy struct {

	// Proxy host.
	// Example: proxy.eng.com
	Host *string `json:"host,omitempty"`

	// Proxy password. Password is not audited.
	// Example: proxypassword
	Password *string `json:"password,omitempty"`

	// Proxy port.
	// Example: 1234
	Port *int64 `json:"port,omitempty"`

	// Proxy type.
	// Enum: ["http","https"]
	Type *string `json:"type,omitempty"`

	// Proxy username.
	// Example: proxyuser
	Username *string `json:"username,omitempty"`
}

// Validate validates this security azure inline proxy
func (m *SecurityAzureInlineProxy) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateType(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var securityAzureInlineProxyTypeTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["http","https"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		securityAzureInlineProxyTypeTypePropEnum = append(securityAzureInlineProxyTypeTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// security_azure_inline_proxy
	// SecurityAzureInlineProxy
	// type
	// Type
	// http
	// END DEBUGGING
	// SecurityAzureInlineProxyTypeHTTP captures enum value "http"
	SecurityAzureInlineProxyTypeHTTP string = "http"

	// BEGIN DEBUGGING
	// security_azure_inline_proxy
	// SecurityAzureInlineProxy
	// type
	// Type
	// https
	// END DEBUGGING
	// SecurityAzureInlineProxyTypeHTTPS captures enum value "https"
	SecurityAzureInlineProxyTypeHTTPS string = "https"
)

// prop value enum
func (m *SecurityAzureInlineProxy) validateTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, securityAzureInlineProxyTypeTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *SecurityAzureInlineProxy) validateType(formats strfmt.Registry) error {
	if swag.IsZero(m.Type) { // not required
		return nil
	}

	// value enum
	if err := m.validateTypeEnum("proxy"+"."+"type", "body", *m.Type); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this security azure inline proxy based on context it is used
func (m *SecurityAzureInlineProxy) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *SecurityAzureInlineProxy) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SecurityAzureInlineProxy) UnmarshalBinary(b []byte) error {
	var res SecurityAzureInlineProxy
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
