// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// SecurityClusterNetwork Manages the cluster network security configuration.
//
// swagger:model security_cluster_network
type SecurityClusterNetwork struct {

	// links
	Links *SelfLink `json:"_links,omitempty"`

	// Indicates whether cluster network security is enabled.
	Enabled *bool `json:"enabled,omitempty"`

	// The cluster network security mode.
	// Enum: ["tls"]
	Mode *string `json:"mode,omitempty"`

	// The status of the cluster network security configuration.
	// Example: ENABLING | DISABLING | READY
	// Read Only: true
	Status *string `json:"status,omitempty"`
}

// Validate validates this security cluster network
func (m *SecurityClusterNetwork) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateMode(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SecurityClusterNetwork) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

var securityClusterNetworkTypeModePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["tls"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		securityClusterNetworkTypeModePropEnum = append(securityClusterNetworkTypeModePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// security_cluster_network
	// SecurityClusterNetwork
	// mode
	// Mode
	// tls
	// END DEBUGGING
	// SecurityClusterNetworkModeTLS captures enum value "tls"
	SecurityClusterNetworkModeTLS string = "tls"
)

// prop value enum
func (m *SecurityClusterNetwork) validateModeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, securityClusterNetworkTypeModePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *SecurityClusterNetwork) validateMode(formats strfmt.Registry) error {
	if swag.IsZero(m.Mode) { // not required
		return nil
	}

	// value enum
	if err := m.validateModeEnum("mode", "body", *m.Mode); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this security cluster network based on the context it is used
func (m *SecurityClusterNetwork) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStatus(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SecurityClusterNetwork) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *SecurityClusterNetwork) contextValidateStatus(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "status", "body", m.Status); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *SecurityClusterNetwork) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SecurityClusterNetwork) UnmarshalBinary(b []byte) error {
	var res SecurityClusterNetwork
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
