// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// SecurityExternalRoleMappingResponse security external role mapping response
//
// swagger:model security_external_role_mapping_response
type SecurityExternalRoleMappingResponse struct {

	// links
	Links *CollectionLinks `json:"_links,omitempty"`

	// Number of records.
	NumRecords *int64 `json:"num_records,omitempty"`

	// security external role mapping response inline records
	SecurityExternalRoleMappingResponseInlineRecords []*SecurityExternalRoleMapping `json:"records,omitempty"`
}

// Validate validates this security external role mapping response
func (m *SecurityExternalRoleMappingResponse) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSecurityExternalRoleMappingResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SecurityExternalRoleMappingResponse) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *SecurityExternalRoleMappingResponse) validateSecurityExternalRoleMappingResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(m.SecurityExternalRoleMappingResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(m.SecurityExternalRoleMappingResponseInlineRecords); i++ {
		if swag.IsZero(m.SecurityExternalRoleMappingResponseInlineRecords[i]) { // not required
			continue
		}

		if m.SecurityExternalRoleMappingResponseInlineRecords[i] != nil {
			if err := m.SecurityExternalRoleMappingResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this security external role mapping response based on the context it is used
func (m *SecurityExternalRoleMappingResponse) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSecurityExternalRoleMappingResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SecurityExternalRoleMappingResponse) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *SecurityExternalRoleMappingResponse) contextValidateSecurityExternalRoleMappingResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.SecurityExternalRoleMappingResponseInlineRecords); i++ {

		if m.SecurityExternalRoleMappingResponseInlineRecords[i] != nil {
			if err := m.SecurityExternalRoleMappingResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *SecurityExternalRoleMappingResponse) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SecurityExternalRoleMappingResponse) UnmarshalBinary(b []byte) error {
	var res SecurityExternalRoleMappingResponse
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
