// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// SecurityHaNetwork Manages the HA network security configuration.
//
// swagger:model security_ha_network
type SecurityHaNetwork struct {

	// links
	Links *SelfLink `json:"_links,omitempty"`

	// Indicates if HA network security is enabled.
	Enabled *bool `json:"enabled,omitempty"`

	// node name
	NodeName *SecurityHaNetworkInlineNodeName `json:"node.name,omitempty"`
}

// Validate validates this security ha network
func (m *SecurityHaNetwork) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateNodeName(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SecurityHaNetwork) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *SecurityHaNetwork) validateNodeName(formats strfmt.Registry) error {
	if swag.IsZero(m.NodeName) { // not required
		return nil
	}

	if m.NodeName != nil {
		if err := m.NodeName.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node.name")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this security ha network based on the context it is used
func (m *SecurityHaNetwork) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateNodeName(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SecurityHaNetwork) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *SecurityHaNetwork) contextValidateNodeName(ctx context.Context, formats strfmt.Registry) error {

	if m.NodeName != nil {
		if err := m.NodeName.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node.name")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *SecurityHaNetwork) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SecurityHaNetwork) UnmarshalBinary(b []byte) error {
	var res SecurityHaNetwork
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// SecurityHaNetworkInlineNodeName Node name
//
// swagger:model security_ha_network_inline_node.name
type SecurityHaNetworkInlineNodeName struct {

	// links
	Links *SecurityHaNetworkInlineNodeNameInlineLinks `json:"_links,omitempty"`

	// name
	// Example: node1
	Name *string `json:"name,omitempty"`

	// uuid
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this security ha network inline node name
func (m *SecurityHaNetworkInlineNodeName) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SecurityHaNetworkInlineNodeName) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node.name" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this security ha network inline node name based on the context it is used
func (m *SecurityHaNetworkInlineNodeName) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SecurityHaNetworkInlineNodeName) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node.name" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *SecurityHaNetworkInlineNodeName) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SecurityHaNetworkInlineNodeName) UnmarshalBinary(b []byte) error {
	var res SecurityHaNetworkInlineNodeName
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// SecurityHaNetworkInlineNodeNameInlineLinks security ha network inline node name inline links
//
// swagger:model security_ha_network_inline_node.name_inline__links
type SecurityHaNetworkInlineNodeNameInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this security ha network inline node name inline links
func (m *SecurityHaNetworkInlineNodeNameInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SecurityHaNetworkInlineNodeNameInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node.name" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this security ha network inline node name inline links based on the context it is used
func (m *SecurityHaNetworkInlineNodeNameInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SecurityHaNetworkInlineNodeNameInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node.name" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *SecurityHaNetworkInlineNodeNameInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SecurityHaNetworkInlineNodeNameInlineLinks) UnmarshalBinary(b []byte) error {
	var res SecurityHaNetworkInlineNodeNameInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
