// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// SecurityJitPrivilegeUser security jit privilege user
//
// swagger:model security_jit_privilege_user
type SecurityJitPrivilegeUser struct {

	// The name of the user.
	//
	Account *AccountReference `json:"account,omitempty"`

	// The name of the application.
	//
	// Enum: ["ssh"]
	Application *string `json:"application,omitempty"`

	// The description of the elevation rule.
	//
	// Example: Comment text
	Comment *string `json:"comment,omitempty"`

	// The end date and time of the JIT privilege session in UTC.
	//
	// Example: 2024-11-08 11:15:31+00:00
	// Read Only: true
	// Format: date-time
	EndTime *strfmt.DateTime `json:"end_time,omitempty"`

	// The current status of the rule: preactive, idle, or active.
	//
	// Example: active
	// Read Only: true
	// Enum: ["preactive","idle","active"]
	JitState *string `json:"jit_state,omitempty"`

	// The JIT validity period on this SVM for this user.
	//
	// Example: P90D
	JitValidity *string `json:"jit_validity,omitempty"`

	// owner
	Owner *SecurityJitPrivilegeUserInlineOwner `json:"owner,omitempty"`

	// role
	Role *SecurityJitPrivilegeUserInlineRole `json:"role,omitempty"`

	// The session validity period on this SVM for this user.
	//
	// Example: PT1H
	SessionValidity *string `json:"session_validity,omitempty"`

	// The start date and time of the JIT privilege session in UTC.
	//
	// Example: 2024-11-08 10:15:31+00:00
	// Format: date-time
	StartTime *strfmt.DateTime `json:"start_time,omitempty"`
}

// Validate validates this security jit privilege user
func (m *SecurityJitPrivilegeUser) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateAccount(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateApplication(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateEndTime(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateJitState(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateOwner(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateRole(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStartTime(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SecurityJitPrivilegeUser) validateAccount(formats strfmt.Registry) error {
	if swag.IsZero(m.Account) { // not required
		return nil
	}

	if m.Account != nil {
		if err := m.Account.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("account")
			}
			return err
		}
	}

	return nil
}

var securityJitPrivilegeUserTypeApplicationPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ssh"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		securityJitPrivilegeUserTypeApplicationPropEnum = append(securityJitPrivilegeUserTypeApplicationPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// security_jit_privilege_user
	// SecurityJitPrivilegeUser
	// application
	// Application
	// ssh
	// END DEBUGGING
	// SecurityJitPrivilegeUserApplicationSSH captures enum value "ssh"
	SecurityJitPrivilegeUserApplicationSSH string = "ssh"
)

// prop value enum
func (m *SecurityJitPrivilegeUser) validateApplicationEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, securityJitPrivilegeUserTypeApplicationPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *SecurityJitPrivilegeUser) validateApplication(formats strfmt.Registry) error {
	if swag.IsZero(m.Application) { // not required
		return nil
	}

	// value enum
	if err := m.validateApplicationEnum("application", "body", *m.Application); err != nil {
		return err
	}

	return nil
}

func (m *SecurityJitPrivilegeUser) validateEndTime(formats strfmt.Registry) error {
	if swag.IsZero(m.EndTime) { // not required
		return nil
	}

	if err := validate.FormatOf("end_time", "body", "date-time", m.EndTime.String(), formats); err != nil {
		return err
	}

	return nil
}

var securityJitPrivilegeUserTypeJitStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["preactive","idle","active"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		securityJitPrivilegeUserTypeJitStatePropEnum = append(securityJitPrivilegeUserTypeJitStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// security_jit_privilege_user
	// SecurityJitPrivilegeUser
	// jit_state
	// JitState
	// preactive
	// END DEBUGGING
	// SecurityJitPrivilegeUserJitStatePreactive captures enum value "preactive"
	SecurityJitPrivilegeUserJitStatePreactive string = "preactive"

	// BEGIN DEBUGGING
	// security_jit_privilege_user
	// SecurityJitPrivilegeUser
	// jit_state
	// JitState
	// idle
	// END DEBUGGING
	// SecurityJitPrivilegeUserJitStateIdle captures enum value "idle"
	SecurityJitPrivilegeUserJitStateIdle string = "idle"

	// BEGIN DEBUGGING
	// security_jit_privilege_user
	// SecurityJitPrivilegeUser
	// jit_state
	// JitState
	// active
	// END DEBUGGING
	// SecurityJitPrivilegeUserJitStateActive captures enum value "active"
	SecurityJitPrivilegeUserJitStateActive string = "active"
)

// prop value enum
func (m *SecurityJitPrivilegeUser) validateJitStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, securityJitPrivilegeUserTypeJitStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *SecurityJitPrivilegeUser) validateJitState(formats strfmt.Registry) error {
	if swag.IsZero(m.JitState) { // not required
		return nil
	}

	// value enum
	if err := m.validateJitStateEnum("jit_state", "body", *m.JitState); err != nil {
		return err
	}

	return nil
}

func (m *SecurityJitPrivilegeUser) validateOwner(formats strfmt.Registry) error {
	if swag.IsZero(m.Owner) { // not required
		return nil
	}

	if m.Owner != nil {
		if err := m.Owner.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("owner")
			}
			return err
		}
	}

	return nil
}

func (m *SecurityJitPrivilegeUser) validateRole(formats strfmt.Registry) error {
	if swag.IsZero(m.Role) { // not required
		return nil
	}

	if m.Role != nil {
		if err := m.Role.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("role")
			}
			return err
		}
	}

	return nil
}

func (m *SecurityJitPrivilegeUser) validateStartTime(formats strfmt.Registry) error {
	if swag.IsZero(m.StartTime) { // not required
		return nil
	}

	if err := validate.FormatOf("start_time", "body", "date-time", m.StartTime.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this security jit privilege user based on the context it is used
func (m *SecurityJitPrivilegeUser) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateAccount(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateEndTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateJitState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateOwner(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateRole(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SecurityJitPrivilegeUser) contextValidateAccount(ctx context.Context, formats strfmt.Registry) error {

	if m.Account != nil {
		if err := m.Account.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("account")
			}
			return err
		}
	}

	return nil
}

func (m *SecurityJitPrivilegeUser) contextValidateEndTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "end_time", "body", m.EndTime); err != nil {
		return err
	}

	return nil
}

func (m *SecurityJitPrivilegeUser) contextValidateJitState(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "jit_state", "body", m.JitState); err != nil {
		return err
	}

	return nil
}

func (m *SecurityJitPrivilegeUser) contextValidateOwner(ctx context.Context, formats strfmt.Registry) error {

	if m.Owner != nil {
		if err := m.Owner.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("owner")
			}
			return err
		}
	}

	return nil
}

func (m *SecurityJitPrivilegeUser) contextValidateRole(ctx context.Context, formats strfmt.Registry) error {

	if m.Role != nil {
		if err := m.Role.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("role")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *SecurityJitPrivilegeUser) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SecurityJitPrivilegeUser) UnmarshalBinary(b []byte) error {
	var res SecurityJitPrivilegeUser
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// SecurityJitPrivilegeUserInlineOwner Owner name and UUID that uniquely identifies the JIT settings for a user.
//
// swagger:model security_jit_privilege_user_inline_owner
type SecurityJitPrivilegeUserInlineOwner struct {

	// links
	Links *SecurityJitPrivilegeUserInlineOwnerInlineLinks `json:"_links,omitempty"`

	// The name of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: svm1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: 02c9e252-41be-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this security jit privilege user inline owner
func (m *SecurityJitPrivilegeUserInlineOwner) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SecurityJitPrivilegeUserInlineOwner) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("owner" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this security jit privilege user inline owner based on the context it is used
func (m *SecurityJitPrivilegeUserInlineOwner) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SecurityJitPrivilegeUserInlineOwner) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("owner" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *SecurityJitPrivilegeUserInlineOwner) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SecurityJitPrivilegeUserInlineOwner) UnmarshalBinary(b []byte) error {
	var res SecurityJitPrivilegeUserInlineOwner
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// SecurityJitPrivilegeUserInlineOwnerInlineLinks security jit privilege user inline owner inline links
//
// swagger:model security_jit_privilege_user_inline_owner_inline__links
type SecurityJitPrivilegeUserInlineOwnerInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this security jit privilege user inline owner inline links
func (m *SecurityJitPrivilegeUserInlineOwnerInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SecurityJitPrivilegeUserInlineOwnerInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("owner" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this security jit privilege user inline owner inline links based on the context it is used
func (m *SecurityJitPrivilegeUserInlineOwnerInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SecurityJitPrivilegeUserInlineOwnerInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("owner" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *SecurityJitPrivilegeUserInlineOwnerInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SecurityJitPrivilegeUserInlineOwnerInlineLinks) UnmarshalBinary(b []byte) error {
	var res SecurityJitPrivilegeUserInlineOwnerInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// SecurityJitPrivilegeUserInlineRole The role the user will be elevated to.
//
// swagger:model security_jit_privilege_user_inline_role
type SecurityJitPrivilegeUserInlineRole struct {

	// links
	Links *SecurityJitPrivilegeUserInlineRoleInlineLinks `json:"_links,omitempty"`

	// Role name
	// Example: admin
	Name *string `json:"name,omitempty"`
}

// Validate validates this security jit privilege user inline role
func (m *SecurityJitPrivilegeUserInlineRole) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SecurityJitPrivilegeUserInlineRole) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("role" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this security jit privilege user inline role based on the context it is used
func (m *SecurityJitPrivilegeUserInlineRole) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SecurityJitPrivilegeUserInlineRole) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("role" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *SecurityJitPrivilegeUserInlineRole) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SecurityJitPrivilegeUserInlineRole) UnmarshalBinary(b []byte) error {
	var res SecurityJitPrivilegeUserInlineRole
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// SecurityJitPrivilegeUserInlineRoleInlineLinks security jit privilege user inline role inline links
//
// swagger:model security_jit_privilege_user_inline_role_inline__links
type SecurityJitPrivilegeUserInlineRoleInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this security jit privilege user inline role inline links
func (m *SecurityJitPrivilegeUserInlineRoleInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SecurityJitPrivilegeUserInlineRoleInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("role" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this security jit privilege user inline role inline links based on the context it is used
func (m *SecurityJitPrivilegeUserInlineRoleInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SecurityJitPrivilegeUserInlineRoleInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("role" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *SecurityJitPrivilegeUserInlineRoleInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SecurityJitPrivilegeUserInlineRoleInlineLinks) UnmarshalBinary(b []byte) error {
	var res SecurityJitPrivilegeUserInlineRoleInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
