// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// SecurityKeyManager security key manager
//
// swagger:model security_key_manager
type SecurityKeyManager struct {

	// links
	Links *SecurityKeyManagerInlineLinks `json:"_links,omitempty"`

	// configuration
	Configuration *SecurityKeyManagerInlineConfiguration `json:"configuration,omitempty"`

	// Indicates whether the configuration is enabled.
	// Read Only: true
	Enabled *bool `json:"enabled,omitempty"`

	// external
	External *SecurityKeyManagerInlineExternal `json:"external,omitempty"`

	// Indicates whether default data-at-rest encryption is disabled in the cluster. This field is deprecated in ONTAP 9.8 and later. Use the "software_data_encryption.disabled_by_default" of /api/security endpoint.
	IsDefaultDataAtRestEncryptionDisabled *bool `json:"is_default_data_at_rest_encryption_disabled,omitempty"`

	// onboard
	Onboard *SecurityKeyManagerInlineOnboard `json:"onboard,omitempty"`

	// Security policy associated with the key manager. This value is currently ignored if specified for the onboard key manager.
	Policy *string `json:"policy,omitempty"`

	// scope
	Scope *NetworkScopeReadonly `json:"scope,omitempty"`

	// status
	Status *SecurityKeyManagerInlineStatus `json:"status,omitempty"`

	// svm
	Svm *SecurityKeyManagerInlineSvm `json:"svm,omitempty"`

	// uuid
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`

	// volume encryption
	VolumeEncryption *SecurityKeyManagerInlineVolumeEncryption `json:"volume_encryption,omitempty"`
}

// Validate validates this security key manager
func (m *SecurityKeyManager) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateConfiguration(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateExternal(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateOnboard(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateScope(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSvm(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateVolumeEncryption(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SecurityKeyManager) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *SecurityKeyManager) validateConfiguration(formats strfmt.Registry) error {
	if swag.IsZero(m.Configuration) { // not required
		return nil
	}

	if m.Configuration != nil {
		if err := m.Configuration.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("configuration")
			}
			return err
		}
	}

	return nil
}

func (m *SecurityKeyManager) validateExternal(formats strfmt.Registry) error {
	if swag.IsZero(m.External) { // not required
		return nil
	}

	if m.External != nil {
		if err := m.External.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("external")
			}
			return err
		}
	}

	return nil
}

func (m *SecurityKeyManager) validateOnboard(formats strfmt.Registry) error {
	if swag.IsZero(m.Onboard) { // not required
		return nil
	}

	if m.Onboard != nil {
		if err := m.Onboard.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("onboard")
			}
			return err
		}
	}

	return nil
}

func (m *SecurityKeyManager) validateScope(formats strfmt.Registry) error {
	if swag.IsZero(m.Scope) { // not required
		return nil
	}

	if m.Scope != nil {
		if err := m.Scope.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("scope")
			}
			return err
		}
	}

	return nil
}

func (m *SecurityKeyManager) validateStatus(formats strfmt.Registry) error {
	if swag.IsZero(m.Status) { // not required
		return nil
	}

	if m.Status != nil {
		if err := m.Status.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("status")
			}
			return err
		}
	}

	return nil
}

func (m *SecurityKeyManager) validateSvm(formats strfmt.Registry) error {
	if swag.IsZero(m.Svm) { // not required
		return nil
	}

	if m.Svm != nil {
		if err := m.Svm.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm")
			}
			return err
		}
	}

	return nil
}

func (m *SecurityKeyManager) validateVolumeEncryption(formats strfmt.Registry) error {
	if swag.IsZero(m.VolumeEncryption) { // not required
		return nil
	}

	if m.VolumeEncryption != nil {
		if err := m.VolumeEncryption.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("volume_encryption")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this security key manager based on the context it is used
func (m *SecurityKeyManager) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateConfiguration(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateEnabled(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateExternal(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateOnboard(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateScope(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStatus(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSvm(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateVolumeEncryption(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SecurityKeyManager) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *SecurityKeyManager) contextValidateConfiguration(ctx context.Context, formats strfmt.Registry) error {

	if m.Configuration != nil {
		if err := m.Configuration.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("configuration")
			}
			return err
		}
	}

	return nil
}

func (m *SecurityKeyManager) contextValidateEnabled(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "enabled", "body", m.Enabled); err != nil {
		return err
	}

	return nil
}

func (m *SecurityKeyManager) contextValidateExternal(ctx context.Context, formats strfmt.Registry) error {

	if m.External != nil {
		if err := m.External.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("external")
			}
			return err
		}
	}

	return nil
}

func (m *SecurityKeyManager) contextValidateOnboard(ctx context.Context, formats strfmt.Registry) error {

	if m.Onboard != nil {
		if err := m.Onboard.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("onboard")
			}
			return err
		}
	}

	return nil
}

func (m *SecurityKeyManager) contextValidateScope(ctx context.Context, formats strfmt.Registry) error {

	if m.Scope != nil {
		if err := m.Scope.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("scope")
			}
			return err
		}
	}

	return nil
}

func (m *SecurityKeyManager) contextValidateStatus(ctx context.Context, formats strfmt.Registry) error {

	if m.Status != nil {
		if err := m.Status.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("status")
			}
			return err
		}
	}

	return nil
}

func (m *SecurityKeyManager) contextValidateSvm(ctx context.Context, formats strfmt.Registry) error {

	if m.Svm != nil {
		if err := m.Svm.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm")
			}
			return err
		}
	}

	return nil
}

func (m *SecurityKeyManager) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "uuid", "body", m.UUID); err != nil {
		return err
	}

	return nil
}

func (m *SecurityKeyManager) contextValidateVolumeEncryption(ctx context.Context, formats strfmt.Registry) error {

	if m.VolumeEncryption != nil {
		if err := m.VolumeEncryption.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("volume_encryption")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *SecurityKeyManager) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SecurityKeyManager) UnmarshalBinary(b []byte) error {
	var res SecurityKeyManager
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// SecurityKeyManagerInlineConfiguration Security keystore object reference.
//
// swagger:model security_key_manager_inline_configuration
type SecurityKeyManagerInlineConfiguration struct {

	// links
	Links *SecurityKeyManagerInlineConfigurationInlineLinks `json:"_links,omitempty"`

	// Name of the configuration.
	// Example: default
	Name *string `json:"name,omitempty"`

	// Keystore UUID.
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563434
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this security key manager inline configuration
func (m *SecurityKeyManagerInlineConfiguration) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SecurityKeyManagerInlineConfiguration) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("configuration" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this security key manager inline configuration based on the context it is used
func (m *SecurityKeyManagerInlineConfiguration) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SecurityKeyManagerInlineConfiguration) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("configuration" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *SecurityKeyManagerInlineConfiguration) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SecurityKeyManagerInlineConfiguration) UnmarshalBinary(b []byte) error {
	var res SecurityKeyManagerInlineConfiguration
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// SecurityKeyManagerInlineConfigurationInlineLinks security key manager inline configuration inline links
//
// swagger:model security_key_manager_inline_configuration_inline__links
type SecurityKeyManagerInlineConfigurationInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this security key manager inline configuration inline links
func (m *SecurityKeyManagerInlineConfigurationInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SecurityKeyManagerInlineConfigurationInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("configuration" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this security key manager inline configuration inline links based on the context it is used
func (m *SecurityKeyManagerInlineConfigurationInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SecurityKeyManagerInlineConfigurationInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("configuration" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *SecurityKeyManagerInlineConfigurationInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SecurityKeyManagerInlineConfigurationInlineLinks) UnmarshalBinary(b []byte) error {
	var res SecurityKeyManagerInlineConfigurationInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// SecurityKeyManagerInlineExternal Configures external key management
//
// swagger:model security_key_manager_inline_external
type SecurityKeyManagerInlineExternal struct {

	// client certificate
	ClientCertificate *SecurityKeyManagerInlineExternalInlineClientCertificate `json:"client_certificate,omitempty"`

	// The array of certificates that are common for all the keyservers per SVM.
	ServerCaCertificates []*SecurityKeyManagerExternalServerCaCertificatesItems0 `json:"server_ca_certificates,omitempty"`

	// The set of external key servers.
	// Max Items: 4
	Servers []*KeyServerReadcreate `json:"servers,omitempty"`
}

// Validate validates this security key manager inline external
func (m *SecurityKeyManagerInlineExternal) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateClientCertificate(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateServerCaCertificates(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateServers(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SecurityKeyManagerInlineExternal) validateClientCertificate(formats strfmt.Registry) error {
	if swag.IsZero(m.ClientCertificate) { // not required
		return nil
	}

	if m.ClientCertificate != nil {
		if err := m.ClientCertificate.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("external" + "." + "client_certificate")
			}
			return err
		}
	}

	return nil
}

func (m *SecurityKeyManagerInlineExternal) validateServerCaCertificates(formats strfmt.Registry) error {
	if swag.IsZero(m.ServerCaCertificates) { // not required
		return nil
	}

	for i := 0; i < len(m.ServerCaCertificates); i++ {
		if swag.IsZero(m.ServerCaCertificates[i]) { // not required
			continue
		}

		if m.ServerCaCertificates[i] != nil {
			if err := m.ServerCaCertificates[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("external" + "." + "server_ca_certificates" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *SecurityKeyManagerInlineExternal) validateServers(formats strfmt.Registry) error {
	if swag.IsZero(m.Servers) { // not required
		return nil
	}

	iServersSize := int64(len(m.Servers))

	if err := validate.MaxItems("external"+"."+"servers", "body", iServersSize, 4); err != nil {
		return err
	}

	for i := 0; i < len(m.Servers); i++ {
		if swag.IsZero(m.Servers[i]) { // not required
			continue
		}

		if m.Servers[i] != nil {
			if err := m.Servers[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("external" + "." + "servers" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this security key manager inline external based on the context it is used
func (m *SecurityKeyManagerInlineExternal) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateClientCertificate(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateServerCaCertificates(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateServers(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SecurityKeyManagerInlineExternal) contextValidateClientCertificate(ctx context.Context, formats strfmt.Registry) error {

	if m.ClientCertificate != nil {
		if err := m.ClientCertificate.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("external" + "." + "client_certificate")
			}
			return err
		}
	}

	return nil
}

func (m *SecurityKeyManagerInlineExternal) contextValidateServerCaCertificates(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.ServerCaCertificates); i++ {

		if m.ServerCaCertificates[i] != nil {
			if err := m.ServerCaCertificates[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("external" + "." + "server_ca_certificates" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *SecurityKeyManagerInlineExternal) contextValidateServers(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.Servers); i++ {

		if m.Servers[i] != nil {
			if err := m.Servers[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("external" + "." + "servers" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *SecurityKeyManagerInlineExternal) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SecurityKeyManagerInlineExternal) UnmarshalBinary(b []byte) error {
	var res SecurityKeyManagerInlineExternal
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// SecurityKeyManagerInlineExternalInlineClientCertificate Client certificate (name and UUID)
//
// swagger:model security_key_manager_inline_external_inline_client_certificate
type SecurityKeyManagerInlineExternalInlineClientCertificate struct {

	// links
	Links *SecurityKeyManagerInlineExternalInlineClientCertificateInlineLinks `json:"_links,omitempty"`

	// Certificate name
	Name *string `json:"name,omitempty"`

	// Certificate UUID
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this security key manager inline external inline client certificate
func (m *SecurityKeyManagerInlineExternalInlineClientCertificate) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SecurityKeyManagerInlineExternalInlineClientCertificate) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("external" + "." + "client_certificate" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this security key manager inline external inline client certificate based on the context it is used
func (m *SecurityKeyManagerInlineExternalInlineClientCertificate) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SecurityKeyManagerInlineExternalInlineClientCertificate) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("external" + "." + "client_certificate" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *SecurityKeyManagerInlineExternalInlineClientCertificate) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SecurityKeyManagerInlineExternalInlineClientCertificate) UnmarshalBinary(b []byte) error {
	var res SecurityKeyManagerInlineExternalInlineClientCertificate
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// SecurityKeyManagerInlineExternalInlineClientCertificateInlineLinks security key manager inline external inline client certificate inline links
//
// swagger:model security_key_manager_inline_external_inline_client_certificate_inline__links
type SecurityKeyManagerInlineExternalInlineClientCertificateInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this security key manager inline external inline client certificate inline links
func (m *SecurityKeyManagerInlineExternalInlineClientCertificateInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SecurityKeyManagerInlineExternalInlineClientCertificateInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("external" + "." + "client_certificate" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this security key manager inline external inline client certificate inline links based on the context it is used
func (m *SecurityKeyManagerInlineExternalInlineClientCertificateInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SecurityKeyManagerInlineExternalInlineClientCertificateInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("external" + "." + "client_certificate" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *SecurityKeyManagerInlineExternalInlineClientCertificateInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SecurityKeyManagerInlineExternalInlineClientCertificateInlineLinks) UnmarshalBinary(b []byte) error {
	var res SecurityKeyManagerInlineExternalInlineClientCertificateInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// SecurityKeyManagerExternalServerCaCertificatesItems0 Security certificate object reference
//
// swagger:model SecurityKeyManagerExternalServerCaCertificatesItems0
type SecurityKeyManagerExternalServerCaCertificatesItems0 struct {

	// links
	Links *SecurityKeyManagerExternalServerCaCertificatesItems0Links `json:"_links,omitempty"`

	// Certificate name
	Name *string `json:"name,omitempty"`

	// Certificate UUID
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this security key manager external server ca certificates items0
func (m *SecurityKeyManagerExternalServerCaCertificatesItems0) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SecurityKeyManagerExternalServerCaCertificatesItems0) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this security key manager external server ca certificates items0 based on the context it is used
func (m *SecurityKeyManagerExternalServerCaCertificatesItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SecurityKeyManagerExternalServerCaCertificatesItems0) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *SecurityKeyManagerExternalServerCaCertificatesItems0) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SecurityKeyManagerExternalServerCaCertificatesItems0) UnmarshalBinary(b []byte) error {
	var res SecurityKeyManagerExternalServerCaCertificatesItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// SecurityKeyManagerExternalServerCaCertificatesItems0Links security key manager external server ca certificates items0 links
//
// swagger:model SecurityKeyManagerExternalServerCaCertificatesItems0Links
type SecurityKeyManagerExternalServerCaCertificatesItems0Links struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this security key manager external server ca certificates items0 links
func (m *SecurityKeyManagerExternalServerCaCertificatesItems0Links) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SecurityKeyManagerExternalServerCaCertificatesItems0Links) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this security key manager external server ca certificates items0 links based on the context it is used
func (m *SecurityKeyManagerExternalServerCaCertificatesItems0Links) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SecurityKeyManagerExternalServerCaCertificatesItems0Links) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *SecurityKeyManagerExternalServerCaCertificatesItems0Links) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SecurityKeyManagerExternalServerCaCertificatesItems0Links) UnmarshalBinary(b []byte) error {
	var res SecurityKeyManagerExternalServerCaCertificatesItems0Links
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// SecurityKeyManagerInlineLinks security key manager inline links
//
// swagger:model security_key_manager_inline__links
type SecurityKeyManagerInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this security key manager inline links
func (m *SecurityKeyManagerInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SecurityKeyManagerInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this security key manager inline links based on the context it is used
func (m *SecurityKeyManagerInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SecurityKeyManagerInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *SecurityKeyManagerInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SecurityKeyManagerInlineLinks) UnmarshalBinary(b []byte) error {
	var res SecurityKeyManagerInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// SecurityKeyManagerInlineOnboard Configures onboard key management. After configuring onboard key management, save the encrypted configuration data in a safe location so that you can use it if you need to perform a manual recovery operation.
//
// swagger:model security_key_manager_inline_onboard
type SecurityKeyManagerInlineOnboard struct {

	// Is the onboard key manager enabled?
	// Read Only: true
	Enabled *bool `json:"enabled,omitempty"`

	// The cluster-wide passphrase. This is not audited.
	// Example: The cluster password of length 32-256 ASCII characters.
	// Format: password
	ExistingPassphrase *strfmt.Password `json:"existing_passphrase,omitempty"`

	// Backup of the onboard key manager's key hierarchy. It is required to save this backup after configuring the onboard key manager to help in the recovery of the cluster in case of catastrophic failures.
	// Example: '--------------------------BEGIN BACKUP-------------------------- TmV0QXBwIEtleSBCbG9iAAEAAAAEAAAAcAEAAAAAAAAxBFWWAAAAACEAAAAAAAAA QAAAAAAAAABzDyyVAAAAALI5Jsjvy6gUxnT78KoDKXHYb6sSeraM00quOULY6BeV n6dMFxuErCD1lbERaOQZSuaYy1p8oQHtTEfGMLZM4TYiAAAAAAAAACgAAAAAAAAA 3WTh7gAAAAAAAAAAAAAAAAIAAAAAAAgAZJEIWvdeHr5RCAvHGclo+wAAAAAAAAAA IgAAAAAAAAAoAAAAAAAAAEOTcR0AAAAAAAAAAAAAAAACAAAAAAAJAGr3tJA/LRzU QRHwv+1aWvAAAAAAAAAAACQAAAAAAAAAgAAAAAAAAADV1Vd/AAAAAMFM9Q229Bhp mDaTSdqku5DCd8wG+fOZSr4bx4JT5WHvV/r5gJnXDQQAAAAAAAAAAAAAAAAAAAAA AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAABOZXRBcHAgS2V5IEJsb2IA AQAAAAMAAAAYAQAAAAAAALgePkcAAAAAIgAAAAAAAAAoAAAAAAAAAEOTcR0AAAAA AAAAAAAAAAACAAAAAAAJAGr3tJA/LRzUQRHwv+1aWvAAAAAAAAAAACIAAAAAAAAA KAAAAAAAAACIlCHZAAAAAAAAAAAAAAAAAgAAAAAAAQCafcabsxRXMM7gxhLRrzxh AAAAAAAAAAAkAAAAAAAAAIAAAAAAAAAA2JjQBQAAAACt4IqXcNpVggahl0axLsN4 yQjnNVKWY7mANB29O42hI7b70DTGCTaVAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA AAAAAAAAAAAAAAAAAAAAAE5ldEFwcCBLZXkgQmxvYgABAAAAAwAAABgBAAAAAAAA 7sbaoQAAAAAiAAAAAAAAACgAAAAAAAAAQ5NxHQAAAAAAAAAAAAAAAAIAAAAAAAkA ave0kD8tHNRBEfC/7Vpa8AAAAAAAAAAAIgAAAAAAAAAoAAAAAAAAALOHfWkAAAAA AAAAAAAAAAACAAAAAAABAMoI9UxrHOGthQm/CB+EHdAAAAAAAAAAACQAAAAAAAAA gAAAAAAAAACnMmUtAAAAAGVk8AtPzENFgsGdsFvnmucmYrlQCsFew0HDSFKaZqK6 W8IEVzBAhPoAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA ---------------------------END BACKUP---------------------------'
	// Read Only: true
	KeyBackup *string `json:"key_backup,omitempty"`

	// The cluster-wide passphrase. This is not audited.
	// Example: The cluster password of length 32-256 ASCII characters.
	// Format: password
	Passphrase *strfmt.Password `json:"passphrase,omitempty"`

	// Synchronizes missing onboard keys on any node in the cluster. If a node is added to a cluster that has onboard key management configured, the synchronize operation needs to be performed in a PATCH operation. In a MetroCluster configuration, if onboard key management is enabled on one site, then the synchronize operation needs to be run as a POST operation on the remote site providing the same passphrase.
	Synchronize *bool `json:"synchronize,omitempty"`
}

// Validate validates this security key manager inline onboard
func (m *SecurityKeyManagerInlineOnboard) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateExistingPassphrase(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePassphrase(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SecurityKeyManagerInlineOnboard) validateExistingPassphrase(formats strfmt.Registry) error {
	if swag.IsZero(m.ExistingPassphrase) { // not required
		return nil
	}

	if err := validate.FormatOf("onboard"+"."+"existing_passphrase", "body", "password", m.ExistingPassphrase.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *SecurityKeyManagerInlineOnboard) validatePassphrase(formats strfmt.Registry) error {
	if swag.IsZero(m.Passphrase) { // not required
		return nil
	}

	if err := validate.FormatOf("onboard"+"."+"passphrase", "body", "password", m.Passphrase.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this security key manager inline onboard based on the context it is used
func (m *SecurityKeyManagerInlineOnboard) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateEnabled(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateKeyBackup(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SecurityKeyManagerInlineOnboard) contextValidateEnabled(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "onboard"+"."+"enabled", "body", m.Enabled); err != nil {
		return err
	}

	return nil
}

func (m *SecurityKeyManagerInlineOnboard) contextValidateKeyBackup(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "onboard"+"."+"key_backup", "body", m.KeyBackup); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *SecurityKeyManagerInlineOnboard) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SecurityKeyManagerInlineOnboard) UnmarshalBinary(b []byte) error {
	var res SecurityKeyManagerInlineOnboard
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// SecurityKeyManagerInlineStatus Optional status information on the current state of the key manager indicating if it is fully setup or requires more action.
//
// swagger:model security_key_manager_inline_status
type SecurityKeyManagerInlineStatus struct {

	// Code corresponding to the status message. Returns 0 if the setup is complete. This is an advanced property; there is an added computational cost to retrieving its value. The property is not populated for either a collection GET or an instance GET unless it is explicitly requested using the `fields` query parameter or GET for all advanced properties is enabled.
	// Example: 346758
	Code *int64 `json:"code,omitempty"`

	// Current state of the key manager indicating any additional steps to perform to finish the setup. This is an advanced property; there is an added computational cost to retrieving its value. The property is not populated for either a collection GET or an instance GET unless it is explicitly requested using the `fields` query parameter or GET for all advanced properties is enabled.
	// Example: This cluster is part of a MetroCluster configuration. Use the REST API POST method security/key_managers/ with the synchronize option and the same passphrase on the partner cluster before proceeding with any key manager operations.  Failure to do so could lead to switchover or switchback failure.
	Message *string `json:"message,omitempty"`
}

// Validate validates this security key manager inline status
func (m *SecurityKeyManagerInlineStatus) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this security key manager inline status based on context it is used
func (m *SecurityKeyManagerInlineStatus) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *SecurityKeyManagerInlineStatus) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SecurityKeyManagerInlineStatus) UnmarshalBinary(b []byte) error {
	var res SecurityKeyManagerInlineStatus
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// SecurityKeyManagerInlineSvm SVM, applies only to SVM-scoped objects.
//
// swagger:model security_key_manager_inline_svm
type SecurityKeyManagerInlineSvm struct {

	// links
	Links *SecurityKeyManagerInlineSvmInlineLinks `json:"_links,omitempty"`

	// The name of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: svm1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: 02c9e252-41be-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this security key manager inline svm
func (m *SecurityKeyManagerInlineSvm) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SecurityKeyManagerInlineSvm) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this security key manager inline svm based on the context it is used
func (m *SecurityKeyManagerInlineSvm) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SecurityKeyManagerInlineSvm) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *SecurityKeyManagerInlineSvm) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SecurityKeyManagerInlineSvm) UnmarshalBinary(b []byte) error {
	var res SecurityKeyManagerInlineSvm
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// SecurityKeyManagerInlineSvmInlineLinks security key manager inline svm inline links
//
// swagger:model security_key_manager_inline_svm_inline__links
type SecurityKeyManagerInlineSvmInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this security key manager inline svm inline links
func (m *SecurityKeyManagerInlineSvmInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SecurityKeyManagerInlineSvmInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this security key manager inline svm inline links based on the context it is used
func (m *SecurityKeyManagerInlineSvmInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SecurityKeyManagerInlineSvmInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *SecurityKeyManagerInlineSvmInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SecurityKeyManagerInlineSvmInlineLinks) UnmarshalBinary(b []byte) error {
	var res SecurityKeyManagerInlineSvmInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// SecurityKeyManagerInlineVolumeEncryption Indicates whether volume encryption is supported in the cluster.
//
// swagger:model security_key_manager_inline_volume_encryption
type SecurityKeyManagerInlineVolumeEncryption struct {

	// Code corresponding to the status message. Returns a 0 if volume encryption is supported in all nodes of the cluster.
	// Example: 346758
	Code *int64 `json:"code,omitempty"`

	// Reason for not supporting volume encryption.
	// Example: No platform support for volume encryption in following nodes - node1, node2.
	Message *string `json:"message,omitempty"`

	// Set to true when volume encryption support is available on all nodes of the cluster.
	Supported *bool `json:"supported,omitempty"`
}

// Validate validates this security key manager inline volume encryption
func (m *SecurityKeyManagerInlineVolumeEncryption) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this security key manager inline volume encryption based on context it is used
func (m *SecurityKeyManagerInlineVolumeEncryption) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *SecurityKeyManagerInlineVolumeEncryption) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SecurityKeyManagerInlineVolumeEncryption) UnmarshalBinary(b []byte) error {
	var res SecurityKeyManagerInlineVolumeEncryption
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
