// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// SecurityOauth2 security oauth2
//
// swagger:model security_oauth2
type SecurityOauth2 struct {

	// links
	Links *SecurityOauth2InlineLinks `json:"_links,omitempty"`

	// The name of the application using OAuth 2.0. Required for POST operations.
	// Enum: ["http"]
	Application *string `json:"application,omitempty"`

	// The OAuth 2.0 Audience.
	Audience *string `json:"audience,omitempty"`

	// The OAuth 2.0 client ID. Required in POST operations for remote introspection.
	ClientID *string `json:"client_id,omitempty"`

	// The OAuth 2.0 client secret. Required in POST operations for remote introspection.
	ClientSecret *string `json:"client_secret,omitempty"`

	// The OAuth 2.0 client secret as a SHA256 HMAC hashed value created with the cluster UUID as its HMAC secret key.
	// Read Only: true
	HashedClientSecret *string `json:"hashed_client_secret,omitempty"`

	// introspection
	Introspection *SecurityOauth2InlineIntrospection `json:"introspection,omitempty"`

	// The OAuth 2.0 Issuer.
	// Example: https://examplelab.customer.com
	Issuer *string `json:"issuer,omitempty"`

	// jwks
	Jwks *SecurityOauth2InlineJwks `json:"jwks,omitempty"`

	// The configuration name. Required for POST operations.
	// Example: auth0
	Name *string `json:"name,omitempty"`

	// Outgoing proxy to access external identity providers (IdPs). If not specified, no proxy is configured.
	// Example: https://johndoe:secretpass@proxy.example.com:8080
	OutgoingProxy *string `json:"outgoing_proxy,omitempty"`

	// The Identity Provider type.
	// Example: entra
	// Enum: ["basic","keycloak","auth0","adfs","entra"]
	Provider *string `json:"provider,omitempty"`

	// The remote user claim.
	RemoteUserClaim *string `json:"remote_user_claim,omitempty"`

	// Indicates whether or not to validate the input URIs. Default value is false.
	SkipURIValidation *bool `json:"skip_uri_validation,omitempty"`

	// Indicates whether or not to use locally configured roles, if present. Default value is false.
	UseLocalRolesIfPresent *bool `json:"use_local_roles_if_present,omitempty"`

	// OAuth 2.0 mutual TLS authentication setting. Set this value to \"none\" to disable mutual TLS authentication. Set this value to \"required\" to enforce mutual TLS authentication for all access tokens and reject any token that does not have x5t#S256 property in the cnf section. The default value is \"request\" which means mutual TLS authentication is enforced only if the x5t#S256 property is present in the cnf section of the access token.
	// Enum: ["none","request","required"]
	UseMutualTLS *string `json:"use_mutual_tls,omitempty"`
}

// Validate validates this security oauth2
func (m *SecurityOauth2) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateApplication(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateIntrospection(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateJwks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateProvider(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateUseMutualTLS(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SecurityOauth2) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

var securityOauth2TypeApplicationPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["http"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		securityOauth2TypeApplicationPropEnum = append(securityOauth2TypeApplicationPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// security_oauth2
	// SecurityOauth2
	// application
	// Application
	// http
	// END DEBUGGING
	// SecurityOauth2ApplicationHTTP captures enum value "http"
	SecurityOauth2ApplicationHTTP string = "http"
)

// prop value enum
func (m *SecurityOauth2) validateApplicationEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, securityOauth2TypeApplicationPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *SecurityOauth2) validateApplication(formats strfmt.Registry) error {
	if swag.IsZero(m.Application) { // not required
		return nil
	}

	// value enum
	if err := m.validateApplicationEnum("application", "body", *m.Application); err != nil {
		return err
	}

	return nil
}

func (m *SecurityOauth2) validateIntrospection(formats strfmt.Registry) error {
	if swag.IsZero(m.Introspection) { // not required
		return nil
	}

	if m.Introspection != nil {
		if err := m.Introspection.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("introspection")
			}
			return err
		}
	}

	return nil
}

func (m *SecurityOauth2) validateJwks(formats strfmt.Registry) error {
	if swag.IsZero(m.Jwks) { // not required
		return nil
	}

	if m.Jwks != nil {
		if err := m.Jwks.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("jwks")
			}
			return err
		}
	}

	return nil
}

var securityOauth2TypeProviderPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["basic","keycloak","auth0","adfs","entra"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		securityOauth2TypeProviderPropEnum = append(securityOauth2TypeProviderPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// security_oauth2
	// SecurityOauth2
	// provider
	// Provider
	// basic
	// END DEBUGGING
	// SecurityOauth2ProviderBasic captures enum value "basic"
	SecurityOauth2ProviderBasic string = "basic"

	// BEGIN DEBUGGING
	// security_oauth2
	// SecurityOauth2
	// provider
	// Provider
	// keycloak
	// END DEBUGGING
	// SecurityOauth2ProviderKeycloak captures enum value "keycloak"
	SecurityOauth2ProviderKeycloak string = "keycloak"

	// BEGIN DEBUGGING
	// security_oauth2
	// SecurityOauth2
	// provider
	// Provider
	// auth0
	// END DEBUGGING
	// SecurityOauth2ProviderAuth0 captures enum value "auth0"
	SecurityOauth2ProviderAuth0 string = "auth0"

	// BEGIN DEBUGGING
	// security_oauth2
	// SecurityOauth2
	// provider
	// Provider
	// adfs
	// END DEBUGGING
	// SecurityOauth2ProviderAdfs captures enum value "adfs"
	SecurityOauth2ProviderAdfs string = "adfs"

	// BEGIN DEBUGGING
	// security_oauth2
	// SecurityOauth2
	// provider
	// Provider
	// entra
	// END DEBUGGING
	// SecurityOauth2ProviderEntra captures enum value "entra"
	SecurityOauth2ProviderEntra string = "entra"
)

// prop value enum
func (m *SecurityOauth2) validateProviderEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, securityOauth2TypeProviderPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *SecurityOauth2) validateProvider(formats strfmt.Registry) error {
	if swag.IsZero(m.Provider) { // not required
		return nil
	}

	// value enum
	if err := m.validateProviderEnum("provider", "body", *m.Provider); err != nil {
		return err
	}

	return nil
}

var securityOauth2TypeUseMutualTLSPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["none","request","required"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		securityOauth2TypeUseMutualTLSPropEnum = append(securityOauth2TypeUseMutualTLSPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// security_oauth2
	// SecurityOauth2
	// use_mutual_tls
	// UseMutualTLS
	// none
	// END DEBUGGING
	// SecurityOauth2UseMutualTLSNone captures enum value "none"
	SecurityOauth2UseMutualTLSNone string = "none"

	// BEGIN DEBUGGING
	// security_oauth2
	// SecurityOauth2
	// use_mutual_tls
	// UseMutualTLS
	// request
	// END DEBUGGING
	// SecurityOauth2UseMutualTLSRequest captures enum value "request"
	SecurityOauth2UseMutualTLSRequest string = "request"

	// BEGIN DEBUGGING
	// security_oauth2
	// SecurityOauth2
	// use_mutual_tls
	// UseMutualTLS
	// required
	// END DEBUGGING
	// SecurityOauth2UseMutualTLSRequired captures enum value "required"
	SecurityOauth2UseMutualTLSRequired string = "required"
)

// prop value enum
func (m *SecurityOauth2) validateUseMutualTLSEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, securityOauth2TypeUseMutualTLSPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *SecurityOauth2) validateUseMutualTLS(formats strfmt.Registry) error {
	if swag.IsZero(m.UseMutualTLS) { // not required
		return nil
	}

	// value enum
	if err := m.validateUseMutualTLSEnum("use_mutual_tls", "body", *m.UseMutualTLS); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this security oauth2 based on the context it is used
func (m *SecurityOauth2) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateHashedClientSecret(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIntrospection(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateJwks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SecurityOauth2) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *SecurityOauth2) contextValidateHashedClientSecret(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "hashed_client_secret", "body", m.HashedClientSecret); err != nil {
		return err
	}

	return nil
}

func (m *SecurityOauth2) contextValidateIntrospection(ctx context.Context, formats strfmt.Registry) error {

	if m.Introspection != nil {
		if err := m.Introspection.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("introspection")
			}
			return err
		}
	}

	return nil
}

func (m *SecurityOauth2) contextValidateJwks(ctx context.Context, formats strfmt.Registry) error {

	if m.Jwks != nil {
		if err := m.Jwks.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("jwks")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *SecurityOauth2) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SecurityOauth2) UnmarshalBinary(b []byte) error {
	var res SecurityOauth2
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// SecurityOauth2InlineIntrospection security oauth2 inline introspection
//
// swagger:model security_oauth2_inline_introspection
type SecurityOauth2InlineIntrospection struct {

	// The token introspection endpoint URI.
	// Example: https://examplelab.customer.com/token/introspect
	EndpointURI *string `json:"endpoint_uri,omitempty"`

	// The refresh interval for caching tokens, in ISO-8601 format. This can be set to the value \"disabled\" to disable caching of tokens. When set to 0, tokens are cached according to the expiry period in them. Otherwise, it can be set to a value from 1 second to 2147483647 seconds.
	// Example: PT1H
	Interval *string `json:"interval,omitempty"`
}

// Validate validates this security oauth2 inline introspection
func (m *SecurityOauth2InlineIntrospection) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this security oauth2 inline introspection based on context it is used
func (m *SecurityOauth2InlineIntrospection) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *SecurityOauth2InlineIntrospection) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SecurityOauth2InlineIntrospection) UnmarshalBinary(b []byte) error {
	var res SecurityOauth2InlineIntrospection
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// SecurityOauth2InlineJwks security oauth2 inline jwks
//
// swagger:model security_oauth2_inline_jwks
type SecurityOauth2InlineJwks struct {

	// The URI on which the JSON Web Key Set (JWKS) are hosted.
	// Example: https://examplelab.customer.com/pf/JWKS
	ProviderURI *string `json:"provider_uri,omitempty"`

	// The refresh interval for the JSON Web Key Set (JWKS), in ISO-8601 format. This can be set to a value from 300 seconds to 2147483647 seconds.
	// Example: PT2H
	RefreshInterval *string `json:"refresh_interval,omitempty"`
}

// Validate validates this security oauth2 inline jwks
func (m *SecurityOauth2InlineJwks) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this security oauth2 inline jwks based on context it is used
func (m *SecurityOauth2InlineJwks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *SecurityOauth2InlineJwks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SecurityOauth2InlineJwks) UnmarshalBinary(b []byte) error {
	var res SecurityOauth2InlineJwks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// SecurityOauth2InlineLinks security oauth2 inline links
//
// swagger:model security_oauth2_inline__links
type SecurityOauth2InlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this security oauth2 inline links
func (m *SecurityOauth2InlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SecurityOauth2InlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this security oauth2 inline links based on the context it is used
func (m *SecurityOauth2InlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SecurityOauth2InlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *SecurityOauth2InlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SecurityOauth2InlineLinks) UnmarshalBinary(b []byte) error {
	var res SecurityOauth2InlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
