// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// SecurityOidc security oidc
//
// swagger:model security_oidc
type SecurityOidc struct {

	// links
	Links *SecurityOidcInlineLinks `json:"_links,omitempty"`

	// The issuer value for the access token when it is different from the OpenID Connect issuer.
	// Example: https://example.netapp.com/adfs/services/trust
	AccessTokenIssuer *string `json:"access_token_issuer,omitempty"`

	// The URI of the authorization endpoint for the OpenID Connect provider.
	// Example: https://example.netapp.com/adfs/oauth2/authorize
	AuthorizationEndpoint *string `json:"authorization_endpoint,omitempty"`

	// The client ID for the application.
	// Example: 1234567890abcdef
	ClientID *string `json:"client_id,omitempty"`

	// The client secret for the application.
	// Example: 1234567890abcdef1234567890abcdef
	ClientSecret *string `json:"client_secret,omitempty"`

	// The hash of the client secret for the application.
	// Example: 1234567890abcdef1234567890abcdef1234567890abcdef1234567890abcdef
	// Read Only: true
	ClientSecretHash *string `json:"client_secret_hash,omitempty"`

	// Indicates whether the OpenID Connect configuration is enabled.
	// Example: true
	Enabled *bool `json:"enabled,omitempty"`

	// The URI of the end session endpoint for the OpenID Connect provider.
	// Example: https://example.netapp.com/adfs/oauth2/logout
	EndSessionEndpoint *string `json:"end_session_endpoint,omitempty"`

	// The URI of the OpenID Connect provider.
	// Example: https://example.netapp.com/adfs
	Issuer *string `json:"issuer,omitempty"`

	// The refresh interval for the JSON Web Key Set (JWKS), in ISO-8601 format. This can be set to a value from 300 seconds to 2147483647 seconds.
	// Example: PT2H
	JwksRefreshInterval *string `json:"jwks_refresh_interval,omitempty"`

	// Outgoing proxy to access external identity providers (IdPs). If not specified, no proxy is configured.
	// Example: https://johndoe:secretpass@proxy.example.com:8080
	OutgoingProxy *string `json:"outgoing_proxy,omitempty"`

	// The OpenID Connect provider type.
	// Example: adfs
	// Enum: ["adfs","entra"]
	Provider *string `json:"provider,omitempty"`

	// The URI of the JSON Web Key Set (JWKS) for the OpenID Connect provider.
	// Example: https://example.netapp.com/adfs/discovery/v2.0/keys
	ProviderJwksURI *string `json:"provider_jwks_uri,omitempty"`

	// The IP address to redirect to after authentication.
	// Example: 10.10.10.10
	RedirectIpaddress *string `json:"redirect_ipaddress,omitempty"`

	// The claim used to identify the remote user.
	// Example: unique_name
	RemoteUserClaim *string `json:"remote_user_claim,omitempty"`

	// Indicates whether to skip URI validation.
	// Example: false
	SkipURIValidation *bool `json:"skip_uri_validation,omitempty"`

	// The URI of the token endpoint for the OpenID Connect provider.
	// Example: https://example.netapp.com/adfs/oauth2/token
	TokenEndpoint *string `json:"token_endpoint,omitempty"`
}

// Validate validates this security oidc
func (m *SecurityOidc) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateProvider(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SecurityOidc) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

var securityOidcTypeProviderPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["adfs","entra"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		securityOidcTypeProviderPropEnum = append(securityOidcTypeProviderPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// security_oidc
	// SecurityOidc
	// provider
	// Provider
	// adfs
	// END DEBUGGING
	// SecurityOidcProviderAdfs captures enum value "adfs"
	SecurityOidcProviderAdfs string = "adfs"

	// BEGIN DEBUGGING
	// security_oidc
	// SecurityOidc
	// provider
	// Provider
	// entra
	// END DEBUGGING
	// SecurityOidcProviderEntra captures enum value "entra"
	SecurityOidcProviderEntra string = "entra"
)

// prop value enum
func (m *SecurityOidc) validateProviderEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, securityOidcTypeProviderPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *SecurityOidc) validateProvider(formats strfmt.Registry) error {
	if swag.IsZero(m.Provider) { // not required
		return nil
	}

	// value enum
	if err := m.validateProviderEnum("provider", "body", *m.Provider); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this security oidc based on the context it is used
func (m *SecurityOidc) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateClientSecretHash(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SecurityOidc) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *SecurityOidc) contextValidateClientSecretHash(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "client_secret_hash", "body", m.ClientSecretHash); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *SecurityOidc) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SecurityOidc) UnmarshalBinary(b []byte) error {
	var res SecurityOidc
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// SecurityOidcInlineLinks security oidc inline links
//
// swagger:model security_oidc_inline__links
type SecurityOidcInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this security oidc inline links
func (m *SecurityOidcInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SecurityOidcInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this security oidc inline links based on the context it is used
func (m *SecurityOidcInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SecurityOidcInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *SecurityOidcInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SecurityOidcInlineLinks) UnmarshalBinary(b []byte) error {
	var res SecurityOidcInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
