// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// SecurityProxy security proxy
//
// swagger:model security_proxy
type SecurityProxy struct {

	// Proxy host.
	// Example: proxy.eng.com
	Host *string `json:"host,omitempty"`

	// Proxy password. Password is not audited.
	// Example: proxypassword
	Password *string `json:"password,omitempty"`

	// Proxy port.
	// Example: 1234
	Port *int64 `json:"port,omitempty"`

	// Proxy type.
	// Enum: ["http","https"]
	Type *string `json:"type,omitempty"`

	// Proxy username.
	// Example: proxyuser
	Username *string `json:"username,omitempty"`
}

// Validate validates this security proxy
func (m *SecurityProxy) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateType(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var securityProxyTypeTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["http","https"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		securityProxyTypeTypePropEnum = append(securityProxyTypeTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// security_proxy
	// SecurityProxy
	// type
	// Type
	// http
	// END DEBUGGING
	// SecurityProxyTypeHTTP captures enum value "http"
	SecurityProxyTypeHTTP string = "http"

	// BEGIN DEBUGGING
	// security_proxy
	// SecurityProxy
	// type
	// Type
	// https
	// END DEBUGGING
	// SecurityProxyTypeHTTPS captures enum value "https"
	SecurityProxyTypeHTTPS string = "https"
)

// prop value enum
func (m *SecurityProxy) validateTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, securityProxyTypeTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *SecurityProxy) validateType(formats strfmt.Registry) error {
	if swag.IsZero(m.Type) { // not required
		return nil
	}

	// value enum
	if err := m.validateTypeEnum("type", "body", *m.Type); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this security proxy based on context it is used
func (m *SecurityProxy) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *SecurityProxy) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SecurityProxy) UnmarshalBinary(b []byte) error {
	var res SecurityProxy
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
