// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// SecuritySamlDefMetadata security saml def metadata
//
// swagger:model security_saml_def_metadata
type SecuritySamlDefMetadata struct {

	// links
	Links *SecuritySamlDefMetadataInlineLinks `json:"_links,omitempty"`

	// certificate
	Certificate *SecuritySamlDefMetadataInlineCertificate `json:"certificate,omitempty"`

	// The SAML service provider host.
	Host *string `json:"host,omitempty"`

	// Scope of the entity. Set to "cluster" for cluster owned objects and to "svm" for SVM owned objects.
	// Read Only: true
	// Enum: ["cluster","svm"]
	Scope *string `json:"scope,omitempty"`
}

// Validate validates this security saml def metadata
func (m *SecuritySamlDefMetadata) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCertificate(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateScope(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SecuritySamlDefMetadata) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *SecuritySamlDefMetadata) validateCertificate(formats strfmt.Registry) error {
	if swag.IsZero(m.Certificate) { // not required
		return nil
	}

	if m.Certificate != nil {
		if err := m.Certificate.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("certificate")
			}
			return err
		}
	}

	return nil
}

var securitySamlDefMetadataTypeScopePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["cluster","svm"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		securitySamlDefMetadataTypeScopePropEnum = append(securitySamlDefMetadataTypeScopePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// security_saml_def_metadata
	// SecuritySamlDefMetadata
	// scope
	// Scope
	// cluster
	// END DEBUGGING
	// SecuritySamlDefMetadataScopeCluster captures enum value "cluster"
	SecuritySamlDefMetadataScopeCluster string = "cluster"

	// BEGIN DEBUGGING
	// security_saml_def_metadata
	// SecuritySamlDefMetadata
	// scope
	// Scope
	// svm
	// END DEBUGGING
	// SecuritySamlDefMetadataScopeSvm captures enum value "svm"
	SecuritySamlDefMetadataScopeSvm string = "svm"
)

// prop value enum
func (m *SecuritySamlDefMetadata) validateScopeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, securitySamlDefMetadataTypeScopePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *SecuritySamlDefMetadata) validateScope(formats strfmt.Registry) error {
	if swag.IsZero(m.Scope) { // not required
		return nil
	}

	// value enum
	if err := m.validateScopeEnum("scope", "body", *m.Scope); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this security saml def metadata based on the context it is used
func (m *SecuritySamlDefMetadata) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateCertificate(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateScope(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SecuritySamlDefMetadata) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *SecuritySamlDefMetadata) contextValidateCertificate(ctx context.Context, formats strfmt.Registry) error {

	if m.Certificate != nil {
		if err := m.Certificate.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("certificate")
			}
			return err
		}
	}

	return nil
}

func (m *SecuritySamlDefMetadata) contextValidateScope(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "scope", "body", m.Scope); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *SecuritySamlDefMetadata) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SecuritySamlDefMetadata) UnmarshalBinary(b []byte) error {
	var res SecuritySamlDefMetadata
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// SecuritySamlDefMetadataInlineCertificate security saml def metadata inline certificate
//
// swagger:model security_saml_def_metadata_inline_certificate
type SecuritySamlDefMetadataInlineCertificate struct {

	// Server certificate issuing certificate authority (CA).  This cannot be used with the server certificate common name.
	// Max Length: 256
	// Min Length: 1
	Ca *string `json:"ca,omitempty"`

	// Server certificate common name.  This cannot be used with the certificate authority (CA) or serial_number.
	// Example: cluster1
	CommonName *string `json:"common_name,omitempty"`

	// Server certificate serial number.  This cannot be used with the server certificate common name.
	// Example: 1506B24A94F566BA
	// Max Length: 40
	// Min Length: 1
	SerialNumber *string `json:"serial_number,omitempty"`
}

// Validate validates this security saml def metadata inline certificate
func (m *SecuritySamlDefMetadataInlineCertificate) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateCa(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSerialNumber(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SecuritySamlDefMetadataInlineCertificate) validateCa(formats strfmt.Registry) error {
	if swag.IsZero(m.Ca) { // not required
		return nil
	}

	if err := validate.MinLength("certificate"+"."+"ca", "body", *m.Ca, 1); err != nil {
		return err
	}

	if err := validate.MaxLength("certificate"+"."+"ca", "body", *m.Ca, 256); err != nil {
		return err
	}

	return nil
}

func (m *SecuritySamlDefMetadataInlineCertificate) validateSerialNumber(formats strfmt.Registry) error {
	if swag.IsZero(m.SerialNumber) { // not required
		return nil
	}

	if err := validate.MinLength("certificate"+"."+"serial_number", "body", *m.SerialNumber, 1); err != nil {
		return err
	}

	if err := validate.MaxLength("certificate"+"."+"serial_number", "body", *m.SerialNumber, 40); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this security saml def metadata inline certificate based on context it is used
func (m *SecuritySamlDefMetadataInlineCertificate) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *SecuritySamlDefMetadataInlineCertificate) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SecuritySamlDefMetadataInlineCertificate) UnmarshalBinary(b []byte) error {
	var res SecuritySamlDefMetadataInlineCertificate
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// SecuritySamlDefMetadataInlineLinks security saml def metadata inline links
//
// swagger:model security_saml_def_metadata_inline__links
type SecuritySamlDefMetadataInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this security saml def metadata inline links
func (m *SecuritySamlDefMetadataInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SecuritySamlDefMetadataInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this security saml def metadata inline links based on the context it is used
func (m *SecuritySamlDefMetadataInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SecuritySamlDefMetadataInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *SecuritySamlDefMetadataInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SecuritySamlDefMetadataInlineLinks) UnmarshalBinary(b []byte) error {
	var res SecuritySamlDefMetadataInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
