// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// SecuritySamlSp security saml sp
//
// swagger:model security_saml_sp
type SecuritySamlSp struct {

	// links
	Links *SecuritySamlSpInlineLinks `json:"_links,omitempty"`

	// certificate
	Certificate *SecuritySamlSpInlineCertificate `json:"certificate,omitempty"`

	// The SAML service provider is enabled.  Valid for PATCH and GET operations only.
	Enabled *bool `json:"enabled,omitempty"`

	// The SAML service provider host.
	Host *string `json:"host,omitempty"`

	// The identity provider (IdP) metadata location. Required for POST operations.
	// Example: https://idp.example.com/FederationMetadata/2007-06/FederationMetadata.xml
	IdpURI *string `json:"idp_uri,omitempty"`
}

// Validate validates this security saml sp
func (m *SecuritySamlSp) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCertificate(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SecuritySamlSp) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *SecuritySamlSp) validateCertificate(formats strfmt.Registry) error {
	if swag.IsZero(m.Certificate) { // not required
		return nil
	}

	if m.Certificate != nil {
		if err := m.Certificate.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("certificate")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this security saml sp based on the context it is used
func (m *SecuritySamlSp) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateCertificate(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SecuritySamlSp) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *SecuritySamlSp) contextValidateCertificate(ctx context.Context, formats strfmt.Registry) error {

	if m.Certificate != nil {
		if err := m.Certificate.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("certificate")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *SecuritySamlSp) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SecuritySamlSp) UnmarshalBinary(b []byte) error {
	var res SecuritySamlSp
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// SecuritySamlSpInlineCertificate security saml sp inline certificate
//
// swagger:model security_saml_sp_inline_certificate
type SecuritySamlSpInlineCertificate struct {

	// Server certificate issuing certificate authority (CA).  This cannot be used with the server certificate common name.
	// Max Length: 256
	// Min Length: 1
	Ca *string `json:"ca,omitempty"`

	// Server certificate common name.  This cannot be used with the certificate authority (CA) or serial_number.
	// Example: cluster1
	CommonName *string `json:"common_name,omitempty"`

	// Server certificate serial number.  This cannot be used with the server certificate common name.
	// Example: 1506B24A94F566BA
	// Max Length: 40
	// Min Length: 1
	SerialNumber *string `json:"serial_number,omitempty"`
}

// Validate validates this security saml sp inline certificate
func (m *SecuritySamlSpInlineCertificate) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateCa(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSerialNumber(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SecuritySamlSpInlineCertificate) validateCa(formats strfmt.Registry) error {
	if swag.IsZero(m.Ca) { // not required
		return nil
	}

	if err := validate.MinLength("certificate"+"."+"ca", "body", *m.Ca, 1); err != nil {
		return err
	}

	if err := validate.MaxLength("certificate"+"."+"ca", "body", *m.Ca, 256); err != nil {
		return err
	}

	return nil
}

func (m *SecuritySamlSpInlineCertificate) validateSerialNumber(formats strfmt.Registry) error {
	if swag.IsZero(m.SerialNumber) { // not required
		return nil
	}

	if err := validate.MinLength("certificate"+"."+"serial_number", "body", *m.SerialNumber, 1); err != nil {
		return err
	}

	if err := validate.MaxLength("certificate"+"."+"serial_number", "body", *m.SerialNumber, 40); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this security saml sp inline certificate based on context it is used
func (m *SecuritySamlSpInlineCertificate) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *SecuritySamlSpInlineCertificate) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SecuritySamlSpInlineCertificate) UnmarshalBinary(b []byte) error {
	var res SecuritySamlSpInlineCertificate
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// SecuritySamlSpInlineLinks security saml sp inline links
//
// swagger:model security_saml_sp_inline__links
type SecuritySamlSpInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this security saml sp inline links
func (m *SecuritySamlSpInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SecuritySamlSpInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this security saml sp inline links based on the context it is used
func (m *SecuritySamlSpInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SecuritySamlSpInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *SecuritySamlSpInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SecuritySamlSpInlineLinks) UnmarshalBinary(b []byte) error {
	var res SecuritySamlSpInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
