// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// Server server
//
// swagger:model server
type Server struct {

	// Windows Internet Name Server (WINS) address which manages and maps the NetBIOS name of the CIFS server to their network IP addresses. The IP addresses are IPv4 addresses.
	// Example: 10.224.65.20
	IP *string `json:"ip,omitempty"`

	// Specifies the state of the WINS server.
	// Enum: ["active","inactive"]
	State *string `json:"state,omitempty"`
}

// Validate validates this server
func (m *Server) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var serverTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["active","inactive"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		serverTypeStatePropEnum = append(serverTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// server
	// Server
	// state
	// State
	// active
	// END DEBUGGING
	// ServerStateActive captures enum value "active"
	ServerStateActive string = "active"

	// BEGIN DEBUGGING
	// server
	// Server
	// state
	// State
	// inactive
	// END DEBUGGING
	// ServerStateInactive captures enum value "inactive"
	ServerStateInactive string = "inactive"
)

// prop value enum
func (m *Server) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, serverTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *Server) validateState(formats strfmt.Registry) error {
	if swag.IsZero(m.State) { // not required
		return nil
	}

	// value enum
	if err := m.validateStateEnum("state", "body", *m.State); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this server based on context it is used
func (m *Server) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *Server) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *Server) UnmarshalBinary(b []byte) error {
	var res Server
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
