// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// ServiceProcessor service processor
//
// swagger:model service_processor
type ServiceProcessor struct {

	// api service
	APIService *ServiceProcessorInlineAPIService `json:"api_service,omitempty"`

	// auto config
	AutoConfig *ServiceProcessorInlineAutoConfig `json:"auto_config,omitempty"`

	// Indicates whether the service processor can be automatically updated from ONTAP.
	AutoupdateEnabled *bool `json:"autoupdate_enabled,omitempty"`

	// backup
	Backup *ServiceProcessorInlineBackup `json:"backup,omitempty"`

	// Set to "true" to use DHCP to configure an IPv4 interface. Do not provide values for address, netmask and gateway when set to "true".
	DhcpEnabled *bool `json:"dhcp_enabled,omitempty"`

	// The version of firmware installed.
	// Read Only: true
	FirmwareVersion *string `json:"firmware_version,omitempty"`

	// ipv4 interface
	IPV4Interface *ServiceProcessorInlineIPV4Interface `json:"ipv4_interface,omitempty"`

	// ipv6 interface
	IPV6Interface *ServiceProcessorInlineIPV6Interface `json:"ipv6_interface,omitempty"`

	// Indicates whether the service processor network is configured.
	// Read Only: true
	IsIPConfigured *bool `json:"is_ip_configured,omitempty"`

	// Provides the "update status" of the last service processor update.
	// Read Only: true
	// Enum: ["failed","passed"]
	LastUpdateState *string `json:"last_update_state,omitempty"`

	// link status
	// Read Only: true
	// Enum: ["up","down","disabled","unknown"]
	LinkStatus *string `json:"link_status,omitempty"`

	// mac address
	// Read Only: true
	MacAddress *string `json:"mac_address,omitempty"`

	// primary
	Primary *ServiceProcessorInlinePrimary `json:"primary,omitempty"`

	// ssh info
	SSHInfo *ServiceProcessorInlineSSHInfo `json:"ssh_info,omitempty"`

	// state
	// Read Only: true
	// Enum: ["online","offline","degraded","rebooting","unknown","updating","node_offline","sp_daemon_offline"]
	State *string `json:"state,omitempty"`

	// type
	// Read Only: true
	// Enum: ["sp","none","bmc"]
	Type *string `json:"type,omitempty"`

	// web service
	WebService *ServiceProcessorInlineWebService `json:"web_service,omitempty"`
}

// Validate validates this service processor
func (m *ServiceProcessor) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateAPIService(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateAutoConfig(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateBackup(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateIPV4Interface(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateIPV6Interface(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLastUpdateState(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLinkStatus(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePrimary(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSSHInfo(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateType(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateWebService(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ServiceProcessor) validateAPIService(formats strfmt.Registry) error {
	if swag.IsZero(m.APIService) { // not required
		return nil
	}

	if m.APIService != nil {
		if err := m.APIService.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("api_service")
			}
			return err
		}
	}

	return nil
}

func (m *ServiceProcessor) validateAutoConfig(formats strfmt.Registry) error {
	if swag.IsZero(m.AutoConfig) { // not required
		return nil
	}

	if m.AutoConfig != nil {
		if err := m.AutoConfig.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("auto_config")
			}
			return err
		}
	}

	return nil
}

func (m *ServiceProcessor) validateBackup(formats strfmt.Registry) error {
	if swag.IsZero(m.Backup) { // not required
		return nil
	}

	if m.Backup != nil {
		if err := m.Backup.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("backup")
			}
			return err
		}
	}

	return nil
}

func (m *ServiceProcessor) validateIPV4Interface(formats strfmt.Registry) error {
	if swag.IsZero(m.IPV4Interface) { // not required
		return nil
	}

	if m.IPV4Interface != nil {
		if err := m.IPV4Interface.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ipv4_interface")
			}
			return err
		}
	}

	return nil
}

func (m *ServiceProcessor) validateIPV6Interface(formats strfmt.Registry) error {
	if swag.IsZero(m.IPV6Interface) { // not required
		return nil
	}

	if m.IPV6Interface != nil {
		if err := m.IPV6Interface.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ipv6_interface")
			}
			return err
		}
	}

	return nil
}

var serviceProcessorTypeLastUpdateStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["failed","passed"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		serviceProcessorTypeLastUpdateStatePropEnum = append(serviceProcessorTypeLastUpdateStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// service_processor
	// ServiceProcessor
	// last_update_state
	// LastUpdateState
	// failed
	// END DEBUGGING
	// ServiceProcessorLastUpdateStateFailed captures enum value "failed"
	ServiceProcessorLastUpdateStateFailed string = "failed"

	// BEGIN DEBUGGING
	// service_processor
	// ServiceProcessor
	// last_update_state
	// LastUpdateState
	// passed
	// END DEBUGGING
	// ServiceProcessorLastUpdateStatePassed captures enum value "passed"
	ServiceProcessorLastUpdateStatePassed string = "passed"
)

// prop value enum
func (m *ServiceProcessor) validateLastUpdateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, serviceProcessorTypeLastUpdateStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ServiceProcessor) validateLastUpdateState(formats strfmt.Registry) error {
	if swag.IsZero(m.LastUpdateState) { // not required
		return nil
	}

	// value enum
	if err := m.validateLastUpdateStateEnum("last_update_state", "body", *m.LastUpdateState); err != nil {
		return err
	}

	return nil
}

var serviceProcessorTypeLinkStatusPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["up","down","disabled","unknown"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		serviceProcessorTypeLinkStatusPropEnum = append(serviceProcessorTypeLinkStatusPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// service_processor
	// ServiceProcessor
	// link_status
	// LinkStatus
	// up
	// END DEBUGGING
	// ServiceProcessorLinkStatusUp captures enum value "up"
	ServiceProcessorLinkStatusUp string = "up"

	// BEGIN DEBUGGING
	// service_processor
	// ServiceProcessor
	// link_status
	// LinkStatus
	// down
	// END DEBUGGING
	// ServiceProcessorLinkStatusDown captures enum value "down"
	ServiceProcessorLinkStatusDown string = "down"

	// BEGIN DEBUGGING
	// service_processor
	// ServiceProcessor
	// link_status
	// LinkStatus
	// disabled
	// END DEBUGGING
	// ServiceProcessorLinkStatusDisabled captures enum value "disabled"
	ServiceProcessorLinkStatusDisabled string = "disabled"

	// BEGIN DEBUGGING
	// service_processor
	// ServiceProcessor
	// link_status
	// LinkStatus
	// unknown
	// END DEBUGGING
	// ServiceProcessorLinkStatusUnknown captures enum value "unknown"
	ServiceProcessorLinkStatusUnknown string = "unknown"
)

// prop value enum
func (m *ServiceProcessor) validateLinkStatusEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, serviceProcessorTypeLinkStatusPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ServiceProcessor) validateLinkStatus(formats strfmt.Registry) error {
	if swag.IsZero(m.LinkStatus) { // not required
		return nil
	}

	// value enum
	if err := m.validateLinkStatusEnum("link_status", "body", *m.LinkStatus); err != nil {
		return err
	}

	return nil
}

func (m *ServiceProcessor) validatePrimary(formats strfmt.Registry) error {
	if swag.IsZero(m.Primary) { // not required
		return nil
	}

	if m.Primary != nil {
		if err := m.Primary.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("primary")
			}
			return err
		}
	}

	return nil
}

func (m *ServiceProcessor) validateSSHInfo(formats strfmt.Registry) error {
	if swag.IsZero(m.SSHInfo) { // not required
		return nil
	}

	if m.SSHInfo != nil {
		if err := m.SSHInfo.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ssh_info")
			}
			return err
		}
	}

	return nil
}

var serviceProcessorTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["online","offline","degraded","rebooting","unknown","updating","node_offline","sp_daemon_offline"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		serviceProcessorTypeStatePropEnum = append(serviceProcessorTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// service_processor
	// ServiceProcessor
	// state
	// State
	// online
	// END DEBUGGING
	// ServiceProcessorStateOnline captures enum value "online"
	ServiceProcessorStateOnline string = "online"

	// BEGIN DEBUGGING
	// service_processor
	// ServiceProcessor
	// state
	// State
	// offline
	// END DEBUGGING
	// ServiceProcessorStateOffline captures enum value "offline"
	ServiceProcessorStateOffline string = "offline"

	// BEGIN DEBUGGING
	// service_processor
	// ServiceProcessor
	// state
	// State
	// degraded
	// END DEBUGGING
	// ServiceProcessorStateDegraded captures enum value "degraded"
	ServiceProcessorStateDegraded string = "degraded"

	// BEGIN DEBUGGING
	// service_processor
	// ServiceProcessor
	// state
	// State
	// rebooting
	// END DEBUGGING
	// ServiceProcessorStateRebooting captures enum value "rebooting"
	ServiceProcessorStateRebooting string = "rebooting"

	// BEGIN DEBUGGING
	// service_processor
	// ServiceProcessor
	// state
	// State
	// unknown
	// END DEBUGGING
	// ServiceProcessorStateUnknown captures enum value "unknown"
	ServiceProcessorStateUnknown string = "unknown"

	// BEGIN DEBUGGING
	// service_processor
	// ServiceProcessor
	// state
	// State
	// updating
	// END DEBUGGING
	// ServiceProcessorStateUpdating captures enum value "updating"
	ServiceProcessorStateUpdating string = "updating"

	// BEGIN DEBUGGING
	// service_processor
	// ServiceProcessor
	// state
	// State
	// node_offline
	// END DEBUGGING
	// ServiceProcessorStateNodeOffline captures enum value "node_offline"
	ServiceProcessorStateNodeOffline string = "node_offline"

	// BEGIN DEBUGGING
	// service_processor
	// ServiceProcessor
	// state
	// State
	// sp_daemon_offline
	// END DEBUGGING
	// ServiceProcessorStateSpDaemonOffline captures enum value "sp_daemon_offline"
	ServiceProcessorStateSpDaemonOffline string = "sp_daemon_offline"
)

// prop value enum
func (m *ServiceProcessor) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, serviceProcessorTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ServiceProcessor) validateState(formats strfmt.Registry) error {
	if swag.IsZero(m.State) { // not required
		return nil
	}

	// value enum
	if err := m.validateStateEnum("state", "body", *m.State); err != nil {
		return err
	}

	return nil
}

var serviceProcessorTypeTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["sp","none","bmc"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		serviceProcessorTypeTypePropEnum = append(serviceProcessorTypeTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// service_processor
	// ServiceProcessor
	// type
	// Type
	// sp
	// END DEBUGGING
	// ServiceProcessorTypeSp captures enum value "sp"
	ServiceProcessorTypeSp string = "sp"

	// BEGIN DEBUGGING
	// service_processor
	// ServiceProcessor
	// type
	// Type
	// none
	// END DEBUGGING
	// ServiceProcessorTypeNone captures enum value "none"
	ServiceProcessorTypeNone string = "none"

	// BEGIN DEBUGGING
	// service_processor
	// ServiceProcessor
	// type
	// Type
	// bmc
	// END DEBUGGING
	// ServiceProcessorTypeBmc captures enum value "bmc"
	ServiceProcessorTypeBmc string = "bmc"
)

// prop value enum
func (m *ServiceProcessor) validateTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, serviceProcessorTypeTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ServiceProcessor) validateType(formats strfmt.Registry) error {
	if swag.IsZero(m.Type) { // not required
		return nil
	}

	// value enum
	if err := m.validateTypeEnum("type", "body", *m.Type); err != nil {
		return err
	}

	return nil
}

func (m *ServiceProcessor) validateWebService(formats strfmt.Registry) error {
	if swag.IsZero(m.WebService) { // not required
		return nil
	}

	if m.WebService != nil {
		if err := m.WebService.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("web_service")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this service processor based on the context it is used
func (m *ServiceProcessor) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateAPIService(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateAutoConfig(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateBackup(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateFirmwareVersion(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIPV4Interface(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIPV6Interface(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIsIPConfigured(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLastUpdateState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLinkStatus(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMacAddress(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidatePrimary(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSSHInfo(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateType(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateWebService(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ServiceProcessor) contextValidateAPIService(ctx context.Context, formats strfmt.Registry) error {

	if m.APIService != nil {
		if err := m.APIService.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("api_service")
			}
			return err
		}
	}

	return nil
}

func (m *ServiceProcessor) contextValidateAutoConfig(ctx context.Context, formats strfmt.Registry) error {

	if m.AutoConfig != nil {
		if err := m.AutoConfig.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("auto_config")
			}
			return err
		}
	}

	return nil
}

func (m *ServiceProcessor) contextValidateBackup(ctx context.Context, formats strfmt.Registry) error {

	if m.Backup != nil {
		if err := m.Backup.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("backup")
			}
			return err
		}
	}

	return nil
}

func (m *ServiceProcessor) contextValidateFirmwareVersion(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "firmware_version", "body", m.FirmwareVersion); err != nil {
		return err
	}

	return nil
}

func (m *ServiceProcessor) contextValidateIPV4Interface(ctx context.Context, formats strfmt.Registry) error {

	if m.IPV4Interface != nil {
		if err := m.IPV4Interface.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ipv4_interface")
			}
			return err
		}
	}

	return nil
}

func (m *ServiceProcessor) contextValidateIPV6Interface(ctx context.Context, formats strfmt.Registry) error {

	if m.IPV6Interface != nil {
		if err := m.IPV6Interface.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ipv6_interface")
			}
			return err
		}
	}

	return nil
}

func (m *ServiceProcessor) contextValidateIsIPConfigured(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "is_ip_configured", "body", m.IsIPConfigured); err != nil {
		return err
	}

	return nil
}

func (m *ServiceProcessor) contextValidateLastUpdateState(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "last_update_state", "body", m.LastUpdateState); err != nil {
		return err
	}

	return nil
}

func (m *ServiceProcessor) contextValidateLinkStatus(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "link_status", "body", m.LinkStatus); err != nil {
		return err
	}

	return nil
}

func (m *ServiceProcessor) contextValidateMacAddress(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "mac_address", "body", m.MacAddress); err != nil {
		return err
	}

	return nil
}

func (m *ServiceProcessor) contextValidatePrimary(ctx context.Context, formats strfmt.Registry) error {

	if m.Primary != nil {
		if err := m.Primary.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("primary")
			}
			return err
		}
	}

	return nil
}

func (m *ServiceProcessor) contextValidateSSHInfo(ctx context.Context, formats strfmt.Registry) error {

	if m.SSHInfo != nil {
		if err := m.SSHInfo.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ssh_info")
			}
			return err
		}
	}

	return nil
}

func (m *ServiceProcessor) contextValidateState(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "state", "body", m.State); err != nil {
		return err
	}

	return nil
}

func (m *ServiceProcessor) contextValidateType(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "type", "body", m.Type); err != nil {
		return err
	}

	return nil
}

func (m *ServiceProcessor) contextValidateWebService(ctx context.Context, formats strfmt.Registry) error {

	if m.WebService != nil {
		if err := m.WebService.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("web_service")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ServiceProcessor) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ServiceProcessor) UnmarshalBinary(b []byte) error {
	var res ServiceProcessor
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ServiceProcessorInlineAPIService Provides the properties of the service processor (SP) or baseboard management controller (BMC) API service.
//
// swagger:model service_processor_inline_api_service
type ServiceProcessorInlineAPIService struct {

	// Indicates whether the SP API service of the SP or BMC is enabled or disabled. When the SP API service is disabled, features such as network-based firmware updates and network-based down node log collection are not available, and the slower serial-interface is used for firmware updates and down node log collection.
	Enabled *bool `json:"enabled,omitempty"`

	// Restricts SP API service access to cluster nodes only. By default, limit_access is set to true.
	LimitAccess *bool `json:"limit_access,omitempty"`

	// Specifies the port number on the SP or BMC used for the SP API service. By default, port 50000 is used.
	Port *int64 `json:"port,omitempty"`
}

// Validate validates this service processor inline api service
func (m *ServiceProcessorInlineAPIService) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this service processor inline api service based on the context it is used
func (m *ServiceProcessorInlineAPIService) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *ServiceProcessorInlineAPIService) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ServiceProcessorInlineAPIService) UnmarshalBinary(b []byte) error {
	var res ServiceProcessorInlineAPIService
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ServiceProcessorInlineAutoConfig Provides the properties of the service processor auto configuration.
//
// swagger:model service_processor_inline_auto_config
type ServiceProcessorInlineAutoConfig struct {

	// Indicates the service processor auto configuration IPv4 subnet name. To enable IPv4 auto-config give the subnet name, give the value as null or an empty string "" to disable auto-config.
	// Example: ipv4_mgmt
	IPV4Subnet *string `json:"ipv4_subnet,omitempty"`

	// Indicates the service processor auto configuration IPv6 subnet name. To enable IPv6 auto-config give the subnet name, give the value as null or an empty string "" to disable auto-config.
	// Example: ipv6_mgmt
	IPV6Subnet *string `json:"ipv6_subnet,omitempty"`
}

// Validate validates this service processor inline auto config
func (m *ServiceProcessorInlineAutoConfig) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this service processor inline auto config based on the context it is used
func (m *ServiceProcessorInlineAutoConfig) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *ServiceProcessorInlineAutoConfig) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ServiceProcessorInlineAutoConfig) UnmarshalBinary(b []byte) error {
	var res ServiceProcessorInlineAutoConfig
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ServiceProcessorInlineBackup Provides the properties of the service processor backup partition.
//
// swagger:model service_processor_inline_backup
type ServiceProcessorInlineBackup struct {

	// Indicates whether the service processor is currently booted from the backup partition.
	// Read Only: true
	IsCurrent *bool `json:"is_current,omitempty"`

	// Status of the backup partition.
	// Read Only: true
	// Enum: ["installed","corrupt","updating","auto_updating","none"]
	State *string `json:"state,omitempty"`

	// Firmware version of the backup partition.
	// Example: 11.6
	// Read Only: true
	Version *string `json:"version,omitempty"`
}

// Validate validates this service processor inline backup
func (m *ServiceProcessorInlineBackup) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var serviceProcessorInlineBackupTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["installed","corrupt","updating","auto_updating","none"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		serviceProcessorInlineBackupTypeStatePropEnum = append(serviceProcessorInlineBackupTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// service_processor_inline_backup
	// ServiceProcessorInlineBackup
	// state
	// State
	// installed
	// END DEBUGGING
	// ServiceProcessorInlineBackupStateInstalled captures enum value "installed"
	ServiceProcessorInlineBackupStateInstalled string = "installed"

	// BEGIN DEBUGGING
	// service_processor_inline_backup
	// ServiceProcessorInlineBackup
	// state
	// State
	// corrupt
	// END DEBUGGING
	// ServiceProcessorInlineBackupStateCorrupt captures enum value "corrupt"
	ServiceProcessorInlineBackupStateCorrupt string = "corrupt"

	// BEGIN DEBUGGING
	// service_processor_inline_backup
	// ServiceProcessorInlineBackup
	// state
	// State
	// updating
	// END DEBUGGING
	// ServiceProcessorInlineBackupStateUpdating captures enum value "updating"
	ServiceProcessorInlineBackupStateUpdating string = "updating"

	// BEGIN DEBUGGING
	// service_processor_inline_backup
	// ServiceProcessorInlineBackup
	// state
	// State
	// auto_updating
	// END DEBUGGING
	// ServiceProcessorInlineBackupStateAutoUpdating captures enum value "auto_updating"
	ServiceProcessorInlineBackupStateAutoUpdating string = "auto_updating"

	// BEGIN DEBUGGING
	// service_processor_inline_backup
	// ServiceProcessorInlineBackup
	// state
	// State
	// none
	// END DEBUGGING
	// ServiceProcessorInlineBackupStateNone captures enum value "none"
	ServiceProcessorInlineBackupStateNone string = "none"
)

// prop value enum
func (m *ServiceProcessorInlineBackup) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, serviceProcessorInlineBackupTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ServiceProcessorInlineBackup) validateState(formats strfmt.Registry) error {
	if swag.IsZero(m.State) { // not required
		return nil
	}

	// value enum
	if err := m.validateStateEnum("backup"+"."+"state", "body", *m.State); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this service processor inline backup based on the context it is used
func (m *ServiceProcessorInlineBackup) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateIsCurrent(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateVersion(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ServiceProcessorInlineBackup) contextValidateIsCurrent(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "backup"+"."+"is_current", "body", m.IsCurrent); err != nil {
		return err
	}

	return nil
}

func (m *ServiceProcessorInlineBackup) contextValidateState(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "backup"+"."+"state", "body", m.State); err != nil {
		return err
	}

	return nil
}

func (m *ServiceProcessorInlineBackup) contextValidateVersion(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "backup"+"."+"version", "body", m.Version); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ServiceProcessorInlineBackup) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ServiceProcessorInlineBackup) UnmarshalBinary(b []byte) error {
	var res ServiceProcessorInlineBackup
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ServiceProcessorInlineIPV4Interface Object to set up an interface along with its default router.
//
// swagger:model service_processor_inline_ipv4_interface
type ServiceProcessorInlineIPV4Interface struct {

	// IPv4 address
	// Example: 10.10.10.7
	Address *string `json:"address,omitempty"`

	// Indicates whether the IPv4 interfaces is enabled. It expects dhcp_enabled as "true" or values for address, netmask and gateway when set to "true".
	Enabled *bool `json:"enabled,omitempty"`

	// The IPv4 address of the default router.
	// Example: 10.1.1.1
	Gateway *string `json:"gateway,omitempty"`

	// Input as IPv4 mask (255.255.0.0). Output is always the netmask length.
	// Example: 255.255.0.0
	Netmask *string `json:"netmask,omitempty"`

	// Indicates the setup state of the interface.
	// Read Only: true
	// Enum: ["not_setup","succeeded","in_progress","failed"]
	SetupState *string `json:"setup_state,omitempty"`
}

// Validate validates this service processor inline ipv4 interface
func (m *ServiceProcessorInlineIPV4Interface) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSetupState(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var serviceProcessorInlineIpv4InterfaceTypeSetupStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["not_setup","succeeded","in_progress","failed"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		serviceProcessorInlineIpv4InterfaceTypeSetupStatePropEnum = append(serviceProcessorInlineIpv4InterfaceTypeSetupStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// service_processor_inline_ipv4_interface
	// ServiceProcessorInlineIPV4Interface
	// setup_state
	// SetupState
	// not_setup
	// END DEBUGGING
	// ServiceProcessorInlineIPV4InterfaceSetupStateNotSetup captures enum value "not_setup"
	ServiceProcessorInlineIPV4InterfaceSetupStateNotSetup string = "not_setup"

	// BEGIN DEBUGGING
	// service_processor_inline_ipv4_interface
	// ServiceProcessorInlineIPV4Interface
	// setup_state
	// SetupState
	// succeeded
	// END DEBUGGING
	// ServiceProcessorInlineIPV4InterfaceSetupStateSucceeded captures enum value "succeeded"
	ServiceProcessorInlineIPV4InterfaceSetupStateSucceeded string = "succeeded"

	// BEGIN DEBUGGING
	// service_processor_inline_ipv4_interface
	// ServiceProcessorInlineIPV4Interface
	// setup_state
	// SetupState
	// in_progress
	// END DEBUGGING
	// ServiceProcessorInlineIPV4InterfaceSetupStateInProgress captures enum value "in_progress"
	ServiceProcessorInlineIPV4InterfaceSetupStateInProgress string = "in_progress"

	// BEGIN DEBUGGING
	// service_processor_inline_ipv4_interface
	// ServiceProcessorInlineIPV4Interface
	// setup_state
	// SetupState
	// failed
	// END DEBUGGING
	// ServiceProcessorInlineIPV4InterfaceSetupStateFailed captures enum value "failed"
	ServiceProcessorInlineIPV4InterfaceSetupStateFailed string = "failed"
)

// prop value enum
func (m *ServiceProcessorInlineIPV4Interface) validateSetupStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, serviceProcessorInlineIpv4InterfaceTypeSetupStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ServiceProcessorInlineIPV4Interface) validateSetupState(formats strfmt.Registry) error {
	if swag.IsZero(m.SetupState) { // not required
		return nil
	}

	// value enum
	if err := m.validateSetupStateEnum("ipv4_interface"+"."+"setup_state", "body", *m.SetupState); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this service processor inline ipv4 interface based on the context it is used
func (m *ServiceProcessorInlineIPV4Interface) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSetupState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ServiceProcessorInlineIPV4Interface) contextValidateSetupState(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "ipv4_interface"+"."+"setup_state", "body", m.SetupState); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ServiceProcessorInlineIPV4Interface) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ServiceProcessorInlineIPV4Interface) UnmarshalBinary(b []byte) error {
	var res ServiceProcessorInlineIPV4Interface
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ServiceProcessorInlineIPV6Interface Object to setup an interface along with its default router.
//
// swagger:model service_processor_inline_ipv6_interface
type ServiceProcessorInlineIPV6Interface struct {

	// IPv6 address
	// Example: fd20:8b1e:b255:5011:10:141:4:97
	Address *string `json:"address,omitempty"`

	// Indicates whether the IPv6 interfaces is enabled. It expects values for address, netmask and gateway when set to "true".
	Enabled *bool `json:"enabled,omitempty"`

	// The IPv6 address of the default router.
	// Example: fd20:8b1e:b255:5011:10::1
	Gateway *string `json:"gateway,omitempty"`

	// Indicates whether IPv6 RA is enabled.
	IsIPV6RaEnabled *bool `json:"is_ipv6_ra_enabled,omitempty"`

	// Link local IP address.
	// Example: FE80::/10
	LinkLocalIP *string `json:"link_local_ip,omitempty"`

	// The IPv6 netmask/prefix length. The default value is 64 with a valid range of 1 to 127.
	// Example: 64
	Netmask *int64 `json:"netmask,omitempty"`

	// Router assigned IP address.
	// Example: 2001:0db8:85a3:0000:0000:8a2e:0370:7334
	RouterIP *string `json:"router_ip,omitempty"`

	// Indicates the setup state of the interface.
	// Read Only: true
	// Enum: ["not_setup","succeeded","in_progress","failed"]
	SetupState *string `json:"setup_state,omitempty"`
}

// Validate validates this service processor inline ipv6 interface
func (m *ServiceProcessorInlineIPV6Interface) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSetupState(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var serviceProcessorInlineIpv6InterfaceTypeSetupStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["not_setup","succeeded","in_progress","failed"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		serviceProcessorInlineIpv6InterfaceTypeSetupStatePropEnum = append(serviceProcessorInlineIpv6InterfaceTypeSetupStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// service_processor_inline_ipv6_interface
	// ServiceProcessorInlineIPV6Interface
	// setup_state
	// SetupState
	// not_setup
	// END DEBUGGING
	// ServiceProcessorInlineIPV6InterfaceSetupStateNotSetup captures enum value "not_setup"
	ServiceProcessorInlineIPV6InterfaceSetupStateNotSetup string = "not_setup"

	// BEGIN DEBUGGING
	// service_processor_inline_ipv6_interface
	// ServiceProcessorInlineIPV6Interface
	// setup_state
	// SetupState
	// succeeded
	// END DEBUGGING
	// ServiceProcessorInlineIPV6InterfaceSetupStateSucceeded captures enum value "succeeded"
	ServiceProcessorInlineIPV6InterfaceSetupStateSucceeded string = "succeeded"

	// BEGIN DEBUGGING
	// service_processor_inline_ipv6_interface
	// ServiceProcessorInlineIPV6Interface
	// setup_state
	// SetupState
	// in_progress
	// END DEBUGGING
	// ServiceProcessorInlineIPV6InterfaceSetupStateInProgress captures enum value "in_progress"
	ServiceProcessorInlineIPV6InterfaceSetupStateInProgress string = "in_progress"

	// BEGIN DEBUGGING
	// service_processor_inline_ipv6_interface
	// ServiceProcessorInlineIPV6Interface
	// setup_state
	// SetupState
	// failed
	// END DEBUGGING
	// ServiceProcessorInlineIPV6InterfaceSetupStateFailed captures enum value "failed"
	ServiceProcessorInlineIPV6InterfaceSetupStateFailed string = "failed"
)

// prop value enum
func (m *ServiceProcessorInlineIPV6Interface) validateSetupStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, serviceProcessorInlineIpv6InterfaceTypeSetupStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ServiceProcessorInlineIPV6Interface) validateSetupState(formats strfmt.Registry) error {
	if swag.IsZero(m.SetupState) { // not required
		return nil
	}

	// value enum
	if err := m.validateSetupStateEnum("ipv6_interface"+"."+"setup_state", "body", *m.SetupState); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this service processor inline ipv6 interface based on the context it is used
func (m *ServiceProcessorInlineIPV6Interface) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSetupState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ServiceProcessorInlineIPV6Interface) contextValidateSetupState(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "ipv6_interface"+"."+"setup_state", "body", m.SetupState); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ServiceProcessorInlineIPV6Interface) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ServiceProcessorInlineIPV6Interface) UnmarshalBinary(b []byte) error {
	var res ServiceProcessorInlineIPV6Interface
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ServiceProcessorInlinePrimary Provides the properties of the service processor primary partition.
//
// swagger:model service_processor_inline_primary
type ServiceProcessorInlinePrimary struct {

	// Indicates whether the service processor is currently booted from the primary partition.
	// Read Only: true
	IsCurrent *bool `json:"is_current,omitempty"`

	// Status of the primary partition.
	// Read Only: true
	// Enum: ["installed","corrupt","updating","auto_updating","none"]
	State *string `json:"state,omitempty"`

	// Firmware version of the primary partition.
	// Example: 11.6
	// Read Only: true
	Version *string `json:"version,omitempty"`
}

// Validate validates this service processor inline primary
func (m *ServiceProcessorInlinePrimary) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var serviceProcessorInlinePrimaryTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["installed","corrupt","updating","auto_updating","none"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		serviceProcessorInlinePrimaryTypeStatePropEnum = append(serviceProcessorInlinePrimaryTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// service_processor_inline_primary
	// ServiceProcessorInlinePrimary
	// state
	// State
	// installed
	// END DEBUGGING
	// ServiceProcessorInlinePrimaryStateInstalled captures enum value "installed"
	ServiceProcessorInlinePrimaryStateInstalled string = "installed"

	// BEGIN DEBUGGING
	// service_processor_inline_primary
	// ServiceProcessorInlinePrimary
	// state
	// State
	// corrupt
	// END DEBUGGING
	// ServiceProcessorInlinePrimaryStateCorrupt captures enum value "corrupt"
	ServiceProcessorInlinePrimaryStateCorrupt string = "corrupt"

	// BEGIN DEBUGGING
	// service_processor_inline_primary
	// ServiceProcessorInlinePrimary
	// state
	// State
	// updating
	// END DEBUGGING
	// ServiceProcessorInlinePrimaryStateUpdating captures enum value "updating"
	ServiceProcessorInlinePrimaryStateUpdating string = "updating"

	// BEGIN DEBUGGING
	// service_processor_inline_primary
	// ServiceProcessorInlinePrimary
	// state
	// State
	// auto_updating
	// END DEBUGGING
	// ServiceProcessorInlinePrimaryStateAutoUpdating captures enum value "auto_updating"
	ServiceProcessorInlinePrimaryStateAutoUpdating string = "auto_updating"

	// BEGIN DEBUGGING
	// service_processor_inline_primary
	// ServiceProcessorInlinePrimary
	// state
	// State
	// none
	// END DEBUGGING
	// ServiceProcessorInlinePrimaryStateNone captures enum value "none"
	ServiceProcessorInlinePrimaryStateNone string = "none"
)

// prop value enum
func (m *ServiceProcessorInlinePrimary) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, serviceProcessorInlinePrimaryTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ServiceProcessorInlinePrimary) validateState(formats strfmt.Registry) error {
	if swag.IsZero(m.State) { // not required
		return nil
	}

	// value enum
	if err := m.validateStateEnum("primary"+"."+"state", "body", *m.State); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this service processor inline primary based on the context it is used
func (m *ServiceProcessorInlinePrimary) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateIsCurrent(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateVersion(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ServiceProcessorInlinePrimary) contextValidateIsCurrent(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "primary"+"."+"is_current", "body", m.IsCurrent); err != nil {
		return err
	}

	return nil
}

func (m *ServiceProcessorInlinePrimary) contextValidateState(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "primary"+"."+"state", "body", m.State); err != nil {
		return err
	}

	return nil
}

func (m *ServiceProcessorInlinePrimary) contextValidateVersion(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "primary"+"."+"version", "body", m.Version); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ServiceProcessorInlinePrimary) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ServiceProcessorInlinePrimary) UnmarshalBinary(b []byte) error {
	var res ServiceProcessorInlinePrimary
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ServiceProcessorInlineSSHInfo Service processor SSH allowed IP address configuration applied across the cluster.
//
// swagger:model service_processor_inline_ssh_info
type ServiceProcessorInlineSSHInfo struct {

	// Allowed IP addresses
	AllowedAddresses []*IPAddressAndNetmask `json:"allowed_addresses,omitempty"`
}

// Validate validates this service processor inline ssh info
func (m *ServiceProcessorInlineSSHInfo) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateAllowedAddresses(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ServiceProcessorInlineSSHInfo) validateAllowedAddresses(formats strfmt.Registry) error {
	if swag.IsZero(m.AllowedAddresses) { // not required
		return nil
	}

	for i := 0; i < len(m.AllowedAddresses); i++ {
		if swag.IsZero(m.AllowedAddresses[i]) { // not required
			continue
		}

		if m.AllowedAddresses[i] != nil {
			if err := m.AllowedAddresses[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("ssh_info" + "." + "allowed_addresses" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this service processor inline ssh info based on the context it is used
func (m *ServiceProcessorInlineSSHInfo) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateAllowedAddresses(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ServiceProcessorInlineSSHInfo) contextValidateAllowedAddresses(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.AllowedAddresses); i++ {

		if m.AllowedAddresses[i] != nil {
			if err := m.AllowedAddresses[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("ssh_info" + "." + "allowed_addresses" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *ServiceProcessorInlineSSHInfo) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ServiceProcessorInlineSSHInfo) UnmarshalBinary(b []byte) error {
	var res ServiceProcessorInlineSSHInfo
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ServiceProcessorInlineWebService Provides the properties of SP or BMC web service.
//
// swagger:model service_processor_inline_web_service
type ServiceProcessorInlineWebService struct {

	// Indicates whether the web service of the SP or BMC is enabled or disabled. When the web service is disabled, features such as network-based firmware updates and network-based down node log collection are not available, and the slower serial-interface is used for firmware updates and down node log collection.
	Enabled *bool `json:"enabled,omitempty"`

	// Restricts web service access to cluster nodes only. By default, limit_access is set to true.
	LimitAccess *bool `json:"limit_access,omitempty"`
}

// Validate validates this service processor inline web service
func (m *ServiceProcessorInlineWebService) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this service processor inline web service based on the context it is used
func (m *ServiceProcessorInlineWebService) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *ServiceProcessorInlineWebService) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ServiceProcessorInlineWebService) UnmarshalBinary(b []byte) error {
	var res ServiceProcessorInlineWebService
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
